/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.amanda.DoubleCache;
import visad.data.amanda.Event;
import visad.data.amanda.FitTrack;
import visad.data.amanda.FloatCache;
import visad.data.amanda.Hit;
import visad.data.amanda.Hits;
import visad.data.amanda.IntCache;
import visad.data.amanda.MCTrack;
import visad.data.amanda.Module;
import visad.data.amanda.ModuleList;

public class AmandaFile {
    public static final RealType moduleIndexType = RealType.getRealType("Module_Index");
    public static RealTupleType xyzType;
    private double xmin = Double.MAX_VALUE;
    private double xmax = Double.MIN_VALUE;
    private double ymin = Double.MAX_VALUE;
    private double ymax = Double.MIN_VALUE;
    private double zmin = Double.MAX_VALUE;
    private double zmax = Double.MIN_VALUE;
    private ModuleList modules = new ModuleList();
    private ArrayList events = new ArrayList();
    private HashMap lastCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmandaFile(String id) throws BadFormException, IOException, VisADException {
        FileReader rdr = new FileReader(id);
        try {
            this.loadFile(new BufferedReader(rdr));
        }
        finally {
            try {
                rdr.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmandaFile(URL url) throws BadFormException, IOException, VisADException {
        InputStream is = url.openStream();
        try {
            this.loadFile(new BufferedReader(new InputStreamReader(is)));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void loadFile(BufferedReader br) throws BadFormException, VisADException {
        String firstLine;
        try {
            firstLine = this.nextLine(br);
        }
        catch (IOException ioe) {
            throw new BadFormException("Unreadable file");
        }
        if (firstLine == null || firstLine.length() <= 1 || firstLine.charAt(0) != 'v' || !Character.isSpaceChar(firstLine.charAt(1))) {
            throw new BadFormException("Bad first line \"" + firstLine + "\"");
        }
        Event currentEvent = null;
        boolean inSlowEvent = false;
        while (true) {
            String line;
            try {
                line = this.nextLine(br);
            }
            catch (IOException ioe) {
                throw new BadFormException("Unreadable file");
            }
            if (line == null) break;
            if (line.length() == 0) continue;
            StringTokenizer tok = new StringTokenizer(line);
            String keyword = tok.nextToken();
            if (keyword.equals("array")) {
                if (this.modules.isInitialized()) {
                    System.err.println("Warning: Multiple ARRAY lines found");
                }
                int nmodules = this.readArrayLine(line, tok);
                continue;
            }
            if (keyword.equals("om")) {
                float z;
                float y;
                Module module = this.readOMLine(line, tok);
                if (module == null) continue;
                this.modules.add(module);
                float x = module.getX();
                if (x == x) {
                    if ((double)x < this.xmin) {
                        this.xmin = x;
                    }
                    if ((double)x > this.xmax) {
                        this.xmax = x;
                    }
                }
                if ((y = module.getY()) == y) {
                    if ((double)y < this.ymin) {
                        this.ymin = y;
                    }
                    if ((double)y > this.ymax) {
                        this.ymax = y;
                    }
                }
                if ((z = module.getZ()) != z) continue;
                if ((double)z < this.zmin) {
                    this.zmin = z;
                }
                if (!((double)z > this.zmax)) continue;
                this.zmax = x;
                continue;
            }
            if (keyword.equals("es")) {
                if (inSlowEvent) {
                    System.err.println("Warning: Missing EE for slow event");
                }
                inSlowEvent = true;
                continue;
            }
            if (keyword.equals("em")) {
                if (currentEvent != null) {
                    System.err.println("Warning: Missing EE for " + currentEvent);
                }
                currentEvent = this.startEvent(line, tok);
                continue;
            }
            if (keyword.equals("tr")) {
                MCTrack track = this.readTrack(line, tok);
                if (track == null) continue;
                if (currentEvent == null) {
                    System.err.println("Found TRACK " + track + " outside event");
                    continue;
                }
                currentEvent.add(track);
                continue;
            }
            if (keyword.equals("fit")) {
                FitTrack fit = this.readFit(line, tok);
                if (fit == null) continue;
                if (currentEvent == null) {
                    System.err.println("Found FIT " + fit + " outside event");
                    continue;
                }
                currentEvent.add(fit);
                continue;
            }
            if (keyword.equals("ht")) {
                Hit hit = this.readHit(line, tok);
                if (hit == null) continue;
                if (currentEvent == null) {
                    System.err.println("Found HIT " + hit + " outside event");
                    continue;
                }
                currentEvent.add(hit);
                continue;
            }
            if (!keyword.equals("ee")) continue;
            if (currentEvent == null) {
                if (inSlowEvent) {
                    inSlowEvent = false;
                    continue;
                }
                System.err.println("Found EE outside event");
                continue;
            }
            this.events.add(currentEvent);
            currentEvent = null;
        }
        this.lastCache.clear();
    }

    private final void dump(PrintStream out) {
        int nEvents = this.events.size();
        for (int i = 0; i < nEvents; ++i) {
            ((Event)this.events.get(i)).dump(out);
        }
        this.modules.dump(out);
    }

    public final Event getEvent(int index) {
        return (Event)this.events.get(index);
    }

    public final int getNumberOfEvents() {
        return this.events.size();
    }

    public final double getXMax() {
        return this.xmax;
    }

    public final double getXMin() {
        return this.xmin;
    }

    public final double getYMax() {
        return this.ymax;
    }

    public final double getYMin() {
        return this.ymin;
    }

    public final double getZMax() {
        return this.zmax;
    }

    public final double getZMin() {
        return this.zmin;
    }

    public final FieldImpl makeEventData() {
        FieldImpl fld;
        Integer1DSet set;
        int num = this.events.size();
        try {
            set = new Integer1DSet((MathType)Event.indexType, num == 0 ? 1 : num);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            return null;
        }
        try {
            FunctionType funcType = new FunctionType(Event.indexType, Hits.timeSequenceType);
            fld = new FieldImpl(funcType, set);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            return null;
        }
        if (num > 0) {
            Data[] samples = new Data[num];
            for (int e = 0; e < num; ++e) {
                samples[e] = ((Event)this.events.get(e)).makeHitSequence();
            }
            try {
                fld.setSamples(samples, false);
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
            catch (VisADException ve) {
                ve.printStackTrace();
            }
        }
        return fld;
    }

    public final FlatField makeModuleData() throws RemoteException, VisADException {
        FlatField fld;
        Integer1DSet set;
        int num = this.modules.size();
        try {
            set = new Integer1DSet((MathType)moduleIndexType, num);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            return null;
        }
        try {
            FunctionType funcType = new FunctionType(moduleIndexType, xyzType);
            fld = new FlatField(funcType, set);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            return null;
        }
        if (num > 0) {
            float[][] samples = new float[3][num];
            for (int i = 0; i < num; ++i) {
                Module mod = this.modules.get(i);
                samples[0][i] = mod.getX();
                samples[1][i] = mod.getY();
                samples[2][i] = mod.getZ();
            }
            try {
                fld.setSamples(samples);
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
        return fld;
    }

    private String nextLine(BufferedReader rdr) throws IOException {
        String line = rdr.readLine();
        if (line != null) {
            line = line.trim().toLowerCase();
        }
        return line;
    }

    private int parseChannel(String tokenName, String token) throws NumberFormatException {
        int dotIdx = token.indexOf(46);
        if (dotIdx >= 0) {
            token = "-" + token.substring(dotIdx + 1);
        }
        return this.parseInt(tokenName, token);
    }

    private double parseDouble(String tokenName, String token) throws NumberFormatException {
        DoubleCache cval;
        double value = token == null ? Double.NaN : (token.equals("inf") ? Double.POSITIVE_INFINITY : (token.equals("-inf") ? Double.NEGATIVE_INFINITY : (token.equals("?") ? Double.NaN : (token.equals("nan") ? Double.NaN : (token.equals("*") ? ((cval = (DoubleCache)this.lastCache.get(tokenName)) == null ? Double.NaN : cval.getValue()) : Double.parseDouble(token))))));
        DoubleCache cache = (DoubleCache)this.lastCache.get(tokenName);
        if (cache == null) {
            this.lastCache.put(tokenName, new DoubleCache(value));
        } else {
            cache.setValue(value);
        }
        return value;
    }

    private float parseFloat(String tokenName, String token) throws NumberFormatException {
        FloatCache cval;
        float value = token == null ? Float.NaN : (token.equals("inf") ? Float.POSITIVE_INFINITY : (token.equals("-inf") ? Float.NEGATIVE_INFINITY : (token.equals("?") ? Float.NaN : (token.equals("nan") ? Float.NaN : (token.equals("*") ? ((cval = (FloatCache)this.lastCache.get(tokenName)) == null ? Float.NaN : cval.getValue()) : Float.parseFloat(token))))));
        FloatCache cache = (FloatCache)this.lastCache.get(tokenName);
        if (cache == null) {
            this.lastCache.put(tokenName, new FloatCache(value));
        } else {
            cache.setValue(value);
        }
        return value;
    }

    private int parseInt(String tokenName, String token) throws NumberFormatException {
        IntCache cval;
        int value = token == null ? -1 : (token.equals("inf") ? Integer.MAX_VALUE : (token.equals("-inf") ? Integer.MIN_VALUE : (token.equals("?") ? -1 : (token.equals("nan") ? -1 : (token.equals("*") ? ((cval = (IntCache)this.lastCache.get(tokenName)) == null ? -1 : cval.getValue()) : Integer.parseInt(token))))));
        IntCache cache = (IntCache)this.lastCache.get(tokenName);
        if (cache == null) {
            this.lastCache.put(tokenName, new IntCache(value));
        } else {
            cache.setValue(value);
        }
        return value;
    }

    private int readArrayLine(String line, StringTokenizer tok) throws BadFormException {
        int nmodules;
        int nstrings;
        String detector = tok.nextToken();
        try {
            float longitude = this.parseFloat("raLon", tok.nextToken());
            float latitude = this.parseFloat("raLat", tok.nextToken());
            float depth = this.parseFloat("raDepth", tok.nextToken());
            nstrings = this.parseInt("raNStr", tok.nextToken());
            nmodules = this.parseInt("raNMod", tok.nextToken());
        }
        catch (NumberFormatException e) {
            throw new BadFormException("Bad ARRAY line \"" + line + "\": " + e.getMessage());
        }
        if (nstrings < 1 || nmodules < 1) {
            throw new BadFormException("Bad ARRAY line \"" + line + "\": " + (nstrings < 1 ? "nstrings < 1" : "nmodule < 1"));
        }
        return nmodules;
    }

    private final FitTrack readFit(String line, StringTokenizer tok) throws VisADException {
        float energy;
        float length;
        float time;
        float azimuth;
        float zenith;
        float zstart;
        float ystart;
        float xstart;
        tok.nextToken();
        tok.nextToken();
        try {
            xstart = this.parseFloat("fitXStart", tok.nextToken());
            ystart = this.parseFloat("fitYStart", tok.nextToken());
            zstart = this.parseFloat("fitZStart", tok.nextToken());
            zenith = this.parseFloat("fitZenith", tok.nextToken());
            azimuth = this.parseFloat("fitAzimuth", tok.nextToken());
            time = this.parseFloat("fitTime", tok.nextToken());
            length = this.parseFloat("fitLength", tok.nextToken());
            energy = this.parseFloat("fitEnergy", tok.nextToken());
        }
        catch (NumberFormatException e) {
            throw new BadFormException("Bad FIT line \"" + line + "\": " + e.getMessage());
        }
        return new FitTrack(xstart, ystart, zstart, zenith, azimuth, length, energy, time);
    }

    private final Hit readHit(String line, StringTokenizer tok) throws VisADException {
        float timeOverThreshold;
        float leadEdgeTime;
        float amplitude;
        String chanStr = tok.nextToken();
        int number = this.parseChannel("htNum", chanStr);
        if (number < 0) {
            System.err.println("Warning: Ignoring HIT for secondary channel \"" + chanStr + "\"");
            return null;
        }
        Module mod = this.modules.find(number);
        if (mod == null) {
            System.err.println("Warning: Module not found for HIT line \"" + line + "\"; hit ignored");
            return null;
        }
        try {
            amplitude = this.parseFloat("htAmp", tok.nextToken());
            tok.nextToken();
            tok.nextToken();
            leadEdgeTime = this.parseFloat("htLet", tok.nextToken());
            timeOverThreshold = this.parseFloat("htTot", tok.nextToken());
        }
        catch (NumberFormatException e) {
            throw new BadFormException("Bad HIT line \"" + line + "\": " + e.getMessage());
        }
        return new Hit(mod, amplitude, leadEdgeTime, timeOverThreshold);
    }

    private final Module readOMLine(String line, StringTokenizer tok) throws BadFormException {
        float z;
        float y;
        float x;
        int string;
        int stringOrder;
        int number;
        String numStr = tok.nextToken();
        try {
            number = this.parseInt("omNum", numStr);
        }
        catch (NumberFormatException e) {
            throw new BadFormException("unparseable module number \"" + numStr + "\" in \"" + line + "\"");
        }
        if (number < 0) {
            throw new BadFormException("bad module number \"" + numStr + "\" in \"" + line + "\"");
        }
        try {
            stringOrder = this.parseInt("modOrd", tok.nextToken());
            string = this.parseInt("modStr", tok.nextToken());
            x = this.parseFloat("modX", tok.nextToken());
            y = this.parseFloat("modY", tok.nextToken());
            z = this.parseFloat("modZ", tok.nextToken());
        }
        catch (NumberFormatException e) {
            throw new BadFormException("Bad OM line \"" + line + "\": " + e.getMessage());
        }
        return new Module(number, x, y, z, string, stringOrder);
    }

    private final MCTrack readTrack(String line, StringTokenizer tok) throws VisADException {
        float time;
        float energy;
        float length;
        float azimuth;
        float zenith;
        float zstart;
        float ystart;
        float xstart;
        for (int i = 0; i < 3; ++i) {
            tok.nextToken();
        }
        try {
            xstart = this.parseFloat("trXStart", tok.nextToken());
            ystart = this.parseFloat("trYStart", tok.nextToken());
            zstart = this.parseFloat("trZStart", tok.nextToken());
            zenith = this.parseFloat("trZenith", tok.nextToken());
            azimuth = this.parseFloat("trAzimuth", tok.nextToken());
            length = this.parseFloat("trLength", tok.nextToken());
            energy = this.parseFloat("trEnergy", tok.nextToken());
            time = this.parseFloat("trTime", tok.nextToken());
        }
        catch (NumberFormatException e) {
            throw new BadFormException("bad TRACK line \"" + line + "\": " + e.getMessage());
        }
        return new MCTrack(xstart, ystart, zstart, zenith, azimuth, length, energy, time);
    }

    private final Event startEvent(String line, StringTokenizer tok) throws BadFormException {
        double timeShift;
        double time;
        int day;
        int year;
        int runNum;
        int evtNum;
        try {
            evtNum = this.parseInt("emNum", tok.nextToken());
            runNum = this.parseInt("emRun", tok.nextToken());
            year = this.parseInt("emYear", tok.nextToken());
            day = this.parseInt("emDay", tok.nextToken());
            time = this.parseDouble("emTime", tok.nextToken());
            timeShift = !tok.hasMoreTokens() ? Double.NaN : this.parseDouble("emTimeShift", tok.nextToken()) * 1.0E-9;
        }
        catch (NumberFormatException e) {
            throw new BadFormException("Bad EM line \"" + line + "\": " + e.getMessage());
        }
        return new Event(evtNum, runNum, year, day, time, timeShift);
    }

    static {
        try {
            xyzType = new RealTupleType(RealType.XAxis, RealType.YAxis, RealType.ZAxis);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            xyzType = null;
        }
    }
}

