/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.ErrorEstimate;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.ShadowType;
import visad.SingletonSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;
import visad.data.AreaImageAccessor;
import visad.data.FlatFieldCache;
import visad.data.FlatFieldCacheAccessor;
import visad.data.FlatFieldCacheError;
import visad.meteorology.SatelliteImage;

public class AreaImageCacheAdapter
extends SatelliteImage
implements FlatFieldCache.CacheOwner {
    private static Logger log = Logger.getLogger(AreaImageCacheAdapter.class.getName());
    private final FlatFieldCacheAccessor fileAccessor;
    private final FlatFieldCache cache;
    private final SatelliteImage adapted;

    public AreaImageCacheAdapter(SatelliteImage template, AreaImageAccessor accessor, FlatFieldCache cache) throws VisADException, RemoteException {
        super((FunctionType)template.getType(), AreaImageCacheAdapter.getNullDomainSet(((FunctionType)template.getType()).getDomain()), template.getStartTime(), template.getDescription(), template.getSensorName());
        this.adapted = (SatelliteImage)template.clone();
        this.fileAccessor = accessor;
        this.cache = cache;
    }

    @Override
    public String getId() {
        return ((AreaImageAccessor)this.fileAccessor).getSource();
    }

    public static Set getNullDomainSet(RealTupleType type) throws VisADException {
        int n = type.getDimension();
        double[] values = new double[n];
        for (int i = 0; i < n; ++i) {
            values[i] = 0.0;
        }
        try {
            RealTuple tuple = new RealTuple(type, values);
            return new SingletonSet(tuple);
        }
        catch (RemoteException e) {
            throw new VisADError("FileFlatField.getNullDomainSet: " + e.toString());
        }
    }

    protected SatelliteImage getAdaptedFlatField() {
        try {
            this.adapted.setSamples(this.cache.getData(this, this.fileAccessor), false);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error setting samples", e);
            throw new FlatFieldCacheError("Error retrieving cached FlatField", e);
        }
        return this.adapted;
    }

    @Override
    public Data getSample(int index) throws VisADException, RemoteException {
        log.finest("getSample");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.getSample(index);
    }

    @Override
    public int getLength() {
        log.finest("getLength");
        int length = 0;
        try {
            length = this.adapted.getLength();
        }
        catch (Exception e) {
            throw new FlatFieldCacheError("Error accessing accessor template", e);
        }
        return length;
    }

    @Override
    public Unit[] getDomainUnits() {
        log.finest("getDomainUnits");
        Unit[] units = null;
        try {
            units = this.adapted.getDomainUnits();
        }
        catch (Exception e) {
            throw new FlatFieldCacheError("Error accessing accessor template", e);
        }
        return units;
    }

    @Override
    public CoordinateSystem getDomainCoordinateSystem() {
        log.finest("getDomainCoordinateSystem");
        CoordinateSystem coordSystem = null;
        try {
            this.adapted.getDomainCoordinateSystem();
        }
        catch (Exception e) {
            throw new FlatFieldCacheError("Error accessing accessor template", e);
        }
        return coordSystem;
    }

    @Override
    public CoordinateSystem[] getRangeCoordinateSystem() throws TypeException {
        log.finest("getRangeCoordinateSystem");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.getRangeCoordinateSystem();
    }

    @Override
    public CoordinateSystem[] getRangeCoordinateSystem(int component) throws TypeException {
        log.finest("getRangeCoordinateSystem");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.getRangeCoordinateSystem(component);
    }

    @Override
    public Unit[][] getRangeUnits() {
        log.finest("getRangeUnits");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.getRangeUnits();
    }

    @Override
    public Unit[] getDefaultRangeUnits() {
        log.finest("getDefaultRangeUnits");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.getDefaultRangeUnits();
    }

    @Override
    public double[][] getValues() throws VisADException {
        log.finest("getValues");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.getValues();
    }

    @Override
    public double[][] getValues(boolean copy) throws VisADException {
        log.finest("getValues");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.getValues(copy);
    }

    @Override
    public double[] getValues(int index) throws VisADException {
        log.finest("getValues");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.getValues(index);
    }

    @Override
    public float[][] getFloats(boolean copy) throws VisADException {
        log.finest("getFloats");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.getFloats(copy);
    }

    @Override
    public Set getDomainSet() {
        log.finest("getDomainSet");
        Set domainSet = null;
        try {
            domainSet = this.adapted.getDomainSet();
        }
        catch (Exception e) {
            throw new FlatFieldCacheError("Error accessing accessor template", e);
        }
        return domainSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSample(int index, Data range) throws VisADException, RemoteException {
        log.finest("setSample");
        FlatFieldCache flatFieldCache = this.cache;
        synchronized (flatFieldCache) {
            SatelliteImage fld = this.getAdaptedFlatField();
            this.cache.setDirty(this, true);
            fld.setSample(index, range);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSample(RealTuple domain, Data range) throws VisADException, RemoteException {
        log.finest("setSample");
        FlatFieldCache flatFieldCache = this.cache;
        synchronized (flatFieldCache) {
            SatelliteImage fld = this.getAdaptedFlatField();
            this.cache.setDirty(this, true);
            fld.setSample(domain, range);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSample(int index, Data range, boolean copy) throws VisADException, RemoteException {
        log.finest("getSample");
        FlatFieldCache flatFieldCache = this.cache;
        synchronized (flatFieldCache) {
            SatelliteImage fld = this.getAdaptedFlatField();
            this.cache.setDirty(this, true);
            fld.setSample(index, range, copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSamples(double[][] data) throws RemoteException, VisADException {
        log.finest("getSamples");
        FlatFieldCache flatFieldCache = this.cache;
        synchronized (flatFieldCache) {
            SatelliteImage fld = this.getAdaptedFlatField();
            this.cache.setDirty(this, true);
            fld.setSamples(data, false);
        }
    }

    @Override
    public void setSamples(double[][] range, ErrorEstimate[] errors, boolean copy) throws VisADException, RemoteException {
        this.setSamples(range);
    }

    @Override
    public boolean isMissing() {
        log.finest("isMissing");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.isMissing();
    }

    @Override
    public Data binary(Data data, int op, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        log.finest("binary");
        SatelliteImage fld = this.getAdaptedFlatField();
        return ((DataImpl)fld).binary(data, op, sampling_mode, error_mode);
    }

    @Override
    public Data binary(Data data, int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        log.finest("binary");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.binary(data, op, new_type, sampling_mode, error_mode);
    }

    @Override
    public Data unary(int op, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        log.finest("unary");
        SatelliteImage fld = this.getAdaptedFlatField();
        return ((DataImpl)fld).unary(op, sampling_mode, error_mode);
    }

    @Override
    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException {
        log.finest("unary");
        SatelliteImage fld = this.getAdaptedFlatField();
        return ((FlatField)fld).unary(op, new_type, sampling_mode, error_mode);
    }

    @Override
    public double[][] unpackValues() throws VisADException {
        log.finest("unpackValues");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.unpackValues();
    }

    @Override
    public float[][] unpackFloats() throws VisADException {
        log.finest("unpackFloats");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.unpackFloats();
    }

    @Override
    public Field extract(int component) throws VisADException, RemoteException {
        log.finest("extract");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.extract(component);
    }

    @Override
    public Field domainFactor(RealType factor) throws VisADException, RemoteException {
        log.finest("domainFactor");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.domainFactor(factor);
    }

    @Override
    public Field resample(Set set, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        log.finest("resample");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.resample(set, sampling_mode, error_mode);
    }

    @Override
    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException {
        log.finest("computeRanges");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.computeRanges(type, shadow);
    }

    @Override
    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        log.finest("adjustSamplingError");
        SatelliteImage fld = this.getAdaptedFlatField();
        return fld.adjustSamplingError(error, error_mode);
    }

    @Override
    public boolean isFlatField() {
        return true;
    }

    @Override
    public Object clone() {
        SatelliteImage fld = this.getAdaptedFlatField();
        if (fld == null) {
            return null;
        }
        return fld.clone();
    }

    @Override
    public String longString(String pre) {
        log.finest("longString");
        SatelliteImage fld = this.getAdaptedFlatField();
        try {
            return fld.longString(pre);
        }
        catch (VisADException e) {
            return pre + e.getMessage();
        }
    }

    @Override
    public String toString() {
        return this.getClass().toString();
    }
}

