/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import javax.swing.JFrame;
import visad.BadMappingException;
import visad.BaseColorControl;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.Field;
import visad.FlatField;
import visad.Function;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.ImageFlatField;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.ShadowFunctionOrSetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.Unit;
import visad.VisADException;
import visad.VisADQuadArray;
import visad.VisADTriangleStripArray;
import visad.bom.ImageRendererJ3D;
import visad.data.gif.GIFForm;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.java3d.AVControlJ3D;
import visad.java3d.AnimationControlJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.RendererJ3D;
import visad.java3d.ShadowFunctionTypeJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.java3d.VisADBranchGroup;

public class ShadowImageFunctionTypeJ3D
extends ShadowFunctionTypeJ3D {
    private static final int MISSING1 = -128;
    private static DisplayImpl display;
    private static BaseMapAdapter baseMap;
    private static ScalarMap lat_map;
    private static ScalarMap lon_map;
    private static ScalarMap xaxis;
    private static ScalarMap yaxis;

    public ShadowImageFunctionTypeJ3D(MathType t, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t, link, parent);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        int domain_length;
        DataDisplayLink link = renderer.getLink();
        if (data.isMissing()) {
            ((ImageRendererJ3D)renderer).markMissingVisADBranch();
            return false;
        }
        if (this.getLevelOfDifficulty() == 6) {
            return false;
        }
        ShadowFunctionOrSetType adaptedShadowType = (ShadowFunctionOrSetType)this.getAdaptedShadowType();
        DisplayImpl display = this.getDisplay();
        GraphicsModeControl mode = (GraphicsModeControl)display.getGraphicsModeControl().clone();
        display.setDepthBufferOffset(renderer, mode);
        boolean anyContour = adaptedShadowType.getAnyContour();
        boolean anyFlow = adaptedShadowType.getAnyFlow();
        boolean anyShape = adaptedShadowType.getAnyShape();
        boolean anyText = adaptedShadowType.getAnyText();
        if (anyContour || anyFlow || anyShape || anyText) {
            throw new BadMappingException("no contour, flow, shape or text allowed");
        }
        int valueArrayLength = display.getValueArrayLength();
        int[] valueToScalar = display.getValueToScalar();
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        float[][] display_values = new float[valueArrayLength][];
        int[] inherited_values = adaptedShadowType.getInheritedValues();
        for (int i = 0; i < valueArrayLength; ++i) {
            if (inherited_values[i] <= 0) continue;
            display_values[i] = new float[1];
            display_values[i][0] = value_array[i];
        }
        Set domain_set = ((Field)data).getDomainSet();
        Unit[] dataUnits = ((Function)data).getDomainUnits();
        CoordinateSystem dataCoordinateSystem = ((Function)data).getDomainCoordinateSystem();
        float[][] domain_values = null;
        double[][] domain_doubles = null;
        ShadowRealTupleType Domain2 = adaptedShadowType.getDomain();
        Unit[] domain_units = ((RealTupleType)Domain2.getType()).getDefaultUnits();
        try {
            domain_length = domain_set.getLength();
            int domain_dimension = domain_set.getDimension();
        }
        catch (SetException e) {
            return false;
        }
        ShadowRealType[] DomainComponents = adaptedShadowType.getDomainComponents();
        if (adaptedShadowType.getIsTerminal()) {
            void var38_62;
            int j;
            float constant_alpha = Float.NaN;
            float[] constant_color = null;
            ShadowRealType[] RangeComponents = adaptedShadowType.getRangeComponents();
            int rangesize = RangeComponents.length;
            if (rangesize != 1 && rangesize != 3) {
                throw new BadMappingException("image values must single or triple");
            }
            ScalarMap cmap = null;
            ScalarMap[] cmaps = null;
            int[] permute = new int[]{-1, -1, -1};
            int color_length = 3;
            if (rangesize == 1) {
                Vector vector = RangeComponents[0].getSelectedMapVector();
                if (vector.size() != 1) {
                    throw new BadMappingException("image values must be mapped to RGB only");
                }
                cmap = (ScalarMap)vector.elementAt(0);
                if (Display.RGB.equals(cmap.getDisplayScalar())) {
                    color_length = 3;
                } else {
                    if (!Display.RGBA.equals(cmap.getDisplayScalar())) throw new BadMappingException("image values must be mapped to RGB or RGBA");
                    color_length = 4;
                }
            } else {
                int n;
                int i;
                void var38_50;
                cmaps = new ScalarMap[3];
                boolean bl = false;
                while (var38_50 < 3) {
                    Vector mvector = RangeComponents[var38_50].getSelectedMapVector();
                    if (mvector.size() != 1) {
                        throw new BadMappingException("image values must be mapped to color only");
                    }
                    cmaps[var38_50] = (ScalarMap)mvector.elementAt(0);
                    if (Display.Red.equals(cmaps[var38_50].getDisplayScalar())) {
                        permute[0] = var38_50;
                    } else if (Display.Green.equals(cmaps[var38_50].getDisplayScalar())) {
                        permute[1] = var38_50;
                    } else if (Display.Blue.equals(cmaps[var38_50].getDisplayScalar())) {
                        permute[2] = var38_50;
                    } else {
                        if (!Display.RGB.equals(cmaps[var38_50].getDisplayScalar())) throw new BadMappingException("image values must be mapped to Red, Green or Blue only");
                        permute[var38_50] = var38_50;
                    }
                    ++var38_50;
                }
                if (permute[0] < 0 || permute[1] < 0 || permute[2] < 0) {
                    throw new BadMappingException("image values must be mapped to Red, Green and Blue");
                }
                int n2 = -1;
                for (i = 0; i < 3; ++i) {
                    if (!cmaps[i].getDisplayScalar().equals(Display.RGB)) continue;
                    n = i;
                    break;
                }
                if (n != -1) {
                    for (i = 0; i < 3; ++i) {
                        if (i == n || cmaps[i].getDisplayScalar().equals(Display.RGB)) continue;
                        throw new BadMappingException("image values must be mapped to (Red, Green, Blue) or (RGB,RGB,RGB) only");
                    }
                }
            }
            constant_alpha = default_values[display.getDisplayScalarIndex(Display.Alpha)];
            if (cmap != null) {
                BaseColorControl control = (BaseColorControl)cmap.getControl();
                float[][] fArray = control.getTable();
                byte[][] bytes = null;
                Set rset = null;
                boolean is_default_unit = false;
                if (data instanceof FlatField) {
                    RealType rtype;
                    Unit def_unit;
                    bytes = ((FlatField)data).grabBytes();
                    Set[] rsets = ((FlatField)data).getRangeSets();
                    if (rsets != null) {
                        rset = rsets[0];
                    }
                    if ((def_unit = (rtype = (RealType)RangeComponents[0].getType()).getDefaultUnit()) == null) {
                        is_default_unit = true;
                    } else {
                        Unit[][] data_units = ((FlatField)data).getRangeUnits();
                        Unit data_unit = data_units == null ? null : data_units[0][0];
                        is_default_unit = def_unit.equals(data_unit);
                    }
                }
                if (fArray != null) {
                    byte[][] itable = new byte[fArray[0].length][4];
                    int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                    int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                    for (int j2 = 0; j2 < fArray[0].length; ++j2) {
                        int b;
                        c = (int)(255.0 * (double)fArray[0][j2]);
                        int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)fArray[1][j2]);
                        int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)fArray[2][j2]);
                        int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                        if (color_length == 4) {
                            c = (int)(255.0 * (double)fArray[3][j2]);
                            a = c < 0 ? 0 : (c > 255 ? 255 : c);
                        }
                        itable[j2][0] = (byte)r;
                        itable[j2][1] = (byte)g;
                        itable[j2][2] = (byte)b;
                        itable[j2][3] = (byte)a;
                    }
                    int tblEnd = fArray[0].length - 1;
                    int table_scale = fArray[0].length;
                    if (data instanceof ImageFlatField && bytes != null && is_default_unit) {
                        byte[][] byArray = new byte[4][domain_length];
                        bytes[0] = cmap.scaleValues(bytes[0], table_scale);
                        byte[] bytes0 = bytes[0];
                        for (int i = 0; i < domain_length; ++i) {
                            int j3 = bytes0[i] & 0xFF;
                            int ndx = j3 < 0 ? 0 : (j3 > tblEnd ? tblEnd : j3);
                            byArray[0][i] = itable[ndx][0];
                            byArray[1][i] = itable[ndx][1];
                            byArray[2][i] = itable[ndx][2];
                            byArray[3][i] = itable[ndx][3];
                        }
                    } else if (bytes != null && bytes[0] != null && is_default_unit && rset != null && rset instanceof Linear1DSet) {
                        double first = ((Linear1DSet)rset).getFirst();
                        double step = ((Linear1DSet)rset).getStep();
                        double[] so = new double[2];
                        double[] da = new double[2];
                        double[] di = new double[2];
                        cmap.getScale(so, da, di);
                        double scale = so[0];
                        double offset = so[1];
                        float mult = (float)((double)table_scale * scale * step);
                        float add = (float)((double)table_scale * (offset + scale * first));
                        byte[][] fast_table = new byte[256][];
                        for (int j4 = 0; j4 < 256; ++j4) {
                            int index = j4 - 1;
                            if (index < 0) continue;
                            int k = (int)(add + mult * (float)index);
                            int ndx = k < 0 ? 0 : (k > tblEnd ? tblEnd : k);
                            fast_table[j4] = itable[ndx];
                        }
                        byte[][] byArray = new byte[4][domain_length];
                        byte[] bytes0 = bytes[0];
                        for (int i = 0; i < domain_length; ++i) {
                            int ndx = bytes0[i] - -128;
                            byArray[0][i] = fast_table[ndx][0];
                            byArray[1][i] = fast_table[ndx][1];
                            byArray[2][i] = fast_table[ndx][2];
                            byArray[3][i] = fast_table[ndx][3];
                        }
                        bytes = null;
                    } else {
                        bytes = null;
                        float[][] values = ((Field)data).getFloats(false);
                        values[0] = cmap.scaleValues(values[0]);
                        byte[][] byArray = new byte[4][domain_length];
                        float[] values0 = values[0];
                        for (int i = 0; i < domain_length; ++i) {
                            if (values0[i] != values0[i]) continue;
                            j = (int)((float)table_scale * values0[i]);
                            int ndx = j < 0 ? 0 : (j > tblEnd ? tblEnd : j);
                            byArray[0][i] = itable[ndx][0];
                            byArray[1][i] = itable[ndx][1];
                            byArray[2][i] = itable[ndx][2];
                            byArray[3][i] = itable[ndx][3];
                        }
                        values = null;
                    }
                } else {
                    bytes = null;
                    float[][] values = ((Field)data).getFloats(false);
                    values[0] = cmap.scaleValues(values[0]);
                    float[][] color_values = control.lookupValues(values[0]);
                    int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                    int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                    byte[][] byArray = new byte[4][domain_length];
                    for (int i = 0; i < domain_length; ++i) {
                        int b;
                        if (values[0][i] != values[0][i]) continue;
                        c = (int)(255.0 * (double)color_values[0][i]);
                        int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)color_values[1][i]);
                        int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)color_values[2][i]);
                        int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                        if (color_length == 4) {
                            c = (int)(255.0 * (double)color_values[3][i]);
                            a = c < 0 ? 0 : (c > 255 ? 255 : c);
                        }
                        byArray[0][i] = (byte)r;
                        byArray[1][i] = (byte)g;
                        byArray[2][i] = (byte)b;
                        byArray[3][i] = (byte)a;
                    }
                    values = null;
                    color_values = null;
                }
            } else {
                if (cmaps == null) throw new BadMappingException("cmap == null and cmaps == null ??");
                byte[][] bytes = null;
                if (data instanceof ImageFlatField) {
                    bytes = ((ImageFlatField)data).grabBytes();
                }
                if (bytes != null) {
                    byte[][] byArrayArray = new byte[4][];
                    if (cmaps[0].getDisplayScalar() == Display.RGB && cmaps[1].getDisplayScalar() == Display.RGB && cmaps[2].getDisplayScalar() == Display.RGB) {
                        void var40_73;
                        boolean bl2 = false;
                        bl2 = false;
                        while (var40_73 < cmaps.length) {
                            BaseColorControl basecolorcontrol = (BaseColorControl)cmaps[var40_73].getControl();
                            float[][] color_table = basecolorcontrol.getTable();
                            int[][] itable = new int[color_table[0].length][3];
                            for (int table_indx = 0; table_indx < itable.length; ++table_indx) {
                                int c = (int)(255.0 * (double)color_table[0][table_indx]);
                                int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                                c = (int)(255.0 * (double)color_table[1][table_indx]);
                                int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                                c = (int)(255.0 * (double)color_table[2][table_indx]);
                                int b = c < 0 ? 0 : (c > 255 ? 255 : c);
                                itable[table_indx][0] = (byte)r;
                                itable[table_indx][1] = (byte)g;
                                itable[table_indx][2] = (byte)b;
                            }
                            int table_length = color_table[0].length;
                            int color_indx = permute[var40_73];
                            byte[] bytes1 = cmaps[color_indx].scaleValues(bytes[color_indx], table_length);
                            int domainLength = bytes1.length;
                            int tblEnd = table_length - 1;
                            byArrayArray[var40_73] = new byte[domain_length];
                            for (int data_indx = 0; data_indx < domainLength; ++data_indx) {
                                j = bytes1[data_indx] & 0xFF;
                                int ndx = j < 0 ? 0 : (j > tblEnd ? tblEnd : j);
                                byArrayArray[var40_73][data_indx] = (byte)itable[ndx][var40_73];
                            }
                            itable = null;
                            bytes1 = null;
                            ++var40_73;
                        }
                    } else {
                        byArrayArray[0] = cmaps[permute[0]].scaleValues(bytes[permute[0]], 255);
                        byArrayArray[1] = cmaps[permute[1]].scaleValues(bytes[permute[1]], 255);
                        byArrayArray[2] = cmaps[permute[2]].scaleValues(bytes[permute[2]], 255);
                    }
                    int n = (int)(255.0 * (double)(1.0f - constant_alpha));
                    byArrayArray[3] = new byte[domain_length];
                    Arrays.fill(byArrayArray[3], (byte)n);
                } else {
                    int b;
                    int g;
                    int r;
                    float[][] fArray = ((Field)data).getFloats(false);
                    float[][] new_values = new float[][]{cmaps[permute[0]].scaleValues(fArray[permute[0]]), cmaps[permute[1]].scaleValues(fArray[permute[1]]), cmaps[permute[2]].scaleValues(fArray[permute[2]])};
                    float[][] fArrayArray = new_values;
                    int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                    int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                    byte[][] byArray = new byte[4][domain_length];
                    if (cmaps[0].getDisplayScalar() == Display.RGB && cmaps[1].getDisplayScalar() == Display.RGB && cmaps[2].getDisplayScalar() == Display.RGB) {
                        for (int map_indx = 0; map_indx < cmaps.length; ++map_indx) {
                            BaseColorControl basecolorcontrol = (BaseColorControl)cmaps[map_indx].getControl();
                            float[][] color_table = basecolorcontrol.getTable();
                            int[][] itable = new int[color_table[0].length][3];
                            for (int table_indx = 0; table_indx < itable.length; ++table_indx) {
                                c = (int)(255.0 * (double)color_table[0][table_indx]);
                                r = c < 0 ? 0 : (c > 255 ? 255 : c);
                                c = (int)(255.0 * (double)color_table[1][table_indx]);
                                g = c < 0 ? 0 : (c > 255 ? 255 : c);
                                c = (int)(255.0 * (double)color_table[2][table_indx]);
                                b = c < 0 ? 0 : (c > 255 ? 255 : c);
                                itable[table_indx][0] = (byte)r;
                                itable[table_indx][1] = (byte)g;
                                itable[table_indx][2] = (byte)b;
                            }
                            int tableEnd = color_table[0].length - 1;
                            for (int data_indx = 0; data_indx < domain_length; ++data_indx) {
                                int indx = (int)((float)tableEnd * fArrayArray[map_indx][data_indx]);
                                indx = indx < 0 ? 0 : (indx > tableEnd ? tableEnd : indx);
                                byArray[map_indx][data_indx] = (byte)itable[indx][map_indx];
                            }
                            itable = null;
                        }
                        Arrays.fill(byArray[3], (byte)a);
                    } else {
                        for (int i = 0; i < domain_length; ++i) {
                            if (fArrayArray[0][i] != fArrayArray[0][i] || fArrayArray[1][i] != fArrayArray[1][i] || fArrayArray[2][i] != fArrayArray[2][i]) continue;
                            c = (int)(255.0 * (double)fArrayArray[0][i]);
                            r = c < 0 ? 0 : (c > 255 ? 255 : c);
                            c = (int)(255.0 * (double)fArrayArray[1][i]);
                            g = c < 0 ? 0 : (c > 255 ? 255 : c);
                            c = (int)(255.0 * (double)fArrayArray[2][i]);
                            b = c < 0 ? 0 : (c > 255 ? 255 : c);
                            byArray[0][i] = (byte)r;
                            byArray[1][i] = (byte)g;
                            byArray[2][i] = (byte)b;
                            byArray[3][i] = (byte)a;
                        }
                    }
                    float[][] fArray2 = null;
                }
            }
            if (!Domain2.getAllSpatial() || Domain2.getMultipleDisplayScalar()) {
                throw new BadMappingException("domain must be only spatial");
            }
            boolean isTextureMap = adaptedShadowType.getIsTextureMap() && (domain_set instanceof Linear2DSet || domain_set instanceof LinearNDSet && domain_set.getDimension() == 2) && domain_set.getManifoldDimension() == 2;
            int n = (int)default_values[display.getDisplayScalarIndex(Display.CurvedSize)];
            int curved_size = n > 0 ? n : display.getGraphicsModeControl().getCurvedSize();
            boolean curvedTexture = adaptedShadowType.getCurvedTexture() && !isTextureMap && curved_size > 0 && (domain_set instanceof Gridded2DSet || domain_set instanceof GriddedSet && domain_set.getDimension() == 2) && domain_set.getManifoldDimension() == 2;
            Object coordinates = null;
            Object texCoords = null;
            Object normals = null;
            Object colors = null;
            boolean data_width = false;
            boolean data_height = false;
            boolean texture_width = true;
            boolean texture_height = true;
            Object coordinatesX = null;
            Object texCoordsX = null;
            Object normalsX = null;
            Object colorsX = null;
            Object coordinatesY = null;
            Object texCoordsY = null;
            Object normalsY = null;
            Object colorsY = null;
            if (color_length == 4) {
                constant_alpha = Float.NaN;
            }
            if (isTextureMap) {
                int k;
                int[] lens = ((GriddedSet)domain_set).getLengths();
                int limit = link.getDisplay().getDisplayRenderer().getTextureWidthMax();
                int y_sub_len = lens[1];
                int n_y_sub = 1;
                while (y_sub_len >= limit) {
                    y_sub_len /= 2;
                    n_y_sub *= 2;
                }
                int[][] y_start_stop = new int[n_y_sub][2];
                for (k = 0; k < n_y_sub - 1; ++k) {
                    y_start_stop[k][0] = k * y_sub_len;
                    y_start_stop[k][1] = (k + 1) * y_sub_len - 1;
                }
                k = n_y_sub - 1;
                y_start_stop[k][0] = k * y_sub_len;
                y_start_stop[k][1] = lens[1] - 1;
                int x_sub_len = lens[0];
                int n_x_sub = 1;
                while (x_sub_len >= limit) {
                    x_sub_len /= 2;
                    n_x_sub *= 2;
                }
                int[][] x_start_stop = new int[n_x_sub][2];
                for (k = 0; k < n_x_sub - 1; ++k) {
                    x_start_stop[k][0] = k * x_sub_len;
                    x_start_stop[k][1] = (k + 1) * x_sub_len - 1;
                }
                k = n_x_sub - 1;
                x_start_stop[k][0] = k * x_sub_len;
                x_start_stop[k][1] = lens[0] - 1;
                if (n_y_sub == 1 && n_x_sub == 1) {
                    this.buildLinearTexture(group, domain_set, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, (byte[][])var38_62, display);
                } else {
                    BranchGroup branch = new BranchGroup();
                    branch.setCapability(17);
                    branch.setCapability(14);
                    branch.setCapability(12);
                    branch.setCapability(13);
                    int start = 0;
                    int i_total = 0;
                    for (int i = 0; i < n_y_sub; ++i) {
                        int leny = y_start_stop[i][1] - y_start_stop[i][0] + 1;
                        for (int j5 = 0; j5 < n_x_sub; ++j5) {
                            int lenx = x_start_stop[j5][1] - x_start_stop[j5][0] + 1;
                            float[][] g00 = ((GriddedSet)domain_set).gridToValue(new float[][]{{x_start_stop[j5][0]}, {y_start_stop[i][0]}});
                            float[][] g11 = ((GriddedSet)domain_set).gridToValue(new float[][]{{x_start_stop[j5][1]}, {y_start_stop[i][1]}});
                            double x0 = g00[0][0];
                            double x1 = g11[0][0];
                            double y0 = g00[1][0];
                            double y1 = g11[1][0];
                            Linear2DSet dset = new Linear2DSet(x0, x1, lenx, y0, y1, leny);
                            byte[][] color_bytesW = new byte[4][lenx * leny];
                            int cnt = 0;
                            for (k = 0; k < leny; ++k) {
                                start = x_start_stop[j5][0] + i_total * lens[0] + k * lens[0];
                                for (int c = 0; c < 4; ++c) {
                                    System.arraycopy(var38_62[c], start, color_bytesW[c], cnt, lenx);
                                }
                                cnt += lenx;
                            }
                            BranchGroup branch1 = new BranchGroup();
                            branch1.setCapability(17);
                            branch1.setCapability(14);
                            branch1.setCapability(12);
                            branch1.setCapability(13);
                            this.buildLinearTexture(branch1, dset, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_bytesW, display);
                            branch.addChild(branch1);
                        }
                        i_total += leny;
                    }
                    if (((Group)group).numChildren() > 0) {
                        ((Group)group).setChild(branch, 0);
                    } else {
                        ((Group)group).addChild(branch);
                    }
                }
            } else {
                int k;
                if (!curvedTexture) throw new BadMappingException("must be texture map or curved texture map");
                int[] lens = ((GriddedSet)domain_set).getLengths();
                int limit = link.getDisplay().getDisplayRenderer().getTextureWidthMax();
                int y_sub_len = lens[1];
                int n_y_sub = 1;
                while (y_sub_len >= limit) {
                    y_sub_len /= 2;
                    n_y_sub *= 2;
                }
                int[][] y_start_stop = new int[n_y_sub][2];
                for (k = 0; k < n_y_sub - 1; ++k) {
                    y_start_stop[k][0] = k * y_sub_len;
                    y_start_stop[k][1] = (k + 1) * y_sub_len - 1;
                }
                k = n_y_sub - 1;
                y_start_stop[k][0] = k * y_sub_len;
                y_start_stop[k][1] = lens[1] - 1;
                int x_sub_len = lens[0];
                int n_x_sub = 1;
                while (x_sub_len >= limit) {
                    x_sub_len /= 2;
                    n_x_sub *= 2;
                }
                int[][] x_start_stop = new int[n_x_sub][2];
                for (k = 0; k < n_x_sub - 1; ++k) {
                    x_start_stop[k][0] = k * x_sub_len;
                    x_start_stop[k][1] = (k + 1) * x_sub_len - 1;
                }
                k = n_x_sub - 1;
                x_start_stop[k][0] = k * x_sub_len;
                x_start_stop[k][1] = lens[0] - 1;
                if (n_y_sub == 1 && n_x_sub == 1) {
                    this.buildCurvedTexture(group, domain_set, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, (byte[][])var38_62, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{0, 0}, lens[0], lens[1], null, lens[0], lens[1]);
                } else {
                    float[][] samples = ((GriddedSet)domain_set).getSamples(false);
                    BranchGroup branch = new BranchGroup();
                    branch.setCapability(17);
                    branch.setCapability(14);
                    branch.setCapability(12);
                    branch.setCapability(13);
                    int start = 0;
                    int i_total = 0;
                    for (int i = 0; i < n_y_sub; ++i) {
                        int leny = y_start_stop[i][1] - y_start_stop[i][0] + 1;
                        for (int j6 = 0; j6 < n_x_sub; ++j6) {
                            float[][] samplesC;
                            int lenx = x_start_stop[j6][1] - x_start_stop[j6][0] + 1;
                            if (j6 > 0) {
                                samplesC = new float[2][4 * leny];
                                byte[][] color_bytesC = new byte[4][4 * leny];
                                int cntv = 0;
                                int startv = x_start_stop[j6][0] + i_total * lens[0];
                                for (int iv = 0; iv < leny; ++iv) {
                                    samplesC[0][cntv] = samples[0][startv - 2];
                                    samplesC[0][cntv + 1] = samples[0][startv - 1];
                                    samplesC[0][cntv + 2] = samples[0][startv];
                                    samplesC[0][cntv + 3] = samples[0][startv + 1];
                                    samplesC[1][cntv] = samples[1][startv - 2];
                                    samplesC[1][cntv + 1] = samples[1][startv - 1];
                                    samplesC[1][cntv + 2] = samples[1][startv];
                                    samplesC[1][cntv + 3] = samples[1][startv + 1];
                                    for (int c = 0; c < 4; ++c) {
                                        color_bytesC[c][cntv] = var38_62[c][startv - 2];
                                        color_bytesC[c][cntv + 1] = var38_62[c][startv - 1];
                                        color_bytesC[c][cntv + 2] = var38_62[c][startv];
                                        color_bytesC[c][cntv + 3] = var38_62[c][startv + 1];
                                    }
                                    cntv += 4;
                                    startv += lens[0];
                                }
                                Gridded2DSet gsetv = new Gridded2DSet(domain_set.getType(), samplesC, 4, leny);
                                BranchGroup branchv = new BranchGroup();
                                branchv.setCapability(17);
                                branchv.setCapability(14);
                                branchv.setCapability(12);
                                branchv.setCapability(13);
                                this.buildCurvedTexture(branchv, gsetv, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_bytesC, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{x_start_stop[j6][0], y_start_stop[i][0]}, lenx, leny, samples, lens[0], lens[1]);
                                branch.addChild(branchv);
                            }
                            if (i > 0) {
                                int c;
                                samplesC = new float[2][4 * lenx];
                                byte[][] color_bytesC = new byte[4][4 * lenx];
                                int starth = x_start_stop[j6][0] + i_total * lens[0];
                                int cnth = 0;
                                System.arraycopy(samples[0], starth - 2 * lens[0], samplesC[0], cnth, lenx);
                                System.arraycopy(samples[1], starth - 2 * lens[0], samplesC[1], cnth, lenx);
                                System.arraycopy(samples[0], starth - 1 * lens[0], samplesC[0], cnth += lenx, lenx);
                                System.arraycopy(samples[1], starth - 1 * lens[0], samplesC[1], cnth, lenx);
                                System.arraycopy(samples[0], starth, samplesC[0], cnth += lenx, lenx);
                                System.arraycopy(samples[1], starth, samplesC[1], cnth, lenx);
                                System.arraycopy(samples[0], starth + 1 * lens[0], samplesC[0], cnth += lenx, lenx);
                                System.arraycopy(samples[1], starth + 1 * lens[0], samplesC[1], cnth, lenx);
                                cnth = 0;
                                for (c = 0; c < 4; ++c) {
                                    System.arraycopy(var38_62[c], starth - 2 * lens[0], color_bytesC[c], cnth, lenx);
                                }
                                cnth += lenx;
                                for (c = 0; c < 4; ++c) {
                                    System.arraycopy(var38_62[c], starth - 1 * lens[0], color_bytesC[c], cnth, lenx);
                                }
                                cnth += lenx;
                                for (c = 0; c < 4; ++c) {
                                    System.arraycopy(var38_62[c], starth, color_bytesC[c], cnth, lenx);
                                }
                                cnth += lenx;
                                for (c = 0; c < 4; ++c) {
                                    System.arraycopy(var38_62[c], starth + 1 * lens[0], color_bytesC[c], cnth, lenx);
                                }
                                Gridded2DSet gseth = new Gridded2DSet(domain_set.getType(), samplesC, lenx, 4);
                                BranchGroup branchh = new BranchGroup();
                                branchh.setCapability(17);
                                branchh.setCapability(14);
                                branchh.setCapability(12);
                                branchh.setCapability(13);
                                this.buildCurvedTexture(branchh, gseth, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_bytesC, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{x_start_stop[j6][0], y_start_stop[i][0]}, lenx, leny, samples, lens[0], lens[1]);
                                branch.addChild(branchh);
                            }
                            byte[][] color_bytesW = new byte[4][lenx * leny];
                            int cnt = 0;
                            for (k = 0; k < leny; ++k) {
                                start = x_start_stop[j6][0] + i_total * lens[0] + k * lens[0];
                                for (int c = 0; c < 4; ++c) {
                                    System.arraycopy(var38_62[c], start, color_bytesW[c], cnt, lenx);
                                }
                                cnt += lenx;
                            }
                            Set gset1 = null;
                            BranchGroup branch1 = new BranchGroup();
                            branch1.setCapability(17);
                            branch1.setCapability(14);
                            branch1.setCapability(12);
                            branch1.setCapability(13);
                            this.buildCurvedTexture(branch1, gset1, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_bytesW, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{x_start_stop[j6][0], y_start_stop[i][0]}, lenx, leny, samples, lens[0], lens[1]);
                            branch.addChild(branch1);
                        }
                        i_total += leny;
                    }
                    byte[][] byArray = null;
                    if (((Group)group).numChildren() > 0) {
                        ((Group)group).setChild(branch, 0);
                    } else {
                        ((Group)group).addChild(branch);
                    }
                }
            }
        } else {
            int i;
            ScalarMap map;
            Vector domain_maps = DomainComponents[0].getSelectedMapVector();
            ScalarMap amap = null;
            if (domain_set.getDimension() == 1 && domain_maps.size() == 1 && Display.Animation.equals((map = (ScalarMap)domain_maps.elementAt(0)).getDisplayScalar())) {
                amap = map;
            }
            if (amap == null) {
                throw new BadMappingException("time must be mapped to Animation");
            }
            AnimationControlJ3D control = (AnimationControlJ3D)amap.getControl();
            Switch old_swit = null;
            BranchGroup[] old_nodes = null;
            double[] old_times = null;
            boolean[] old_mark = null;
            int old_len = 0;
            boolean bl = ((ImageRendererJ3D)renderer).getReUseFrames();
            if (group instanceof BranchGroup && ((BranchGroup)group).numChildren() > 0) {
                Node g = ((BranchGroup)group).getChild(0);
                if (g instanceof BranchGroup && ((BranchGroup)g).numChildren() > 0) {
                    g = ((BranchGroup)g).getChild(0);
                }
                if (g instanceof Switch && (old_len = (old_swit = (Switch)g).numChildren()) > 0) {
                    void var40_84;
                    void var40_82;
                    void var40_80;
                    old_nodes = new BranchGroup[old_len];
                    boolean bl3 = false;
                    while (var40_80 < old_len) {
                        old_nodes[var40_80] = (BranchGroup)old_swit.getChild((int)var40_80);
                        ++var40_80;
                    }
                    boolean bl4 = false;
                    while (var40_82 < old_len) {
                        old_nodes[var40_82].detach();
                        ++var40_82;
                    }
                    old_times = new double[old_len];
                    old_mark = new boolean[old_len];
                    boolean bl5 = false;
                    while (var40_84 < old_len) {
                        old_mark[var40_84] = false;
                        old_times[var40_84] = old_nodes[var40_84] instanceof VisADBranchGroup && bl ? ((VisADBranchGroup)old_nodes[var40_84]).getTime() : Double.NaN;
                        ++var40_84;
                    }
                }
            }
            double[][] values = domain_set.getDoubles();
            double[] dArray = values[0];
            int len = dArray.length;
            double delta = Math.abs((dArray[len - 1] - dArray[0]) / (1000.0 * (double)len));
            Switch swit = null;
            if (old_swit != null) {
                swit = old_swit;
                control.addPair(swit, domain_set, renderer);
                ((AVControlJ3D)control).init();
            } else {
                swit = (Switch)this.makeSwitch();
                swit.setCapability(14);
                swit.setCapability(12);
                swit.setCapability(13);
                this.addSwitch(group, swit, control, domain_set, renderer);
            }
            VisADBranchGroup[] nodes = new VisADBranchGroup[len];
            boolean[] mark = new boolean[len];
            for (i = 0; i < len; ++i) {
                for (int j = 0; j < old_len; ++j) {
                    if (old_mark[j] || !(Math.abs(dArray[i] - old_times[j]) < delta)) continue;
                    old_mark[j] = true;
                    nodes[i] = (VisADBranchGroup)old_nodes[j];
                    break;
                }
                if (nodes[i] != null) {
                    mark[i] = true;
                } else {
                    mark[i] = false;
                    nodes[i] = new VisADBranchGroup(dArray[i]);
                    nodes[i].setCapability(17);
                    nodes[i].setCapability(14);
                    nodes[i].setCapability(12);
                    nodes[i].setCapability(13);
                    this.ensureNotEmpty(nodes[i]);
                }
                this.addToSwitch(swit, nodes[i]);
            }
            for (int j = 0; j < old_len; ++j) {
                if (old_mark[j]) continue;
                ((RendererJ3D)renderer).flush(old_nodes[j]);
                old_nodes[j] = null;
            }
            if (group instanceof BranchGroup) {
                ((ImageRendererJ3D)renderer).setBranchEarly((BranchGroup)group);
            }
            if (((ImageRendererJ3D)renderer).getReUseFrames() && ((ImageRendererJ3D)renderer).getSetSetOnReUseFrames()) {
                control.setSet(domain_set, true);
            }
            old_nodes = null;
            old_times = null;
            old_mark = null;
            for (i = 0; i < len; ++i) {
                if (mark[i]) continue;
                BranchGroup branch = (BranchGroup)this.makeBranch();
                ((ImageRendererJ3D)renderer).setVisADBranch(nodes[i]);
                this.recurseRange(branch, ((Field)data).getSample(i), value_array, default_values, renderer);
                ((ImageRendererJ3D)renderer).setVisADBranch(null);
                nodes[i].addChild(branch);
            }
        }
        this.ensureNotEmpty(group);
        return false;
    }

    public void buildCurvedTexture(Object group, Set domain_set, Unit[] dataUnits, Unit[] domain_units, float[] default_values, ShadowRealType[] DomainComponents, int valueArrayLength, int[] inherited_values, int[] valueToScalar, GraphicsModeControl mode, float constant_alpha, float[] value_array, float[] constant_color, byte[][] color_bytes, DisplayImpl display, int curved_size, ShadowRealTupleType Domain2, CoordinateSystem dataCoordinateSystem, DataRenderer renderer, ShadowFunctionOrSetType adaptedShadowType, int[] start, int lenX, int lenY, float[][] samples, int bigX, int bigY) throws VisADException, DisplayException {
        int len;
        int i;
        RealTupleType ref;
        float[] coordinates = null;
        float[] texCoords = null;
        float[] normals = null;
        byte[] colors = null;
        int data_width = 0;
        int data_height = 0;
        int texture_width = 1;
        int texture_height = 1;
        int[] lengths = null;
        lengths = domain_set != null ? ((GriddedSet)domain_set).getLengths() : new int[]{lenX, lenY};
        data_width = lengths[0];
        data_height = lengths[1];
        texture_width = this.textureWidth(data_width);
        texture_height = this.textureHeight(data_height);
        int size = (data_width + data_height) / 2;
        curved_size = Math.min(curved_size, size / 32);
        int nwidth = 2 + (data_width - 1) / curved_size;
        int nheight = 2 + (data_height - 1) / curved_size;
        int nn = nwidth * nheight;
        int[] is = new int[nwidth];
        int[] js = new int[nheight];
        for (int i2 = 0; i2 < nwidth; ++i2) {
            is[i2] = Math.min(i2 * curved_size, data_width - 1);
        }
        for (int j = 0; j < nheight; ++j) {
            js[j] = Math.min(j * curved_size, data_height - 1);
        }
        int[] indices = new int[nn];
        int k = 0;
        for (int j = 0; j < nheight; ++j) {
            for (int i3 = 0; i3 < nwidth; ++i3) {
                indices[k] = is[i3] + data_width * js[j];
                ++k;
            }
        }
        float[][] spline_domain = null;
        if (domain_set == null) {
            int kk;
            for (kk = 0; kk < indices.length; ++kk) {
                int x = indices[kk] % lenX;
                int y = indices[kk] / lenX;
                indices[kk] = start[0] + x + (start[1] + y) * bigX;
            }
            spline_domain = new float[2][indices.length];
            for (kk = 0; kk < indices.length; ++kk) {
                spline_domain[0][kk] = samples[0][indices[kk]];
                spline_domain[1][kk] = samples[1][indices[kk]];
            }
        } else {
            spline_domain = domain_set.indexToValue(indices);
        }
        spline_domain = Unit.convertTuple(spline_domain, dataUnits, domain_units, false);
        ShadowRealTupleType domain_reference = Domain2.getReference();
        ShadowRealType[] DC = DomainComponents;
        if (domain_reference != null && domain_reference.getMappedDisplayScalar()) {
            ref = (RealTupleType)domain_reference.getType();
            renderer.setEarthSpatialData(Domain2, domain_reference, ref, ref.getDefaultUnits(), (RealTupleType)Domain2.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
            spline_domain = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)Domain2.getType(), dataCoordinateSystem, domain_units, null, spline_domain);
            DC = adaptedShadowType.getDomainReferenceComponents();
        } else {
            ref = domain_reference == null ? null : (RealTupleType)domain_reference.getType();
            Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
            renderer.setEarthSpatialData(Domain2, domain_reference, ref, ref_units, (RealTupleType)Domain2.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
        }
        int[] tuple_index = new int[3];
        int[] spatial_value_indices = new int[]{-1, -1, -1};
        ScalarMap[] spatial_maps = new ScalarMap[3];
        DisplayTupleType spatial_tuple = null;
        for (int i4 = 0; i4 < DC.length; ++i4) {
            Enumeration maps = DC[i4].getSelectedMapVector().elements();
            ScalarMap map = (ScalarMap)maps.nextElement();
            DisplayRealType real = map.getDisplayScalar();
            spatial_tuple = real.getTuple();
            if (spatial_tuple == null) {
                throw new DisplayException("texture with bad tuple: ShadowImageFunctionTypeJ3D.doTransform");
            }
            tuple_index[i4] = real.getTupleIndex();
            spatial_value_indices[tuple_index[i4]] = map.getValueIndex();
            spatial_maps[tuple_index[i4]] = map;
            if (!maps.hasMoreElements()) continue;
            throw new DisplayException("texture with multiple spatial: ShadowImageFunctionTypeJ3D.doTransform");
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)spatial_tuple.getComponent(tuple_index[2]);
        int value2_index = display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        for (int i5 = 0; i5 < valueArrayLength; ++i5) {
            if (inherited_values[i5] <= 0 || !real.equals(display.getDisplayScalar(valueToScalar[i5]))) continue;
            value2 = value_array[i5];
            break;
        }
        Object spatial_values = new float[3][];
        spatial_values[tuple_index[0]] = spline_domain[0];
        spatial_values[tuple_index[1]] = spline_domain[1];
        spatial_values[tuple_index[2]] = new float[nn];
        Arrays.fill(spatial_values[tuple_index[2]], value2);
        for (i = 0; i < 3; ++i) {
            if (spatial_maps[i] == null) continue;
            spatial_values[i] = spatial_maps[i].scaleValues(spatial_values[i], false);
        }
        if (spatial_tuple.equals(Display.DisplaySpatialCartesianTuple)) {
            renderer.setEarthSpatialDisplay(null, spatial_tuple, display, spatial_value_indices, default_values, null);
        } else {
            CoordinateSystem coord = spatial_tuple.getCoordinateSystem();
            spatial_values = coord.toReference((float[][])spatial_values);
            renderer.setEarthSpatialDisplay(coord, spatial_tuple, display, spatial_value_indices, default_values, null);
        }
        coordinates = new float[3 * nn];
        k = 0;
        for (i = 0; i < nn; ++i) {
            coordinates[k++] = spatial_values[0][i];
            coordinates[k++] = spatial_values[1][i];
            coordinates[k++] = spatial_values[2][i];
        }
        boolean spatial_all_select = true;
        for (int i6 = 0; i6 < 3 * nn; ++i6) {
            if (coordinates[i6] == coordinates[i6]) continue;
            spatial_all_select = false;
            break;
        }
        normals = Gridded3DSet.makeNormals(coordinates, nwidth, nheight);
        colors = new byte[3 * nn];
        Arrays.fill(colors, (byte)127);
        float ratiow = (float)data_width / (float)texture_width;
        float ratioh = (float)data_height / (float)texture_height;
        float half_width = 0.5f / (float)texture_width;
        float half_height = 0.5f / (float)texture_height;
        float width = 1.0f / (float)texture_width;
        float height = 1.0f / (float)texture_height;
        int mt = 0;
        texCoords = new float[2 * nn];
        for (int j = 0; j < nheight; ++j) {
            float jsfactor = (float)js[j] / ((float)data_height - 1.0f);
            for (int i7 = 0; i7 < nwidth; ++i7) {
                float isfactor = (float)is[i7] / ((float)data_width - 1.0f);
                texCoords[mt++] = (ratiow - width) * isfactor + half_width;
                texCoords[mt++] = 1.0f - (ratioh - height) * jsfactor - half_height;
            }
        }
        VisADTriangleStripArray tarray = new VisADTriangleStripArray();
        tarray.stripVertexCounts = new int[nheight - 1];
        Arrays.fill(tarray.stripVertexCounts, 2 * nwidth);
        tarray.vertexCount = len = (nheight - 1) * (2 * nwidth);
        tarray.normals = new float[3 * len];
        tarray.coordinates = new float[3 * len];
        tarray.texCoords = new float[2 * len];
        k = 0;
        int kt = 0;
        int nwidth3 = 3 * nwidth;
        int nwidth2 = 2 * nwidth;
        for (int i8 = 0; i8 < nheight - 1; ++i8) {
            int m = i8 * nwidth3;
            mt = i8 * nwidth2;
            for (int j = 0; j < nwidth; ++j) {
                tarray.coordinates[k] = coordinates[m];
                tarray.coordinates[k + 1] = coordinates[m + 1];
                tarray.coordinates[k + 2] = coordinates[m + 2];
                tarray.coordinates[k + 3] = coordinates[m + nwidth3];
                tarray.coordinates[k + 4] = coordinates[m + nwidth3 + 1];
                tarray.coordinates[k + 5] = coordinates[m + nwidth3 + 2];
                tarray.normals[k] = normals[m];
                tarray.normals[k + 1] = normals[m + 1];
                tarray.normals[k + 2] = normals[m + 2];
                tarray.normals[k + 3] = normals[m + nwidth3];
                tarray.normals[k + 4] = normals[m + nwidth3 + 1];
                tarray.normals[k + 5] = normals[m + nwidth3 + 2];
                tarray.texCoords[kt] = texCoords[mt];
                tarray.texCoords[kt + 1] = texCoords[mt + 1];
                tarray.texCoords[kt + 2] = texCoords[mt + nwidth2];
                tarray.texCoords[kt + 3] = texCoords[mt + nwidth2 + 1];
                k += 6;
                m += 3;
                kt += 4;
                mt += 2;
            }
        }
        if (!spatial_all_select) {
            tarray = (VisADTriangleStripArray)tarray.removeMissing();
        }
        if (adaptedShadowType.getAdjustProjectionSeam()) {
            tarray = (VisADTriangleStripArray)tarray.adjustLongitude(renderer);
            tarray = (VisADTriangleStripArray)tarray.adjustSeam(renderer);
        }
        BufferedImage image = this.createImage(data_width, data_height, texture_width, texture_height, color_bytes);
        this.textureToGroup(group, tarray, image, mode, constant_alpha, constant_color, texture_width, texture_height);
    }

    public void buildLinearTexture(Object group, Set domain_set, Unit[] dataUnits, Unit[] domain_units, float[] default_values, ShadowRealType[] DomainComponents, int valueArrayLength, int[] inherited_values, int[] valueToScalar, GraphicsModeControl mode, float constant_alpha, float[] value_array, float[] constant_color, byte[][] color_bytes, DisplayImpl display) throws VisADException, DisplayException {
        float[] coordinates = null;
        float[] texCoords = null;
        float[] normals = null;
        byte[] colors = null;
        int data_width = 0;
        int data_height = 0;
        int texture_width = 1;
        int texture_height = 1;
        Linear1DSet X = null;
        Linear1DSet Y = null;
        if (domain_set instanceof Linear2DSet) {
            X = ((Linear2DSet)domain_set).getX();
            Y = ((Linear2DSet)domain_set).getY();
        } else {
            X = ((LinearNDSet)domain_set).getLinear1DComponent(0);
            Y = ((LinearNDSet)domain_set).getLinear1DComponent(1);
        }
        float[][] limits = new float[2][2];
        limits[0][0] = (float)X.getFirst();
        limits[0][1] = (float)X.getLast();
        limits[1][0] = (float)Y.getFirst();
        limits[1][1] = (float)Y.getLast();
        data_width = X.getLength();
        data_height = Y.getLength();
        texture_width = this.textureWidth(data_width);
        texture_height = this.textureHeight(data_height);
        float half_width = 0.5f / (float)(data_width - 1);
        float half_height = 0.5f / (float)(data_height - 1);
        half_width = (limits[0][1] - limits[0][0]) * half_width;
        half_height = (limits[1][1] - limits[1][0]) * half_height;
        float[] fArray = limits[0];
        fArray[0] = fArray[0] - half_width;
        float[] fArray2 = limits[0];
        fArray2[1] = fArray2[1] + half_width;
        float[] fArray3 = limits[1];
        fArray3[0] = fArray3[0] - half_height;
        float[] fArray4 = limits[1];
        fArray4[1] = fArray4[1] + half_height;
        limits = Unit.convertTuple(limits, dataUnits, domain_units);
        int[] tuple_index = new int[3];
        if (DomainComponents.length != 2) {
            throw new DisplayException("texture domain dimension != 2:ShadowFunctionOrSetType.doTransform");
        }
        for (int i = 0; i < DomainComponents.length; ++i) {
            Enumeration maps = DomainComponents[i].getSelectedMapVector().elements();
            ScalarMap map = (ScalarMap)maps.nextElement();
            limits[i] = map.scaleValues(limits[i]);
            DisplayRealType real = map.getDisplayScalar();
            DisplayTupleType tuple = real.getTuple();
            if (tuple == null || !tuple.equals(Display.DisplaySpatialCartesianTuple)) {
                throw new DisplayException("texture with bad tuple: ShadowFunctionOrSetType.doTransform");
            }
            tuple_index[i] = real.getTupleIndex();
            if (!maps.hasMoreElements()) continue;
            throw new DisplayException("texture with multiple spatial: ShadowFunctionOrSetType.doTransform");
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)Display.DisplaySpatialCartesianTuple.getComponent(tuple_index[2]);
        int value2_index = display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        for (int i = 0; i < valueArrayLength; ++i) {
            if (inherited_values[i] <= 0 || !real.equals(display.getDisplayScalar(valueToScalar[i]))) continue;
            value2 = value_array[i];
            break;
        }
        coordinates = new float[12];
        coordinates[tuple_index[0]] = limits[0][0];
        coordinates[tuple_index[1]] = limits[1][0];
        coordinates[tuple_index[2]] = value2;
        coordinates[3 + tuple_index[0]] = limits[0][1];
        coordinates[3 + tuple_index[1]] = limits[1][0];
        coordinates[3 + tuple_index[2]] = value2;
        coordinates[6 + tuple_index[0]] = limits[0][1];
        coordinates[6 + tuple_index[1]] = limits[1][1];
        coordinates[6 + tuple_index[2]] = value2;
        coordinates[9 + tuple_index[0]] = limits[0][0];
        coordinates[9 + tuple_index[1]] = limits[1][1];
        coordinates[9 + tuple_index[2]] = value2;
        this.adjustZ(coordinates);
        texCoords = new float[8];
        float ratiow = (float)data_width / (float)texture_width;
        float ratioh = (float)data_height / (float)texture_height;
        this.setTexCoords(texCoords, ratiow, ratioh);
        normals = new float[12];
        float n0 = (coordinates[5] - coordinates[2]) * (coordinates[7] - coordinates[1]) - (coordinates[4] - coordinates[1]) * (coordinates[8] - coordinates[2]);
        float n1 = (coordinates[3] - coordinates[0]) * (coordinates[8] - coordinates[2]) - (coordinates[5] - coordinates[2]) * (coordinates[6] - coordinates[0]);
        float n2 = (coordinates[4] - coordinates[1]) * (coordinates[6] - coordinates[0]) - (coordinates[3] - coordinates[0]) * (coordinates[7] - coordinates[1]);
        float nlen = (float)Math.sqrt(n0 * n0 + n1 * n1 + n2 * n2);
        normals[0] = n0 /= nlen;
        normals[1] = n1 /= nlen;
        normals[2] = n2 /= nlen;
        normals[3] = n0;
        normals[4] = n1;
        normals[5] = n2;
        normals[6] = n0;
        normals[7] = n1;
        normals[8] = n2;
        normals[9] = n0;
        normals[10] = n1;
        normals[11] = n2;
        colors = new byte[12];
        for (int i = 0; i < 12; ++i) {
            colors[i] = 127;
        }
        VisADQuadArray qarray = new VisADQuadArray();
        qarray.vertexCount = 4;
        qarray.coordinates = coordinates;
        qarray.texCoords = texCoords;
        qarray.colors = colors;
        qarray.normals = normals;
        BufferedImage image = this.createImage(data_width, data_height, texture_width, texture_height, color_bytes);
        this.textureToGroup(group, qarray, image, mode, constant_alpha, constant_color, texture_width, texture_height);
    }

    public BufferedImage createImage(int data_width, int data_height, int texture_width, int texture_height, byte[][] color_bytes) throws VisADException {
        ShadowFunctionOrSetType adaptedShadowType = (ShadowFunctionOrSetType)this.getAdaptedShadowType();
        return adaptedShadowType.createImage(data_width, data_height, texture_width, texture_height, color_bytes);
    }

    public static void main(String[] args) {
        String mapFile = "OUTLSUPW";
        String areaFile = "AREA2001";
        boolean threeD = true;
        boolean remap = false;
        JFrame frame = new JFrame("Map Display");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        if (args.length > 0 && !args[0].equals("X")) {
            areaFile = args[0];
        }
        if (args.length == 2) {
            threeD = args[1].indexOf("2") < 0;
            remap = args[1].indexOf("2") < 0;
        }
        boolean gif = areaFile.endsWith("gif") || areaFile.endsWith("GIF") || areaFile.endsWith("jpg") || areaFile.endsWith("JPG");
        try {
            Set[] setArray;
            baseMap = mapFile.indexOf("://") > 0 ? new BaseMapAdapter(new URL(mapFile)) : new BaseMapAdapter(mapFile);
            if (gif) {
                display = new DisplayImplJ3D("display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                lat_map = new ScalarMap(RealType.getRealType("ImageLine"), Display.YAxis);
                lon_map = new ScalarMap(RealType.getRealType("ImageElement"), Display.XAxis);
            } else if (threeD) {
                display = new DisplayImplJ3D("display");
                lat_map = new ScalarMap(RealType.Latitude, Display.Latitude);
                lon_map = new ScalarMap(RealType.Longitude, Display.Longitude);
            } else {
                display = new DisplayImplJ3D("display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                lat_map = new ScalarMap(RealType.Latitude, Display.YAxis);
                lon_map = new ScalarMap(RealType.Longitude, Display.XAxis);
            }
            display.addMap(lat_map);
            display.addMap(lon_map);
            if (!gif) {
                lat_map.setRange(-90.0, 90.0);
                lon_map.setRange(-180.0, 180.0);
            }
            DataReferenceImpl maplines_ref = new DataReferenceImpl("MapLines");
            maplines_ref.setData(baseMap.getData());
            ConstantMap[] colMap = new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(1.001, Display.Radius)};
            FlatField imaget = null;
            if (gif) {
                GIFForm gif_form = new GIFForm();
                imaget = (FlatField)gif_form.open(areaFile);
            } else {
                AreaAdapter aa = new AreaAdapter(areaFile);
                imaget = aa.getData();
            }
            FunctionType ftype = (FunctionType)imaget.getType();
            RealTupleType dtype = ftype.getDomain();
            RealTupleType rtype = (RealTupleType)ftype.getRange();
            if (remap) {
                int SIZE = 256;
                RealTupleType lat_lon = dtype.getCoordinateSystem().getReference();
                Linear2DSet dset = new Linear2DSet((MathType)lat_lon, -4.0, 70.0, SIZE, -150.0, 5.0, SIZE);
                imaget = (FlatField)imaget.resample(dset, 100, 202);
                ftype = (FunctionType)imaget.getType();
                dtype = ftype.getDomain();
            }
            if (gif) {
                ScalarMap rmap = new ScalarMap((RealType)rtype.getComponent(0), Display.Red);
                display.addMap(rmap);
                ScalarMap gmap = new ScalarMap((RealType)rtype.getComponent(1), Display.Green);
                display.addMap(gmap);
                ScalarMap bmap = new ScalarMap((RealType)rtype.getComponent(2), Display.Blue);
                display.addMap(bmap);
            } else {
                ScalarMap rgbmap = new ScalarMap((RealType)rtype.getComponent(0), Display.RGBA);
                display.addMap(rgbmap);
                BaseColorControl control = (BaseColorControl)rgbmap.getControl();
                control.initGreyWedge();
                float[][] table = control.getTable();
                for (int i = 0; i < table[3].length; ++i) {
                    table[3][i] = table[0][i];
                }
                control.setTable(table);
            }
            DataReferenceImpl ref_image = new DataReferenceImpl("ref_image");
            if (gif) {
                Set[] setArray2 = new Set[3];
                setArray2[0] = new Linear1DSet(0.0, 255.0, 255);
                setArray2[1] = new Linear1DSet(0.0, 255.0, 255);
                setArray = setArray2;
                setArray2[2] = new Linear1DSet(0.0, 255.0, 255);
            } else {
                Set[] setArray3 = new Set[1];
                setArray = setArray3;
                setArray3[0] = new Integer1DSet(255);
            }
            Set[] range_sets = setArray;
            FlatField new_field = new FlatField(ftype, imaget.getDomainSet(), null, null, range_sets, null);
            float[][] values = imaget.getFloats(false);
            new_field.setSamples(values);
            imaget = new_field;
            ref_image.setData(imaget);
            display.disableAction();
            display.addReferences((DataRenderer)new ImageRendererJ3D(), ref_image);
            display.addReference(maplines_ref, colMap);
            display.enableAction();
        }
        catch (Exception ne) {
            ne.printStackTrace();
            System.exit(1);
        }
        frame.getContentPane().add(display.getComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
    }
}

