/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Arrays;
import visad.FlowInfo;
import visad.GriddedSet;
import visad.ShadowType;
import visad.TrajectoryManager;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADTriangleStripArray;

public class Trajectory {
    TrajectoryManager trajMan;
    float[] startPts = new float[3];
    int[] startCell;
    float[] cellWeights;
    int[][] indices = new int[1][];
    float[][] weights = new float[1][];
    float[] uVecPath = new float[]{Float.NaN, Float.NaN, Float.NaN};
    int[] guess3D = new int[]{-1, -1, -1};
    int[] guess2D = new int[]{-1, -1};
    byte[] startColor;
    byte[] stopColor;
    float[] stopPts = new float[3];
    float[][] startPts2D = new float[2][1];
    float[][] startPts3D = new float[3][1];
    public int initialTimeIndex = 0;
    public int currentTimeIndex = 0;
    public double initialTime = 0.0;
    public double currentTime = 0.0;
    boolean offGrid = false;
    int clrDim;
    GriddedSet spatial_set;
    int manifoldDimension;
    int npairs = 0;
    int[] indexes = new int[60];
    float[] lastPtD = null;
    float[] lastPtC = null;
    float[] lastPtDD = null;
    float[] lastPtCC = null;
    float[][] circleXYZ;
    float[][] last_circleXYZ;
    float[] lastTvec = new float[3];
    float[] lastSvec;
    static float[][] circle;

    public Trajectory(TrajectoryManager trajMan, float startX, float startY, float startZ, int[] startCell, float[] cellWeights, byte[] startColor, double initialTime) {
        this.startPts[0] = startX;
        this.startPts[1] = startY;
        this.startPts[2] = startZ;
        this.startCell = startCell;
        this.cellWeights = cellWeights;
        this.indices[0] = startCell;
        this.weights[0] = cellWeights;
        this.clrDim = startColor.length;
        this.stopColor = new byte[this.clrDim];
        this.startColor = startColor;
        this.initialTime = initialTime;
        this.trajMan = trajMan;
    }

    public void forward(FlowInfo info, float[][] flow_values, byte[][] color_values, GriddedSet spatial_set, int direction, float timeStep) throws VisADException {
        if (this.offGrid) {
            return;
        }
        this.clrDim = color_values.length;
        float[] intrpClr = new float[this.clrDim];
        this.spatial_set = spatial_set;
        this.manifoldDimension = spatial_set.getManifoldDimension();
        float[][] flowLoc = new float[3][1];
        float[][] flowVec = new float[3][1];
        float[] intrpFlow = new float[3];
        if (this.indices[0] != null) {
            Arrays.fill(intrpFlow, 0.0f);
            Arrays.fill(intrpClr, 0.0f);
            for (int j = 0; j < this.indices[0].length; ++j) {
                int idx = this.indices[0][j];
                flowLoc[0][0] = info.spatial_values[0][idx];
                flowLoc[1][0] = info.spatial_values[1][idx];
                flowLoc[2][0] = info.spatial_values[2][idx];
                flowVec[0][0] = flow_values[0][idx];
                flowVec[1][0] = flow_values[1][idx];
                flowVec[2][0] = flow_values[2][idx];
                float[][] del = TrajectoryManager.computeDisplacement(info, flowLoc, flowVec, timeStep);
                intrpFlow[0] = intrpFlow[0] + this.weights[0][j] * (float)direction * del[0][0];
                intrpFlow[1] = intrpFlow[1] + this.weights[0][j] * (float)direction * del[1][0];
                intrpFlow[2] = intrpFlow[2] + this.weights[0][j] * (float)direction * del[2][0];
                intrpClr[0] = intrpClr[0] + this.weights[0][j] * ShadowType.byteToFloat(color_values[0][idx]);
                intrpClr[1] = intrpClr[1] + this.weights[0][j] * ShadowType.byteToFloat(color_values[1][idx]);
                intrpClr[2] = intrpClr[2] + this.weights[0][j] * ShadowType.byteToFloat(color_values[2][idx]);
                if (this.clrDim != 4) continue;
                intrpClr[3] = intrpClr[3] + this.weights[0][j] * ShadowType.byteToFloat(color_values[3][idx]);
            }
            this.stopPts[0] = this.startPts[0] + intrpFlow[0];
            this.stopPts[1] = this.startPts[1] + intrpFlow[1];
            this.stopPts[2] = this.startPts[2] + intrpFlow[2];
            this.stopColor[0] = ShadowType.floatToByte(intrpClr[0]);
            this.stopColor[1] = ShadowType.floatToByte(intrpClr[1]);
            this.stopColor[2] = ShadowType.floatToByte(intrpClr[2]);
            if (this.clrDim == 4) {
                this.stopColor[3] = ShadowType.floatToByte(intrpClr[3]);
            }
            this.addPair(this.startPts, this.stopPts, this.startColor, this.stopColor);
            this.uVecPath[0] = this.stopPts[0] - this.startPts[0];
            this.uVecPath[1] = this.stopPts[1] - this.startPts[1];
            this.uVecPath[2] = this.stopPts[2] - this.startPts[2];
            float mag = (float)Math.sqrt(this.uVecPath[0] * this.uVecPath[0] + this.uVecPath[1] * this.uVecPath[1] + this.uVecPath[2] * this.uVecPath[2]);
            this.uVecPath[0] = this.uVecPath[0] / mag;
            this.uVecPath[1] = this.uVecPath[1] / mag;
            this.uVecPath[2] = this.uVecPath[2] / mag;
            this.update();
        }
    }

    public void addPair(float[] startPt, float[] stopPt, byte[] startColor, byte[] stopColor) {
        this.indexes[this.npairs] = this.trajMan.getCoordinateCount();
        this.trajMan.addPair(startPt, stopPt, startColor, stopColor);
        ++this.npairs;
        int clrDim = startColor.length;
        if (this.indexes.length == this.npairs) {
            int[] tmp = new int[this.npairs + 40];
            System.arraycopy(this.indexes, 0, tmp, 0, this.npairs);
            this.indexes = tmp;
        }
    }

    private void update() throws VisADException {
        this.startPts[0] = this.stopPts[0];
        this.startPts[1] = this.stopPts[1];
        this.startPts[2] = this.stopPts[2];
        this.startColor[0] = this.stopColor[0];
        this.startColor[1] = this.stopColor[1];
        this.startColor[2] = this.stopColor[2];
        if (this.clrDim == 4) {
            this.startColor[3] = this.stopColor[3];
        }
        if (this.manifoldDimension == 2) {
            this.startPts2D[0][0] = this.startPts[0];
            this.startPts2D[1][0] = this.startPts[1];
            this.spatial_set.valueToInterp(this.startPts2D, this.indices, this.weights, this.guess2D);
        } else if (this.manifoldDimension == 3) {
            this.startPts3D[0][0] = this.startPts[0];
            this.startPts3D[1][0] = this.startPts[1];
            this.startPts3D[2][0] = this.startPts[2];
            this.spatial_set.valueToInterp(this.startPts3D, this.indices, this.weights, this.guess3D);
        }
        this.startCell = this.indices[0];
        this.cellWeights = this.weights[0];
        if (this.indices[0] == null) {
            this.offGrid = true;
        }
    }

    public VisADGeometryArray makeCylinderStrip(float[] T, float[] S, float[] pt0, float[] pt1, byte[][] clr0, byte[][] clr1, float size, int npts, float[] coords, byte[] colors, float[] normls, int[] vertCnt) {
        int k;
        VisADTriangleStripArray array = new VisADTriangleStripArray();
        int clrDim = clr0.length;
        if (circle == null) {
            circle = new float[2][npts];
            float intrvl = (float)Math.PI * 2 / (float)(npts - 1);
            for (int i = 0; i < npts; ++i) {
                Trajectory.circle[0][i] = (float)Math.cos(intrvl * (float)i);
                Trajectory.circle[1][i] = (float)Math.sin(intrvl * (float)i);
            }
        }
        int vcnt = vertCnt[0];
        int idx = 3 * vcnt;
        int cidx = clrDim * vcnt;
        if (this.circleXYZ == null) {
            this.circleXYZ = new float[3][npts];
        }
        if (this.last_circleXYZ == null) {
            float[][] ptsXYZ = new float[3][npts];
            for (int k2 = 0; k2 < npts; ++k2) {
                float s = size * circle[0][k2];
                float t = size * circle[1][k2];
                ptsXYZ[0][k2] = pt0[0] + s * S[0] + t * T[0];
                ptsXYZ[1][k2] = pt0[1] + s * S[1] + t * T[1];
                ptsXYZ[2][k2] = pt0[2] + s * S[2] + t * T[2];
            }
            this.last_circleXYZ = new float[3][npts];
            System.arraycopy(ptsXYZ[0], 0, this.last_circleXYZ[0], 0, npts);
            System.arraycopy(ptsXYZ[1], 0, this.last_circleXYZ[1], 0, npts);
            System.arraycopy(ptsXYZ[2], 0, this.last_circleXYZ[2], 0, npts);
        }
        for (k = 0; k < npts; ++k) {
            float s = size * circle[0][k];
            float t = size * circle[1][k];
            this.circleXYZ[0][k] = pt1[0] + s * S[0] + t * T[0];
            this.circleXYZ[1][k] = pt1[1] + s * S[1] + t * T[1];
            this.circleXYZ[2][k] = pt1[2] + s * S[2] + t * T[2];
        }
        for (k = 0; k < npts; ++k) {
            float x = this.last_circleXYZ[0][k];
            float y = this.last_circleXYZ[1][k];
            float z = this.last_circleXYZ[2][k];
            float delx = x - pt0[0];
            float dely = y - pt0[1];
            float delz = z - pt0[2];
            float mag = (float)Math.sqrt(delx * delx + dely * dely + delz * delz);
            normls[idx] = delx / mag;
            coords[idx++] = x;
            normls[idx] = dely / mag;
            coords[idx++] = y;
            normls[idx] = delz / mag;
            coords[idx++] = z;
            if (clrDim == 3) {
                colors[cidx++] = clr0[0][0];
                colors[cidx++] = clr0[1][0];
                colors[cidx++] = clr0[2][0];
            } else {
                colors[cidx++] = clr0[0][0];
                colors[cidx++] = clr0[1][0];
                colors[cidx++] = clr0[2][0];
                colors[cidx++] = clr0[3][0];
            }
            ++vcnt;
            x = this.circleXYZ[0][k];
            y = this.circleXYZ[1][k];
            z = this.circleXYZ[2][k];
            delx = x - pt1[0];
            dely = y - pt1[1];
            delz = z - pt1[2];
            mag = (float)Math.sqrt(delx * delx + dely * dely + delz * delz);
            normls[idx] = delx / mag;
            coords[idx++] = x;
            normls[idx] = dely / mag;
            coords[idx++] = y;
            normls[idx] = delz / mag;
            coords[idx++] = z;
            if (clrDim == 3) {
                colors[cidx++] = clr1[0][0];
                colors[cidx++] = clr1[1][0];
                colors[cidx++] = clr1[2][0];
            } else {
                colors[cidx++] = clr1[0][0];
                colors[cidx++] = clr1[1][0];
                colors[cidx++] = clr1[2][0];
                colors[cidx++] = clr1[3][0];
            }
            ++vcnt;
        }
        System.arraycopy(this.circleXYZ[0], 0, this.last_circleXYZ[0], 0, npts);
        System.arraycopy(this.circleXYZ[1], 0, this.last_circleXYZ[1], 0, npts);
        System.arraycopy(this.circleXYZ[2], 0, this.last_circleXYZ[2], 0, npts);
        this.lastTvec[0] = T[0];
        this.lastTvec[1] = T[1];
        this.lastTvec[2] = T[2];
        vertCnt[0] = vcnt;
        return array;
    }
}

