/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataShadow;
import visad.ErrorEstimate;
import visad.Field;
import visad.MathType;
import visad.Real;
import visad.RealTupleIface;
import visad.RealTupleType;
import visad.RealType;
import visad.ShadowRealTupleType;
import visad.ShadowType;
import visad.ThingReference;
import visad.Tuple;
import visad.TupleIface;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class RealTuple
extends Tuple
implements RealTupleIface {
    private CoordinateSystem TupleCoordinateSystem;
    private boolean checkRealUnits;
    private Unit[] TupleUnits = null;

    public RealTuple(RealTupleType type) {
        super(type);
        this.TupleCoordinateSystem = type.getCoordinateSystem();
        if (this.tupleComponents != null) {
            int n = this.tupleComponents.length;
            this.TupleUnits = new Unit[n];
            for (int i = 0; i < n; ++i) {
                this.TupleUnits[i] = null;
            }
        }
    }

    public RealTuple(RealTupleType type, Real[] reals, CoordinateSystem coord_sys) throws VisADException, RemoteException {
        this(type, reals, coord_sys, null, true);
    }

    public RealTuple(RealTupleType type, Real[] reals, CoordinateSystem coord_sys, Unit[] units, boolean checkUnits) throws VisADException, RemoteException {
        super(type, reals, false);
        this.TupleUnits = units;
        this.checkRealUnits = checkUnits;
        this.init_coord_sys(coord_sys);
    }

    public RealTuple(Real[] reals) throws VisADException, RemoteException {
        this((RealTupleType)RealTuple.buildTupleType(reals), reals, null, RealTuple.buildTupleUnits(reals), false);
    }

    public RealTuple(RealTupleType type, double[] values) throws VisADException, RemoteException {
        this(type, RealTuple.buildRealArray(type, values), null, type.getDefaultUnits(), false);
    }

    private void init_coord_sys(CoordinateSystem coord_sys) throws VisADException {
        CoordinateSystem cs = ((RealTupleType)this.Type).getCoordinateSystem();
        if (coord_sys == null) {
            this.TupleCoordinateSystem = cs;
        } else {
            if (cs == null || !cs.getReference().equals(coord_sys.getReference())) {
                throw new CoordinateSystemException("RealTuple: coord_sys " + coord_sys.getReference() + " must match Type.DefaultCoordinateSystem " + (cs == null ? null : cs.getReference()));
            }
            this.TupleCoordinateSystem = coord_sys;
        }
        if (this.TupleCoordinateSystem != null && !Unit.canConvertArray(this.TupleCoordinateSystem.getCoordinateSystemUnits(), ((RealTupleType)this.Type).getDefaultUnits())) {
            throw new UnitException("RealTuple: CoordinateSystem Units must be convertable with Type default Units");
        }
        if (this.TupleUnits == null) {
            int n = this.tupleComponents.length;
            this.TupleUnits = new Unit[n];
            for (int i = 0; i < n; ++i) {
                this.TupleUnits[i] = ((Real)this.tupleComponents[i]).getUnit();
            }
        }
        if (this.checkRealUnits && !Unit.canConvertArray(this.TupleUnits, ((RealTupleType)this.Type).getDefaultUnits())) {
            throw new UnitException("Tuple: Units must be convertable with Type default Units");
        }
        if (this.TupleCoordinateSystem != null && !Unit.canConvertArray(this.TupleCoordinateSystem.getCoordinateSystemUnits(), this.TupleUnits)) {
            throw new UnitException("Tuple: Units must be convertable with CoordinateSystem Units");
        }
    }

    private static Real[] buildRealArray(RealTupleType type, double[] values) throws VisADException {
        Real[] reals = new Real[values.length];
        for (int i = 0; i < values.length; ++i) {
            reals[i] = new Real((RealType)type.getComponent(i), values[i]);
        }
        return reals;
    }

    private static Unit[] buildTupleUnits(Real[] reals) throws VisADException {
        if (reals == null || reals.length == 0) {
            return null;
        }
        int n = reals.length;
        Unit[] units = new Unit[reals.length];
        for (int i = 0; i < n; ++i) {
            units[i] = reals[i].getUnit();
        }
        return units;
    }

    @Override
    public final void addReference(ThingReference listener) {
    }

    @Override
    public final void removeReference(ThingReference listener) {
    }

    @Override
    public double[] getValues() {
        int n = this.getDimension();
        double[] values = new double[n];
        Data[] tupleComps = this.getComponents(false);
        for (int i = 0; i < n; ++i) {
            values[i] = ((Real)tupleComps[i]).getValue();
        }
        return values;
    }

    @Override
    public Unit[] getTupleUnits() {
        return Unit.copyUnitsArray(this.TupleUnits);
    }

    @Override
    public ErrorEstimate[] getErrors() throws VisADException, RemoteException {
        int n = this.getDimension();
        ErrorEstimate[] errors = new ErrorEstimate[n];
        for (int i = 0; i < n; ++i) {
            errors[i] = ((Real)this.getComponent(i)).getError();
        }
        return errors;
    }

    @Override
    public CoordinateSystem getCoordinateSystem() {
        return this.TupleCoordinateSystem;
    }

    @Override
    public Data binary(Data data, int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof RealTuple) {
            if (!this.Type.equalsExceptName(data.getType())) {
                throw new TypeException("RealTuple.binary: types don't match");
            }
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException("RealTuple.binary: new_type doesn't match return type");
            }
            if (this.isMissing() || data.isMissing()) {
                return new RealTuple((RealTupleType)new_type);
            }
            int dim = this.getDimension();
            double[][] vals = new double[dim][1];
            for (int j = 0; j < dim; ++j) {
                vals[j][0] = ((Real)((RealTuple)data).getComponent(j)).getValue();
            }
            ErrorEstimate[] errors_out = new ErrorEstimate[dim];
            vals = CoordinateSystem.transformCoordinates((RealTupleType)this.Type, this.getCoordinateSystem(), this.getTupleUnits(), errors_out, (RealTupleType)data.getType(), ((RealTuple)data).getCoordinateSystem(), ((RealTuple)data).getTupleUnits(), ((RealTuple)data).getErrors(), vals);
            Real[] reals = new Real[dim];
            Unit[] tupleUnits = this.getTupleUnits();
            for (int j = 0; j < dim; ++j) {
                Real real = new Real((RealType)((RealTupleType)this.Type).getComponent(j), vals[j][0], tupleUnits[j], errors_out[j]);
                MathType m_type = ((RealTupleType)new_type).getComponent(j);
                reals[j] = (Real)this.getComponent(j).binary(real, op, m_type, sampling_mode, error_mode);
            }
            return new RealTuple((RealTupleType)new_type, reals, null);
        }
        if (data instanceof TupleIface) {
            throw new TypeException("RealTuple.binary: types don't match");
        }
        if (data instanceof Real) {
            if (this.isMissing() || data.isMissing()) {
                return new RealTuple((RealTupleType)this.Type);
            }
            int dim = this.getDimension();
            Real[] reals = new Real[dim];
            for (int j = 0; j < dim; ++j) {
                MathType m_type = ((RealTupleType)new_type).getComponent(j);
                reals[j] = (Real)this.getComponent(j).binary(data, op, m_type, sampling_mode, error_mode);
            }
            return new RealTuple((RealTupleType)new_type, reals, null);
        }
        if (data instanceof Field) {
            if (!data.getType().equalsExceptName(new_type)) {
                throw new TypeException();
            }
            return data.binary(this, RealTuple.invertOp(op), new_type, sampling_mode, error_mode);
        }
        throw new TypeException("RealTuple.binary");
    }

    @Override
    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        if (!this.Type.equalsExceptName(new_type)) {
            throw new TypeException("unary: new_type doesn't match return type");
        }
        RealTupleType RT_type = (RealTupleType)new_type;
        if (this.isMissing()) {
            return new RealTuple((RealTupleType)this.Type);
        }
        int dim = this.getDimension();
        Real[] reals = new Real[dim];
        for (int j = 0; j < dim; ++j) {
            reals[j] = (Real)this.getComponent(j).unary(op, RT_type.getComponent(j), sampling_mode, error_mode);
        }
        return new RealTuple((RealTupleType)new_type, reals, this.getCoordinateSystem());
    }

    @Override
    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        shadow = super.computeRanges(type, shadow);
        ShadowRealTupleType shad_ref = ((ShadowRealTupleType)type).getReference();
        if (this.isMissing() || shad_ref == null) {
            return shadow;
        }
        int n = this.tupleComponents.length;
        double[][] ranges = new double[2][n];
        for (int i = 0; i < n; ++i) {
            double value = ((Real)this.getComponent(i)).getValue();
            Unit[] tupleUnits = this.getTupleUnits();
            Unit unit = ((RealType)((RealTupleType)this.Type).getComponent(i)).getDefaultUnit();
            if (unit != null && !unit.equals(tupleUnits[i])) {
                value = unit.toThis(value, tupleUnits[i]);
            }
            if (value != value) {
                return shadow;
            }
            ranges[0][i] = value;
            ranges[1][i] = value;
        }
        return this.computeReferenceRanges((ShadowRealTupleType)type, this.getCoordinateSystem(), ((RealTupleType)this.Type).getDefaultUnits(), shadow, shad_ref, ranges);
    }

    @Override
    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Assertion failure");
        }
    }

    @Override
    public String toString() {
        if (this.isMissing()) {
            return "missing";
        }
        Data[] tupleComps = this.getComponents(false);
        String s = "(" + tupleComps[0];
        for (int i = 1; i < this.getDimension(); ++i) {
            s = s + ", " + tupleComps[i];
        }
        return s + ")";
    }

    @Override
    public String longString(String pre) throws VisADException, RemoteException {
        String s = pre + "RealTuple\n" + pre + "  Type: " + this.Type.toString() + "\n";
        if (this.isMissing()) {
            return s + "  missing\n";
        }
        for (int i = 0; i < this.getDimension(); ++i) {
            s = s + pre + "  Tuple Component " + i + ": Value = " + ((Real)this.getComponent(i)).getValue() + "  (TypeName = " + ((RealType)this.getComponent(i).getType()).getName() + ")\n";
        }
        return s;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        int b = 10;
        Real w = new Real(b);
        Real[] reals1 = new Real[]{new Real(1.0), new Real(2.0), new Real(3.0)};
        RealTuple rt1 = new RealTuple(reals1);
        Real[] reals2 = new Real[]{new Real(6.0), new Real(5.0), new Real(4.0)};
        RealTuple rt2 = new RealTuple(reals2);
        System.out.println("rt1 = " + rt1 + "\nrt2 = " + rt2);
        System.out.println("rt1 + rt2 = " + rt1.add(rt2));
        System.out.println("rt1 - rt2 = " + rt1.subtract(rt2));
        System.out.println("rt1 * rt2 = " + rt1.multiply(rt2));
        System.out.println("rt1 / rt2 = " + rt1.divide(rt2));
        System.out.println("sqrt(rt1) = " + rt1.sqrt());
        System.out.println("rt1 + w = " + rt1.add(w));
        System.out.println("rt1 - w = " + rt1.subtract(w));
        System.out.println("rt1 * w = " + rt1.multiply(w));
        System.out.println("rt1 / w = " + rt1.divide(w));
        System.out.println("w + rt2 = " + w.add(rt2));
        System.out.println("w - rt2 = " + w.subtract(rt2));
        System.out.println("w * rt2 = " + w.multiply(rt2));
        System.out.println("w / rt2 = " + w.divide(rt2));
    }
}

