/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Random;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatFieldIface;
import visad.FloatSet;
import visad.Function;
import visad.FunctionType;
import visad.GriddedDoubleSet;
import visad.GriddedSet;
import visad.Integer2DSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearSet;
import visad.MathType;
import visad.PromiscuousUnit;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Tuple;
import visad.TupleIface;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.util.Trace;

public class FlatField
extends FieldImpl
implements FlatFieldIface {
    protected int TupleDimension;
    private Set[] RangeSet;
    private int[] RangeMode;
    protected CoordinateSystem RangeCoordinateSystem;
    protected CoordinateSystem[] RangeCoordinateSystems;
    private boolean MissingFlag;
    protected Unit[] RangeUnits;
    private ErrorEstimate[] RangeErrors;
    private double[][] DoubleRange;
    private float[][] FloatRange;
    private long[][] LongRange;
    private int[][] IntRange;
    private short[][] ShortRange;
    private byte[][] ByteRange;
    private static final int MISSING1 = -128;
    private static final int MISSING2 = Short.MIN_VALUE;
    private static final int MISSING4 = Integer.MIN_VALUE;
    private static final int DOUBLE = 1;
    private static final int FLOAT = 2;
    private static final int LONG = 3;
    private static final int INT = 4;
    private static final int SHORT = 5;
    private static final int BYTE = 6;

    public FlatField(FunctionType type) throws VisADException {
        this(type, type.getDomain().getDefaultSet(), null, null, null, null);
    }

    public FlatField(FunctionType type, Set domain_set) throws VisADException {
        this(type, domain_set, null, null, null, null);
    }

    public FlatField(FunctionType type, Set domain_set, CoordinateSystem range_coord_sys, Set[] range_sets, Unit[] units) throws VisADException {
        this(type, domain_set, range_coord_sys, null, range_sets, units);
    }

    public FlatField(FunctionType type, Set domain_set, CoordinateSystem[] range_coord_syses, Set[] range_sets, Unit[] units) throws VisADException {
        this(type, domain_set, null, range_coord_syses, range_sets, units);
    }

    public FlatField(FunctionType type, Set domain_set, CoordinateSystem range_coord_sys, CoordinateSystem[] range_coord_syses, Set[] range_sets, Unit[] units) throws VisADException {
        super(type, domain_set, false);
        int i;
        this.pr("ctor");
        if (!type.getFlat()) {
            throw new FieldException("FlatField: FunctionType must be Flat");
        }
        MathType RangeType = type.getRange();
        RealTupleType FlatRange = type.getFlatRange();
        this.TupleDimension = FlatRange.getDimension();
        this.DoubleRange = new double[this.TupleDimension][];
        this.RangeSet = new Set[this.TupleDimension];
        this.RangeMode = new int[this.TupleDimension];
        if (range_sets == null) {
            for (i = 0; i < this.TupleDimension; ++i) {
                this.RangeSet[i] = ((RealType)FlatRange.getComponent(i)).getDefaultSet();
                if (this.RangeSet[i] != null) continue;
                this.RangeSet[i] = new FloatSet(new SetType(FlatRange.getComponent(i)));
            }
        } else {
            if (this.TupleDimension != range_sets.length) {
                throw new SetException("FlatField: range set dimensions don't match");
            }
            for (i = 0; i < this.TupleDimension; ++i) {
                if (range_sets[i] != null && range_sets[i].getDimension() == 1) continue;
                throw new SetException("FlatField: each range set dimension must be 1");
            }
            for (i = 0; i < this.TupleDimension; ++i) {
                this.RangeSet[i] = FlatRange.getComponent(i).equals(((SetType)range_sets[i].getType()).getDomain()) ? range_sets[i] : (Set)range_sets[i].cloneButType(new SetType(FlatRange.getComponent(i)));
            }
        }
        this.nullRanges();
        if (type.getReal()) {
            if (range_coord_syses != null) {
                throw new CoordinateSystemException("FlatField: Real Function Type requires single range coordinate system");
            }
            this.RangeCoordinateSystems = null;
            this.RangeCoordinateSystem = FlatRange.getCoordinateSystem();
            if (range_coord_sys != null) {
                if (!(RangeType instanceof RealTupleType)) {
                    throw new CoordinateSystemException("FlatField: range_coord_sys supplied, but RangeType is not RealTupleType");
                }
                if (this.RangeCoordinateSystem == null || !this.RangeCoordinateSystem.getReference().equals(range_coord_sys.getReference())) {
                    throw new CoordinateSystemException("FlatField: range_coord_sys " + (range_coord_sys == null ? null : range_coord_sys.getReference()) + " must match default range CoordinateSystem " + (this.RangeCoordinateSystem == null ? null : this.RangeCoordinateSystem.getReference()));
                }
                this.RangeCoordinateSystem = range_coord_sys;
            }
            if (units == null) {
                this.RangeUnits = this.RangeCoordinateSystem == null ? FlatRange.getDefaultUnits() : this.RangeCoordinateSystem.getCoordinateSystemUnits();
            } else {
                if (units.length != this.TupleDimension) {
                    throw new UnitException("FlatField: units dimension does not match");
                }
                this.RangeUnits = new Unit[this.TupleDimension];
                for (int i2 = 0; i2 < this.TupleDimension; ++i2) {
                    RealType componentType = (RealType)FlatRange.getComponent(i2);
                    Unit componentUnit = units[i2];
                    this.RangeUnits[i2] = componentUnit == null || !componentType.isInterval() ? componentUnit : componentUnit.getAbsoluteUnit();
                }
            }
            Unit[] type_units = RangeType instanceof RealTupleType ? ((RealTupleType)RangeType).getDefaultUnits() : new Unit[]{((RealType)RangeType).getDefaultUnit()};
            if (this.RangeCoordinateSystem != null && !Unit.canConvertArray(this.RangeCoordinateSystem.getCoordinateSystemUnits(), type_units)) {
                throw new UnitException("FlatField: RangeCoordinateSystem Units must be convertable with RangeType default Units");
            }
            if (this.RangeCoordinateSystem != null && !Unit.canConvertArray(this.RangeCoordinateSystem.getCoordinateSystemUnits(), this.RangeUnits)) {
                throw new UnitException("FlatField: RangeUnits must be convertable with RangeCoordinateSystem Units");
            }
            if (!Unit.canConvertArray(type_units, this.RangeUnits)) {
                throw new UnitException("FlatField: RangeUnits must be convertable with RangeType default Units");
            }
        } else {
            int j;
            int i3;
            if (range_coord_sys != null) {
                throw new CoordinateSystemException("FlatField: non-Real Function Type requires multiple range coordinate systems");
            }
            this.RangeCoordinateSystem = null;
            int n = ((TupleType)RangeType).getDimension();
            this.RangeCoordinateSystems = new CoordinateSystem[n];
            for (i3 = 0; i3 < n; ++i3) {
                MathType component = ((TupleType)RangeType).getComponent(i3);
                if (component instanceof RealTupleType) {
                    this.RangeCoordinateSystems[i3] = ((RealTupleType)component).getCoordinateSystem();
                    if (range_coord_syses == null || range_coord_syses[i3] == null) continue;
                    if (this.RangeCoordinateSystems[i3] == null || this.RangeCoordinateSystems[i3].getReference() != range_coord_syses[i3].getReference()) {
                        throw new TypeException("FlatField: range_coord_syses must match Range DefaultCoordinateSystem");
                    }
                    this.RangeCoordinateSystems[i3] = range_coord_syses[i3];
                    continue;
                }
                this.RangeCoordinateSystems[i3] = null;
            }
            if (units == null) {
                this.RangeUnits = FlatRange.getDefaultUnits();
                j = 0;
                for (int i4 = 0; i4 < n; ++i4) {
                    MathType component;
                    if (this.RangeCoordinateSystems[i4] != null) {
                        Unit[] sub_range_units = this.RangeCoordinateSystems[i4].getCoordinateSystemUnits();
                        for (int k = 0; k < sub_range_units.length; ++k) {
                            this.RangeUnits[j + k] = sub_range_units[k];
                        }
                    }
                    if ((component = ((TupleType)RangeType).getComponent(i4)) instanceof RealType) {
                        ++j;
                        continue;
                    }
                    if (!(component instanceof RealTupleType)) continue;
                    j += ((RealTupleType)component).getDimension();
                }
            } else {
                if (units.length != this.TupleDimension) {
                    throw new UnitException("FlatField: units dimension does not match");
                }
                this.RangeUnits = new Unit[this.TupleDimension];
                for (i3 = 0; i3 < this.TupleDimension; ++i3) {
                    RealType componentType = (RealType)FlatRange.getComponent(i3);
                    Unit componentUnit = units[i3];
                    this.RangeUnits[i3] = componentUnit == null || !componentType.isInterval() ? componentUnit : componentUnit.getAbsoluteUnit();
                }
            }
            j = 0;
            for (int i5 = 0; i5 < n; ++i5) {
                Unit[] sub_range_units;
                int m;
                Unit[] sub_type_units;
                MathType component = ((TupleType)RangeType).getComponent(i5);
                if (component instanceof RealTupleType) {
                    sub_type_units = ((RealTupleType)component).getDefaultUnits();
                    m = ((RealTupleType)component).getDimension();
                    sub_range_units = new Unit[m];
                    for (int k = 0; k < m; ++k) {
                        sub_range_units[k] = this.RangeUnits[j + k];
                    }
                } else {
                    sub_type_units = new Unit[]{((RealType)component).getDefaultUnit()};
                    m = 1;
                    sub_range_units = new Unit[]{this.RangeUnits[j]};
                }
                if (this.RangeCoordinateSystems[i5] != null && !Unit.canConvertArray(sub_type_units, this.RangeCoordinateSystems[i5].getCoordinateSystemUnits())) {
                    throw new UnitException("FlatField: RangeCoordinateSystems Units must be convertable with RangeType default Units");
                }
                if (this.RangeCoordinateSystems[i5] != null && !Unit.canConvertArray(sub_range_units, this.RangeCoordinateSystems[i5].getCoordinateSystemUnits())) {
                    throw new UnitException("FlatField: RangeUnits must be convertable with RangeCoordinateSystems Units");
                }
                if (!Unit.canConvertArray(sub_type_units, sub_range_units)) {
                    throw new UnitException("FlatField: RangeUnits must be convertable with RangeType default Units");
                }
                j += m;
            }
        }
        if (this.RangeUnits == null) {
            this.RangeUnits = new Unit[this.TupleDimension];
        }
        this.RangeErrors = new ErrorEstimate[this.TupleDimension];
        this.MissingFlag = true;
    }

    @Override
    public CoordinateSystem[] getRangeCoordinateSystem() throws TypeException {
        MathType RangeType = ((FunctionType)this.Type).getRange();
        if (!((FunctionType)this.Type).getReal()) {
            throw new TypeException("FlatField.getRangeCoordinateSystem: Range is not Real, need DefaultCoordinateSystem index");
        }
        CoordinateSystem[] cs = new CoordinateSystem[]{this.RangeCoordinateSystem};
        return cs;
    }

    @Override
    public Set[] getRangeSets() {
        Set[] sets = new Set[this.RangeSet.length];
        System.arraycopy(this.RangeSet, 0, sets, 0, sets.length);
        return sets;
    }

    @Override
    public CoordinateSystem[] getRangeCoordinateSystem(int i) throws TypeException {
        if (((FunctionType)this.Type).getReal()) {
            throw new TypeException("FlatField.getRangeCoordinateSystem: Range is Real, cannot specify CoordinateSystem index");
        }
        CoordinateSystem[] cs = new CoordinateSystem[]{this.RangeCoordinateSystems[i]};
        return cs;
    }

    @Override
    public Unit[][] getRangeUnits() {
        Unit[][] units = new Unit[this.RangeUnits.length][1];
        for (int i = 0; i < this.RangeUnits.length; ++i) {
            units[i][0] = this.RangeUnits[i];
        }
        return units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorEstimate[] getRangeErrors() {
        ErrorEstimate[] errorEstimateArray = this.RangeErrors;
        synchronized (this.RangeErrors) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ErrorEstimate.copyErrorsArray(this.RangeErrors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRangeErrors(ErrorEstimate[] errors) throws FieldException {
        ErrorEstimate[] errorEstimateArray = this.RangeErrors;
        synchronized (this.RangeErrors) {
            if (errors == null) {
                for (int i = 0; i < this.TupleDimension; ++i) {
                    this.RangeErrors[i] = null;
                }
            } else {
                if (errors.length != this.TupleDimension) {
                    throw new FieldException("FlatField.setRangeErrors: errors dimension does not match");
                }
                for (int i = 0; i < this.TupleDimension; ++i) {
                    this.RangeErrors[i] = errors[i];
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setSamples(Data[] range, boolean copy) throws VisADException, RemoteException {
        if (range == null || range.length != this.getLength()) {
            throw new FieldException("setSamples: bad Data[] length");
        }
        for (int i = 0; i < this.getLength(); ++i) {
            this.setSample(i, range[i]);
        }
    }

    @Override
    public void setSamples(double[][] range) throws VisADException, RemoteException {
        this.setSamples(range, null, true);
    }

    @Override
    public void setSamples(float[][] range) throws VisADException, RemoteException {
        this.setSamples(range, (ErrorEstimate[])null, true);
    }

    @Override
    public void setSamples(double[][] range, boolean copy) throws VisADException, RemoteException {
        this.setSamples(range, null, copy);
    }

    @Override
    public void setSamples(float[][] range, boolean copy) throws VisADException, RemoteException {
        this.setSamples(range, (ErrorEstimate[])null, copy);
    }

    @Override
    public void setSamples(double[][] range, ErrorEstimate[] errors, boolean copy) throws VisADException, RemoteException {
        if (range.length != this.TupleDimension || errors != null && errors.length != this.TupleDimension) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        for (int i = 0; i < this.TupleDimension; ++i) {
            if (range[i].length == this.getLength()) continue;
            throw new FieldException("setSamples: bad array length");
        }
        this.packValues(range, copy);
        this.setRangeErrors(errors);
        this.notifyReferences();
    }

    private boolean shouldBeDouble() {
        for (int i = 0; i < this.TupleDimension; ++i) {
            if (this.RangeMode[i] != 1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSamples(int start, double[][] range) throws VisADException, RemoteException {
        if (range.length != this.TupleDimension) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        for (int i = 0; i < this.TupleDimension; ++i) {
            if (range[i].length + start <= this.getLength()) continue;
            throw new FieldException("setSamples: bad array length");
        }
        boolean copy = false;
        int length = range[0].length;
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            block11: for (int i = 0; i < this.TupleDimension; ++i) {
                double[] rangeI = range[i];
                double[][] range1 = new double[][]{rangeI};
                switch (this.RangeMode[i]) {
                    case 1: {
                        if (this.DoubleRange[i] == null) {
                            this.DoubleRange[i] = new double[this.getLength()];
                        }
                        double[] DoubleRangeI = this.DoubleRange[i];
                        System.arraycopy(rangeI, 0, DoubleRangeI, start, length);
                        continue block11;
                    }
                    case 2: {
                        int j3;
                        if (this.FloatRange[i] == null) {
                            this.FloatRange[i] = new float[this.getLength()];
                            for (int j2 = 0; j2 < this.getLength(); ++j2) {
                                this.FloatRange[i][j2] = Float.NaN;
                            }
                        }
                        float[] FloatRangeI = this.FloatRange[i];
                        for (j3 = 0; j3 < length; ++j3) {
                            FloatRangeI[start + j3] = (float)rangeI[j3];
                        }
                        continue block11;
                    }
                    case 6: {
                        int j4;
                        int j3;
                        int[] index = this.RangeSet[i].valueToIndex(Set.doubleToFloat(range1));
                        if (this.ByteRange[i] == null) {
                            this.ByteRange[i] = new byte[this.getLength()];
                            for (j3 = 0; j3 < this.getLength(); ++j3) {
                                this.ByteRange[i][j3] = -128;
                            }
                        }
                        byte[] ByteRangeI = this.ByteRange[i];
                        for (j4 = 0; j4 < length; ++j4) {
                            ByteRangeI[start + j4] = (byte)(index[j4] + -128 + 1);
                        }
                        continue block11;
                    }
                    case 5: {
                        int j;
                        int j4;
                        int[] index = this.RangeSet[i].valueToIndex(Set.doubleToFloat(range1));
                        if (this.ShortRange[i] == null) {
                            this.ShortRange[i] = new short[this.getLength()];
                            for (j4 = 0; j4 < this.getLength(); ++j4) {
                                this.ShortRange[i][j4] = Short.MIN_VALUE;
                            }
                        }
                        short[] ShortRangeI = this.ShortRange[i];
                        for (j = 0; j < length; ++j) {
                            ShortRangeI[start + j] = (short)(index[j] + Short.MIN_VALUE + 1);
                        }
                        continue block11;
                    }
                    case 4: {
                        int j;
                        int[] index = this.RangeSet[i].valueToIndex(Set.doubleToFloat(range1));
                        if (this.IntRange[i] == null) {
                            this.IntRange[i] = new int[this.getLength()];
                            for (j = 0; j < this.getLength(); ++j) {
                                this.IntRange[i][j] = Integer.MIN_VALUE;
                            }
                        }
                        int[] IntRangeI = this.IntRange[i];
                        for (int j5 = 0; j5 < length; ++j5) {
                            IntRangeI[start + j5] = index[j5] + Integer.MIN_VALUE + 1;
                        }
                        continue block11;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
            }
            this.clearMissing();
            // ** MonitorExit[var6_5] (shouldn't be in output)
            this.setRangeErrors(null);
            this.notifyReferences();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSamples(int[] indices, double[][] range) throws VisADException, RemoteException {
        this.pr("setSamples");
        int length = indices.length;
        if (range.length != this.TupleDimension) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        if (length > this.getLength()) {
            throw new FieldException("setSamples: indices array too long");
        }
        for (int i = 0; i < this.TupleDimension; ++i) {
            if (range[i].length == length) continue;
            throw new FieldException("setSamples: bad data array length");
        }
        boolean copy = false;
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            block11: for (int i = 0; i < this.TupleDimension; ++i) {
                double[] rangeI = range[i];
                double[][] range1 = new double[][]{rangeI};
                switch (this.RangeMode[i]) {
                    case 1: {
                        int j2;
                        if (this.DoubleRange[i] == null) {
                            this.DoubleRange[i] = new double[this.getLength()];
                        }
                        double[] DoubleRangeI = this.DoubleRange[i];
                        for (j2 = 0; j2 < length; ++j2) {
                            DoubleRangeI[indices[j2]] = rangeI[j2];
                        }
                        continue block11;
                    }
                    case 2: {
                        int j3;
                        int j2;
                        if (this.FloatRange[i] == null) {
                            this.FloatRange[i] = new float[this.getLength()];
                            for (j2 = 0; j2 < this.getLength(); ++j2) {
                                this.FloatRange[i][j2] = Float.NaN;
                            }
                        }
                        float[] FloatRangeI = this.FloatRange[i];
                        for (j3 = 0; j3 < length; ++j3) {
                            FloatRangeI[indices[j3]] = (float)rangeI[j3];
                        }
                        continue block11;
                    }
                    case 6: {
                        int j4;
                        int j3;
                        int[] index = this.RangeSet[i].valueToIndex(Set.doubleToFloat(range1));
                        if (this.ByteRange[i] == null) {
                            this.ByteRange[i] = new byte[this.getLength()];
                            for (j3 = 0; j3 < this.getLength(); ++j3) {
                                this.ByteRange[i][j3] = -128;
                            }
                        }
                        byte[] ByteRangeI = this.ByteRange[i];
                        for (j4 = 0; j4 < length; ++j4) {
                            ByteRangeI[indices[j4]] = (byte)(index[j4] + -128 + 1);
                        }
                        continue block11;
                    }
                    case 5: {
                        int j;
                        int j4;
                        int[] index = this.RangeSet[i].valueToIndex(Set.doubleToFloat(range1));
                        if (this.ShortRange[i] == null) {
                            this.ShortRange[i] = new short[this.getLength()];
                            for (j4 = 0; j4 < this.getLength(); ++j4) {
                                this.ShortRange[i][j4] = Short.MIN_VALUE;
                            }
                        }
                        short[] ShortRangeI = this.ShortRange[i];
                        for (j = 0; j < length; ++j) {
                            ShortRangeI[indices[j]] = (short)(index[j] + Short.MIN_VALUE + 1);
                        }
                        continue block11;
                    }
                    case 4: {
                        int j;
                        int[] index = this.RangeSet[i].valueToIndex(Set.doubleToFloat(range1));
                        if (this.IntRange[i] == null) {
                            this.IntRange[i] = new int[this.getLength()];
                            for (j = 0; j < this.getLength(); ++j) {
                                this.IntRange[i][j] = Integer.MIN_VALUE;
                            }
                        }
                        int[] IntRangeI = this.IntRange[i];
                        for (int j5 = 0; j5 < length; ++j5) {
                            IntRangeI[indices[j5]] = index[j5] + Integer.MIN_VALUE + 1;
                        }
                        continue block11;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
            }
            this.clearMissing();
            // ** MonitorExit[var6_5] (shouldn't be in output)
            this.setRangeErrors(null);
            this.notifyReferences();
            return;
        }
    }

    @Override
    public void setSamples(float[][] range, ErrorEstimate[] errors, boolean copy) throws VisADException, RemoteException {
        if (range.length != this.TupleDimension || errors != null && errors.length != this.TupleDimension) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        for (int i = 0; i < this.TupleDimension; ++i) {
            if (range[i].length == this.getLength()) continue;
            throw new FieldException("setSamples: bad array length");
        }
        this.packValues(range, copy);
        this.setRangeErrors(errors);
        this.notifyReferences();
    }

    protected void pr(String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packValues(double[][] range, boolean copy) throws VisADException {
        this.pr("packValuesD");
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            this.nullRanges();
            block10: for (int i = 0; i < this.TupleDimension; ++i) {
                double[] rangeI = range[i];
                double[][] range1 = new double[][]{rangeI};
                switch (this.RangeMode[i]) {
                    case 1: {
                        if (copy) {
                            this.DoubleRange[i] = new double[this.getLength()];
                            double[] DoubleRangeI = this.DoubleRange[i];
                            System.arraycopy(rangeI, 0, DoubleRangeI, 0, this.getLength());
                            continue block10;
                        }
                        this.DoubleRange[i] = rangeI;
                        continue block10;
                    }
                    case 2: {
                        this.FloatRange[i] = new float[this.getLength()];
                        float[] FloatRangeI = this.FloatRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            FloatRangeI[j] = (float)rangeI[j];
                        }
                        continue block10;
                    }
                    case 6: {
                        int[] index = this.RangeSet[i].valueToIndex(Set.doubleToFloat(range1));
                        this.ByteRange[i] = new byte[this.getLength()];
                        byte[] ByteRangeI = this.ByteRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            ByteRangeI[j] = (byte)(index[j] + -128 + 1);
                        }
                        continue block10;
                    }
                    case 5: {
                        int[] index = this.RangeSet[i].valueToIndex(Set.doubleToFloat(range1));
                        this.ShortRange[i] = new short[this.getLength()];
                        short[] ShortRangeI = this.ShortRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            ShortRangeI[j] = (short)(index[j] + Short.MIN_VALUE + 1);
                        }
                        continue block10;
                    }
                    case 4: {
                        int[] index = this.RangeSet[i].valueToIndex(Set.doubleToFloat(range1));
                        this.IntRange[i] = new int[this.getLength()];
                        int[] IntRangeI = this.IntRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            IntRangeI[j] = index[j] + Integer.MIN_VALUE + 1;
                        }
                        continue block10;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
            }
            this.clearMissing();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packValues(float[][] range, boolean copy) throws VisADException {
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            this.nullRanges();
            block10: for (int i = 0; i < this.TupleDimension; ++i) {
                float[] rangeI = range[i];
                float[][] range1 = new float[][]{rangeI};
                switch (this.RangeMode[i]) {
                    case 1: {
                        this.DoubleRange[i] = new double[this.getLength()];
                        double[] DoubleRangeI = this.DoubleRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            DoubleRangeI[j] = rangeI[j];
                        }
                        continue block10;
                    }
                    case 2: {
                        if (copy) {
                            this.FloatRange[i] = new float[this.getLength()];
                            float[] FloatRangeI = this.FloatRange[i];
                            System.arraycopy(rangeI, 0, FloatRangeI, 0, this.getLength());
                            continue block10;
                        }
                        this.FloatRange[i] = rangeI;
                        continue block10;
                    }
                    case 6: {
                        int[] index = this.RangeSet[i].valueToIndex(range1);
                        this.ByteRange[i] = new byte[this.getLength()];
                        byte[] ByteRangeI = this.ByteRange[i];
                        int offset = -127;
                        for (int j = 0; j < this.getLength(); ++j) {
                            ByteRangeI[j] = (byte)(index[j] + offset);
                        }
                        continue block10;
                    }
                    case 5: {
                        int[] index = this.RangeSet[i].valueToIndex(range1);
                        this.ShortRange[i] = new short[this.getLength()];
                        short[] ShortRangeI = this.ShortRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            ShortRangeI[j] = (short)(index[j] + Short.MIN_VALUE + 1);
                        }
                        continue block10;
                    }
                    case 4: {
                        int[] index = this.RangeSet[i].valueToIndex(range1);
                        this.IntRange[i] = new int[this.getLength()];
                        int[] IntRangeI = this.IntRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            IntRangeI[j] = index[j] + Integer.MIN_VALUE + 1;
                        }
                        continue block10;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
            }
            this.clearMissing();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public byte[][] grabBytes() {
        return this.ByteRange;
    }

    public double[][] unpackValues() throws VisADException {
        return this.unpackValues(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double[][] unpackValues(boolean copy) throws SetException, VisADException {
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            if (this.isMissing()) {
                double[][] range = new double[this.TupleDimension][this.getLength()];
                for (int i = 0; i < this.TupleDimension; ++i) {
                    for (int j = 0; j < this.getLength(); ++j) {
                        range[i][j] = Double.NaN;
                    }
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return range;
            }
            double[][] range = new double[this.TupleDimension][];
            block12: for (int i = 0; i < this.TupleDimension; ++i) {
                switch (this.RangeMode[i]) {
                    case 1: {
                        double[] rangeI;
                        if (copy) {
                            range[i] = new double[this.getLength()];
                            rangeI = range[i];
                            double[] DoubleRangeI = this.DoubleRange[i];
                            System.arraycopy(DoubleRangeI, 0, rangeI, 0, this.getLength());
                            continue block12;
                        }
                        range[i] = this.DoubleRange[i];
                        continue block12;
                    }
                    case 2: {
                        range[i] = new double[this.getLength()];
                        double[] rangeI = range[i];
                        float[] FloatRangeI = this.FloatRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            rangeI[j] = FloatRangeI[j];
                        }
                        continue block12;
                    }
                    case 6: {
                        int[] index = new int[this.getLength()];
                        byte[] ByteRangeI = this.ByteRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            index[j] = ByteRangeI[j] - -128 - 1;
                        }
                        double[][] range0 = Set.floatToDouble(this.RangeSet[i].indexToValue(index));
                        range[i] = range0[0];
                        continue block12;
                    }
                    case 5: {
                        int[] index = new int[this.getLength()];
                        short[] ShortRangeI = this.ShortRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            index[j] = ShortRangeI[j] - Short.MIN_VALUE - 1;
                        }
                        double[][] range0 = Set.floatToDouble(this.RangeSet[i].indexToValue(index));
                        range[i] = range0[0];
                        continue block12;
                    }
                    case 4: {
                        int[] index = new int[this.getLength()];
                        int[] IntRangeI = this.IntRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            index[j] = IntRangeI[j] - Integer.MIN_VALUE - 1;
                        }
                        double[][] range0 = Set.floatToDouble(this.RangeSet[i].indexToValue(index));
                        range[i] = range0[0];
                        continue block12;
                    }
                    default: {
                        throw new SetException("FlatField.unpackValues: bad RangeMode");
                    }
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return range;
        }
    }

    public float[][] unpackFloats() throws VisADException {
        return this.unpackFloats(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float[][] unpackFloats(boolean copy) throws VisADException {
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            if (this.isMissing()) {
                float[][] range = new float[this.TupleDimension][this.getLength()];
                for (int i = 0; i < this.TupleDimension; ++i) {
                    for (int j = 0; j < this.getLength(); ++j) {
                        range[i][j] = Float.NaN;
                    }
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return range;
            }
            float[][] range = new float[this.TupleDimension][];
            block12: for (int i = 0; i < this.TupleDimension; ++i) {
                switch (this.RangeMode[i]) {
                    case 1: {
                        range[i] = new float[this.getLength()];
                        float[] rangeI = range[i];
                        double[] DoubleRangeI = this.DoubleRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            rangeI[j] = (float)DoubleRangeI[j];
                        }
                        continue block12;
                    }
                    case 2: {
                        if (copy) {
                            range[i] = new float[this.getLength()];
                            System.arraycopy(this.FloatRange[i], 0, range[i], 0, this.getLength());
                            continue block12;
                        }
                        range[i] = this.FloatRange[i];
                        continue block12;
                    }
                    case 6: {
                        int[] index = new int[this.getLength()];
                        byte[] ByteRangeI = this.ByteRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            index[j] = ByteRangeI[j] - -128 - 1;
                        }
                        float[][] range0 = this.RangeSet[i].indexToValue(index);
                        range[i] = range0[0];
                        continue block12;
                    }
                    case 5: {
                        int[] index = new int[this.getLength()];
                        short[] ShortRangeI = this.ShortRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            index[j] = ShortRangeI[j] - Short.MIN_VALUE - 1;
                        }
                        float[][] range0 = this.RangeSet[i].indexToValue(index);
                        range[i] = range0[0];
                        continue block12;
                    }
                    case 4: {
                        int[] index = new int[this.getLength()];
                        int[] IntRangeI = this.IntRange[i];
                        for (int j = 0; j < this.getLength(); ++j) {
                            index[j] = IntRangeI[j] - Integer.MIN_VALUE - 1;
                        }
                        float[][] range0 = this.RangeSet[i].indexToValue(index);
                        range[i] = range0[0];
                        continue block12;
                    }
                    default: {
                        throw new SetException("FlatField.unpackFloats: bad RangeMode");
                    }
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return range;
        }
    }

    protected double[] unpackOneRangeComp(int comp) throws VisADException {
        return this.unpackOneRangeComp(comp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double[] unpackOneRangeComp(int comp, boolean copy) throws VisADException {
        double[] range = null;
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            if (this.isMissing()) {
                range = new double[this.getLength()];
                for (int j = 0; j < this.getLength(); ++j) {
                    range[j] = Double.NaN;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return range;
            }
            block11: for (int i = 0; i < this.TupleDimension; ++i) {
                switch (this.RangeMode[comp]) {
                    case 1: {
                        if (copy) {
                            range = new double[this.getLength()];
                            System.arraycopy(this.DoubleRange[comp], 0, range, 0, this.getLength());
                            continue block11;
                        }
                        range = this.DoubleRange[comp];
                        continue block11;
                    }
                    case 2: {
                        range = new double[this.getLength()];
                        float[] FloatRangeI = this.FloatRange[comp];
                        for (int j = 0; j < this.getLength(); ++j) {
                            range[j] = FloatRangeI[j];
                        }
                        continue block11;
                    }
                    case 6: {
                        int[] index = new int[this.getLength()];
                        byte[] ByteRangeI = this.ByteRange[comp];
                        for (int j = 0; j < this.getLength(); ++j) {
                            index[j] = ByteRangeI[j] - -128 - 1;
                        }
                        double[][] range0 = Set.floatToDouble(this.RangeSet[comp].indexToValue(index));
                        range = range0[0];
                        continue block11;
                    }
                    case 5: {
                        int[] index = new int[this.getLength()];
                        short[] ShortRangeI = this.ShortRange[comp];
                        for (int j = 0; j < this.getLength(); ++j) {
                            index[j] = ShortRangeI[j] - Short.MIN_VALUE - 1;
                        }
                        double[][] range0 = Set.floatToDouble(this.RangeSet[comp].indexToValue(index));
                        range = range0[0];
                        continue block11;
                    }
                    case 4: {
                        int[] index = new int[this.getLength()];
                        int[] IntRangeI = this.IntRange[comp];
                        for (int j = 0; j < this.getLength(); ++j) {
                            index[j] = IntRangeI[j] - Integer.MIN_VALUE - 1;
                        }
                        double[][] range0 = Set.floatToDouble(this.RangeSet[comp].indexToValue(index));
                        range = range0[0];
                        continue block11;
                    }
                    default: {
                        throw new SetException("FlatField.unpackValues: bad RangeMode");
                    }
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return range;
        }
    }

    protected float[] unpackOneFloatRangeComp(int comp) throws VisADException {
        return this.unpackOneFloatRangeComp(comp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float[] unpackOneFloatRangeComp(int comp, boolean copy) throws VisADException {
        float[] range = null;
        float[][] fArray = this.FloatRange;
        synchronized (this.FloatRange) {
            if (this.isMissing()) {
                range = new float[this.getLength()];
                for (int j = 0; j < this.getLength(); ++j) {
                    range[j] = Float.NaN;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return range;
            }
            block11: for (int i = 0; i < this.TupleDimension; ++i) {
                switch (this.RangeMode[comp]) {
                    case 1: {
                        range = new float[this.getLength()];
                        double[] DoubleRangeI = this.DoubleRange[comp];
                        for (int j = 0; j < this.getLength(); ++j) {
                            range[j] = (float)DoubleRangeI[j];
                        }
                        continue block11;
                    }
                    case 2: {
                        if (copy) {
                            range = new float[this.getLength()];
                            System.arraycopy(this.FloatRange[comp], 0, range, 0, this.getLength());
                            continue block11;
                        }
                        range = this.FloatRange[comp];
                        continue block11;
                    }
                    case 6: {
                        int[] index = new int[this.getLength()];
                        byte[] ByteRangeI = this.ByteRange[comp];
                        for (int j = 0; j < this.getLength(); ++j) {
                            index[j] = ByteRangeI[j] - -128 - 1;
                        }
                        float[][] range0 = this.RangeSet[comp].indexToValue(index);
                        range = range0[0];
                        continue block11;
                    }
                    case 5: {
                        int[] index = new int[this.getLength()];
                        short[] ShortRangeI = this.ShortRange[comp];
                        for (int j = 0; j < this.getLength(); ++j) {
                            index[j] = ShortRangeI[j] - Short.MIN_VALUE - 1;
                        }
                        float[][] range0 = this.RangeSet[comp].indexToValue(index);
                        range = range0[0];
                        continue block11;
                    }
                    case 4: {
                        int[] index = new int[this.getLength()];
                        int[] IntRangeI = this.IntRange[comp];
                        for (int j = 0; j < this.getLength(); ++j) {
                            index[j] = IntRangeI[j] - Integer.MIN_VALUE - 1;
                        }
                        float[][] range0 = this.RangeSet[comp].indexToValue(index);
                        range = range0[0];
                        continue block11;
                    }
                    default: {
                        throw new SetException("FlatField.unpackValues: bad RangeMode");
                    }
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return range;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double[] unpackValues(int s_index) throws VisADException {
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            if (this.isMissing()) {
                double[] range = new double[this.TupleDimension];
                for (int i = 0; i < this.TupleDimension; ++i) {
                    range[i] = Double.NaN;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return range;
            }
            double[] range = new double[this.TupleDimension];
            block11: for (int i = 0; i < this.TupleDimension; ++i) {
                switch (this.RangeMode[i]) {
                    case 1: {
                        range[i] = this.DoubleRange[i][s_index];
                        continue block11;
                    }
                    case 2: {
                        range[i] = this.FloatRange[i][s_index];
                        continue block11;
                    }
                    case 6: {
                        int[] index = new int[1];
                        byte[] ByteRangeI = this.ByteRange[i];
                        index[0] = ByteRangeI[s_index] - -128 - 1;
                        double[][] range0 = Set.floatToDouble(this.RangeSet[i].indexToValue(index));
                        range[i] = range0[0][0];
                        continue block11;
                    }
                    case 5: {
                        int[] index = new int[1];
                        short[] ShortRangeI = this.ShortRange[i];
                        index[0] = ShortRangeI[s_index] - Short.MIN_VALUE - 1;
                        double[][] range0 = Set.floatToDouble(this.RangeSet[i].indexToValue(index));
                        range[i] = range0[0][0];
                        continue block11;
                    }
                    case 4: {
                        int[] index = new int[1];
                        int[] IntRangeI = this.IntRange[i];
                        index[0] = IntRangeI[s_index] - Integer.MIN_VALUE - 1;
                        double[][] range0 = Set.floatToDouble(this.RangeSet[i].indexToValue(index));
                        range[i] = range0[0][0];
                        continue block11;
                    }
                    default: {
                        throw new SetException("FlatField.unpackValues: bad RangeMode");
                    }
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return range;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float[] unpackFloats(int s_index) throws VisADException {
        float[][] fArray = this.FloatRange;
        synchronized (this.FloatRange) {
            if (this.isMissing()) {
                float[] range = new float[this.TupleDimension];
                for (int i = 0; i < this.TupleDimension; ++i) {
                    range[i] = Float.NaN;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return range;
            }
            float[] range = new float[this.TupleDimension];
            block11: for (int i = 0; i < this.TupleDimension; ++i) {
                switch (this.RangeMode[i]) {
                    case 1: {
                        range[i] = (float)this.DoubleRange[i][s_index];
                        continue block11;
                    }
                    case 2: {
                        range[i] = this.FloatRange[i][s_index];
                        continue block11;
                    }
                    case 6: {
                        int[] index = new int[1];
                        byte[] ByteRangeI = this.ByteRange[i];
                        index[0] = ByteRangeI[s_index] - -128 - 1;
                        float[][] range0 = this.RangeSet[i].indexToValue(index);
                        range[i] = range0[0][0];
                        continue block11;
                    }
                    case 5: {
                        int[] index = new int[1];
                        short[] ShortRangeI = this.ShortRange[i];
                        index[0] = ShortRangeI[s_index] - Short.MIN_VALUE - 1;
                        float[][] range0 = this.RangeSet[i].indexToValue(index);
                        range[i] = range0[0][0];
                        continue block11;
                    }
                    case 4: {
                        int[] index = new int[1];
                        int[] IntRangeI = this.IntRange[i];
                        index[0] = IntRangeI[s_index] - Integer.MIN_VALUE - 1;
                        float[][] range0 = this.RangeSet[i].indexToValue(index);
                        range[i] = range0[0][0];
                        continue block11;
                    }
                    default: {
                        throw new SetException("FlatField.unpackFloats: bad RangeMode");
                    }
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return range;
        }
    }

    @Override
    public float[][] getFloats() throws VisADException {
        return this.getFloats(true);
    }

    @Override
    public float[][] getFloats(boolean copy) throws VisADException {
        this.pr("getFloats(" + copy + ")");
        float[][] values = this.unpackFloats(copy);
        Object[] units_out = ((FunctionType)this.Type).getFlatRange().getDefaultUnits();
        if (!Arrays.equals(units_out, this.RangeUnits)) {
            values = Unit.convertTuple(values, this.RangeUnits, (Unit[])units_out);
        }
        return values;
    }

    @Override
    public double[][] getValues() throws VisADException {
        return this.getValues(true);
    }

    @Override
    public double[][] getValues(boolean copy) throws VisADException {
        this.pr("getValues(" + copy + ")");
        double[][] values = this.unpackValues(copy);
        Unit[] units_out = ((FunctionType)this.Type).getFlatRange().getDefaultUnits();
        double[][] result = Unit.convertTuple(values, this.RangeUnits, units_out);
        return result;
    }

    @Override
    public String[][] getStringValues() throws VisADException, RemoteException {
        return null;
    }

    @Override
    public double[] getValues(int s_index) throws VisADException {
        double[] values = new double[this.TupleDimension];
        values = this.unpackValues(s_index);
        double[][] n_values = new double[this.TupleDimension][1];
        for (int ii = 0; ii < this.TupleDimension; ++ii) {
            n_values[ii][0] = values[ii];
        }
        Unit[] units_out = ((FunctionType)this.Type).getFlatRange().getDefaultUnits();
        double[][] r_values = Unit.convertTuple(n_values, this.RangeUnits, units_out);
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = r_values[ii][0];
        }
        return values;
    }

    @Override
    public Unit[] getDefaultRangeUnits() {
        return ((FunctionType)this.Type).getFlatRange().getDefaultUnits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data getSample(int index) throws VisADException, RemoteException {
        if (this.isMissing() || index < 0 || index >= this.getLength()) {
            return ((FunctionType)this.Type).getRange().missingData();
        }
        double[][] range = new double[this.TupleDimension][1];
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            block10: for (int i = 0; i < this.TupleDimension; ++i) {
                switch (this.RangeMode[i]) {
                    case 1: {
                        range[i][0] = this.DoubleRange[i][index];
                        continue block10;
                    }
                    case 2: {
                        range[i][0] = this.FloatRange[i][index];
                        continue block10;
                    }
                    case 6: {
                        int[] inds = new int[]{this.ByteRange[i][index] - -128 - 1};
                        double[][] range1 = Set.floatToDouble(this.RangeSet[i].indexToValue(inds));
                        range[i] = range1[0];
                        continue block10;
                    }
                    case 5: {
                        int[] inds = new int[]{this.ShortRange[i][index] - Short.MIN_VALUE - 1};
                        double[][] range1 = Set.floatToDouble(this.RangeSet[i].indexToValue(inds));
                        range[i] = range1[0];
                        continue block10;
                    }
                    case 4: {
                        int[] inds = new int[]{this.IntRange[i][index] - Integer.MIN_VALUE - 1};
                        double[][] range1 = Set.floatToDouble(this.RangeSet[i].indexToValue(inds));
                        range[i] = range1[0];
                        continue block10;
                    }
                    default: {
                        throw new SetException("FlatField.getSample: bad RangeMode");
                    }
                }
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            MathType RangeType = ((FunctionType)this.Type).getRange();
            if (RangeType instanceof RealType) {
                return new Real((RealType)RangeType, range[0][0], this.RangeUnits[0], this.RangeErrors[0]);
            }
            if (RangeType instanceof RealTupleType) {
                Real[] reals = new Real[this.TupleDimension];
                for (int j = 0; j < this.TupleDimension; ++j) {
                    MathType type = ((RealTupleType)RangeType).getComponent(j);
                    reals[j] = new Real((RealType)type, range[j][0], this.RangeUnits[j], this.RangeErrors[j]);
                }
                return new RealTuple((RealTupleType)RangeType, reals, this.RangeCoordinateSystem);
            }
            int n = ((TupleType)RangeType).getDimension();
            int j = 0;
            Data[] datums = new Data[n];
            for (int i = 0; i < n; ++i) {
                MathType type = ((TupleType)RangeType).getComponent(i);
                if (type instanceof RealType) {
                    datums[i] = new Real((RealType)type, range[j][0], this.RangeUnits[j], this.RangeErrors[j]);
                    ++j;
                    continue;
                }
                int m = ((RealTupleType)type).getDimension();
                Real[] reals = new Real[m];
                for (int k = 0; k < m; ++k) {
                    RealType ctype = (RealType)((RealTupleType)type).getComponent(k);
                    reals[k] = new Real(ctype, range[j][0], this.RangeUnits[j], this.RangeErrors[j]);
                    ++j;
                }
                datums[i] = new RealTuple((RealTupleType)type, reals, this.RangeCoordinateSystems[i]);
            }
            return new Tuple(datums, false);
        }
    }

    @Override
    public Data getSample(int index, boolean metadataOnly) throws VisADException, RemoteException {
        return this.getSample(index);
    }

    @Override
    public void setSample(int index, Data range, boolean copy) throws VisADException, RemoteException {
        this.setSample(index, range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSample(int index, Data range) throws VisADException, RemoteException {
        int i;
        this.pr("setSample");
        if (this.getDomainSet() == null) {
            throw new FieldException("Field.setSample: DomainSet undefined");
        }
        if (range != null && !((FunctionType)this.Type).getRange().equals(range.getType())) {
            throw new TypeException("Field.setSample: sample range type " + range.getType() + " does not match expected type " + ((FunctionType)this.Type).getRange());
        }
        if (index < 0 || index >= this.getLength()) {
            return;
        }
        double[] vals = new double[this.TupleDimension];
        ErrorEstimate[] errors_out = new ErrorEstimate[this.TupleDimension];
        if (range == null) {
            for (int j = 0; j < this.TupleDimension; ++j) {
                vals[j] = Double.NaN;
            }
        } else if (range instanceof Real) {
            vals[0] = ((Real)range).getValue();
            vals = Unit.transformUnits(this.RangeUnits[0], errors_out, ((Real)range).getUnit(), ((Real)range).getError(), vals);
        } else if (range instanceof RealTuple) {
            int j;
            double[][] value = new double[this.TupleDimension][1];
            for (j = 0; j < this.TupleDimension; ++j) {
                value[j][0] = ((Real)((RealTuple)range).getComponent(j)).getValue();
            }
            value = CoordinateSystem.transformCoordinates((RealTupleType)((FunctionType)this.Type).getRange(), this.RangeCoordinateSystem, this.RangeUnits, errors_out, (RealTupleType)range.getType(), ((RealTuple)range).getCoordinateSystem(), ((RealTuple)range).getTupleUnits(), ((RealTuple)range).getErrors(), value);
            for (j = 0; j < this.TupleDimension; ++j) {
                vals[j] = value[j][0];
            }
        } else {
            MathType RangeType = ((FunctionType)this.Type).getRange();
            int n = ((TupleIface)range).getDimension();
            int j = 0;
            for (i = 0; i < n; ++i) {
                int k;
                Data component = ((TupleIface)range).getComponent(i);
                if (component instanceof Real) {
                    double[] value = new double[]{((Real)component).getValue()};
                    ErrorEstimate[] sub_errors_out = new ErrorEstimate[1];
                    value = Unit.transformUnits(this.RangeUnits[0], sub_errors_out, ((Real)component).getUnit(), ((Real)component).getError(), value);
                    vals[j] = value[0];
                    errors_out[j] = sub_errors_out[0];
                    ++j;
                    continue;
                }
                int m = ((RealTuple)component).getDimension();
                double[][] value = new double[m][1];
                Unit[] units_out = new Unit[m];
                ErrorEstimate[] sub_errors_out = ((RealTuple)component).getErrors();
                for (k = 0; k < m; ++k) {
                    value[k][0] = ((Real)((RealTuple)component).getComponent(k)).getValue();
                    units_out[k] = this.RangeUnits[j + k];
                }
                value = CoordinateSystem.transformCoordinates((RealTupleType)((TupleType)RangeType).getComponent(i), this.RangeCoordinateSystems[i], units_out, sub_errors_out, (RealTupleType)component.getType(), ((RealTuple)component).getCoordinateSystem(), ((RealTuple)component).getTupleUnits(), ((RealTuple)component).getErrors(), value);
                for (k = 0; k < m; ++k) {
                    vals[j] = value[k][0];
                    errors_out[j] = sub_errors_out[k];
                    ++j;
                }
            }
        }
        int[] incs = new int[this.TupleDimension];
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            block19: for (int i2 = 0; i2 < this.TupleDimension; ++i2) {
                incs[i2] = vals[i2] != vals[i2] ? 0 : 1;
                switch (this.RangeMode[i2]) {
                    case 1: {
                        int j;
                        if (this.DoubleRange[i2] == null) {
                            this.DoubleRange[i2] = new double[this.getLength()];
                            for (j = 0; j < this.getLength(); ++j) {
                                this.DoubleRange[i2][j] = Double.NaN;
                            }
                        }
                        int n = i2;
                        incs[n] = incs[n] - (this.DoubleRange[i2][index] != this.DoubleRange[i2][index] ? 0 : 1);
                        this.DoubleRange[i2][index] = vals[i2];
                        continue block19;
                    }
                    case 2: {
                        int j;
                        if (this.FloatRange[i2] == null) {
                            this.FloatRange[i2] = new float[this.getLength()];
                            for (j = 0; j < this.getLength(); ++j) {
                                this.FloatRange[i2][j] = Float.NaN;
                            }
                        }
                        int n = i2;
                        incs[n] = incs[n] - (this.FloatRange[i2][index] != this.FloatRange[i2][index] ? 0 : 1);
                        this.FloatRange[i2][index] = (float)vals[i2];
                        continue block19;
                    }
                    case 6: {
                        int j;
                        double[][] values = new double[1][1];
                        values[0][0] = vals[i2];
                        int[] indices = this.RangeSet[i2].valueToIndex(Set.doubleToFloat(values));
                        if (this.ByteRange[i2] == null) {
                            this.ByteRange[i2] = new byte[this.getLength()];
                            for (j = 0; j < this.getLength(); ++j) {
                                this.ByteRange[i2][j] = -128;
                            }
                        }
                        int n = i2;
                        incs[n] = incs[n] - (this.ByteRange[i2][index] == -128 ? 0 : 1);
                        this.ByteRange[i2][index] = (byte)(indices[0] + -128 + 1);
                        continue block19;
                    }
                    case 5: {
                        int j;
                        double[][] values = new double[1][1];
                        values[0][0] = vals[i2];
                        int[] indices = this.RangeSet[i2].valueToIndex(Set.doubleToFloat(values));
                        if (this.ShortRange[i2] == null) {
                            this.ShortRange[i2] = new short[this.getLength()];
                            for (j = 0; j < this.getLength(); ++j) {
                                this.ShortRange[i2][j] = Short.MIN_VALUE;
                            }
                        }
                        int n = i2;
                        incs[n] = incs[n] - (this.ShortRange[i2][index] == Short.MIN_VALUE ? 0 : 1);
                        this.ShortRange[i2][index] = (short)(indices[0] + Short.MIN_VALUE + 1);
                        continue block19;
                    }
                    case 4: {
                        int j;
                        double[][] values = new double[1][1];
                        values[0][0] = vals[i2];
                        int[] indices = this.RangeSet[i2].valueToIndex(Set.doubleToFloat(values));
                        if (this.IntRange[i2] == null) {
                            this.IntRange[i2] = new int[this.getLength()];
                            for (j = 0; j < this.getLength(); ++j) {
                                this.IntRange[i2][j] = Integer.MIN_VALUE;
                            }
                        }
                        int n = i2;
                        incs[n] = incs[n] - (this.IntRange[i2][index] == Integer.MIN_VALUE ? 0 : 1);
                        this.IntRange[i2][index] = indices[0] + Integer.MIN_VALUE + 1;
                        continue block19;
                    }
                    default: {
                        throw new SetException("FlatField.setSample: bad RangeMode");
                    }
                }
            }
            ErrorEstimate[] errorEstimateArray = this.RangeErrors;
            synchronized (this.RangeErrors) {
                for (i = 0; i < this.TupleDimension; ++i) {
                    this.RangeErrors[i] = new ErrorEstimate(this.RangeErrors[i], errors_out[i], vals[i], incs[i]);
                }
                // ** MonitorExit[var9_12] (shouldn't be in output)
            }
            {
                this.clearMissing();
                this.notifyReferences();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nullRanges() throws VisADException {
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            int i;
            for (i = 0; i < this.TupleDimension; ++i) {
                this.DoubleRange[i] = null;
            }
            this.FloatRange = new float[this.TupleDimension][];
            this.LongRange = new long[this.TupleDimension][];
            this.IntRange = new int[this.TupleDimension][];
            this.ShortRange = new short[this.TupleDimension][];
            this.ByteRange = new byte[this.TupleDimension][];
            for (i = 0; i < this.TupleDimension; ++i) {
                int SetLength;
                this.RangeMode[i] = this.RangeSet[i] instanceof DoubleSet ? 1 : (this.RangeSet[i] instanceof FloatSet ? 2 : ((SetLength = this.RangeSet[i].getLength()) < 256 ? 6 : (SetLength < 65536 ? 5 : 4)));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMissing() {
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.MissingFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearMissing() {
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            this.MissingFlag = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Data binary(Data data, int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof Field) {
            boolean binaryDouble;
            FunctionType data_type = (FunctionType)data.getType();
            if (data_type.getRange().equalsExceptName(this.Type)) {
                if (!data_type.equalsExceptName(new_type)) {
                    throw new TypeException("binary: new_type doesn't match return type");
                }
                return data.binary(this, FlatField.invertOp(op), new_type, sampling_mode, error_mode);
            }
            if (!this.Type.equalsExceptName(data.getType())) {
                throw new TypeException("FlatField.binary: types don't match");
            }
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException();
            }
            if (!((Field)data).isFlatField()) {
                return this.convertToField().binary(data, op, new_type, sampling_mode, error_mode);
            }
            data = data.local();
            if (this.isMissing() || data.isMissing()) {
                return new_type.missingData();
            }
            data = ((FlatField)data).resample(this.getDomainSet(), sampling_mode, error_mode);
            double[][] thatValuesD = null;
            double[][] thisValuesD = null;
            float[][] thatValuesF = null;
            float[][] thisValuesF = null;
            boolean bl = binaryDouble = this.shouldBeDouble() && ((FlatField)data).shouldBeDouble();
            if (binaryDouble) {
                thatValuesD = ((FlatField)data).unpackValues();
                thisValuesD = this.unpackValues();
            } else {
                thatValuesF = ((FlatField)data).unpackFloats();
                thisValuesF = this.unpackFloats();
            }
            Unit[][] temp_units = ((FlatField)data).getRangeUnits();
            Unit[] units_in = new Unit[temp_units.length];
            for (int i = 0; i < temp_units.length; ++i) {
                units_in[i] = temp_units[i][0];
            }
            ErrorEstimate[] errors_in = ((FlatField)data).getRangeErrors();
            if (units_in == null) {
                units_in = new Unit[this.TupleDimension];
            }
            if (errors_in == null) {
                errors_in = new ErrorEstimate[this.TupleDimension];
            }
            Unit[] units_out = new Unit[this.TupleDimension];
            ErrorEstimate[] errors_out = new ErrorEstimate[this.TupleDimension];
            if (((FunctionType)this.Type).getReal()) {
                CoordinateSystem[] cs = ((FlatField)data).getRangeCoordinateSystem();
                if (thatValuesD != null) {
                    thatValuesD = CoordinateSystem.transformCoordinatesFreeUnits(((FunctionType)this.Type).getFlatRange(), this.RangeCoordinateSystem, units_out, errors_out, ((FunctionType)data.getType()).getFlatRange(), cs[0], units_in, errors_in, thatValuesD);
                }
                if (thatValuesF != null) {
                    thatValuesF = CoordinateSystem.transformCoordinatesFreeUnits(((FunctionType)this.Type).getFlatRange(), this.RangeCoordinateSystem, units_out, errors_out, ((FunctionType)data.getType()).getFlatRange(), cs[0], units_in, errors_in, thatValuesF);
                }
            } else if (this.RangeCoordinateSystems != null) {
                TupleType rtype = (TupleType)((FunctionType)this.Type).getRange();
                TupleType dtype = (TupleType)((FunctionType)data.getType()).getRange();
                int n = rtype.getDimension();
                int j = 0;
                for (int i = 0; i < n; ++i) {
                    MathType crtype = rtype.getComponent(i);
                    MathType cdtype = dtype.getComponent(i);
                    if (crtype instanceof RealTupleType) {
                        int m = ((RealTupleType)crtype).getDimension();
                        Object tmpValuesD = null;
                        Object tmpValuesF = null;
                        if (thatValuesD != null) {
                            tmpValuesD = new double[m][];
                        }
                        if (thatValuesF != null) {
                            tmpValuesF = new float[m][];
                        }
                        Unit[] sub_units_out = new Unit[m];
                        Unit[] sub_units_in = new Unit[m];
                        ErrorEstimate[] sub_errors_out = new ErrorEstimate[m];
                        ErrorEstimate[] sub_errors_in = new ErrorEstimate[m];
                        for (int k = 0; k < m; ++k) {
                            if (tmpValuesD != null) {
                                tmpValuesD[k] = thatValuesD[j + k];
                            }
                            if (tmpValuesF != null) {
                                tmpValuesF[k] = thatValuesF[j + k];
                            }
                            sub_units_in[k] = units_in[j + k];
                            sub_errors_in[k] = errors_in[j + k];
                        }
                        CoordinateSystem[] cs = ((FlatField)data).getRangeCoordinateSystem(i);
                        if (tmpValuesD != null) {
                            tmpValuesD = CoordinateSystem.transformCoordinatesFreeUnits((RealTupleType)crtype, this.RangeCoordinateSystems[i], sub_units_out, sub_errors_out, (RealTupleType)cdtype, cs[0], sub_units_in, sub_errors_in, tmpValuesD);
                        }
                        if (tmpValuesF != null) {
                            tmpValuesF = CoordinateSystem.transformCoordinatesFreeUnits((RealTupleType)crtype, this.RangeCoordinateSystems[i], sub_units_out, sub_errors_out, (RealTupleType)cdtype, cs[0], sub_units_in, sub_errors_in, tmpValuesF);
                        }
                        for (int k = 0; k < m; ++k) {
                            if (thatValuesD != null) {
                                thatValuesD[j + k] = tmpValuesD[k];
                            }
                            if (thatValuesF != null) {
                                thatValuesF[j + k] = tmpValuesF[k];
                            }
                            errors_out[j + k] = sub_errors_out[k];
                            units_out[j + k] = sub_units_out[k];
                        }
                        j += m;
                        continue;
                    }
                    errors_out[j] = errors_in[j];
                    units_out[j] = units_in[j];
                    ++j;
                }
            }
            Unit[] thisUnits = (Unit[])this.RangeUnits.clone();
            Unit[] thatUnits = units_out;
            ErrorEstimate[] thisErrs = (ErrorEstimate[])this.RangeErrors.clone();
            ErrorEstimate[] thatErrs = errors_out;
            Unit[] outUnits = new Unit[this.TupleDimension];
            switch (op) {
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    int j;
                    block72: for (j = 0; j < this.TupleDimension; ++j) {
                        if (thisUnits[j] == null || thatUnits[j] == null) {
                            outUnits[j] = null;
                        } else if (thisUnits[j] == CommonUnit.promiscuous) {
                            outUnits[j] = thatUnits[j].getAbsoluteUnit();
                        } else if (thatUnits[j] == CommonUnit.promiscuous) {
                            outUnits[j] = thisUnits[j].getAbsoluteUnit();
                        } else {
                            try {
                                boolean convertThat;
                                outUnits[j] = thisUnits[j].getAbsoluteUnit();
                                boolean convertThis = !outUnits[j].equals(thisUnits[j]);
                                boolean bl2 = convertThat = !outUnits[j].equals(thatUnits[j]);
                                if (convertThis) {
                                    if (thisValuesD != null) {
                                        thisValuesD[j] = outUnits[j].toThis(thisValuesD[j], thisUnits[j]);
                                    }
                                    if (thisValuesF != null) {
                                        thisValuesF[j] = outUnits[j].toThis(thisValuesF[j], thisUnits[j]);
                                    }
                                }
                                if (convertThat) {
                                    if (thatValuesD != null) {
                                        thatValuesD[j] = outUnits[j].toThis(thatValuesD[j], thatUnits[j]);
                                    }
                                    if (thatValuesF != null) {
                                        thatValuesF[j] = outUnits[j].toThis(thatValuesF[j], thatUnits[j]);
                                    }
                                }
                                if (error_mode != 202 && thisErrs[j] != null && thatErrs[j] != null) {
                                    double b;
                                    double a;
                                    Unit errUnit;
                                    if (convertThis) {
                                        errUnit = thisErrs[j].getUnit();
                                        if (errUnit == null) {
                                            errUnit = thisUnits[j];
                                        }
                                        double err = 0.5 * thisErrs[j].getErrorValue();
                                        double mean = thisErrs[j].getMean();
                                        a = outUnits[j].toThis(mean + err, errUnit);
                                        b = outUnits[j].toThis(mean - err, errUnit);
                                        mean = (a + b) / 2.0;
                                        err = Math.abs(a - b);
                                        thisErrs[j] = new ErrorEstimate(mean, err, outUnits[j]);
                                    }
                                    if (convertThat) {
                                        errUnit = thatErrs[j].getUnit();
                                        if (errUnit == null) {
                                            errUnit = thatUnits[j];
                                        }
                                        double err = 0.5 * thatErrs[j].getErrorValue();
                                        double mean = thatErrs[j].getMean();
                                        a = outUnits[j].toThis(mean + err, errUnit);
                                        b = outUnits[j].toThis(mean - err, errUnit);
                                        mean = (a + b) / 2.0;
                                        err = Math.abs(a - b);
                                        thatErrs[j] = new ErrorEstimate(mean, err, outUnits[j]);
                                    }
                                }
                            }
                            catch (UnitException e) {
                                outUnits[j] = null;
                            }
                        }
                        Object thisLineD = null;
                        Object thatLineD = null;
                        Object thisLineF = null;
                        Object thatLineF = null;
                        switch (op) {
                            case 1: {
                                int i;
                                if (thisValuesD != null) {
                                    double[] thisValuesLineD = thisValuesD[j];
                                    double[] thatValuesLineD = thatValuesD[j];
                                    for (i = 0; i < this.getLength(); ++i) {
                                        int n = i;
                                        thisValuesLineD[n] = thisValuesLineD[n] + thatValuesLineD[i];
                                    }
                                }
                                if (thisValuesF == null) continue block72;
                                float[] thisValuesLineF = thisValuesF[j];
                                float[] thatValuesLineF = thatValuesF[j];
                                for (i = 0; i < this.getLength(); ++i) {
                                    int n = i;
                                    thisValuesLineF[n] = thisValuesLineF[n] + thatValuesLineF[i];
                                }
                                continue block72;
                            }
                            case 2: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        double[] dArray = thisValuesD[j];
                                        int n = i;
                                        dArray[n] = dArray[n] - thatValuesD[j][i];
                                    }
                                }
                                if (thisValuesF == null) continue block72;
                                for (int i = 0; i < this.getLength(); ++i) {
                                    float[] fArray = thisValuesF[j];
                                    int n = i;
                                    fArray[n] = fArray[n] - thatValuesF[j][i];
                                }
                                continue block72;
                            }
                            case 3: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = thatValuesD[j][i] - thisValuesD[j][i];
                                    }
                                }
                                if (thisValuesF == null) continue block72;
                                for (int i = 0; i < this.getLength(); ++i) {
                                    thisValuesF[j][i] = thatValuesF[j][i] - thisValuesF[j][i];
                                }
                                continue block72;
                            }
                            case 9: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = Math.max(thisValuesD[j][i], thatValuesD[j][i]);
                                    }
                                }
                                if (thisValuesF == null) continue block72;
                                for (int i = 0; i < this.getLength(); ++i) {
                                    thisValuesF[j][i] = Math.max(thisValuesF[j][i], thatValuesF[j][i]);
                                }
                                continue block72;
                            }
                            case 10: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = Math.min(thisValuesD[j][i], thatValuesD[j][i]);
                                    }
                                }
                                if (thisValuesF == null) continue block72;
                                for (int i = 0; i < this.getLength(); ++i) {
                                    thisValuesF[j][i] = Math.min(thisValuesF[j][i], thatValuesF[j][i]);
                                }
                                continue block72;
                            }
                        }
                    }
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    int j;
                    block83: for (j = 0; j < this.TupleDimension; ++j) {
                        Unit absUnit;
                        if (thisUnits[j] != null && !(absUnit = thisUnits[j].getAbsoluteUnit()).equals(thisUnits[j])) {
                            if (thisValuesD != null) {
                                thisValuesD[j] = absUnit.toThis(thisValuesD[j], thisUnits[j]);
                            }
                            if (thisValuesF != null) {
                                thisValuesF[j] = absUnit.toThis(thisValuesF[j], thisUnits[j]);
                            }
                            thisUnits[j] = absUnit;
                        }
                        if (thatUnits[j] != null && !(absUnit = thatUnits[j].getAbsoluteUnit()).equals(thatUnits[j])) {
                            if (thatValuesD != null) {
                                thatValuesD[j] = absUnit.toThis(thatValuesD[j], thatUnits[j]);
                            }
                            if (thatValuesF != null) {
                                thatValuesF[j] = absUnit.toThis(thatValuesF[j], thatUnits[j]);
                            }
                            thatUnits[j] = absUnit;
                        }
                        if (thisUnits[j] == null || thatUnits[j] == null) {
                            outUnits[j] = null;
                        } else {
                            switch (op) {
                                case 4: {
                                    outUnits[j] = thisUnits[j].equals(CommonUnit.promiscuous) ? thatUnits[j] : (thatUnits[j].equals(CommonUnit.promiscuous) ? thisUnits[j] : thisUnits[j].multiply(thatUnits[j]));
                                    break;
                                }
                                case 5: {
                                    outUnits[j] = thatUnits[j].equals(CommonUnit.promiscuous) ? thisUnits[j] : thisUnits[j].divide(thatUnits[j]);
                                    break;
                                }
                                case 6: {
                                    outUnits[j] = thisUnits[j].equals(CommonUnit.promiscuous) ? thatUnits[j] : thatUnits[j].divide(thisUnits[j]);
                                }
                            }
                        }
                        switch (op) {
                            case 4: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        double[] dArray = thisValuesD[j];
                                        int n = i;
                                        dArray[n] = dArray[n] * thatValuesD[j][i];
                                    }
                                }
                                if (thisValuesF == null) continue block83;
                                for (int i = 0; i < this.getLength(); ++i) {
                                    float[] fArray = thisValuesF[j];
                                    int n = i;
                                    fArray[n] = fArray[n] * thatValuesF[j][i];
                                }
                                continue block83;
                            }
                            case 5: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        double[] dArray = thisValuesD[j];
                                        int n = i;
                                        dArray[n] = dArray[n] / thatValuesD[j][i];
                                    }
                                }
                                if (thisValuesF == null) continue block83;
                                for (int i = 0; i < this.getLength(); ++i) {
                                    float[] fArray = thisValuesF[j];
                                    int n = i;
                                    fArray[n] = fArray[n] / thatValuesF[j][i];
                                }
                                continue block83;
                            }
                            case 6: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = thatValuesD[j][i] / thisValuesD[j][i];
                                    }
                                }
                                if (thisValuesF == null) continue block83;
                                for (int i = 0; i < this.getLength(); ++i) {
                                    thisValuesF[j][i] = thatValuesF[j][i] / thisValuesF[j][i];
                                }
                                continue block83;
                            }
                        }
                    }
                    break;
                }
                case 7: {
                    int j;
                    for (j = 0; j < this.TupleDimension; ++j) {
                        Unit absUnit;
                        if (thisUnits[j] != null && !(absUnit = thisUnits[j].getAbsoluteUnit()).equals(thisUnits[j])) {
                            if (thisValuesD != null) {
                                thisValuesD[j] = absUnit.toThis(thisValuesD[j], thisUnits[j]);
                            }
                            if (thisValuesF != null) {
                                thisValuesF[j] = absUnit.toThis(thisValuesF[j], thisUnits[j]);
                            }
                            thisUnits[j] = absUnit;
                        }
                        if (thatUnits[j] != null && !CommonUnit.promiscuous.equals(thatUnits[j]) && !(absUnit = thatUnits[j].getAbsoluteUnit()).equals(thatUnits[j])) {
                            if (thatValuesD != null) {
                                thatValuesD[j] = absUnit.toThis(thatValuesD[j], thatUnits[j]);
                            }
                            if (thatValuesF != null) {
                                thatValuesF[j] = absUnit.toThis(thatValuesF[j], thatUnits[j]);
                            }
                            thatUnits[j] = absUnit;
                        }
                        outUnits[j] = thisUnits[j] != null && (thisUnits[j].equals(CommonUnit.promiscuous) || thisUnits[j].equals(CommonUnit.dimensionless)) ? thisUnits[j] : null;
                        if (thisValuesD != null) {
                            for (int i = 0; i < this.getLength(); ++i) {
                                thisValuesD[j][i] = Math.pow(thisValuesD[j][i], thatValuesD[j][i]);
                            }
                        }
                        if (thisValuesF == null) continue;
                        for (int i = 0; i < this.getLength(); ++i) {
                            thisValuesF[j][i] = (float)Math.pow(thisValuesF[j][i], thatValuesF[j][i]);
                        }
                    }
                    break;
                }
                case 8: {
                    int j;
                    for (j = 0; j < this.TupleDimension; ++j) {
                        Unit absUnit;
                        if (thatUnits[j] != null && !(absUnit = thatUnits[j].getAbsoluteUnit()).equals(thatUnits[j])) {
                            if (thatValuesD != null) {
                                thatValuesD[j] = absUnit.toThis(thatValuesD[j], thatUnits[j]);
                            }
                            if (thatValuesF != null) {
                                thatValuesF[j] = absUnit.toThis(thatValuesF[j], thatUnits[j]);
                            }
                            thatUnits[j] = absUnit;
                        }
                        if (thisUnits[j] != null && !CommonUnit.promiscuous.equals(thisUnits[j]) && !(absUnit = thisUnits[j].getAbsoluteUnit()).equals(thisUnits[j])) {
                            if (thisValuesD != null) {
                                thisValuesD[j] = absUnit.toThis(thisValuesD[j], thisUnits[j]);
                            }
                            if (thisValuesF != null) {
                                thisValuesF[j] = absUnit.toThis(thisValuesF[j], thisUnits[j]);
                            }
                            thisUnits[j] = absUnit;
                        }
                        outUnits[j] = thatUnits[j] != null && (thatUnits[j].equals(CommonUnit.promiscuous) || thatUnits[j].equals(CommonUnit.dimensionless)) ? thatUnits[j] : null;
                        if (thisValuesD != null) {
                            for (int i = 0; i < this.getLength(); ++i) {
                                thisValuesD[j][i] = Math.pow(thatValuesD[j][i], thisValuesD[j][i]);
                            }
                        }
                        if (thisValuesF == null) continue;
                        for (int i = 0; i < this.getLength(); ++i) {
                            thisValuesF[j][i] = (float)Math.pow(thatValuesF[j][i], thisValuesF[j][i]);
                        }
                    }
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    int j;
                    block96: for (j = 0; j < this.TupleDimension; ++j) {
                        if (thisUnits[j] != null && thatUnits[j] != null) {
                            Unit absUnit = thisUnits[j].getAbsoluteUnit();
                            if (!absUnit.equals(thisUnits[j])) {
                                if (thisValuesD != null) {
                                    thisValuesD[j] = absUnit.toThis(thisValuesD[j], thisUnits[j]);
                                }
                                if (thisValuesF != null) {
                                    thisValuesF[j] = absUnit.toThis(thisValuesF[j], thisUnits[j]);
                                }
                                thisUnits[j] = absUnit;
                            }
                            if (!absUnit.equals(thatUnits[j])) {
                                if (thatValuesD != null) {
                                    thatValuesD[j] = absUnit.toThis(thatValuesD[j], thatUnits[j]);
                                }
                                if (thatValuesF != null) {
                                    thatValuesF[j] = absUnit.toThis(thatValuesF[j], thatUnits[j]);
                                }
                                thatUnits[j] = absUnit;
                            }
                        }
                        switch (op) {
                            case 11: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = Math.atan2(thisValuesD[j][i], thatValuesD[j][i]);
                                    }
                                }
                                if (thisValuesF != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesF[j][i] = (float)Math.atan2(thisValuesF[j][i], thatValuesF[j][i]);
                                    }
                                }
                                outUnits[j] = CommonUnit.radian;
                                continue block96;
                            }
                            case 12: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = 57.29577951308232 * Math.atan2(thisValuesD[j][i], thatValuesD[j][i]);
                                    }
                                }
                                if (thisValuesF != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesF[j][i] = (float)(57.29577951308232 * Math.atan2(thisValuesF[j][i], thatValuesF[j][i]));
                                    }
                                }
                                outUnits[j] = CommonUnit.degree;
                                continue block96;
                            }
                            case 13: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = Math.atan2(thatValuesD[j][i], thisValuesD[j][i]);
                                    }
                                }
                                if (thisValuesF != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesF[j][i] = (float)Math.atan2(thatValuesF[j][i], thisValuesF[j][i]);
                                    }
                                }
                                outUnits[j] = CommonUnit.radian;
                                continue block96;
                            }
                            case 14: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = 57.29577951308232 * Math.atan2(thatValuesD[j][i], thisValuesD[j][i]);
                                    }
                                }
                                if (thisValuesF != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesF[j][i] = (float)(57.29577951308232 * Math.atan2(thatValuesF[j][i], thisValuesF[j][i]));
                                    }
                                }
                                outUnits[j] = CommonUnit.degree;
                                continue block96;
                            }
                            case 15: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        double[] dArray = thisValuesD[j];
                                        int n = i;
                                        dArray[n] = dArray[n] % thatValuesD[j][i];
                                    }
                                }
                                if (thisValuesF != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        float[] fArray = thisValuesF[j];
                                        int n = i;
                                        fArray[n] = fArray[n] % thatValuesF[j][i];
                                    }
                                }
                                outUnits[j] = thisUnits[j];
                                continue block96;
                            }
                            case 16: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = thatValuesD[j][i] % thisValuesD[j][i];
                                    }
                                }
                                if (thisValuesF != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesF[j][i] = thatValuesF[j][i] % thisValuesF[j][i];
                                    }
                                }
                                outUnits[j] = thatUnits[j];
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new ArithmeticException("FlatField.binary: illegal operation");
                }
            }
            ErrorEstimate[] outErrs = new ErrorEstimate[this.TupleDimension];
            for (int j = 0; j < this.TupleDimension; ++j) {
                if (error_mode == 202 || thisErrs[j] == null || thatErrs[j] == null) {
                    outErrs[j] = null;
                    continue;
                }
                if (thisValuesD != null) {
                    outErrs[j] = new ErrorEstimate(thisValuesD[j], outUnits[j], op, thisErrs[j], thatErrs[j], error_mode);
                }
                if (thisValuesF == null) continue;
                outErrs[j] = new ErrorEstimate(thisValuesF[j], outUnits[j], op, thisErrs[j], thatErrs[j], error_mode);
            }
            FlatField new_field = null;
            if (thisValuesD != null) {
                new_field = this.cloneDouble(new_type, outUnits, outErrs, thisValuesD);
            }
            if (thisValuesF != null) {
                new_field = this.cloneFloat(new_type, outUnits, outErrs, thisValuesF);
            }
            new_field.clearMissing();
            return new_field;
        }
        if (data instanceof Real || data instanceof RealTuple || data instanceof TupleIface && ((TupleType)data.getType()).getFlat()) {
            int j;
            int j2;
            MathType RangeType = ((FunctionType)this.Type).getRange();
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
            if (this.isMissing() || data.isMissing()) {
                return new_type.missingData();
            }
            double[][] vals = new double[this.TupleDimension][1];
            Unit[] units_out = new Unit[this.TupleDimension];
            ErrorEstimate[] errors_out = new ErrorEstimate[this.TupleDimension];
            if (data instanceof Real) {
                for (j2 = 0; j2 < this.TupleDimension; ++j2) {
                    vals[j2][0] = ((Real)data).getValue();
                    units_out[j2] = ((Real)data).getUnit();
                    errors_out[j2] = ((Real)data).getError();
                }
            } else if (data instanceof RealTuple) {
                for (j2 = 0; j2 < this.TupleDimension; ++j2) {
                    vals[j2][0] = ((Real)((RealTuple)data).getComponent(j2)).getValue();
                }
                vals = CoordinateSystem.transformCoordinatesFreeUnits(((FunctionType)this.Type).getFlatRange(), this.RangeCoordinateSystem, units_out, errors_out, (RealTupleType)data.getType(), ((RealTuple)data).getCoordinateSystem(), ((RealTuple)data).getTupleUnits(), ((RealTuple)data).getErrors(), vals);
            } else {
                int n = ((TupleIface)data).getDimension();
                int j3 = 0;
                for (int i = 0; i < n; ++i) {
                    int k;
                    Data component = ((TupleIface)data).getComponent(i);
                    if (component instanceof Real) {
                        vals[j3][0] = ((Real)component).getValue();
                        units_out[j3] = ((Real)component).getUnit();
                        errors_out[j3] = ((Real)component).getError();
                        ++j3;
                        continue;
                    }
                    int m = ((TupleIface)component).getDimension();
                    double[][] tvals = new double[m][1];
                    Unit[] sub_units_out = new Unit[m];
                    ErrorEstimate[] sub_errors_out = new ErrorEstimate[m];
                    for (k = 0; k < m; ++k) {
                        tvals[k][0] = ((Real)((TupleIface)component).getComponent(k)).getValue();
                    }
                    tvals = CoordinateSystem.transformCoordinatesFreeUnits((RealTupleType)((TupleType)RangeType).getComponent(i), this.RangeCoordinateSystems[i], sub_units_out, sub_errors_out, (RealTupleType)component.getType(), ((RealTuple)component).getCoordinateSystem(), ((RealTuple)component).getTupleUnits(), ((RealTuple)component).getErrors(), tvals);
                    for (k = 0; k < m; ++k) {
                        vals[j3 + k][0] = tvals[k][0];
                        units_out[j3 + k] = sub_units_out[k];
                        errors_out[j3 + k] = sub_errors_out[k];
                    }
                    j3 += m;
                }
            }
            Unit[] thisUnits = (Unit[])this.RangeUnits.clone();
            Unit[] thatUnits = units_out;
            boolean binaryDouble = this.shouldBeDouble();
            double[][] thisValuesD = null;
            float[][] thisValuesF = null;
            if (binaryDouble) {
                thisValuesD = this.unpackValues();
            } else {
                thisValuesF = this.unpackFloats();
            }
            double[] thatValues = new double[vals.length];
            ErrorEstimate[] thisErrs = (ErrorEstimate[])this.RangeErrors.clone();
            ErrorEstimate[] thatErrs = errors_out;
            Unit[] outUnits = new Unit[this.TupleDimension];
            for (j = 0; j < vals.length; ++j) {
                thatValues[j] = vals[j][0];
            }
            switch (op) {
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    block116: for (j = 0; j < this.TupleDimension; ++j) {
                        if (thisUnits[j] == null || thatUnits[j] == null) {
                            outUnits[j] = null;
                        } else if (thisUnits[j] == CommonUnit.promiscuous) {
                            outUnits[j] = thatUnits[j].getAbsoluteUnit();
                        } else if (thatUnits[j] == CommonUnit.promiscuous) {
                            outUnits[j] = thisUnits[j].getAbsoluteUnit();
                        } else {
                            try {
                                boolean convertThat;
                                outUnits[j] = thisUnits[j].getAbsoluteUnit();
                                boolean convertThis = !outUnits[j].equals(thisUnits[j]);
                                boolean bl = convertThat = !outUnits[j].equals(thatUnits[j]);
                                if (convertThis && thisValuesD != null) {
                                    thisValuesD[j] = outUnits[j].toThis(thisValuesD[j], thisUnits[j]);
                                }
                                if (thisValuesF != null) {
                                    thisValuesF[j] = outUnits[j].toThis(thisValuesF[j], thisUnits[j]);
                                }
                                if (convertThat) {
                                    thatValues[j] = outUnits[j].toThis(thatValues[j], thatUnits[j]);
                                }
                                if (error_mode != 202 && thisErrs[j] != null && thatErrs[j] != null) {
                                    double b;
                                    double a;
                                    double mean;
                                    double err;
                                    Unit errUnit;
                                    if (convertThis) {
                                        errUnit = thisErrs[j].getUnit();
                                        if (errUnit == null) {
                                            errUnit = thisUnits[j];
                                        }
                                        err = 0.5 * thisErrs[j].getErrorValue();
                                        mean = thisErrs[j].getMean();
                                        a = outUnits[j].toThis(mean + err, errUnit);
                                        b = outUnits[j].toThis(mean - err, errUnit);
                                        mean = (a + b) / 2.0;
                                        err = Math.abs(a - b);
                                        thisErrs[j] = new ErrorEstimate(mean, err, outUnits[j]);
                                    }
                                    if (convertThat) {
                                        errUnit = thatErrs[j].getUnit();
                                        if (errUnit == null) {
                                            errUnit = thatUnits[j];
                                        }
                                        err = 0.5 * thatErrs[j].getErrorValue();
                                        mean = thatErrs[j].getMean();
                                        a = outUnits[j].toThis(mean + err, errUnit);
                                        b = outUnits[j].toThis(mean - err, errUnit);
                                        mean = (a + b) / 2.0;
                                        err = Math.abs(a - b);
                                        thatErrs[j] = new ErrorEstimate(mean, err, outUnits[j]);
                                    }
                                }
                            }
                            catch (UnitException e) {
                                outUnits[j] = null;
                            }
                        }
                        switch (op) {
                            case 1: {
                                if (thisValuesD != null) {
                                    int i = 0;
                                    while (i < this.getLength()) {
                                        double[] dArray = thisValuesD[j];
                                        int n = i++;
                                        dArray[n] = dArray[n] + thatValues[j];
                                    }
                                }
                                if (thisValuesF == null) continue block116;
                                int i = 0;
                                while (i < this.getLength()) {
                                    float[] fArray = thisValuesF[j];
                                    int n = i++;
                                    fArray[n] = (float)((double)fArray[n] + thatValues[j]);
                                }
                                continue block116;
                            }
                            case 2: {
                                if (thisValuesD != null) {
                                    int i = 0;
                                    while (i < this.getLength()) {
                                        double[] dArray = thisValuesD[j];
                                        int n = i++;
                                        dArray[n] = dArray[n] - thatValues[j];
                                    }
                                }
                                if (thisValuesF == null) continue block116;
                                int i = 0;
                                while (i < this.getLength()) {
                                    float[] fArray = thisValuesF[j];
                                    int n = i++;
                                    fArray[n] = (float)((double)fArray[n] - thatValues[j]);
                                }
                                continue block116;
                            }
                            case 3: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = thatValues[j] - thisValuesD[j][i];
                                    }
                                }
                                if (thisValuesF == null) continue block116;
                                for (int i = 0; i < this.getLength(); ++i) {
                                    thisValuesF[j][i] = (float)(thatValues[j] - (double)thisValuesF[j][i]);
                                }
                                continue block116;
                            }
                            case 9: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = Math.max(thisValuesD[j][i], thatValues[j]);
                                    }
                                }
                                if (thisValuesF == null) continue block116;
                                for (int i = 0; i < this.getLength(); ++i) {
                                    thisValuesF[j][i] = (float)Math.max((double)thisValuesF[j][i], thatValues[j]);
                                }
                                continue block116;
                            }
                            case 10: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = Math.min(thisValuesD[j][i], thatValues[j]);
                                    }
                                }
                                if (thisValuesF == null) continue block116;
                                for (int i = 0; i < this.getLength(); ++i) {
                                    thisValuesF[j][i] = (float)Math.min((double)thisValuesF[j][i], thatValues[j]);
                                }
                                continue block116;
                            }
                        }
                    }
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    block127: for (j = 0; j < this.TupleDimension; ++j) {
                        Unit absUnit;
                        if (thisUnits[j] != null && !(absUnit = thisUnits[j].getAbsoluteUnit()).equals(thisUnits[j])) {
                            if (thisValuesD != null) {
                                thisValuesD[j] = absUnit.toThis(thisValuesD[j], thisUnits[j]);
                            }
                            if (thisValuesF != null) {
                                thisValuesF[j] = absUnit.toThis(thisValuesF[j], thisUnits[j]);
                            }
                            thisUnits[j] = absUnit;
                        }
                        if (thatUnits[j] != null && !(absUnit = thatUnits[j].getAbsoluteUnit()).equals(thatUnits[j])) {
                            thatValues[j] = absUnit.toThis(thatValues[j], thatUnits[j]);
                            thatUnits[j] = absUnit;
                        }
                        if (thisUnits[j] == null || thatUnits[j] == null) {
                            outUnits[j] = null;
                        } else {
                            switch (op) {
                                case 4: {
                                    outUnits[j] = thisUnits[j].equals(CommonUnit.promiscuous) ? thatUnits[j] : (thatUnits[j].equals(CommonUnit.promiscuous) ? thisUnits[j] : thisUnits[j].multiply(thatUnits[j]));
                                    break;
                                }
                                case 5: {
                                    outUnits[j] = thatUnits[j].equals(CommonUnit.promiscuous) ? thisUnits[j] : thisUnits[j].divide(thatUnits[j]);
                                    break;
                                }
                                case 6: {
                                    outUnits[j] = thisUnits[j].equals(CommonUnit.promiscuous) ? thatUnits[j] : thatUnits[j].divide(thisUnits[j]);
                                }
                            }
                        }
                        switch (op) {
                            case 4: {
                                if (thisValuesD != null) {
                                    int i = 0;
                                    while (i < this.getLength()) {
                                        double[] dArray = thisValuesD[j];
                                        int n = i++;
                                        dArray[n] = dArray[n] * thatValues[j];
                                    }
                                }
                                if (thisValuesF == null) continue block127;
                                int i = 0;
                                while (i < this.getLength()) {
                                    float[] fArray = thisValuesF[j];
                                    int n = i++;
                                    fArray[n] = (float)((double)fArray[n] * thatValues[j]);
                                }
                                continue block127;
                            }
                            case 5: {
                                if (thisValuesD != null) {
                                    int i = 0;
                                    while (i < this.getLength()) {
                                        double[] dArray = thisValuesD[j];
                                        int n = i++;
                                        dArray[n] = dArray[n] / thatValues[j];
                                    }
                                }
                                if (thisValuesF == null) continue block127;
                                int i = 0;
                                while (i < this.getLength()) {
                                    float[] fArray = thisValuesF[j];
                                    int n = i++;
                                    fArray[n] = (float)((double)fArray[n] / thatValues[j]);
                                }
                                continue block127;
                            }
                            case 6: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = thatValues[j] / thisValuesD[j][i];
                                    }
                                }
                                if (thisValuesF == null) continue block127;
                                for (int i = 0; i < this.getLength(); ++i) {
                                    thisValuesF[j][i] = (float)(thatValues[j] / (double)thisValuesF[j][i]);
                                }
                                continue block127;
                            }
                        }
                    }
                    break;
                }
                case 7: {
                    for (j = 0; j < this.TupleDimension; ++j) {
                        Unit absUnit;
                        if (thisUnits[j] != null && !(absUnit = thisUnits[j].getAbsoluteUnit()).equals(thisUnits[j])) {
                            if (thisValuesD != null) {
                                thisValuesD[j] = absUnit.toThis(thisValuesD[j], thisUnits[j]);
                            }
                            if (thisValuesF != null) {
                                thisValuesF[j] = absUnit.toThis(thisValuesF[j], thisUnits[j]);
                            }
                            thisUnits[j] = absUnit;
                        }
                        if (thatUnits[j] != null && !CommonUnit.promiscuous.equals(thatUnits[j]) && !(absUnit = thatUnits[j].getAbsoluteUnit()).equals(thatUnits[j])) {
                            thatValues[j] = absUnit.toThis(thatValues[j], thatUnits[j]);
                            thatUnits[j] = absUnit;
                        }
                        outUnits[j] = thisUnits[j] != null && (thisUnits[j].equals(CommonUnit.promiscuous) || thisUnits[j].equals(CommonUnit.dimensionless)) ? thisUnits[j] : null;
                        if (thisValuesD != null) {
                            for (int i = 0; i < this.getLength(); ++i) {
                                thisValuesD[j][i] = Math.pow(thisValuesD[j][i], thatValues[j]);
                            }
                        }
                        if (thisValuesF == null) continue;
                        for (int i = 0; i < this.getLength(); ++i) {
                            thisValuesF[j][i] = (float)Math.pow(thisValuesF[j][i], thatValues[j]);
                        }
                    }
                    break;
                }
                case 8: {
                    for (j = 0; j < this.TupleDimension; ++j) {
                        Unit absUnit;
                        if (thatUnits[j] != null && !(absUnit = thatUnits[j].getAbsoluteUnit()).equals(thatUnits[j])) {
                            thatValues[j] = absUnit.toThis(thatValues[j], thatUnits[j]);
                            thatUnits[j] = absUnit;
                        }
                        if (thisUnits[j] != null && !CommonUnit.promiscuous.equals(thisUnits[j]) && !(absUnit = thisUnits[j].getAbsoluteUnit()).equals(thisUnits[j])) {
                            if (thisValuesD != null) {
                                thisValuesD[j] = absUnit.toThis(thisValuesD[j], thisUnits[j]);
                            }
                            if (thisValuesF != null) {
                                thisValuesF[j] = absUnit.toThis(thisValuesF[j], thisUnits[j]);
                            }
                            thisUnits[j] = absUnit;
                        }
                        outUnits[j] = thatUnits[j] != null && (thatUnits[j].equals(CommonUnit.promiscuous) || thatUnits[j].equals(CommonUnit.dimensionless)) ? thatUnits[j] : null;
                        if (thisValuesD != null) {
                            for (int i = 0; i < this.getLength(); ++i) {
                                thisValuesD[j][i] = Math.pow(thatValues[j], thisValuesD[j][i]);
                            }
                        }
                        if (thisValuesF == null) continue;
                        for (int i = 0; i < this.getLength(); ++i) {
                            thisValuesF[j][i] = (float)Math.pow(thatValues[j], thisValuesF[j][i]);
                        }
                    }
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    block140: for (j = 0; j < this.TupleDimension; ++j) {
                        if (thisUnits[j] != null && thatUnits[j] != null) {
                            Unit absUnit = thisUnits[j].getAbsoluteUnit();
                            if (!absUnit.equals(thisUnits[j])) {
                                if (thisValuesD != null) {
                                    thisValuesD[j] = absUnit.toThis(thisValuesD[j], thisUnits[j]);
                                }
                                if (thisValuesF != null) {
                                    thisValuesF[j] = absUnit.toThis(thisValuesF[j], thisUnits[j]);
                                }
                                thisUnits[j] = absUnit;
                            }
                            if (!absUnit.equals(thatUnits[j])) {
                                thatValues[j] = absUnit.toThis(thatValues[j], thatUnits[j]);
                                thatUnits[j] = absUnit;
                            }
                        }
                        switch (op) {
                            case 11: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = Math.atan2(thisValuesD[j][i], thatValues[j]);
                                    }
                                }
                                if (thisValuesF != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesF[j][i] = (float)Math.atan2(thisValuesF[j][i], thatValues[j]);
                                    }
                                }
                                outUnits[j] = CommonUnit.radian;
                                continue block140;
                            }
                            case 12: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = 57.29577951308232 * Math.atan2(thisValuesD[j][i], thatValues[j]);
                                    }
                                }
                                if (thisValuesF != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesF[j][i] = (float)(57.29577951308232 * Math.atan2(thisValuesF[j][i], thatValues[j]));
                                    }
                                }
                                outUnits[j] = CommonUnit.degree;
                                continue block140;
                            }
                            case 13: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = Math.atan2(thatValues[j], thisValuesD[j][i]);
                                    }
                                }
                                if (thisValuesF != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesF[j][i] = (float)Math.atan2(thatValues[j], thisValuesF[j][i]);
                                    }
                                }
                                outUnits[j] = CommonUnit.radian;
                                continue block140;
                            }
                            case 14: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = 57.29577951308232 * Math.atan2(thatValues[j], thisValuesD[j][i]);
                                    }
                                }
                                if (thisValuesF != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesF[j][i] = (float)(57.29577951308232 * Math.atan2(thatValues[j], thisValuesF[j][i]));
                                    }
                                }
                                outUnits[j] = CommonUnit.degree;
                                continue block140;
                            }
                            case 15: {
                                if (thisValuesD != null) {
                                    int i = 0;
                                    while (i < this.getLength()) {
                                        double[] dArray = thisValuesD[j];
                                        int n = i++;
                                        dArray[n] = dArray[n] % thatValues[j];
                                    }
                                }
                                if (thisValuesF != null) {
                                    int i = 0;
                                    while (i < this.getLength()) {
                                        float[] fArray = thisValuesF[j];
                                        int n = i++;
                                        fArray[n] = (float)((double)fArray[n] % thatValues[j]);
                                    }
                                }
                                outUnits[j] = thisUnits[j];
                                continue block140;
                            }
                            case 16: {
                                if (thisValuesD != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesD[j][i] = thatValues[j] % thisValuesD[j][i];
                                    }
                                }
                                if (thisValuesF != null) {
                                    for (int i = 0; i < this.getLength(); ++i) {
                                        thisValuesF[j][i] = (float)(thatValues[j] % (double)thisValuesF[j][i]);
                                    }
                                }
                                outUnits[j] = thatUnits[j];
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new ArithmeticException("FlatField.binary: illegal operation");
                }
            }
            ErrorEstimate[] outErrs = new ErrorEstimate[this.TupleDimension];
            for (int j4 = 0; j4 < this.TupleDimension; ++j4) {
                if (error_mode == 202 || thisErrs[j4] == null || thatErrs[j4] == null) {
                    outErrs[j4] = null;
                    continue;
                }
                if (thisValuesD != null) {
                    outErrs[j4] = new ErrorEstimate(thisValuesD[j4], outUnits[j4], op, thisErrs[j4], thatErrs[j4], error_mode);
                }
                if (thisValuesF == null) continue;
                outErrs[j4] = new ErrorEstimate(thisValuesF[j4], outUnits[j4], op, thisErrs[j4], thatErrs[j4], error_mode);
            }
            FlatField new_field = null;
            if (thisValuesD != null) {
                new_field = this.cloneDouble(new_type, outUnits, outErrs, thisValuesD);
            }
            if (thisValuesF != null) {
                new_field = this.cloneFloat(new_type, outUnits, outErrs, thisValuesF);
            }
            new_field.clearMissing();
            return new_field;
        }
        throw new TypeException("Field.binary");
    }

    @Override
    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException {
        int j;
        if (this.isMissing()) {
            if (this.shouldBeDouble()) {
                return this.cloneDouble(new_type, this.RangeUnits, this.RangeErrors);
            }
            return this.cloneFloat(new_type, this.RangeUnits, this.RangeErrors);
        }
        if (new_type == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        Unit[] units_out = new Unit[this.TupleDimension];
        Unit[] units_in = (Unit[])this.RangeUnits.clone();
        ErrorEstimate[] errors_in = (ErrorEstimate[])this.RangeErrors.clone();
        double[][] valuesD = null;
        float[][] valuesF = null;
        if (this.shouldBeDouble()) {
            valuesD = this.unpackValues();
            FlatField.makeRational(valuesD, units_in, errors_in);
        } else {
            valuesF = this.unpackFloats();
            FlatField.makeRational(valuesF, units_in, errors_in);
        }
        switch (op) {
            case 21: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = Math.abs(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = Math.abs(valuesFJ[i]);
                        }
                    }
                    units_out[j] = units_in[j];
                }
                break;
            }
            case 22: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = Math.acos(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = (float)Math.acos(valuesFJ[i]);
                        }
                    }
                    units_out[j] = CommonUnit.radian;
                }
                break;
            }
            case 23: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = 57.29577951308232 * Math.acos(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = (float)(57.29577951308232 * Math.acos(valuesFJ[i]));
                        }
                    }
                    units_out[j] = CommonUnit.degree;
                }
                break;
            }
            case 24: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = Math.asin(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = (float)Math.asin(valuesFJ[i]);
                        }
                    }
                    units_out[j] = CommonUnit.radian;
                }
                break;
            }
            case 25: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = 57.29577951308232 * Math.asin(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = (float)(57.29577951308232 * Math.asin(valuesFJ[i]));
                        }
                    }
                    units_out[j] = CommonUnit.degree;
                }
                break;
            }
            case 26: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = Math.atan(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = (float)Math.atan(valuesFJ[i]);
                        }
                    }
                    units_out[j] = CommonUnit.radian;
                }
                break;
            }
            case 27: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = 57.29577951308232 * Math.atan(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = (float)(57.29577951308232 * Math.atan(valuesFJ[i]));
                        }
                    }
                    units_out[j] = CommonUnit.degree;
                }
                break;
            }
            case 28: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = Math.ceil(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = (float)Math.ceil(valuesFJ[i]);
                        }
                    }
                    units_out[j] = units_in[j];
                }
                break;
            }
            case 29: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (CommonUnit.degree.equals(units_in[j])) {
                        if (valuesD != null) {
                            valuesDJ = valuesD[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesDJ[i] = Math.cos(Math.PI / 180 * valuesDJ[i]);
                            }
                        }
                        if (valuesF != null) {
                            valuesFJ = valuesF[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesFJ[i] = (float)Math.cos(Math.PI / 180 * (double)valuesFJ[i]);
                            }
                        }
                    } else {
                        if (valuesD != null) {
                            valuesDJ = valuesD[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesDJ[i] = Math.cos(valuesDJ[i]);
                            }
                        }
                        if (valuesF != null) {
                            valuesFJ = valuesF[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesFJ[i] = (float)Math.cos(valuesFJ[i]);
                            }
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                }
                break;
            }
            case 30: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (CommonUnit.radian.equals(units_in[j])) {
                        if (valuesD != null) {
                            valuesDJ = valuesD[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesDJ[i] = Math.cos(valuesDJ[i]);
                            }
                        }
                        if (valuesF != null) {
                            valuesFJ = valuesF[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesFJ[i] = (float)Math.cos(valuesFJ[i]);
                            }
                        }
                    } else {
                        if (valuesD != null) {
                            valuesDJ = valuesD[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesDJ[i] = Math.cos(Math.PI / 180 * valuesDJ[i]);
                            }
                        }
                        if (valuesF != null) {
                            valuesFJ = valuesF[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesFJ[i] = (float)Math.cos(Math.PI / 180 * (double)valuesFJ[i]);
                            }
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                }
                break;
            }
            case 31: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = Math.exp(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = (float)Math.exp(valuesFJ[i]);
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                }
                break;
            }
            case 32: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = Math.floor(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = (float)Math.floor(valuesFJ[i]);
                        }
                    }
                    units_out[j] = units_in[j];
                }
                break;
            }
            case 33: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = Math.log(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = (float)Math.log(valuesFJ[i]);
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                }
                break;
            }
            case 34: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = Math.rint(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = (float)Math.rint(valuesFJ[i]);
                        }
                    }
                    units_out[j] = units_in[j];
                }
                break;
            }
            case 35: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = Math.round(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = Math.round(valuesFJ[i]);
                        }
                    }
                    units_out[j] = units_in[j];
                }
                break;
            }
            case 36: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (CommonUnit.degree.equals(units_in[j])) {
                        if (valuesD != null) {
                            valuesDJ = valuesD[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesDJ[i] = Math.sin(Math.PI / 180 * valuesDJ[i]);
                            }
                        }
                        if (valuesF != null) {
                            valuesFJ = valuesF[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesFJ[i] = (float)Math.sin(Math.PI / 180 * (double)valuesFJ[i]);
                            }
                        }
                    } else {
                        if (valuesD != null) {
                            valuesDJ = valuesD[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesDJ[i] = Math.sin(valuesDJ[i]);
                            }
                        }
                        if (valuesF != null) {
                            valuesFJ = valuesF[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesFJ[i] = (float)Math.sin(valuesFJ[i]);
                            }
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                }
                break;
            }
            case 37: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (CommonUnit.radian.equals(units_in[j])) {
                        if (valuesD != null) {
                            valuesDJ = valuesD[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesDJ[i] = Math.sin(valuesDJ[i]);
                            }
                        }
                        if (valuesF != null) {
                            valuesFJ = valuesF[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesFJ[i] = (float)Math.sin(valuesFJ[i]);
                            }
                        }
                    } else {
                        if (valuesD != null) {
                            valuesDJ = valuesD[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesDJ[i] = Math.sin(Math.PI / 180 * valuesDJ[i]);
                            }
                        }
                        if (valuesF != null) {
                            valuesFJ = valuesF[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesFJ[i] = (float)Math.sin(Math.PI / 180 * (double)valuesFJ[i]);
                            }
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                }
                break;
            }
            case 38: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = Math.sqrt(valuesDJ[i]);
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = (float)Math.sqrt(valuesFJ[i]);
                        }
                    }
                    if (units_in[j] == null) {
                        units_out[j] = null;
                        continue;
                    }
                    try {
                        units_out[j] = units_in[j].sqrt();
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        units_out[j] = null;
                        continue;
                    }
                    catch (UnitException e) {
                        units_out[j] = null;
                    }
                }
                break;
            }
            case 39: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (CommonUnit.degree.equals(units_in[j])) {
                        if (valuesD != null) {
                            valuesDJ = valuesD[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesDJ[i] = Math.tan(Math.PI / 180 * valuesDJ[i]);
                            }
                        }
                        if (valuesF != null) {
                            valuesFJ = valuesF[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesFJ[i] = (float)Math.tan(Math.PI / 180 * (double)valuesFJ[i]);
                            }
                        }
                    } else {
                        if (valuesD != null) {
                            valuesDJ = valuesD[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesDJ[i] = Math.tan(valuesDJ[i]);
                            }
                        }
                        if (valuesF != null) {
                            valuesFJ = valuesF[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesFJ[i] = (float)Math.tan(valuesFJ[i]);
                            }
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                }
                break;
            }
            case 40: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (CommonUnit.radian.equals(units_in[j])) {
                        if (valuesD != null) {
                            valuesDJ = valuesD[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesDJ[i] = Math.tan(valuesDJ[i]);
                            }
                        }
                        if (valuesF != null) {
                            valuesFJ = valuesF[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesFJ[i] = (float)Math.tan(valuesFJ[i]);
                            }
                        }
                    } else {
                        if (valuesD != null) {
                            valuesDJ = valuesD[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesDJ[i] = Math.tan(Math.PI / 180 * valuesDJ[i]);
                            }
                        }
                        if (valuesF != null) {
                            valuesFJ = valuesF[j];
                            for (i = 0; i < this.getLength(); ++i) {
                                valuesFJ[i] = (float)Math.tan(Math.PI / 180 * (double)valuesFJ[i]);
                            }
                        }
                    }
                    units_out[j] = CommonUnit.dimensionless.equals(units_in[j]) ? units_in[j] : null;
                }
                break;
            }
            case 41: {
                float[] valuesFJ;
                int i;
                double[] valuesDJ;
                for (j = 0; j < this.TupleDimension; ++j) {
                    if (valuesD != null) {
                        valuesDJ = valuesD[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesDJ[i] = -valuesDJ[i];
                        }
                    }
                    if (valuesF != null) {
                        valuesFJ = valuesF[j];
                        for (i = 0; i < this.getLength(); ++i) {
                            valuesFJ[i] = -valuesFJ[i];
                        }
                    }
                    units_out[j] = units_in[j];
                }
                break;
            }
            case 42: {
                for (j = 0; j < this.TupleDimension; ++j) {
                    units_out[j] = units_in[j];
                }
                break;
            }
        }
        ErrorEstimate[] errors_out = new ErrorEstimate[this.TupleDimension];
        for (j = 0; j < this.TupleDimension; ++j) {
            if (error_mode == 202 || errors_in[j] == null) {
                errors_out[j] = null;
                continue;
            }
            if (valuesD != null) {
                errors_out[j] = new ErrorEstimate(valuesD[j], units_out[j], op, errors_in[j], error_mode);
            }
            if (valuesF == null) continue;
            errors_out[j] = new ErrorEstimate(valuesF[j], units_out[j], op, errors_in[j], error_mode);
        }
        FlatField newField = null;
        if (valuesD != null) {
            newField = this.cloneDouble(new_type, units_out, errors_out, valuesD);
        }
        if (valuesF != null) {
            newField = this.cloneFloat(new_type, units_out, errors_out, valuesF);
        }
        newField.clearMissing();
        return newField;
    }

    protected static void makeRational(double[][] values, Unit[] units, ErrorEstimate[] errors) throws UnitException {
        for (int j = 0; j < values.length; ++j) {
            Unit inputUnit = units[j];
            if (inputUnit == null || inputUnit instanceof PromiscuousUnit) continue;
            Unit outputUnit = inputUnit.getAbsoluteUnit();
            if (Unit.canConvert(outputUnit, CommonUnit.dimensionless)) {
                outputUnit = CommonUnit.dimensionless;
            }
            if (outputUnit.equals(inputUnit)) continue;
            values[j] = outputUnit.toThis(values[j], inputUnit);
            if (errors[j] != null) {
                errors[j] = new ErrorEstimate(outputUnit.toThis(errors[j].getMean(), inputUnit), errors[j].getErrorValue(), outputUnit);
            }
            units[j] = outputUnit;
        }
    }

    protected static void makeRational(float[][] values, Unit[] units, ErrorEstimate[] errors) throws UnitException {
        for (int j = 0; j < values.length; ++j) {
            Unit inputUnit = units[j];
            if (inputUnit == null || inputUnit instanceof PromiscuousUnit) continue;
            Unit outputUnit = inputUnit.getAbsoluteUnit();
            if (Unit.canConvert(outputUnit, CommonUnit.dimensionless)) {
                outputUnit = CommonUnit.dimensionless;
            }
            if (outputUnit.equals(inputUnit)) continue;
            values[j] = outputUnit.toThis(values[j], inputUnit);
            if (errors[j] != null) {
                errors[j] = new ErrorEstimate(outputUnit.toThis(errors[j].getMean(), inputUnit), errors[j].getErrorValue(), outputUnit);
            }
            units[j] = outputUnit;
        }
    }

    @Override
    public Field extract(int component) throws VisADException, RemoteException {
        return this.extract(component, true);
    }

    public Field extract(int component, boolean copy) throws VisADException, RemoteException {
        CoordinateSystem coord_sys;
        int[] flat_indices;
        int compSize;
        int ii;
        Set domainSet = this.getDomainSet();
        int n_samples = domainSet.getLength();
        MathType rangeType = ((FunctionType)this.Type).getRange();
        RealTupleType domainType = ((FunctionType)this.Type).getDomain();
        if (rangeType instanceof RealType) {
            if (component != 0) {
                throw new VisADException("extract: component index must be zero");
            }
            return this;
        }
        int n_comps = ((TupleType)rangeType).getDimension();
        if (component + 1 > n_comps) {
            throw new VisADException("extract: component index too large");
        }
        MathType new_range = ((TupleType)rangeType).getComponent(component);
        FunctionType new_type = new FunctionType(domainType, new_range);
        int cnt = 0;
        int t_cnt = 0;
        for (ii = 0; ii < component; ++ii) {
            MathType m_type = ((TupleType)rangeType).getComponent(ii);
            if (m_type instanceof RealType) {
                ++cnt;
                continue;
            }
            cnt += ((RealTupleType)m_type).getDimension();
            ++t_cnt;
        }
        if (new_range instanceof RealType) {
            compSize = 1;
            flat_indices = new int[compSize];
            flat_indices[0] = cnt;
            coord_sys = null;
        } else {
            compSize = ((RealTupleType)new_range).getDimension();
            flat_indices = new int[compSize];
            for (int jj = 0; jj < compSize; ++jj) {
                flat_indices[jj] = cnt++;
            }
            coord_sys = this.RangeCoordinateSystems[t_cnt];
        }
        ErrorEstimate[] errors_out = new ErrorEstimate[compSize];
        Unit[] units_out = new Unit[compSize];
        Set[] rangeSet_out = new Set[compSize];
        boolean needDoubles = false;
        for (ii = 0; ii < compSize; ++ii) {
            units_out[ii] = this.RangeUnits[flat_indices[ii]];
            errors_out[ii] = this.RangeErrors[flat_indices[ii]];
            rangeSet_out[ii] = this.RangeSet[flat_indices[ii]];
            if (!(rangeSet_out[ii] instanceof DoubleSet)) continue;
            needDoubles = true;
        }
        FlatField new_field = new FlatField(new_type, domainSet, coord_sys, null, rangeSet_out, units_out);
        new_field.setRangeErrors(errors_out);
        if (needDoubles) {
            double[][] new_values = new double[compSize][n_samples];
            for (ii = 0; ii < compSize; ++ii) {
                new_values[ii] = this.unpackOneRangeComp(flat_indices[ii], copy);
            }
            new_field.setSamples(new_values, false);
        } else {
            float[][] new_floats = new float[compSize][n_samples];
            for (ii = 0; ii < compSize; ++ii) {
                new_floats[ii] = this.unpackOneFloatRangeComp(flat_indices[ii], copy);
            }
            new_field.setSamples(new_floats, false);
        }
        return new_field;
    }

    @Override
    public Data derivative(RealTuple location, RealType[] d_partial_s, MathType[] derivType_s, int error_mode) throws VisADException, RemoteException {
        int pp;
        boolean transform;
        int jj;
        int ii;
        int n_partials;
        Set domainSet = this.getDomainSet();
        int domainDim = domainSet.getDimension();
        int manifoldDimension = domainSet.getManifoldDimension();
        int n_samples = domainSet.getLength();
        CoordinateSystem d_coordsys = this.getDomainCoordinateSystem();
        RealTupleType d_reference = d_coordsys == null ? null : d_coordsys.getReference();
        MathType m_type = null;
        Object m_types = null;
        Object r_type = null;
        Object r_types = null;
        Object t_type = null;
        boolean thisDomainFlag = true;
        if (manifoldDimension != domainDim) {
            throw new SetException("derivative: manifoldDimension must equal domain dimension");
        }
        error_mode = 202;
        if (location != null) {
            thisDomainFlag = false;
        }
        RealTupleType domainType = ((FunctionType)this.Type).getDomain();
        RealType[] r_comps = domainType.getRealComponents();
        RealType[] r_compsRange = ((FunctionType)this.Type).getFlatRange().getRealComponents();
        RealType[] r_compsRef = d_reference == null ? null : d_reference.getRealComponents();
        MathType RangeType = ((FunctionType)this.Type).getRange();
        if (d_partial_s == null) {
            n_partials = domainDim;
            d_partial_s = r_comps;
        } else {
            n_partials = d_partial_s.length;
            if (n_partials > domainDim) {
                throw new VisADException("derivative: too many d_partial components");
            }
        }
        int[] u_index = new int[n_partials];
        double[][] u_vectors = new double[n_partials][domainDim];
        int found = 0;
        int foundRef = 0;
        for (ii = 0; ii < n_partials; ++ii) {
            for (jj = 0; jj < domainDim; ++jj) {
                u_vectors[ii][jj] = 0.0;
                if (r_comps[jj].equals(d_partial_s[ii])) {
                    u_index[ii] = jj;
                    u_vectors[ii][jj] = 1.0;
                    ++found;
                    continue;
                }
                if (d_reference == null || !r_compsRef[jj].equals(d_partial_s[ii])) continue;
                u_index[ii] = jj;
                u_vectors[ii][jj] = 1.0;
                ++foundRef;
            }
        }
        if (found == 0) {
            if (foundRef == 0) {
                throw new VisADException("derivative: d_partial_s not in domain or reference");
            }
            if (0 < foundRef && foundRef < n_partials) {
                throw new VisADException("derivative: d_partial_s must ALL be in function's domain or ALL in domain's reference");
            }
            transform = true;
        } else {
            if (0 < found && found < n_partials) {
                throw new VisADException("derivative: d_partial_s must ALL be in function's domain or ALL in domain's reference");
            }
            transform = false;
        }
        Unit[] D_units = null;
        Unit[][] R_units = this.getRangeUnits();
        String[][] derivNames = null;
        Unit[][] derivUnits = new Unit[n_partials][this.TupleDimension];
        MathType[] new_range = new MathType[n_partials];
        MathType[] new_types = new MathType[n_partials];
        D_units = !transform ? domainSet.getSetUnits() : d_reference.getDefaultUnits();
        for (ii = 0; ii < n_partials; ++ii) {
            for (jj = 0; jj < this.TupleDimension; ++jj) {
                derivUnits[ii][jj] = R_units == null || D_units == null ? null : (R_units[jj][0] == null || D_units[u_index[ii]] == null ? null : R_units[jj][0].divide(D_units[u_index[ii]]));
            }
        }
        if (derivType_s == null) {
            for (ii = 0; ii < n_partials; ++ii) {
                MathType M_type = this.Type.cloneDerivative(d_partial_s[ii]);
                new_types[ii] = thisDomainFlag ? M_type : ((FunctionType)M_type).getRange();
            }
            derivType_s = new_types;
        } else {
            if (derivType_s.length != n_partials) {
                throw new VisADException("derivative: must be a single MathType for each domain RealType");
            }
            for (ii = 0; ii < n_partials; ++ii) {
                if (!(thisDomainFlag ? !this.Type.equalsExceptName(derivType_s[ii]) : !((FunctionType)this.Type).getRange().equalsExceptName(derivType_s[ii]))) continue;
                throw new TypeException("derivative: incompatible with function range");
            }
        }
        double[][][] p_derivatives = null;
        Data[] datums = new DataImpl[n_partials];
        ErrorEstimate[][] rangeErrors_out = new ErrorEstimate[n_partials][this.TupleDimension];
        if (thisDomainFlag) {
            p_derivatives = new double[n_partials][this.TupleDimension][n_samples];
            for (ii = 0; ii < n_partials; ++ii) {
                datums[ii] = this.cloneDouble(derivType_s[ii], derivUnits[ii], null);
            }
            if (this.isMissing()) {
                if (n_partials == 1) {
                    return datums[0];
                }
                return new Tuple(datums);
            }
        } else {
            p_derivatives = new double[n_partials][this.TupleDimension][1];
            if (this.isMissing()) {
                for (ii = 0; ii < n_partials; ++ii) {
                    for (jj = 0; jj < this.TupleDimension; ++jj) {
                        p_derivatives[ii][jj][0] = Double.NaN;
                        rangeErrors_out[ii][jj] = null;
                    }
                }
            }
        }
        if (!this.isMissing()) {
            int rr;
            int kk;
            double[][] rangeValues = null;
            Object neighbors = null;
            ErrorEstimate[] domainErrors = domainSet.getSetErrors();
            if (domainSet instanceof LinearSet && thisDomainFlag) {
                rangeValues = this.getValues();
                for (kk = 0; kk < n_partials; ++kk) {
                    int m_index = u_index[kk];
                    neighbors = domainSet.getNeighbors(m_index);
                    float step = (float)((LinearSet)((Object)domainSet)).getLinear1DComponent(m_index).getStep();
                    for (ii = 0; ii < n_samples; ++ii) {
                        int index;
                        int n_index;
                        float distance;
                        if (neighbors[ii][0] == -1) {
                            distance = step;
                            n_index = neighbors[ii][1];
                            index = ii;
                        } else if (neighbors[ii][1] == -1) {
                            distance = step;
                            n_index = ii;
                            index = neighbors[ii][0];
                        } else {
                            distance = 2.0f * step;
                            n_index = neighbors[ii][1];
                            index = neighbors[ii][0];
                        }
                        for (rr = 0; rr < this.TupleDimension; ++rr) {
                            p_derivatives[kk][rr][ii] = (rangeValues[rr][n_index] - rangeValues[rr][index]) / (double)distance;
                        }
                    }
                    if (error_mode == 202) continue;
                    for (rr = 0; rr < this.TupleDimension; ++rr) {
                        double[] d_values = p_derivatives[kk][rr];
                        rangeErrors_out[kk][rr] = new ErrorEstimate(d_values, derivUnits[kk][rr], 5, this.RangeErrors[rr], domainErrors[m_index], error_mode);
                    }
                }
                neighbors = null;
                rangeValues = null;
            } else {
                int n_points;
                float[][] Samples;
                Object weights = null;
                if (thisDomainFlag) {
                    rangeValues = this.getValues();
                    neighbors = new int[n_samples][];
                    weights = new float[n_samples][];
                    domainSet.getNeighbors((int[][])neighbors, (float[][])weights);
                    if (transform) {
                        Samples = domainSet.getSamples(true);
                        Samples = CoordinateSystem.transformCoordinates(d_reference, null, null, null, domainType, d_coordsys, null, null, Samples);
                    } else {
                        Samples = domainSet.getSamples(false);
                    }
                } else {
                    n_samples = 1;
                    float[][] org_Samples = domainSet.getSamples(false);
                    FlatField new_field = (FlatField)this.resample(new SingletonSet(location, null, null, null), 101, error_mode);
                    float[][] evalSamples = new_field.getDomainSet().getSamples(false);
                    neighbors = new int[n_samples][];
                    weights = new float[n_samples][];
                    ((SimpleSet)domainSet).valueToInterp(evalSamples, (int[][])neighbors, (float[][])weights);
                    n_points = neighbors[0].length;
                    int[][] new_neighbors = new int[n_samples][n_points];
                    double[][] new_rangeValues = new double[this.TupleDimension][n_points + 1];
                    float[][] new_Samples = new float[domainDim][n_points + 1];
                    for (ii = 0; ii < domainDim; ++ii) {
                        new_Samples[ii][0] = evalSamples[ii][0];
                    }
                    double[] d_array = new_field.unpackValues(0);
                    for (ii = 0; ii < this.TupleDimension; ++ii) {
                        new_rangeValues[ii][0] = d_array[ii];
                    }
                    for (kk = 0; kk < n_points; ++kk) {
                        d_array = this.unpackValues(neighbors[0][kk]);
                        new_neighbors[0][kk] = kk + 1;
                        for (ii = 0; ii < this.TupleDimension; ++ii) {
                            new_rangeValues[ii][kk + 1] = d_array[ii];
                        }
                        for (ii = 0; ii < domainDim; ++ii) {
                            new_Samples[ii][kk + 1] = org_Samples[ii][neighbors[0][kk]];
                        }
                    }
                    neighbors = new_neighbors;
                    rangeValues = new_rangeValues;
                    Samples = new_Samples;
                    if (transform) {
                        Samples = CoordinateSystem.transformCoordinates(d_reference, null, null, null, domainType, d_coordsys, null, null, Samples);
                    }
                }
                for (ii = 0; ii < n_samples; ++ii) {
                    int dd;
                    n_points = neighbors[ii].length;
                    double[] distances = new double[n_points];
                    double[][] derivatives = new double[n_points][this.TupleDimension];
                    double[][] uvecPoint = new double[n_points][domainDim];
                    for (kk = 0; kk < n_points; ++kk) {
                        float f_sum = 0.0f;
                        for (dd = 0; dd < domainDim; ++dd) {
                            f_sum += (Samples[dd][neighbors[ii][kk]] - Samples[dd][ii]) * (Samples[dd][neighbors[ii][kk]] - Samples[dd][ii]);
                            uvecPoint[kk][dd] = Samples[dd][neighbors[ii][kk]] - Samples[dd][ii];
                        }
                        distances[kk] = Math.sqrt(f_sum);
                        for (rr = 0; rr < this.TupleDimension; ++rr) {
                            derivatives[kk][rr] = rangeValues[rr][neighbors[ii][kk]] - rangeValues[rr][ii];
                        }
                    }
                    for (pp = 0; pp < n_partials; ++pp) {
                        float sum_weights = 0.0f;
                        for (kk = 0; kk < n_points; ++kk) {
                            float dotproduct = 0.0f;
                            for (dd = 0; dd < domainDim; ++dd) {
                                dotproduct = (float)((double)dotproduct + uvecPoint[kk][dd] * u_vectors[pp][dd]);
                            }
                            float inv_dotproduct = 1.0f / dotproduct;
                            if (Float.isInfinite(inv_dotproduct)) continue;
                            sum_weights += weights[ii][kk];
                            for (rr = 0; rr < this.TupleDimension; ++rr) {
                                double[] dArray = p_derivatives[pp][rr];
                                int n = ii;
                                dArray[n] = dArray[n] + derivatives[kk][rr] * (double)inv_dotproduct * (double)weights[ii][kk];
                            }
                        }
                        for (rr = 0; rr < this.TupleDimension; ++rr) {
                            double[] dArray = p_derivatives[pp][rr];
                            int n = ii;
                            dArray[n] = dArray[n] / (double)sum_weights;
                        }
                    }
                }
            }
        }
        double[][] s_samples = null;
        for (pp = 0; pp < n_partials; ++pp) {
            s_samples = p_derivatives[pp];
            if (thisDomainFlag) {
                ((FlatField)datums[pp]).setSamples(s_samples);
                ((FlatField)datums[pp]).setRangeErrors(rangeErrors_out[pp]);
                continue;
            }
            MathType M_type = derivType_s[pp];
            if (M_type instanceof RealType) {
                datums[pp] = new Real((RealType)M_type, s_samples[0][0], derivUnits[pp][0], rangeErrors_out[pp][0]);
                continue;
            }
            if (M_type instanceof RealTupleType) {
                Real[] reals = new Real[this.TupleDimension];
                for (ii = 0; ii < this.TupleDimension; ++ii) {
                    reals[ii] = new Real((RealType)((TupleType)M_type).getComponent(ii), s_samples[ii][0], derivUnits[pp][ii], rangeErrors_out[pp][0]);
                }
                datums[pp] = new RealTuple((RealTupleType)M_type, reals, this.RangeCoordinateSystem);
                continue;
            }
            if (!(M_type instanceof TupleType)) continue;
            int ss = 0;
            int tt = 0;
            int n_comps = ((TupleType)M_type).getDimension();
            Data[] s_datums = new Data[n_comps];
            for (ii = 0; ii < n_comps; ++ii) {
                m_type = ((TupleType)M_type).getComponent(ii);
                if (m_type instanceof RealType) {
                    s_datums[ii] = new Real((RealType)m_type, s_samples[tt][0], derivUnits[pp][ii], rangeErrors_out[pp][ii]);
                    ++tt;
                    continue;
                }
                if (!(m_type instanceof RealTupleType)) continue;
                int n_compsI = ((TupleType)m_type).getDimension();
                Real[] reals = new Real[n_compsI];
                for (jj = 0; jj < n_compsI; ++jj) {
                    reals[jj] = new Real((RealType)((TupleType)m_type).getComponent(jj), s_samples[tt][0], derivUnits[pp][jj], rangeErrors_out[pp][jj]);
                    ++tt;
                }
                s_datums[ii] = new RealTuple((RealTupleType)m_type, reals, this.RangeCoordinateSystems[ss]);
                ++ss;
            }
            datums[pp] = new Tuple((TupleType)M_type, s_datums);
        }
        if (n_partials == 1) {
            return datums[0];
        }
        return new Tuple(datums);
    }

    @Override
    public Data derivative(int error_mode) throws VisADException, RemoteException {
        MathType[] derivType_s = null;
        RealType[] d_partial_s = null;
        return this.derivative(null, d_partial_s, derivType_s, error_mode);
    }

    @Override
    public Data derivative(MathType[] derivType_s, int error_mode) throws VisADException, RemoteException {
        return this.derivative(null, null, derivType_s, error_mode);
    }

    @Override
    public Function derivative(RealType d_partial, int error_mode) throws VisADException, RemoteException {
        MathType[] derivType_s = null;
        RealType[] d_partial_s = new RealType[]{d_partial};
        return (Function)this.derivative(null, d_partial_s, derivType_s, error_mode);
    }

    @Override
    public Function derivative(RealType d_partial, MathType derivType, int error_mode) throws VisADException, RemoteException {
        MathType[] derivType_s = new MathType[1];
        RealType[] d_partial_s = new RealType[1];
        derivType_s[0] = derivType;
        d_partial_s[0] = d_partial;
        return (Function)this.derivative(null, d_partial_s, derivType_s, error_mode);
    }

    @Override
    public Field resample(Set set, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        float[] new_valuesJ;
        float[] valuesJ;
        int j;
        Object indices;
        int i;
        boolean sampling_errors;
        ErrorEstimate[] range_errors_in;
        Set domainSet = this.getDomainSet();
        Trace.call1("FlatField.resample");
        if (domainSet.equals(set)) {
            Trace.call2("FlatField.resample", "sampling set==domain set");
            return this;
        }
        int dim = domainSet.getDimension();
        if (dim != set.getDimension()) {
            throw new SetException("FlatField.resample: bad Set Dimension");
        }
        if (domainSet instanceof GriddedDoubleSet) {
            return this.resampleDouble(set, sampling_mode, error_mode);
        }
        CoordinateSystem coord_sys = set.getCoordinateSystem();
        Unit[] units = set.getSetUnits();
        ErrorEstimate[] errors = error_mode == 202 ? new ErrorEstimate[dim] : set.getSetErrors();
        Set[] sets = new Set[this.TupleDimension];
        for (int i2 = 0; i2 < this.TupleDimension; ++i2) {
            SetType set_type = new SetType(((FunctionType)this.Type).getFlatRange().getComponent(i2));
            sets[i2] = sampling_mode == 100 ? this.RangeSet[i2] : new FloatSet(set_type);
        }
        MathType range_type = ((FunctionType)this.Type).getRange();
        RealTupleType domain_type = ((SetType)set.getType()).getDomain();
        FunctionType func_type = new FunctionType(domain_type, range_type);
        FlatField new_field = new FlatField(func_type, set, this.RangeCoordinateSystem, this.RangeCoordinateSystems, sets, this.RangeUnits);
        if (this.isMissing()) {
            return new_field;
        }
        ErrorEstimate[] range_errors_out = range_errors_in = error_mode == 202 ? new ErrorEstimate[this.TupleDimension] : this.RangeErrors;
        int length = set.getLength();
        int[] wedge = set.getWedge();
        float[][] vals = set.indexToValue(wedge);
        ErrorEstimate[] errors_out = new ErrorEstimate[dim];
        float[][] oldvals = vals;
        Trace.call1("FlatField.resample:transformCoords");
        try {
            vals = CoordinateSystem.transformCoordinates(((FunctionType)this.Type).getDomain(), this.getDomainCoordinateSystem(), this.getDomainUnits(), errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, errors, vals, false);
        }
        catch (UnitException ue) {
            throw new VisADException("Sampling set is not compatible with domain");
        }
        Trace.call2("FlatField.resample:transformCoords");
        boolean coord_transform = vals != oldvals;
        boolean bl = sampling_errors = error_mode != 202;
        if (sampling_errors) {
            for (i = 0; i < dim; ++i) {
                if (errors_out[i] != null) continue;
                sampling_errors = false;
            }
            boolean any_range_error = false;
            for (i = 0; i < this.TupleDimension; ++i) {
                if (range_errors_in[i] == null) continue;
                any_range_error = true;
            }
            if (!any_range_error) {
                sampling_errors = false;
            }
        }
        float[][] sampling_partials = new float[this.TupleDimension][dim];
        float[][] error_values = new float[1][1];
        if (sampling_errors) {
            error_values = Set.doubleToFloat(ErrorEstimate.init_error_values(errors_out));
        }
        float[][] values = null;
        if (sampling_errors || 10 * length > this.getLength() || !this.shouldBeDouble() || sampling_mode == 101) {
            values = this.unpackFloats(false);
        }
        float[][] new_values = new float[this.TupleDimension][length];
        if (sampling_mode == 101 && domainSet instanceof SimpleSet) {
            int k;
            indices = new int[length][];
            float[][] coefs = new float[length][];
            ((SimpleSet)domainSet).valueToInterp(vals, (int[][])indices, coefs);
            if (values != null) {
                for (j = 0; j < this.TupleDimension; ++j) {
                    valuesJ = values[j];
                    new_valuesJ = new_values[j];
                    for (i = 0; i < length; ++i) {
                        int len;
                        float v = Float.NaN;
                        int n = len = indices[i] == null ? 0 : ((int)indices[i]).length;
                        if (len > 0) {
                            v = valuesJ[indices[i][0]] * coefs[i][0];
                            for (k = 1; k < len; ++k) {
                                v += valuesJ[indices[i][k]] * coefs[i][k];
                            }
                            new_valuesJ[wedge[i]] = v;
                            continue;
                        }
                        new_valuesJ[wedge[i]] = Float.NaN;
                    }
                }
            } else {
                for (i = 0; i < length; ++i) {
                    int len;
                    int n = len = indices[i] == null ? 0 : ((int)indices[i]).length;
                    if (len > 0) {
                        float[][] xvals = new float[len][];
                        for (k = 0; k < len; ++k) {
                            xvals[k] = this.unpackFloats((int)indices[i][k]);
                        }
                        for (j = 0; j < this.TupleDimension; ++j) {
                            float v = xvals[0][j] * coefs[i][0];
                            for (k = 1; k < len; ++k) {
                                v += xvals[k][j] * coefs[i][k];
                            }
                            new_values[j][wedge[i]] = v;
                        }
                        continue;
                    }
                    for (j = 0; j < this.TupleDimension; ++j) {
                        new_values[j][wedge[i]] = Float.NaN;
                    }
                }
            }
            if (sampling_errors) {
                int[][] error_indices = new int[2 * dim][];
                float[][] error_coefs = new float[2 * dim][];
                ((SimpleSet)domainSet).valueToInterp(error_values, error_indices, error_coefs);
                for (j = 0; j < this.TupleDimension; ++j) {
                    for (i = 0; i < dim; ++i) {
                        float a = Float.NaN;
                        float b = Float.NaN;
                        int len = error_indices[2 * i].length;
                        if (len > 0) {
                            a = values[j][error_indices[2 * i][0]] * error_coefs[2 * i][0];
                            for (k = 1; k < len; ++k) {
                                a += values[j][error_indices[2 * i][k]] * error_coefs[2 * i][k];
                            }
                        }
                        if ((len = error_indices[2 * i + 1].length) > 0) {
                            b = values[j][error_indices[2 * i + 1][0]] * error_coefs[2 * i + 1][0];
                            for (k = 1; k < len; ++k) {
                                b += values[j][error_indices[2 * i + 1][k]] * error_coefs[2 * i + 1][k];
                            }
                        }
                        sampling_partials[j][i] = Math.abs(b - a);
                    }
                }
            }
        } else {
            indices = domainSet.valueToIndex(vals);
            if (values != null) {
                for (j = 0; j < this.TupleDimension; ++j) {
                    valuesJ = values[j];
                    new_valuesJ = new_values[j];
                    for (i = 0; i < length; ++i) {
                        new_valuesJ[wedge[i]] = indices[i] >= 0 ? valuesJ[indices[i]] : Float.NaN;
                    }
                }
            } else {
                for (i = 0; i < length; ++i) {
                    if (indices[i] >= 0) {
                        float[] xvals = this.unpackFloats(indices[i]);
                        for (j = 0; j < this.TupleDimension; ++j) {
                            new_values[j][wedge[i]] = xvals[j];
                        }
                        continue;
                    }
                    for (j = 0; j < this.TupleDimension; ++j) {
                        new_values[j][wedge[i]] = Float.NaN;
                    }
                }
            }
            if (sampling_errors) {
                int[] error_indices = domainSet.valueToIndex(error_values);
                for (j = 0; j < this.TupleDimension; ++j) {
                    for (i = 0; i < dim; ++i) {
                        float a = (float)(error_indices[2 * i] >= 0 ? (double)values[j][error_indices[2 * i]] : Double.NaN);
                        float b = (float)(error_indices[2 * i + 1] >= 0 ? (double)values[j][error_indices[2 * i + 1]] : Double.NaN);
                        sampling_partials[j][i] = Math.abs(b - a);
                    }
                }
            }
        }
        if (sampling_errors) {
            for (j = 0; j < this.TupleDimension; ++j) {
                if (range_errors_in[j] == null) continue;
                float error = (float)range_errors_in[j].getErrorValue();
                if (error_mode == 200) {
                    error *= error;
                    for (i = 0; i < dim; ++i) {
                        error += sampling_partials[j][i] * sampling_partials[j][i];
                    }
                    error = (float)Math.sqrt(error);
                } else {
                    for (i = 0; i < dim; ++i) {
                        error += sampling_partials[j][i];
                    }
                }
                range_errors_out[j] = new ErrorEstimate(new_values[j], (double)error, this.RangeUnits[j]);
            }
        } else if (error_mode != 202) {
            for (j = 0; j < this.TupleDimension; ++j) {
                if (range_errors_in[j] == null) continue;
                range_errors_out[j] = new ErrorEstimate(new_values[j], range_errors_in[j].getErrorValue(), this.RangeUnits[j]);
            }
        }
        if (coord_transform) {
            range_errors_in = range_errors_out;
            MathType Range = ((FunctionType)this.Type).getRange();
            if (Range instanceof RealVectorType) {
                new_values = ((RealVectorType)Range).transformVectors(((FunctionType)this.Type).getDomain(), this.getDomainCoordinateSystem(), this.getDomainUnits(), errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, this.RangeCoordinateSystem, range_errors_in, range_errors_out, oldvals, vals, new_values);
            } else if (Range instanceof TupleType && !(Range instanceof RealTupleType)) {
                int offset = 0;
                int m = ((TupleType)Range).getDimension();
                for (j = 0; j < m; ++j) {
                    MathType comp_type = ((TupleType)Range).getComponent(j);
                    if (comp_type instanceof RealVectorType) {
                        int jj;
                        int mm = ((RealVectorType)comp_type).getDimension();
                        Object comp_vals = new float[mm][];
                        for (int jj2 = 0; jj2 < mm; ++jj2) {
                            comp_vals[jj2] = new_values[offset + jj2];
                        }
                        ErrorEstimate[] comp_errors_in = new ErrorEstimate[mm];
                        for (int jj3 = 0; jj3 < mm; ++jj3) {
                            comp_errors_in[jj3] = range_errors_in[offset + jj3];
                        }
                        ErrorEstimate[] comp_errors_out = comp_errors_in;
                        comp_vals = ((RealVectorType)comp_type).transformVectors(((FunctionType)this.Type).getDomain(), this.getDomainCoordinateSystem(), this.getDomainUnits(), errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, this.RangeCoordinateSystems[j], comp_errors_in, comp_errors_out, oldvals, vals, (float[][])comp_vals);
                        for (jj = 0; jj < mm; ++jj) {
                            new_values[offset + jj] = comp_vals[jj];
                        }
                        for (jj = 0; jj < mm; ++jj) {
                            range_errors_out[offset + jj] = comp_errors_out[jj];
                        }
                    }
                    if (comp_type instanceof RealType) {
                        ++offset;
                        continue;
                    }
                    offset += ((RealTupleType)comp_type).getDimension();
                }
            }
        }
        new_field.packValues(new_values, false);
        new_field.setRangeErrors(range_errors_out);
        new_field.clearMissing();
        Trace.call2("FlatField.resample");
        return new_field;
    }

    @Override
    public Field resampleDouble(Set set, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        double[] new_valuesJ;
        float[] valuesJ;
        int j;
        Object indices;
        int i;
        boolean sampling_errors;
        ErrorEstimate[] range_errors_in;
        Set domainSet = this.getDomainSet();
        Trace.call1("FlatField.resample");
        if (domainSet.equals(set)) {
            Trace.call2("FlatField.resample", "sampling set==domain set");
            return this;
        }
        int dim = domainSet.getDimension();
        if (dim != set.getDimension()) {
            throw new SetException("FlatField.resample: bad Set Dimension");
        }
        if (!(domainSet instanceof GriddedDoubleSet)) {
            return this.resample(set, sampling_mode, error_mode);
        }
        CoordinateSystem coord_sys = set.getCoordinateSystem();
        Unit[] units = set.getSetUnits();
        ErrorEstimate[] errors = error_mode == 202 ? new ErrorEstimate[dim] : set.getSetErrors();
        Set[] sets = new Set[this.TupleDimension];
        for (int i2 = 0; i2 < this.TupleDimension; ++i2) {
            SetType set_type = new SetType(((FunctionType)this.Type).getFlatRange().getComponent(i2));
            sets[i2] = sampling_mode == 100 ? this.RangeSet[i2] : new FloatSet(set_type);
        }
        MathType range_type = ((FunctionType)this.Type).getRange();
        RealTupleType domain_type = ((SetType)set.getType()).getDomain();
        FunctionType func_type = new FunctionType(domain_type, range_type);
        FlatField new_field = new FlatField(func_type, set, this.RangeCoordinateSystem, this.RangeCoordinateSystems, sets, this.RangeUnits);
        if (this.isMissing()) {
            return new_field;
        }
        ErrorEstimate[] range_errors_out = range_errors_in = error_mode == 202 ? new ErrorEstimate[this.TupleDimension] : this.RangeErrors;
        int length = set.getLength();
        int[] wedge = set.getWedge();
        double[][] vals = set.indexToDouble(wedge);
        ErrorEstimate[] errors_out = new ErrorEstimate[dim];
        double[][] oldvals = vals;
        Trace.call1("FlatField.resample:transformCoords");
        try {
            vals = CoordinateSystem.transformCoordinates(((FunctionType)this.Type).getDomain(), this.getDomainCoordinateSystem(), this.getDomainUnits(), errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, errors, vals, false);
        }
        catch (UnitException ue) {
            throw new VisADException("Sampling set is not compatible with domain");
        }
        Trace.call2("FlatField.resample:transformCoords");
        boolean coord_transform = vals != oldvals;
        boolean bl = sampling_errors = error_mode != 202;
        if (sampling_errors) {
            for (i = 0; i < dim; ++i) {
                if (errors_out[i] != null) continue;
                sampling_errors = false;
            }
            boolean any_range_error = false;
            for (i = 0; i < this.TupleDimension; ++i) {
                if (range_errors_in[i] == null) continue;
                any_range_error = true;
            }
            if (!any_range_error) {
                sampling_errors = false;
            }
        }
        double[][] sampling_partials = new double[this.TupleDimension][dim];
        double[][] error_values = new double[1][1];
        if (sampling_errors) {
            error_values = ErrorEstimate.init_error_values(errors_out);
        }
        float[][] values = null;
        if (sampling_errors || 10 * length > this.getLength() || !this.shouldBeDouble() || sampling_mode == 101) {
            values = this.unpackFloats(false);
        }
        double[][] new_values = new double[this.TupleDimension][length];
        if (sampling_mode == 101) {
            int k;
            indices = new int[length][];
            double[][] coefs = new double[length][];
            ((GriddedDoubleSet)((Object)domainSet)).doubleToInterp(vals, (int[][])indices, coefs);
            if (values != null) {
                for (j = 0; j < this.TupleDimension; ++j) {
                    valuesJ = values[j];
                    new_valuesJ = new_values[j];
                    for (i = 0; i < length; ++i) {
                        int len;
                        double v = Double.NaN;
                        int n = len = indices[i] == null ? 0 : indices[i].length;
                        if (len > 0) {
                            v = (double)valuesJ[indices[i][0]] * coefs[i][0];
                            for (k = 1; k < len; ++k) {
                                v += (double)valuesJ[indices[i][k]] * coefs[i][k];
                            }
                            new_valuesJ[wedge[i]] = v;
                            continue;
                        }
                        new_valuesJ[wedge[i]] = Double.NaN;
                    }
                }
            } else {
                for (i = 0; i < length; ++i) {
                    int len;
                    int n = len = indices[i] == null ? 0 : indices[i].length;
                    if (len > 0) {
                        float[][] xvals = new float[len][];
                        for (k = 0; k < len; ++k) {
                            xvals[k] = this.unpackFloats(indices[i][k]);
                        }
                        for (j = 0; j < this.TupleDimension; ++j) {
                            double v = (double)xvals[0][j] * coefs[i][0];
                            for (k = 1; k < len; ++k) {
                                v += (double)xvals[k][j] * coefs[i][k];
                            }
                            new_values[j][wedge[i]] = v;
                        }
                        continue;
                    }
                    for (j = 0; j < this.TupleDimension; ++j) {
                        new_values[j][wedge[i]] = Double.NaN;
                    }
                }
            }
            if (sampling_errors) {
                int[][] error_indices = new int[2 * dim][];
                double[][] error_coefs = new double[2 * dim][];
                ((GriddedDoubleSet)((Object)domainSet)).doubleToInterp(error_values, error_indices, error_coefs);
                for (j = 0; j < this.TupleDimension; ++j) {
                    for (i = 0; i < dim; ++i) {
                        double a = Double.NaN;
                        double b = Double.NaN;
                        int len = error_indices[2 * i].length;
                        if (len > 0) {
                            a = (double)values[j][error_indices[2 * i][0]] * error_coefs[2 * i][0];
                            for (k = 1; k < len; ++k) {
                                a += (double)values[j][error_indices[2 * i][k]] * error_coefs[2 * i][k];
                            }
                        }
                        if ((len = error_indices[2 * i + 1].length) > 0) {
                            b = (double)values[j][error_indices[2 * i + 1][0]] * error_coefs[2 * i + 1][0];
                            for (k = 1; k < len; ++k) {
                                b += (double)values[j][error_indices[2 * i + 1][k]] * error_coefs[2 * i + 1][k];
                            }
                        }
                        sampling_partials[j][i] = Math.abs(b - a);
                    }
                }
            }
        } else {
            indices = domainSet.doubleToIndex(vals);
            if (values != null) {
                for (j = 0; j < this.TupleDimension; ++j) {
                    valuesJ = values[j];
                    new_valuesJ = new_values[j];
                    for (i = 0; i < length; ++i) {
                        new_valuesJ[wedge[i]] = indices[i] >= 0 ? valuesJ[indices[i]] : Float.NaN;
                    }
                }
            } else {
                for (i = 0; i < length; ++i) {
                    if (indices[i] >= 0) {
                        float[] xvals = this.unpackFloats((int)indices[i]);
                        for (j = 0; j < this.TupleDimension; ++j) {
                            new_values[j][wedge[i]] = xvals[j];
                        }
                        continue;
                    }
                    for (j = 0; j < this.TupleDimension; ++j) {
                        new_values[j][wedge[i]] = Double.NaN;
                    }
                }
            }
            if (sampling_errors) {
                int[] error_indices = domainSet.doubleToIndex(error_values);
                for (j = 0; j < this.TupleDimension; ++j) {
                    for (i = 0; i < dim; ++i) {
                        float a = (float)(error_indices[2 * i] >= 0 ? (double)values[j][error_indices[2 * i]] : Double.NaN);
                        float b = (float)(error_indices[2 * i + 1] >= 0 ? (double)values[j][error_indices[2 * i + 1]] : Double.NaN);
                        sampling_partials[j][i] = Math.abs(b - a);
                    }
                }
            }
        }
        if (sampling_errors) {
            for (j = 0; j < this.TupleDimension; ++j) {
                if (range_errors_in[j] == null) continue;
                float error = (float)range_errors_in[j].getErrorValue();
                if (error_mode == 200) {
                    error *= error;
                    for (i = 0; i < dim; ++i) {
                        error = (float)((double)error + sampling_partials[j][i] * sampling_partials[j][i]);
                    }
                    error = (float)Math.sqrt(error);
                } else {
                    for (i = 0; i < dim; ++i) {
                        error = (float)((double)error + sampling_partials[j][i]);
                    }
                }
                range_errors_out[j] = new ErrorEstimate(new_values[j], (double)error, this.RangeUnits[j]);
            }
        } else if (error_mode != 202) {
            for (j = 0; j < this.TupleDimension; ++j) {
                if (range_errors_in[j] == null) continue;
                range_errors_out[j] = new ErrorEstimate(new_values[j], range_errors_in[j].getErrorValue(), this.RangeUnits[j]);
            }
        }
        if (coord_transform) {
            range_errors_in = range_errors_out;
            MathType Range = ((FunctionType)this.Type).getRange();
            if (Range instanceof RealVectorType) {
                new_values = ((RealVectorType)Range).transformVectors(((FunctionType)this.Type).getDomain(), this.getDomainCoordinateSystem(), this.getDomainUnits(), errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, this.RangeCoordinateSystem, range_errors_in, range_errors_out, oldvals, vals, new_values);
            } else if (Range instanceof TupleType && !(Range instanceof RealTupleType)) {
                int offset = 0;
                int m = ((TupleType)Range).getDimension();
                for (j = 0; j < m; ++j) {
                    MathType comp_type = ((TupleType)Range).getComponent(j);
                    if (comp_type instanceof RealVectorType) {
                        int jj;
                        int mm = ((RealVectorType)comp_type).getDimension();
                        Object comp_vals = new double[mm][];
                        for (int jj2 = 0; jj2 < mm; ++jj2) {
                            comp_vals[jj2] = new_values[offset + jj2];
                        }
                        ErrorEstimate[] comp_errors_in = new ErrorEstimate[mm];
                        for (int jj3 = 0; jj3 < mm; ++jj3) {
                            comp_errors_in[jj3] = range_errors_in[offset + jj3];
                        }
                        ErrorEstimate[] comp_errors_out = comp_errors_in;
                        comp_vals = ((RealVectorType)comp_type).transformVectors(((FunctionType)this.Type).getDomain(), this.getDomainCoordinateSystem(), this.getDomainUnits(), errors_out, ((SetType)set.getType()).getDomain(), coord_sys, units, this.RangeCoordinateSystems[j], comp_errors_in, comp_errors_out, oldvals, vals, (double[][])comp_vals);
                        for (jj = 0; jj < mm; ++jj) {
                            new_values[offset + jj] = comp_vals[jj];
                        }
                        for (jj = 0; jj < mm; ++jj) {
                            range_errors_out[offset + jj] = comp_errors_out[jj];
                        }
                    }
                    if (comp_type instanceof RealType) {
                        ++offset;
                        continue;
                    }
                    offset += ((RealTupleType)comp_type).getDimension();
                }
            }
        }
        new_field.packValues(new_values, false);
        new_field.setRangeErrors(range_errors_out);
        new_field.clearMissing();
        Trace.call2("FlatField.resample");
        return new_field;
    }

    @Override
    public Field convertToField() throws VisADException, RemoteException {
        FieldImpl new_field = new FieldImpl((FunctionType)this.Type, this.getDomainSet());
        if (this.isMissing()) {
            return new_field;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            new_field.setSample(i, this.getSample(i));
        }
        return new_field;
    }

    @Override
    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException {
        boolean anyRangeRef;
        if (this.isMissing()) {
            return shadow;
        }
        ShadowRealTupleType domain_type = ((ShadowFunctionType)type).getDomain();
        int n = domain_type.getDimension();
        double[][] ranges = new double[2][n];
        shadow = this.getDomainSet().computeRanges(domain_type, shadow, ranges, true);
        int[] indices = ((ShadowFunctionType)type).getRangeDisplayIndices();
        boolean any_mapped = false;
        for (int i = 0; i < this.TupleDimension; ++i) {
            if (indices[i] < 0) continue;
            any_mapped = true;
        }
        if (!any_mapped) {
            return shadow;
        }
        boolean bl = anyRangeRef = this.RangeCoordinateSystem != null;
        if (this.RangeCoordinateSystems != null) {
            for (int i = 0; i < this.RangeCoordinateSystems.length; ++i) {
                anyRangeRef |= this.RangeCoordinateSystems[i] != null;
            }
        }
        ranges = anyRangeRef ? new double[2][this.TupleDimension] : (double[][])null;
        double[][] valuesD = null;
        float[][] valuesF = null;
        if (this.shouldBeDouble()) {
            valuesD = this.unpackValues(false);
        } else {
            valuesF = this.unpackFloats(false);
        }
        for (int i = 0; i < this.TupleDimension; ++i) {
            Unit dunit;
            int j;
            int k;
            double[] valuesDI = null;
            float[] valuesFI = null;
            if (valuesD != null) {
                valuesDI = valuesD[i];
            }
            if (valuesF != null) {
                valuesFI = valuesF[i];
            }
            if ((k = indices[i]) < 0 && !anyRangeRef) continue;
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            if (valuesDI != null) {
                for (j = 0; j < this.getLength(); ++j) {
                    if (valuesDI[j] != valuesDI[j]) continue;
                    min = Math.min(min, valuesDI[j]);
                    max = Math.max(max, valuesDI[j]);
                }
            }
            if (valuesFI != null) {
                for (j = 0; j < this.getLength(); ++j) {
                    if (valuesFI[j] != valuesFI[j]) continue;
                    min = Math.min(min, (double)valuesFI[j]);
                    max = Math.max(max, (double)valuesFI[j]);
                }
            }
            if ((dunit = ((RealType)((FunctionType)this.Type).getFlatRange().getComponent(i)).getDefaultUnit()) != null && !dunit.equals(this.RangeUnits[i])) {
                min = dunit.toThis(min, this.RangeUnits[i]);
                max = dunit.toThis(max, this.RangeUnits[i]);
            }
            if (anyRangeRef) {
                ranges[0][i] = Math.min(ranges[0][i], min);
                ranges[1][i] = Math.max(ranges[1][i], max);
            }
            if (k < 0 || k >= shadow.ranges[0].length) continue;
            shadow.ranges[0][k] = Math.min(shadow.ranges[0][k], min);
            shadow.ranges[1][k] = Math.max(shadow.ranges[1][k], max);
        }
        if (this.RangeCoordinateSystem != null) {
            ShadowRealTupleType range_type = (ShadowRealTupleType)((ShadowFunctionType)type).getRange();
            ShadowRealTupleType shad_ref = range_type.getReference();
            shadow = this.computeReferenceRanges(range_type, this.RangeCoordinateSystem, this.RangeUnits, shadow, shad_ref, ranges);
        } else if (this.RangeCoordinateSystems != null) {
            TupleType RangeType = (TupleType)((FunctionType)this.Type).getRange();
            int j = 0;
            for (int i = 0; i < this.RangeCoordinateSystems.length; ++i) {
                MathType component = RangeType.getComponent(i);
                if (component instanceof RealType) {
                    ++j;
                    continue;
                }
                int m = ((RealTupleType)component).getDimension();
                if (this.RangeCoordinateSystems[i] != null) {
                    double[][] sub_ranges = new double[2][m];
                    Unit[] sub_units = new Unit[m];
                    for (int k = 0; k < m; ++k) {
                        sub_ranges[0][k] = ranges[0][j];
                        sub_ranges[1][k] = ranges[1][j];
                        sub_units[k] = this.RangeUnits[j];
                        ++j;
                    }
                    ShadowRealTupleType range_type = (ShadowRealTupleType)((ShadowTupleType)((ShadowFunctionType)type).getRange()).getComponent(i);
                    ShadowRealTupleType shad_ref = range_type.getReference();
                    shadow = this.computeReferenceRanges(range_type, this.RangeCoordinateSystems[i], sub_units, shadow, shad_ref, sub_ranges);
                    continue;
                }
                j += m;
            }
        }
        return shadow;
    }

    @Override
    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        if (this.isMissing() || error == null || error.isMissing()) {
            return this;
        }
        FlatField field = new FlatField((FunctionType)this.Type, this.getDomainSet(), this.RangeCoordinateSystem, this.RangeCoordinateSystems, this.RangeSet, this.RangeUnits);
        if (this.isMissing()) {
            return field;
        }
        FlatField new_error = (FlatField)((FlatField)error).resample(this.getDomainSet(), 100, 202);
        double[][] values = this.unpackValues();
        field.packValues(values, false);
        ErrorEstimate[] errors = new ErrorEstimate[this.TupleDimension];
        double[][] error_values = new_error.unpackValues();
        for (int i = 0; i < this.TupleDimension; ++i) {
            double a = 0.0;
            for (int k = 0; k < error_values[i].length; ++k) {
                a += error_values[i][k];
            }
            double b = this.RangeErrors[i].getErrorValue();
            double e = error_mode == 200 ? Math.sqrt(a * a + b * b) : Math.abs(a /= (double)error_values.length) + Math.abs(b);
            errors[i] = new ErrorEstimate(values[i], e, this.RangeUnits[i]);
        }
        field.setRangeErrors(errors);
        return field;
    }

    @Override
    public boolean isFlatField() {
        return true;
    }

    private FlatField cloneDouble() throws VisADException {
        return this.cloneDouble(this.RangeUnits, this.RangeErrors);
    }

    private FlatField cloneDouble(Unit[] units, ErrorEstimate[] errors) throws VisADException {
        return this.cloneDouble(null, units, errors);
    }

    protected FlatField cloneDouble(MathType f_type, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        return this.cloneDouble(f_type, units, errors, null);
    }

    protected FlatField cloneDouble(MathType f_type, Unit[] units, ErrorEstimate[] errors, double[][] newValues) throws VisADException {
        MathType N_type = f_type == null ? this.Type : f_type;
        Set[] sets = new Set[this.TupleDimension];
        for (int i = 0; i < this.TupleDimension; ++i) {
            SetType set_type = new SetType(((FunctionType)N_type).getFlatRange().getComponent(i));
            sets[i] = new DoubleSet(set_type);
        }
        RealTupleType d_type = ((FunctionType)N_type).getDomain();
        Set new_set = null;
        new_set = !d_type.equals(((FunctionType)this.getType()).getDomain()) ? (Set)this.getDomainSet().cloneButType(d_type) : this.getDomainSet();
        FlatField field = new FlatField((FunctionType)N_type, new_set, this.RangeCoordinateSystem, this.RangeCoordinateSystems, sets, units);
        if (newValues == null) {
            newValues = this.unpackValues();
        }
        field.packValues(newValues, false);
        field.setRangeErrors(errors);
        field.clearMissing();
        return field;
    }

    protected FlatField cloneFloat(MathType f_type, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        return this.cloneFloat(f_type, units, errors, null);
    }

    protected FlatField cloneFloat(MathType f_type, Unit[] units, ErrorEstimate[] errors, float[][] newValues) throws VisADException {
        MathType N_type = f_type == null ? this.Type : f_type;
        Set[] sets = new Set[this.TupleDimension];
        for (int i = 0; i < this.TupleDimension; ++i) {
            SetType set_type = new SetType(((FunctionType)N_type).getFlatRange().getComponent(i));
            sets[i] = new FloatSet(set_type);
        }
        RealTupleType d_type = ((FunctionType)N_type).getDomain();
        Set new_set = null;
        new_set = !d_type.equals(((FunctionType)this.getType()).getDomain()) ? (Set)this.getDomainSet().cloneButType(d_type) : this.getDomainSet();
        FlatField field = new FlatField((FunctionType)N_type, new_set, this.RangeCoordinateSystem, this.RangeCoordinateSystems, sets, units);
        if (newValues == null) {
            newValues = this.unpackFloats(true);
        }
        field.packValues(newValues, false);
        field.setRangeErrors(errors);
        field.clearMissing();
        return field;
    }

    private FlatField cloneMissing() throws VisADException {
        return new FlatField((FunctionType)this.Type, this.getDomainSet(), this.RangeCoordinateSystem, this.RangeCoordinateSystems, this.RangeSet, this.RangeUnits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        FlatField clone;
        try {
            clone = (FlatField)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("Assertion failure");
        }
        double[][] dArray = this.DoubleRange;
        synchronized (this.DoubleRange) {
            if (!this.MissingFlag) {
                try {
                    clone.DoubleRange = new double[this.TupleDimension][];
                    double[][] values = this.unpackValues(true);
                    clone.packValues(values, false);
                }
                catch (VisADException ex) {
                    throw new RuntimeException(ex.toString());
                }
                try {
                    clone.setRangeErrors(this.RangeErrors);
                }
                catch (FieldException ex) {
                    throw new Error("Assertion failure");
                }
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return clone;
        }
    }

    String valuesString() throws VisADException {
        StringBuffer s = new StringBuffer("");
        int ncolumns = 8 / this.TupleDimension;
        if (ncolumns < 1) {
            ncolumns = 1;
        }
        int rowlength = this.getDomainSet() instanceof GriddedSet ? ((GriddedSet)this.getDomainSet()).getLength(0) : this.getLength();
        RealTupleType range = ((FunctionType)this.Type).getFlatRange();
        RealType[] types = range.getRealComponents();
        double[][] values = this.unpackValues();
        int rl = rowlength;
        int i = 0;
        while (i < this.getLength()) {
            int nc = Math.min(rl, Math.min(ncolumns, this.getLength() - i));
            int ip = i + nc;
            for (int k = i; k < ip; ++k) {
                if (k > i) {
                    s.append(", ");
                }
                if (this.TupleDimension == 1) {
                    s.append(new Real(types[0], values[0][k], this.RangeUnits[0]).toString());
                    continue;
                }
                if (((FunctionType)this.Type).getReal()) {
                    String t = "(" + new Real(types[0], values[0][k], this.RangeUnits[0]);
                    for (int j = 1; j < this.TupleDimension; ++j) {
                        t = t + ", " + new Real(types[j], values[j][k], this.RangeUnits[j]);
                    }
                    t = t + ")";
                    s.append(t);
                    continue;
                }
                TupleType RangeType = (TupleType)((FunctionType)this.Type).getRange();
                String t = "(";
                int j = 0;
                for (int l = 0; l < RangeType.getDimension(); ++l) {
                    MathType type;
                    if (j > 0) {
                        t = t + ", ";
                    }
                    if ((type = RangeType.getComponent(l)) instanceof RealType) {
                        t = t + new Real(types[j], values[j][k], this.RangeUnits[j]);
                        ++j;
                        continue;
                    }
                    int mm = ((TupleType)type).getDimension();
                    t = t + "(" + new Real(types[j], values[j][k], this.RangeUnits[j]);
                    ++j;
                    for (int kk = 1; kk < mm; ++kk) {
                        t = t + ", " + new Real(types[j], values[j][k], this.RangeUnits[j]);
                        ++j;
                    }
                    t = t + ")";
                }
                t = t + ")";
                s.append(t);
            }
            s.append("\n");
            i = ip;
            if ((rl -= nc) > 0) continue;
            rl = rowlength;
            s.append("\n");
        }
        return s.toString();
    }

    @Override
    public String toString() {
        try {
            if (this.isMissing()) {
                return "FlatField  missing\n";
            }
            return "FlatField\n    " + this.Type + "\n" + this.valuesString();
        }
        catch (VisADException e) {
            return e.toString();
        }
    }

    @Override
    public String longString(String pre) throws VisADException {
        String t = pre + "FlatField\n" + pre + "  Type: " + this.Type.toString() + "\n";
        t = this.getDomainSet() != null ? t + pre + "  DomainSet:\n" + this.getDomainSet().longString(pre + "    ") : t + pre + "  DomainSet: undefined\n";
        for (int i = 0; i < this.TupleDimension; ++i) {
            t = this.RangeSet[i] != null ? t + pre + "  RangeSet[" + i + "]:\n" + this.RangeSet[i].longString(pre + "    ") : t + pre + "  RangeSet[" + i + "]: undefined\n";
        }
        if (this.isMissing()) {
            return t + "  missing\n";
        }
        return t + this.valuesString();
    }

    @Override
    public int getRangeDimension() {
        return this.TupleDimension;
    }

    @Override
    public boolean equals(Object obj) {
        int i;
        if (obj == null || !(obj instanceof FlatField)) {
            return false;
        }
        FlatField fld = (FlatField)obj;
        if (this.RangeMode == null || fld.RangeMode == null) {
            if (this.RangeMode != null || fld.RangeMode != null) {
                return false;
            }
        } else {
            if (this.RangeMode.length != fld.RangeMode.length) {
                return false;
            }
            for (i = 0; i < this.RangeMode.length; ++i) {
                if (this.RangeMode[i] == fld.RangeMode[i]) continue;
                return false;
            }
        }
        if (this.RangeSet == null || fld.RangeSet == null) {
            if (this.RangeSet != null || fld.RangeSet != null) {
                return false;
            }
        } else {
            if (this.RangeSet.length != fld.RangeSet.length) {
                return false;
            }
            for (i = 0; i < this.RangeSet.length; ++i) {
                if (this.RangeSet[i].equals(fld.RangeSet[i])) continue;
                return false;
            }
        }
        block9: for (i = 0; i < this.TupleDimension; ++i) {
            switch (this.RangeMode[i]) {
                case 1: {
                    if (Arrays.equals(this.DoubleRange[i], fld.DoubleRange[i])) continue block9;
                    return false;
                }
                case 2: {
                    if (Arrays.equals(this.FloatRange[i], fld.FloatRange[i])) continue block9;
                    return false;
                }
                case 6: {
                    if (Arrays.equals(this.ByteRange[i], fld.ByteRange[i])) continue block9;
                    return false;
                }
                case 5: {
                    if (Arrays.equals(this.ShortRange[i], fld.ShortRange[i])) continue block9;
                    return false;
                }
                case 4: {
                    if (Arrays.equals(this.IntRange[i], fld.IntRange[i])) continue block9;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return super.equals(obj);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FlatField makeField(FunctionType type, int length, boolean irregular) throws VisADException, RemoteException {
        void var15_18;
        double first = 0.0;
        double last = (double)length - 1.0;
        double step = 1.0;
        double half = 0.5 * last;
        RealTupleType dtype = type.getDomain();
        RealTupleType rtype = type.getFlatRange();
        int domain_dim = dtype.getDimension();
        int range_dim = rtype.getDimension();
        Object var15_11 = null;
        int dsize = 0;
        Random random = new Random();
        if (irregular) {
            float[][] samples;
            if (domain_dim == 1) {
                dsize = length;
                samples = new float[1][dsize];
                for (int i = 0; i < dsize; ++i) {
                    samples[0][i] = (float)(last * (double)random.nextFloat());
                }
                Irregular1DSet irregular1DSet = new Irregular1DSet((MathType)dtype, samples);
            } else if (domain_dim == 2) {
                dsize = length * length;
                samples = new float[2][dsize];
                for (int i = 0; i < dsize; ++i) {
                    samples[0][i] = (float)(last * (double)random.nextFloat());
                    samples[1][i] = (float)(last * (double)random.nextFloat());
                }
                Irregular2DSet irregular2DSet = new Irregular2DSet((MathType)dtype, samples);
            } else {
                if (domain_dim != 3) throw new FieldException("FlatField.makeField: bad domain dimension");
                dsize = length * length * length;
                samples = new float[3][dsize];
                for (int i = 0; i < dsize; ++i) {
                    samples[0][i] = (float)(last * (double)random.nextFloat());
                    samples[1][i] = (float)(last * (double)random.nextFloat());
                    samples[2][i] = (float)(last * (double)random.nextFloat());
                }
                Irregular3DSet irregular3DSet = new Irregular3DSet((MathType)dtype, samples);
            }
        } else if (domain_dim == 1) {
            Linear1DSet linear1DSet = new Linear1DSet((MathType)dtype, first, last, length);
            dsize = length;
        } else if (domain_dim == 2) {
            Linear2DSet linear2DSet = new Linear2DSet((MathType)dtype, first, last, length, first, last, length);
            dsize = length * length;
        } else {
            if (domain_dim != 3) throw new FieldException("FlatField.makeField: bad domain dimension");
            Linear3DSet linear3DSet = new Linear3DSet((MathType)dtype, first, last, length, first, last, length, first, last, length);
            dsize = length * length * length;
        }
        FlatField image = new FlatField(type, (Set)var15_18);
        FlatField.fillField(image, step, half);
        return image;
    }

    public static void fillField(FlatField image, double step, double half) throws VisADException, RemoteException {
        Random random = new Random();
        FunctionType type = (FunctionType)image.getType();
        RealTupleType dtype = type.getDomain();
        RealTupleType rtype = type.getFlatRange();
        int domain_dim = dtype.getDimension();
        int range_dim = rtype.getDimension();
        SampledSet domain_set = (SampledSet)image.getDomainSet();
        int dsize = domain_set.getLength();
        double[][] data = new double[range_dim][dsize];
        float[][] samples = domain_set.getSamples();
        for (int k = 0; k < range_dim; ++k) {
            float y;
            float x;
            int i;
            if (domain_dim == 1) {
                for (i = 0; i < dsize; ++i) {
                    x = samples[0][i];
                    data[k][i] = k == 0 ? (double)((float)Math.abs(step * ((double)x - half))) : (k == 1 ? (double)x : random.nextDouble());
                }
                continue;
            }
            if (domain_dim == 2) {
                for (i = 0; i < dsize; ++i) {
                    x = samples[0][i];
                    y = samples[1][i];
                    data[k][i] = k == 0 ? (double)((float)(step * Math.sqrt(((double)x - half) * ((double)x - half) + ((double)y - half) * ((double)y - half)))) : (k == 1 ? (double)x : (k == 2 ? (double)y : random.nextDouble()));
                }
                continue;
            }
            if (domain_dim != 3) continue;
            for (i = 0; i < dsize; ++i) {
                x = samples[0][i];
                y = samples[1][i];
                float z = samples[2][i];
                data[k][i] = k == 0 ? (double)((float)(step * Math.sqrt(((double)x - half) * ((double)x - half) + ((double)y - half) * ((double)y - half) + ((double)z - half) * ((double)z - half)))) : (k == 1 ? (double)x : (k == 2 ? (double)y : (k == 3 ? (double)z : random.nextDouble())));
            }
        }
        image.setSamples(data);
    }

    public static FlatField makeField1(FunctionType type, double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException, RemoteException {
        double step1 = (last1 - first1) / (double)(length1 - 1);
        double step2 = (last2 - first2) / (double)(length2 - 1);
        Linear2DSet imageset = new Linear2DSet((MathType)type.getDomain(), first1, last1, length1, first2, last2, length2);
        FlatField image = new FlatField(type, imageset);
        double[][] data = new double[1][length1 * length2];
        for (int i = 0; i < length1; ++i) {
            for (int j = 0; j < length2; ++j) {
                data[0][i + length1 * j] = first1 + step1 * (double)i + (first2 + step2 * (double)j);
            }
        }
        image.setSamples(data);
        return image;
    }

    public static FlatField makeField2(FunctionType type, double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException, RemoteException {
        double step1 = (last1 - first1) / (double)(length1 - 1);
        double step2 = (last2 - first2) / (double)(length2 - 1);
        Linear2DSet imageset = new Linear2DSet((MathType)type.getDomain(), first1, last1, length1, first2, last2, length2);
        FlatField image = new FlatField(type, imageset);
        double[][] data = new double[2][length1 * length2];
        for (int i = 0; i < length1; ++i) {
            for (int j = 0; j < length2; ++j) {
                data[0][i + length1 * j] = first1 + step1 * (double)i;
                data[1][i + length1 * j] = first2 + step2 * (double)j;
            }
        }
        image.setSamples(data);
        return image;
    }

    static FlatField makeRandomField2(FunctionType type, double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException, RemoteException {
        double step1 = (last1 - first1) / (double)(length1 - 1);
        double step2 = (last2 - first2) / (double)(length2 - 1);
        Linear2DSet imageset = new Linear2DSet((MathType)type.getDomain(), first1, last1, length1, first2, last2, length2);
        FlatField image = new FlatField(type, imageset);
        Random random = new Random();
        double[][] data = new double[2][length1 * length2];
        for (int i = 0; i < length1; ++i) {
            for (int j = 0; j < length2; ++j) {
                data[0][i + length1 * j] = random.nextDouble();
                data[1][i + length1 * j] = random.nextDouble();
            }
        }
        image.setSamples(data);
        return image;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        int b = 10;
        Real w = new Real(b);
        RealType X = RealType.getRealType("X");
        RealType Y = RealType.getRealType("Y");
        RealType Z = RealType.getRealType("Z");
        RealType A = RealType.getRealType("A");
        RealType B = RealType.getRealType("B");
        RealType[] domain2d = new RealType[]{X, Y};
        RealTupleType Domain2d = new RealTupleType(domain2d, null, null);
        Integer2DSet Domain2dSet = new Integer2DSet((MathType)Domain2d, 4, 4);
        Domain2d.setDefaultSet(Domain2dSet);
        RealType[] range2d = new RealType[]{A, B};
        RealTupleType Range2d = new RealTupleType(range2d);
        FunctionType Field2d1 = new FunctionType(Domain2d, A);
        FunctionType Field2d2 = new FunctionType(Domain2d, Range2d);
        double first11 = 0.0;
        double last11 = 3.0;
        int length11 = 4;
        double first12 = 0.0;
        double last12 = 3.0;
        int length12 = 4;
        FlatField image1 = FlatField.makeField1(Field2d1, first11, last11, length11, first12, last12, length12);
        FlatField image3 = FlatField.makeField2(Field2d2, first11, last11, length11, first12, last12, length12);
        Real[] reals = new Real[]{new Real(X, 1.5), new Real(Y, 2.5)};
        RealTuple val = new RealTuple(reals);
        double first21 = 0.0;
        double last21 = 3.0;
        int length21 = 7;
        double first22 = 0.0;
        double last22 = 3.0;
        int length22 = 7;
        FlatField image2 = FlatField.makeField1(Field2d1, first21, last21, length21, first22, last22, length22);
        FlatField image4 = FlatField.makeField2(Field2d2, first21, last21, length21, first22, last22, length22);
        System.out.println("image1 = " + image1);
        System.out.println("image2 = " + image2);
        System.out.println("image3 = " + image3);
        System.out.println("image4 = " + image4);
        System.out.println("sampling mode is NEAREST_NEIGHBOR");
        System.out.println("image3 + image4 = " + image3.add(image4));
        System.out.println("image4 - image3 = " + image4.subtract(image3));
        System.out.println("image3 * image4 = " + image3.multiply(image4));
        System.out.println("image4 / image3 = " + image4.divide(image3));
        System.out.println("sqrt(image3) = " + image3.sqrt());
        System.out.println("val = " + val + " image1(val) = " + image1.evaluate(val));
        System.out.println("val = " + val + " image3(val) = " + image3.evaluate(val) + "\n");
        System.out.println("image3 + val = " + image3.add(val));
        System.out.println("val - image3 = " + val.subtract(image3));
        System.out.println("image3 * val = " + image3.multiply(val));
        System.out.println("val / image3 = " + val.divide(image3));
        System.out.println("Field.Mode is WEIGHTED_AVERAGE");
        System.out.println("image3 + image4 = " + image3.add(image4, 101, 200));
        System.out.println("image4 - image3 = " + image4.subtract(image3, 101, 200));
        System.out.println("image3 * image4 = " + image3.multiply(image4, 101, 200));
        System.out.println("image4 / image3 = " + image4.divide(image3, 101, 200));
        System.out.println("val = " + val + " image1(val) = " + image1.evaluate(val, 101, 200));
        System.out.println("val = " + val + " image3(val) = " + image3.evaluate(val, 101, 200) + "\n");
        System.out.println("image3 + val = " + image3.add(val, 101, 200));
        System.out.println("val - image3 = " + val.subtract(image3, 101, 200));
        System.out.println("image3 * val = " + image3.multiply(val, 101, 200));
        System.out.println("val / image3 = " + val.divide(image3, 101, 200));
        System.out.println("sampling mode is NEAREST_NEIGHBOR");
        System.out.println("image1 + w = " + image1.add(w));
        System.out.println("image1 - w = " + image1.subtract(w));
        System.out.println("image1 * w = " + image1.multiply(w));
        System.out.println("image1 / w = " + image1.divide(w));
        System.out.println("w + image2 = " + w.add(image2));
        System.out.println("w - image2 = " + w.subtract(image2));
        System.out.println("w * image2 = " + w.multiply(image2));
        System.out.println("w / image2 = " + w.divide(image2));
        RealType[] range2t = new RealType[]{A, RealType.Time};
        RealTupleType Range2t = new RealTupleType(range2t);
        FunctionType Field2t2 = new FunctionType(Domain2d, Range2t);
        FlatField imaget = FlatField.makeField2(Field2t2, first11, last11, length11, first12, last12, length12);
        System.out.println("imaget = " + imaget);
    }
}

