/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Scherk
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 1.0, 1.0, 1.0);

    public Scherk() {
        this.uPatchCount.setValueAndDefault(10);
        this.vPatchCount.setValueAndDefault(10);
        this.umin.reset("-pi/2 + 0.01");
        this.umax.reset("pi/2 - 0.01");
        this.vmin.reset("-pi/2 + 0.01");
        this.vmax.reset("pi/2 - 0.01");
        this.setDefaultViewpoint(new Vector3D(10.0, 10.0, 10.0));
        this.setDefaultWindow(-5.0, 5.0, -5.0, 5.0);
        this.addParameter(this.aa);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double x = u;
        double y = v;
        double z = Math.log(Math.cos(AA * v) / Math.cos(AA * u)) / AA;
        return new Vector3D(x, y, z);
    }
}

