/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Hyperboloid2
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "1.0", "1.0", "0.5");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", "1.0", "1.0", "1.8");
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", "1.0", "1.0", "1.0");

    public Hyperboloid2() {
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset("0");
        this.umax.reset("2");
        this.vmin.reset("0");
        this.vmax.reset("2 pi");
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.setDefaultViewpoint(new Vector3D(25.0, 25.0, 15.0));
        this.setDefaultWindow(-5.5, 5.5, -5.5, 5.5);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.addParameter(this.cc);
    }

    @Override
    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        this.data.addGridTransform(new GridTransformMatrix().scale(1.0, 1.0, -1.0));
    }

    private static double sinh(double t) {
        return 0.5 * (Math.exp(t) - Math.exp(-t));
    }

    private static double cosh(double t) {
        return 0.5 * (Math.exp(t) + Math.exp(-t));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double BB = this.bb.getValue();
        double CC = this.cc.getValue();
        double x = AA * Hyperboloid2.sinh(u) * Math.cos(v);
        double y = BB * Hyperboloid2.sinh(u) * Math.sin(v);
        double z = CC * Hyperboloid2.cosh(u);
        return new Vector3D(x, y, z);
    }
}

