/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class ChenGackstatter
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm.surface.parametric.ChenGackstatter.exponent", 3);
    private RealParamAnimateable lrp = new RealParamAnimateable("vmm.surface.parametric.ChenGackstatter.lrp", 1.0, 0.7, 1.1);
    protected int Ex;
    protected int iP;
    protected int um;
    protected int vm;
    double amp;
    protected double r1;
    protected double LRP;

    public ChenGackstatter() {
        this.addParameter(this.lrp);
        this.lrp.setMinimumValueForInput(0.1);
        this.addParameter(this.exponent);
        this.exponent.setMinimumValueForInput(2);
        this.exponent.setMaximumValueForInput(11);
        this.setDefaultOrientation(0);
        this.setDefaultViewpoint(new Vector3D(38.4, 30.7, -11.2));
        this.setDefaultViewUp(new Vector3D(-0.125, -0.2, -0.97));
        this.setDefaultWindow(-7.5, 7.5, -6.0, 6.0);
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-0.9);
        this.umax.reset(1.72);
        this.umax.setMinimumValueForInput(0.2);
        this.vmin.reset(-0.9995);
        this.vmax.reset(0.9995);
        this.removeParameter(this.umin);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.iFirstInHelper = false;
        this.iBeginMiddleInHelper = true;
        this.needsPeriodClosed = true;
        this.wantsToSeeDomain = false;
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.canShowConjugateSurface = false;
    }

    @Override
    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView view = new WeierstrassMinimalSurface.WMSView(this);
        view.setGridSpacing(6);
        float c0 = 0.34f;
        view.getLightSettings().setLight0(new Color(c0, c0, c0));
        view.getLightSettings().getDirectionalLight2().setItsColor(new Color(0.5f, 1.0f, 0.0f));
        view.getLightSettings().getDirectionalLight2().setItsDirection(new Vector3D(0.66, -0.34, -0.66));
        view.getLightSettings().getDirectionalLight3().setItsDirection(new Vector3D(0.57, 0.2, -0.8));
        view.getLightSettings().setSpecularExponent(55);
        view.getLightSettings().setSpecularRatio(0.5f);
        return view;
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.AFP = this.afp.getValue();
        if (param != this.afp) {
            this.needsValueArray = true;
        }
        if (param == this.exponent) {
            this.needsPeriodClosed = true;
            this.LRP = 1.0;
            if (param != this.umax) {
                this.umax.reset(Math.max(0.9, 1.9 - ((double)this.exponent.getValue() - 2.0) * 0.18));
            }
            super.parameterChanged(param, oldValue, newValue);
        }
    }

    @Override
    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] trList = new GridTransformMatrix[4 * this.Ex];
        trList[0] = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain && this.flag0) {
            int e;
            trList[1] = new GridTransformMatrix().scale(1.0, -1.0, 1.0);
            this.data.addGridTransform(trList[1]);
            for (e = 2; e < 2 * this.Ex; ++e) {
                trList[e] = new GridTransformMatrix(trList[e - 2]).rotateZ(360.0 / (double)this.Ex);
                this.data.addGridTransform(trList[e]);
            }
            if (this.flag0) {
                for (e = 0; e < 2 * this.Ex; ++e) {
                    trList[e + 2 * this.Ex] = new GridTransformMatrix(trList[e]).scale(1.0, -1.0, -1.0).rotateZ(180.0 / (double)this.Ex).reverse();
                    this.data.addGridTransform(trList[e + 2 * this.Ex]);
                }
            }
        }
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double a;
        double r = ChenGackstatter.myRad(u, this.Ex);
        Complex z = new Complex(r * Math.cos(a = Math.PI * Math.sin(v * Math.PI / 2.0)) + 1.0, r * Math.sin(a));
        Complex w = z.squareRootNearer(ONE_C);
        double n = w.r();
        if (n < this.amp) {
            w.assignTimes(Math.max(1.0, (this.amp - n) / n));
        }
        return w;
    }

    protected void p_Index() {
        for (int i = 0; i < this.ucount; ++i) {
            Complex z = this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue());
            if (!(z.re > 1.0E-4) || !(Math.abs(z.im) < 1.0E-4)) continue;
            this.iP = i;
        }
        this.iP += (int)Math.floor(((double)this.Ex - 3.0) * ((double)this.Ex - 2.0) / 2.0);
    }

    protected static double myRad(double u, int e) {
        if (u <= -1.0) {
            return 0.0;
        }
        if (u <= 0.0) {
            return 1.0 + ChenGackstatter.monotonPow(-1.0 + ChenGackstatter.monotonPow(u + 1.0, (int)Math.floor(2.0 + (double)e / 2.0)), e);
        }
        return 1.0 + ChenGackstatter.monotonPow(u, e) * (double)e / ((double)e - 1.0);
    }

    @Override
    protected Complex gauss(Complex z) {
        double denom = z.re * z.re + z.im * z.im;
        Complex w = new Complex(z.re / denom - z.re, -z.im * (1.0 / denom + 1.0));
        Complex aux = z.im > 0.0 ? w.logNearer(ZERO_C).times(1.0 - 1.0 / (double)this.Ex) : w.logNearer(IP__C).times(1.0 - 1.0 / (double)this.Ex);
        w = aux.exponential();
        w.assignTimes(this.LRP);
        return w;
    }

    @Override
    protected Complex hPrime(Complex z) {
        return new Complex(this.r1, 0.0);
    }

    protected double closingLopezRos() {
        int off = this.ucount - 1 - this.iP;
        int mid = Math.min(40, this.ucount - 6);
        double as = this.helperArray[mid][this.vm].y.re;
        double bs = -this.helperArray[mid][this.vm].x.re;
        double cs = -this.helperArray[mid][this.vm].y.im;
        double ds = -this.helperArray[mid][this.vm].x.im;
        double ts = Math.cos(Math.PI / (1.0 * (double)this.Ex)) / Math.sin(Math.PI / (1.0 * (double)this.Ex));
        double al = this.helperArray[this.iP + off][this.vcount - 1].y.re;
        double bl = -this.helperArray[this.iP + off][this.vcount - 1].x.re;
        double cl = -this.helperArray[this.iP + off][this.vcount - 1].y.im;
        double dl = -this.helperArray[this.iP + off][this.vcount - 1].x.im;
        double tl = Math.cos(Math.PI / (2.0 * (double)this.Ex)) / Math.sin(Math.PI / (2.0 * (double)this.Ex));
        double constLeft = cs * ts - as - cl * tl + al;
        double factRight = dl * tl - bl - ds * ts + bs;
        double ro = Math.min(Math.sqrt(constLeft / factRight), Math.sqrt((cl * tl - al) / (bl - dl * tl)));
        al = this.helperArray[this.iP + off][0].y.re;
        bl = -this.helperArray[this.iP + off][0].x.re;
        cl = -this.helperArray[this.iP + off][0].y.im;
        dl = -this.helperArray[this.iP + off][0].x.im;
        tl = Math.cos(Math.PI * 3 / (2.0 * (double)this.Ex)) / Math.sin(Math.PI * 3 / (2.0 * (double)this.Ex));
        constLeft = cs * ts - as - cl * tl + al;
        factRight = dl * tl - bl - ds * ts + bs;
        double ro1 = Math.min(Math.sqrt(constLeft / factRight), Math.sqrt((cl * tl - al) / (bl - dl * tl)));
        ro = Math.min(ro, ro1);
        for (int i = 1; i < 3; ++i) {
            this.LRP = ro;
            this.createHelperArray();
            double al2 = this.helperArray[this.iP + off][0].y.re;
            double bl2 = -this.helperArray[this.iP + off][0].x.re;
            double cl2 = -this.helperArray[this.iP + off][0].y.im;
            double dl2 = -this.helperArray[this.iP + off][0].x.im;
            double tl2 = Math.cos(Math.PI * 3 / (2.0 * (double)this.Ex)) / Math.sin(Math.PI * 3 / (2.0 * (double)this.Ex));
            ro *= Math.sqrt((cl2 * tl2 - al2) / (bl2 - dl2 * tl2));
        }
        this.LRP = ro * this.lrp.getValue();
        return ro;
    }

    @Override
    protected void doClosingJob() {
        this.LRPclosed = this.closingLopezRos();
        this.createHelperArray();
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.LRP = this.needsPeriodClosed ? 1.0 : this.LRPclosed * this.lrp.getValue();
        this.Ex = this.exponent.getValue();
        this.r1 = 1.0 * Math.sqrt(Math.sqrt(2.0 / (double)this.Ex));
        this.amp = 1.0 / (double)(this.Ex * this.Ex * this.Ex * this.Ex * this.Ex * this.Ex * this.Ex * this.Ex * this.Ex * this.Ex);
        this.p_Index();
        this.um = (int)Math.floor((double)(this.ucount - 1) / 2.0);
        this.vm = (int)Math.floor((double)(this.vcount - 1) / 2.0);
    }

    @Override
    protected ComplexVector3D getCenter() {
        if (this.inAssociateMorph) {
            return new ComplexVector3D(this.helperArray[this.um][this.vm]);
        }
        ComplexVector3D minMaxMin2 = this.helperToMinimal(this.helperArray[18][0]);
        ComplexVector3D minMaxMin1 = this.helperToMinimal(this.helperArray[30][0]);
        ComplexVector3D minMaxMid1 = this.helperToMinimal(this.helperArray[12][this.vm]);
        ComplexVector3D minMaxMid2 = this.helperToMinimal(this.helperArray[this.um][this.vm]);
        ComplexVector3D zeroLevel = this.helperToMinimal(this.helperArray[this.ucount - 1][0]);
        Complex z1 = new Complex(minMaxMid1.x.re, minMaxMid1.y.re);
        Complex z2 = new Complex(minMaxMid2.x.re, minMaxMid2.y.re);
        Complex w1 = new Complex(minMaxMin1.x.re, minMaxMin1.y.re);
        Complex w2 = new Complex(minMaxMin2.x.re, minMaxMin2.y.re);
        Complex cs = this.intersectLines(z1, z2, w1, w2);
        return this.minimalToHelper(new ComplexVector3D(cs, cs.times(I__C), zeroLevel.z));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        ComplexVector3D eW;
        int i = (int)Math.floor(0.25 + (u - this.umin.getValue()) / this.du);
        int j = (int)Math.floor(0.25 + (v - this.vmin.getValue()) / this.dv);
        if (!(this.lrp.getValue() != 1.0 || this.inAssociateMorph || this.wantsToSeeDomain || i <= this.iP - this.Ex + 2 || i >= this.iP + this.Ex || j != this.vcount - 1 && j != 0)) {
            eW = new ComplexVector3D(ComplexVector3D.ORIGIN);
        } else {
            ComplexVector3D auxW = new ComplexVector3D(this.helperArray[i][j].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue() + (double)j * this.dv), this.domainGrid(u, v))));
            eW = this.helperToMinimal(auxW);
            if (this.lrp.getValue() == 1.0 && !this.inAssociateMorph && !this.wantsToSeeDomain && i == 0) {
                eW.assign(ZERO_C, ZERO_C, eW.z);
            }
        }
        if (this.wantsToSeeDomain) {
            return new Vector3D(eW.z.re, eW.z.im, 0.0);
        }
        if (this.AFP == 0.0) {
            return eW.re();
        }
        return eW.re().times(Math.cos(this.AFP)).plus(eW.im().times(Math.sin(this.AFP)));
    }
}

