/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import java.awt.Color;
import java.util.Random;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.core3D.DotCloudSurface;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;
import vmm.spacecurve.parametric.SphericalCurve;

public class Viviani
extends SphericalCurve {
    private RealParamAnimateable CylinderRadius;
    protected DotCloudCylinder cloudCylinder;

    public Viviani() {
        this.tResolution.setValueAndDefault(150);
        this.tmin.setValueAndDefaultFromString("-2 * pi");
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.CylinderRadius = new RealParamAnimateable("vmm.spacecurve.parametric.Viviani.CylinderRadius", 0.5, 0.1, 0.9);
        this.addParameter(this.CylinderRadius);
        this.setDefaultWindow(-1.2, 1.2, -1.2, 1.2);
        this.setDefaultViewpoint(new Vector3D(2.0, 20.0, 15.0));
        this.tubeSize.setValueAndDefault(0.2);
        this.cloudCylinder = new DotCloudCylinder();
        this.cloudCylinder.setColor(Color.red);
        this.addDecoration(this.cloudCylinder);
    }

    @Override
    public View getDefaultView() {
        SpaceCurveParametric.SpaceCurveParametricView view = (SpaceCurveParametric.SpaceCurveParametricView)super.getDefaultView();
        view.setUseReverseCollar(true);
        return view;
    }

    @Override
    protected Vector3D value(double t) {
        double r = this.CylinderRadius.getValue();
        double x = 2.0 * Math.sqrt(r * (1.0 - r)) * Math.sin(t / 2.0);
        double y = r * Math.sin(t);
        double z = 1.0 + r * (Math.cos(t) - 1.0);
        return new Vector3D(x, y, z);
    }

    @Override
    protected Vector3D deriv1(double t) {
        double r = this.CylinderRadius.getValue();
        double x = Math.sqrt(r * (1.0 - r)) * Math.cos(t / 2.0);
        double y = r * Math.cos(t);
        double z = r * -Math.sin(t);
        return new Vector3D(x, y, z);
    }

    @Override
    protected Vector3D deriv2(double t) {
        double r = this.CylinderRadius.getValue();
        double x = -Math.sqrt(r * (1.0 - r)) * Math.sin(t / 2.0) / 2.0;
        double y = -r * Math.sin(t);
        double z = -r * Math.cos(t);
        return new Vector3D(x, y, z);
    }

    protected class DotCloudCylinder
    extends DotCloudSurface {
        private int j = 0;

        protected DotCloudCylinder() {
        }

        @Override
        protected Vector3D makeRandomPixel(Random randomNumberGenerator) {
            double u = randomNumberGenerator.nextDouble() * Math.PI * 2.0;
            double VV = randomNumberGenerator.nextDouble();
            ++this.j;
            if (this.j % 10 == 0) {
                VV = Math.round(VV);
            }
            double x = VV * 3.0 - 1.5;
            double r = Viviani.this.CylinderRadius.getValue();
            double z = 1.0 + r * (Math.cos(u) - 1.0);
            double y = r * Math.sin(u);
            return new Vector3D(x, y, z);
        }

        @Override
        public void computeDrawData(View view, boolean exhibitNeedsRedraw, Transform previousTransform, Transform newTransform) {
            this.j = 0;
            super.computeDrawData(view, exhibitNeedsRedraw, previousTransform, newTransform);
        }
    }
}

