/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SphericalCurve;

public class SphericalCycloid
extends SphericalCurve {
    RealParamAnimateable aa = new RealParamAnimateable("vmm.spacecurve.parametric.SphericalCycloid.aa", 0.2, 0.2, 0.2);
    RealParamAnimateable bb = new RealParamAnimateable("vmm.spacecurve.parametric.SphericalCycloid.bb", 2.0, -1.0, 3.0);
    RealParamAnimateable ee = new RealParamAnimateable("vmm.spacecurve.parametric.SphericalCycloid.ee", 5.0, 5.0, 5.0);

    public SphericalCycloid() {
        this.setDefaultViewpoint(new Vector3D(10.0, 0.0, 30.0));
        this.setDefaultWindow(-1.1, 1.1, -1.1, 1.1);
        this.tResolution.setValueAndDefault(200);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.addParameter(this.ee);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.tubeSize.setValueAndDefault(0.1);
    }

    @Override
    protected Vector3D value(double t) {
        double a = this.aa.getValue();
        double b = this.bb.getValue();
        double e = this.ee.getValue();
        e = (int)e;
        double start = 0.0;
        if (Math.signum(e) < 0.0) {
            start = Math.PI;
        }
        double rol = Math.asin(Math.sin(Math.PI * a) / Math.abs(e));
        Vector3D E = this.geographicCoordinates(b * rol, (e + 1.0) * t + start);
        Vector3D M = this.geographicCoordinates((Math.PI * a + Math.signum(e) * rol) / 2.0, t);
        Vector3D C = E.reflectInAxis(M);
        return new Vector3D(C);
    }
}

