/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import vmm.core.Decoration;
import vmm.core.Exhibit;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class RepereMobileDecoration
extends Decoration {
    private SpaceCurveParametric curve;
    @VMMSave
    private double t = Double.NaN;

    public SpaceCurveParametric getCurve() {
        return this.curve;
    }

    public void setCurve(SpaceCurveParametric c) {
        this.curve = c;
    }

    public void setT(double t) {
        this.t = t;
        this.fireDecorationChangeEvent();
    }

    public double getT() {
        return this.t;
    }

    public void setIndex(int tIndex) {
        if (this.curve != null && tIndex >= 0 && tIndex <= this.curve.getTResolution()) {
            this.setT(this.curve.getT(tIndex));
        } else {
            this.setT(Double.NaN);
        }
    }

    @Override
    public void doDraw(Graphics2D g, View view, Transform transform) {
        if (this.curve == null && view != null) {
            Exhibit c = view.getExhibit();
            if (c instanceof SpaceCurveParametric) {
                this.curve = (SpaceCurveParametric)c;
            } else {
                return;
            }
        }
        if (Double.isNaN(this.t)) {
            return;
        }
        if (!(view instanceof View3D)) {
            return;
        }
        View3D view3D = (View3D)view;
        Vector3D[] frame = this.curve.makeRepereMobile(this.t);
        if (frame == null) {
            return;
        }
        Color saveColor = view3D.getColor();
        view3D.setStrokeSizeMultiplier(2);
        boolean anaglyph = view3D.getViewStyle() == 1;
        double length = transform.getPixelWidth() * 50.0;
        if (anaglyph) {
            view3D.setColor(Color.white);
        } else {
            view3D.setColor(Color.red);
        }
        view3D.drawLine(frame[0], frame[0].plus(frame[1].times(length)));
        if (!anaglyph) {
            view3D.setColor(Color.blue);
        }
        view3D.drawLine(frame[0], frame[0].plus(frame[2].times(length)));
        if (!anaglyph) {
            view3D.setColor(Color.green);
        }
        view3D.drawLine(frame[0], frame[0].plus(frame[3].times(length)));
        view3D.setColor(saveColor);
        view3D.setStrokeSizeMultiplier(1);
    }
}

