/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class ConstantCurvature
extends SpaceCurveParametric {
    RealParamAnimateable aa = new RealParamAnimateable("vmm.spacecurve.parametric.ConstantCurvature.aa", 1.0, 1.0, 1.0);
    RealParamAnimateable bb = new RealParamAnimateable("vmm.spacecurve.parametric.ConstantCurvature.bb", 0.0, 0.0, 0.0);
    RealParamAnimateable cc = new RealParamAnimateable("vmm.spacecurve.parametric.ConstantCurvature.cc", 1.00844728, 1.354743, 0.314);
    RealParamAnimateable dd = new RealParamAnimateable("vmm.spacecurve.parametric.ConstantCurvature.dd", 0.0, 0.0, 0.0);
    RealParamAnimateable ee = new RealParamAnimateable("vmm.spacecurve.parametric.ConstantCurvature.ee", 0.0, 0.0, 0.0);
    double kappa = 0.0;
    double b = 0.0;
    double c = 0.0;
    double d = 0.0;
    double e = 0.0;
    private int exampleNumber = 0;
    private ActionRadioGroup exampleSelect;
    int tr = this.tResolution.getValue();
    Vector3D startPoint = new Vector3D(0.0, 0.0, 0.0);
    Vector3D P = new Vector3D(0.0, 0.0, -1.0);
    Vector3D T = new Vector3D(1.0, 0.0, 0.0);
    Vector3D N = new Vector3D(0.0, 1.0, 0.0);
    Vector3D B = new Vector3D(0.0, 0.0, 1.0);
    Vector3D[] initialFrenet = new Vector3D[]{this.startPoint, this.T, this.N, this.B};
    Vector3D[] repere = new Vector3D[]{this.P, this.T, this.N, this.B};
    Vector3D[] pointSet = new Vector3D[this.tr + 1];
    Vector3D[] helperFrame = new Vector3D[4 * (this.tr + 1)];
    boolean needsNewArray = true;
    Vector3D dT1 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dN1 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dB1 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dT2 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dN2 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dB2 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dT3 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dN3 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dB3 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dT4 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dN4 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dB4 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D Vvv = new Vector3D(0.0, 0.0, 0.0);

    public ConstantCurvature() {
        this.setDefaultViewpoint(new Vector3D(0.0, -16.0, -6.0));
        this.setDefaultWindow(-4.0, 4.0, -3.0, 3.0);
        this.tResolution.setValueAndDefault(300);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("4*pi");
        this.addParameter(this.ee);
        this.addParameter(this.dd);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.tubeSize.setValueAndDefault(0.2);
        ActionRadioGroup group = new ActionRadioGroup(){

            @Override
            public void optionSelected(int selectedIndex) {
                ConstantCurvature.this.setExampleNumberFunction(selectedIndex);
            }
        };
        group.addItem(I18n.tr("vmm.spacecurve.parametric.ConstantCurvature.example0"));
        group.addItem(I18n.tr("vmm.spacecurve.parametric.ConstantCurvature.example1"));
        group.addItem(I18n.tr("vmm.spacecurve.parametric.ConstantCurvature.example2"));
        group.addItem(I18n.tr("vmm.spacecurve.parametric.ConstantCurvature.example3"));
        group.addItem(I18n.tr("vmm.spacecurve.parametric.ConstantCurvature.example4"));
        group.setSelectedIndex(0);
        this.exampleSelect = group;
    }

    public int getExampleNumberFunction() {
        return this.exampleNumber;
    }

    public void setExampleNumberFunction(int exampleNumber) {
        if (this.exampleNumber != exampleNumber) {
            this.exampleNumber = exampleNumber;
            System.out.println("exampleNumber = " + exampleNumber);
            this.resetFourierConstants(exampleNumber);
            this.forceRedraw();
        }
    }

    @Override
    public ActionList getActionsForView(View view) {
        ActionList actions = super.getActionsForView(view);
        actions.add(null);
        ActionList submenu = new ActionList(I18n.tr("vmm.spacecurve.parametric.ConstantCurvature.closedCurves"));
        submenu.add(this.exampleSelect);
        actions.add(submenu);
        return actions;
    }

    private void resetFourierConstants(int examplNum) {
        this.needsNewArray = true;
        this.tResolution.reset(300);
        this.aa.reset(1.0);
        switch (examplNum) {
            case 0: {
                this.tmax.reset("4*pi");
                this.bb.reset(0.0);
                this.cc.reset(1.0084472);
                break;
            }
            case 1: {
                this.tmax.reset("6*pi");
                this.bb.reset(0.0);
                this.cc.reset(1.3547);
                break;
            }
            case 2: {
                this.tmax.reset("10*pi");
                this.bb.reset(0.247);
                this.cc.reset(0.4053);
                break;
            }
            case 3: {
                this.tmax.reset("10*pi");
                this.bb.reset(0.5117);
                this.cc.reset(0.8551);
                break;
            }
            case 4: {
                this.tResolution.reset(600);
                this.tmax.reset("22*pi");
                this.aa.reset(0.8944);
                this.bb.reset(0.5005);
                this.cc.reset(0.4129);
            }
        }
        this.getConstants();
    }

    private void getConstants() {
        this.tr = this.tResolution.getValue();
        this.kappa = this.aa.getValue();
        this.b = this.bb.getValue();
        this.c = this.cc.getValue();
        this.d = this.dd.getValue();
        this.e = this.ee.getValue();
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.needsNewArray = true;
    }

    protected double tau(double t) {
        return this.b + this.c * Math.sin(t) + this.d * Math.sin(2.0 * t) + this.e * Math.sin(3.0 * t);
    }

    protected Vector3D[] frenetODEstep2(double tInitial, double tFinal, Vector3D[] initialVal, int numSubdivision) {
        this.P = initialVal[0];
        this.T = initialVal[1];
        this.N = initialVal[2];
        this.B = initialVal[3];
        double t = tInitial;
        double newSub = (1.0 + Math.abs(tFinal - tInitial)) * (double)numSubdivision;
        double dt = (tFinal - tInitial) / newSub;
        Vector3D midT = new Vector3D(this.T);
        Vector3D midN = new Vector3D(this.N);
        Vector3D midB = new Vector3D(this.B);
        int i = 0;
        while ((double)i < newSub) {
            midT = this.T.plus(this.N.times(this.kappa * dt / 2.0));
            midN = this.N.plus(this.T.times(-this.kappa * dt / 2.0)).plus(this.B.times(this.tau(t) * dt / 2.0));
            midB = this.B.plus(this.N.times(-this.tau(t) * dt / 2.0));
            this.P = this.P.plus(this.T.plus(midT.times(4.0)).times(dt / 6.0));
            this.T = this.T.plus(midN.times(this.kappa * dt));
            this.N = this.N.plus(midT.times(-this.kappa * dt)).plus(midB.times(this.tau(t += dt / 2.0) * dt));
            this.B = this.B.plus(midN.times(-this.tau(t) * dt));
            this.P = this.P.plus(this.T.times(dt / 6.0));
            t += dt / 2.0;
            ++i;
        }
        return new Vector3D[]{this.P, this.T, this.N, this.B};
    }

    protected Vector3D[] frenetODEstep4(double tInitial, double tFinal, Vector3D[] initialVal, int numSubdivision) {
        this.P = initialVal[0];
        this.T = initialVal[1];
        this.N = initialVal[2];
        this.B = initialVal[3];
        double t = tInitial;
        double newSub = Math.floor((1.0 + Math.abs(tFinal - tInitial)) * (double)numSubdivision);
        double dt = (tFinal - tInitial) / newSub / 2.0;
        newSub -= 0.0625;
        int i = 0;
        while ((double)i < newSub) {
            for (int j = 1; j < 3; ++j) {
                this.dT1.assignTimes(this.kappa * dt / 2.0, this.N);
                this.dN1.assignLinComb(-this.kappa * dt / 2.0, this.T, this.tau(t) * dt / 2.0, this.B);
                this.dB1.assignTimes(-this.tau(t) * dt / 2.0, this.N);
                this.dT2.assignSumTimes(this.N, this.dN1, this.kappa * dt);
                this.dN2.assignSumTimes(this.T, this.dT1, -this.kappa * dt);
                this.Vvv.assignSumTimes(this.B, this.dB1, this.tau(t += dt / 2.0) * dt);
                this.dN2.assignPlus(this.Vvv);
                this.dB2.assignSumTimes(this.N, this.dN1, -this.tau(t) * dt);
                this.dT3.assignLinComb(this.kappa * dt, this.N, this.kappa * dt / 2.0, this.dN2);
                this.dN3.assignLinComb(-this.kappa * dt, this.T, -this.kappa * dt / 2.0, this.dT2);
                this.Vvv.assignLinComb(this.tau(t) * dt, this.B, this.tau(t) * dt / 2.0, this.dB2);
                this.dN3.assignPlus(this.Vvv);
                this.dB3.assignLinComb(-this.tau(t) * dt, this.N, -this.tau(t) * dt / 2.0, this.dN2);
                this.dT4.assignSumTimes(this.N, this.dN3, this.kappa * dt / 2.0);
                this.dN4.assignSumTimes(this.T, this.dT3, -this.kappa * dt / 2.0);
                this.Vvv.assignSumTimes(this.B, this.dB3, this.tau(t += dt / 2.0) * dt / 2.0);
                this.dN4.assignPlus(this.Vvv);
                this.dB4.assignSumTimes(this.N, this.dN3, -this.tau(t) * dt / 2.0);
                this.P = this.P.plus(this.T.times(dt * (double)j * (double)j / 3.0));
                this.Vvv.assignSumTimes(this.dT1, this.dT2, this.dT3, this.dT4, 0.3333333333333333);
                this.T = this.T.plus(this.Vvv);
                this.Vvv.assignSumTimes(this.dN1, this.dN2, this.dN3, this.dN4, 0.3333333333333333);
                this.N = this.N.plus(this.Vvv);
                this.Vvv.assignSumTimes(this.dB1, this.dB2, this.dB3, this.dB4, 0.3333333333333333);
                this.B = this.B.plus(this.Vvv);
            }
            this.P.assignLinComb(1.0, dt / 3.0, this.T);
            ++i;
        }
        return new Vector3D[]{this.P, this.T, this.N, this.B};
    }

    private void createFrenetArray() {
        int i;
        this.getConstants();
        double dt = (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tr;
        double t = this.tmin.getValue();
        this.helperFrame = new Vector3D[4 * (this.tr + 1)];
        this.pointSet = new Vector3D[this.tr + 1];
        this.helperFrame[0] = new Vector3D(0.0, 0.0, 0.0);
        this.helperFrame[1] = new Vector3D(1.0, 0.0, 0.0);
        this.helperFrame[2] = new Vector3D(0.0, 1.0, 0.0);
        this.helperFrame[3] = new Vector3D(0.0, 0.0, 1.0);
        this.pointSet[0] = new Vector3D(this.helperFrame[0]);
        for (i = 0; i < this.tr; ++i) {
            int j;
            for (j = 0; j < 4; ++j) {
                this.initialFrenet[j] = this.helperFrame[j + 4 * i];
            }
            this.repere = this.frenetODEstep4(t, t + dt, this.initialFrenet, 32);
            for (j = 0; j < 4; ++j) {
                this.helperFrame[j + 4 * (i + 1)] = new Vector3D(this.repere[j]);
            }
            this.pointSet[i + 1] = this.helperFrame[4 * (i + 1)];
            t += dt;
        }
        this.startPoint = this.getCenterOfPoints(this.pointSet, this.tr + 1);
        this.startPoint.x = -this.startPoint.x;
        this.startPoint.y = -this.startPoint.y;
        this.startPoint.z = -this.startPoint.z;
        for (i = 0; i <= this.tr; ++i) {
            this.helperFrame[4 * i].assignPlus(this.startPoint);
        }
    }

    @Override
    public Vector3D[] makeRepereMobile(double t) {
        int i = 0;
        double tStart = 0.0;
        if (this.needsNewArray) {
            this.createFrenetArray();
            this.needsNewArray = false;
        }
        i = (int)Math.floor((double)this.tResolution.getValue() * (t - this.tmin.getValue()) / (this.tmax.getValue() - this.tmin.getValue()));
        i = Math.max(0, Math.min(i, this.tResolution.getValue()));
        tStart = this.tmin.getValue() + (double)i * (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
        for (int j = 0; j < 4; ++j) {
            this.initialFrenet[j] = this.helperFrame[j + 4 * i];
        }
        this.repere = this.frenetODEstep4(tStart, t, this.initialFrenet, 16);
        return this.repere;
    }

    @Override
    protected Vector3D value(double t) {
        int i = 0;
        double tStart = 0.0;
        if (this.needsNewArray) {
            this.createFrenetArray();
            this.needsNewArray = false;
        }
        i = (int)Math.floor((double)this.tResolution.getValue() * (t - this.tmin.getValue()) / (this.tmax.getValue() - this.tmin.getValue()));
        i = Math.max(0, Math.min(i, this.tResolution.getValue()));
        tStart = this.tmin.getValue() + (double)i * (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
        for (int j = 0; j < 4; ++j) {
            this.initialFrenet[j] = this.helperFrame[j + 4 * i];
        }
        Vector3D point = this.frenetODEstep4(tStart, t, this.initialFrenet, 16)[0];
        return point;
    }
}

