/*
 * Decompiled with CFR 0.152.
 */
package vmm.pseudospherical;

import vmm.core.Complex;
import vmm.core3D.Vector3D;
import vmm.pseudospherical.ComplexMatrix2D;
import vmm.pseudospherical.nSolitons;

public class ThreeSoliton
extends nSolitons {
    public ThreeSoliton() {
        int j;
        int i;
        this.addParameter(this.s2);
        this.addParameter(this.s1);
        this.addParameter(this.s);
        this.umin.reset(-3.0);
        this.umax.reset(3.0);
        this.vmin.reset("-2*pi/3");
        this.vmax.reset("2*pi/2");
        this.setDefaultWindow(-0.732233, 2.26917, -0.954466, 1.37996);
        this.setDefaultViewpoint(new Vector3D(-2.389, -7.28113, 2.36436));
        this.setDefaultViewUp(new Vector3D(-0.785128, 0.0573582, -0.616672));
        this.lambda = new Complex(0.0, 1.0);
        this.E = new ComplexMatrix2D[4][6];
        for (i = 0; i <= 3; ++i) {
            for (j = 0; j < 6; ++j) {
                this.E[i][j] = new ComplexMatrix2D();
            }
        }
        this.g = new ComplexMatrix2D[4][5];
        for (i = 0; i <= 3; ++i) {
            for (j = 0; j < 5; ++j) {
                this.g[i][j] = new ComplexMatrix2D();
            }
        }
        this.E0 = new ComplexMatrix2D();
        this.getE0(this.xVar, this.s.getValue(), this.lambda);
        this.proj = ComplexMatrix2D.getProj(this.initVec);
        this.proj1 = ComplexMatrix2D.getProj(this.initVec1);
        this.id = new ComplexMatrix2D();
        this.id.setMatrixEntry(Complex.ONE_C, 1, 1);
        this.id.setMatrixEntry(Complex.ZERO_C, 1, 2);
        this.id.setMatrixEntry(Complex.ZERO_C, 2, 1);
        this.id.setMatrixEntry(Complex.ONE_C, 2, 2);
        this.g1 = new ComplexMatrix2D();
        this.g2 = new ComplexMatrix2D();
    }

    @Override
    public synchronized Vector3D surfacePoint(double x, double t) {
        ComplexMatrix2D ret = this.firstSoliton(x, t);
        this.afterFirstSol(x, t);
        ret = this.iterate1(x, t);
        this.afterIterate1(x, t);
        ret = this.iterate2();
        double aa = ret.entries[1][1].im;
        double bb = ret.entries[1][2].re;
        double cc = ret.entries[1][2].im;
        if (Double.isNaN(aa) || Double.isNaN(aa) || Double.isNaN(aa)) {
            cc = 0.0;
            bb = 0.0;
            aa = 0.0;
        }
        return new Vector3D(aa, bb, cc);
    }
}

