/*
 * Decompiled with CFR 0.152.
 */
package vmm.pseudospherical;

import vmm.core.Complex;

public class ComplexVector2D {
    public Complex x;
    public Complex y;

    public ComplexVector2D() {
        this.x = new Complex(Complex.ZERO_C);
        this.y = new Complex(Complex.ZERO_C);
    }

    public ComplexVector2D(Complex x, Complex y) {
        this.x = new Complex(x);
        this.y = new Complex(y);
    }

    public ComplexVector2D(ComplexVector2D v) {
        if (v == null) {
            this.x = this.y = new Complex(0.0, 0.0);
        } else {
            this.x = new Complex(v.x);
            this.y = new Complex(v.y);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(ComplexVector2D.class)) {
            return false;
        }
        ComplexVector2D v = (ComplexVector2D)obj;
        return v.x.equals(this.x) && v.y.equals(this.y);
    }

    public void negate() {
        this.x = this.x.times(-1.0);
        this.y = this.y.times(-1.0);
    }

    public ComplexVector2D plus(ComplexVector2D v) {
        return new ComplexVector2D(this.x.plus(v.x), this.y.plus(v.y));
    }

    public ComplexVector2D minus(ComplexVector2D v) {
        return new ComplexVector2D(this.x.minus(v.x), this.y.minus(v.y));
    }

    public Complex dot(ComplexVector2D v) {
        Complex c1 = new Complex(this.x.times(v.x.conj()));
        Complex c2 = new Complex(this.y.times(v.y.conj()));
        return c1.plus(c2);
    }

    public ComplexVector2D times(Complex d) {
        return new ComplexVector2D(d.times(this.x), d.times(this.y));
    }

    public double norm2() {
        return this.dot((ComplexVector2D)this).re;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

