/*
 * Decompiled with CFR 0.152.
 */
package vmm.pseudospherical;

import vmm.core.Complex;
import vmm.pseudospherical.ComplexVector2D;

public class ComplexMatrix2D {
    Complex[][] entries = new Complex[3][3];

    public ComplexMatrix2D() {
        this.initialize();
    }

    public ComplexMatrix2D(ComplexMatrix2D inp) {
        if (inp == null) {
            this.initialize();
        } else {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.entries[i][j] = inp.entries[i][j];
                }
            }
        }
    }

    public void initialize() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.entries[i][j] = new Complex(0.0, 0.0);
            }
        }
    }

    public Complex getMatrixEntry(int i, int j) {
        if (i <= 0 || i >= 3 || j <= 0 || j >= 3) {
            return null;
        }
        return this.entries[i][j];
    }

    public void setMatrixEntry(Complex val, int i, int j) {
        if (i > 0 && i < 3 && j > 0 && j < 3) {
            this.entries[i][j] = val;
        }
    }

    public ComplexMatrix2D inverse() {
        Complex zero;
        ComplexMatrix2D theInverse = new ComplexMatrix2D();
        Complex determinant = this.entries[1][1].times(this.entries[2][2]).minus(this.entries[2][1].times(this.entries[1][2]));
        if (determinant.equals(zero = new Complex(0.0, 0.0))) {
            return null;
        }
        theInverse.entries[1][1] = this.entries[2][2].dividedBy(determinant);
        theInverse.entries[2][2] = this.entries[1][1].dividedBy(determinant);
        theInverse.entries[1][2] = zero.minus(this.entries[1][2]).dividedBy(determinant);
        theInverse.entries[2][1] = zero.minus(this.entries[2][1]).dividedBy(determinant);
        return theInverse;
    }

    public ComplexMatrix2D multiply(ComplexMatrix2D inp) {
        ComplexMatrix2D theProduct = new ComplexMatrix2D();
        for (int i = 1; i < 3; ++i) {
            for (int j = 1; j < 3; ++j) {
                theProduct.entries[i][j] = new Complex();
                for (int k = 1; k < 3; ++k) {
                    theProduct.entries[i][j] = theProduct.entries[i][j].plus(this.entries[i][k].times(inp.entries[k][j]));
                }
            }
        }
        return theProduct;
    }

    public ComplexMatrix2D transpose() {
        ComplexMatrix2D theTranspose = new ComplexMatrix2D();
        theTranspose.entries[1][1] = this.entries[1][1];
        theTranspose.entries[1][2] = this.entries[2][1];
        theTranspose.entries[2][1] = this.entries[1][2];
        theTranspose.entries[2][2] = this.entries[2][2];
        return theTranspose;
    }

    public ComplexMatrix2D conjugate() {
        ComplexMatrix2D theConjugate = new ComplexMatrix2D();
        theConjugate.entries[1][1] = this.entries[1][1].conj();
        theConjugate.entries[1][2] = this.entries[1][2].conj();
        theConjugate.entries[2][1] = this.entries[2][1].conj();
        theConjugate.entries[2][2] = this.entries[2][2].conj();
        return theConjugate;
    }

    public ComplexMatrix2D add(ComplexMatrix2D inp) {
        ComplexMatrix2D thesum = new ComplexMatrix2D();
        thesum.entries[1][1] = this.entries[1][1].plus(inp.entries[1][1]);
        thesum.entries[1][2] = this.entries[1][2].plus(inp.entries[1][2]);
        thesum.entries[2][1] = this.entries[2][1].plus(inp.entries[2][1]);
        thesum.entries[2][2] = this.entries[2][2].plus(inp.entries[2][2]);
        return thesum;
    }

    public ComplexMatrix2D subtract(ComplexMatrix2D inp) {
        ComplexMatrix2D thedifference = new ComplexMatrix2D();
        thedifference.entries[1][1] = this.entries[1][1].minus(inp.entries[1][1]);
        thedifference.entries[1][2] = this.entries[1][2].minus(inp.entries[1][2]);
        thedifference.entries[2][1] = this.entries[2][1].minus(inp.entries[2][1]);
        thedifference.entries[2][2] = this.entries[2][2].minus(inp.entries[2][2]);
        return thedifference;
    }

    public ComplexMatrix2D scalarMul(Complex c) {
        ComplexMatrix2D theScalarProd = new ComplexMatrix2D();
        theScalarProd.entries[1][1] = this.entries[1][1].times(c);
        theScalarProd.entries[1][2] = this.entries[1][2].times(c);
        theScalarProd.entries[2][1] = this.entries[2][1].times(c);
        theScalarProd.entries[2][2] = this.entries[2][2].times(c);
        return theScalarProd;
    }

    public boolean equals(ComplexMatrix2D inp) {
        return this.entries[1][1].equals(inp.entries[1][1]) && this.entries[1][2].equals(inp.entries[1][2]) && this.entries[2][1].equals(inp.entries[2][1]) && this.entries[2][2].equals(inp.entries[2][2]);
    }

    public String toString() {
        String out = new String();
        out = out + "{{";
        out = out + this.entries[1][1].toString();
        out = out + ",";
        out = out + this.entries[1][2].toString();
        out = out + "},{";
        out = out + this.entries[2][1].toString();
        out = out + ",";
        out = out + this.entries[2][2].toString();
        out = out + "}}";
        return out;
    }

    public static ComplexMatrix2D getProj(ComplexVector2D v) {
        ComplexMatrix2D mat = new ComplexMatrix2D();
        double c = v.norm2();
        mat.entries[1][1] = v.x.times(v.x.conj()).dividedBy(c);
        mat.entries[1][2] = v.x.times(v.y.conj()).dividedBy(c);
        mat.entries[2][1] = v.y.times(v.x.conj()).dividedBy(c);
        mat.entries[2][2] = v.y.times(v.y.conj()).dividedBy(c);
        return mat;
    }

    public ComplexVector2D vectMul(ComplexVector2D v) {
        Complex v1 = new Complex(this.entries[1][1].times(v.x).plus(this.entries[1][2].times(v.y)));
        Complex v2 = new Complex(this.entries[2][1].times(v.x).plus(this.entries[2][2].times(v.y)));
        return new ComplexVector2D(v1, v2);
    }

    public Complex trace() {
        return this.entries[1][1].plus(this.entries[2][2]);
    }

    public Complex determinant() {
        return this.entries[1][1].times(this.entries[2][2]).minus(this.entries[1][2].times(this.entries[2][1]));
    }
}

