/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import vmm.core.Decoration;
import vmm.core.Exhibit;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class TangentAndNormalDecoration
extends Decoration {
    private PlaneCurveParametric curve;
    @VMMSave
    private double t = Double.NaN;

    public PlaneCurveParametric getCurve() {
        return this.curve;
    }

    public void setCurve(PlaneCurveParametric c) {
        this.curve = c;
    }

    public void setT(double t) {
        this.t = t;
        this.fireDecorationChangeEvent();
    }

    public double getT() {
        return this.t;
    }

    public void setIndex(int tIndex) {
        if (this.curve != null) {
            this.setT(this.curve.getT(tIndex));
        }
    }

    @Override
    public void doDraw(Graphics2D g, View view, Transform limits) {
        if (this.curve == null && view != null) {
            Exhibit c = view.getExhibit();
            if (c instanceof PlaneCurveParametric) {
                this.curve = (PlaneCurveParametric)c;
            } else {
                return;
            }
        }
        if (Double.isNaN(this.t)) {
            return;
        }
        double x = this.curve.xValue(this.t);
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            return;
        }
        double y = this.curve.yValue(this.t);
        if (Double.isNaN(y) || Double.isInfinite(y)) {
            return;
        }
        double dx = this.curve.xDerivativeValue(this.t);
        if (Double.isNaN(dx) || Double.isInfinite(dx)) {
            return;
        }
        double dy = this.curve.yDerivativeValue(this.t);
        if (Double.isNaN(dy) || Double.isInfinite(dy)) {
            return;
        }
        double length = Math.sqrt(dx * dx + dy * dy);
        if (length == 0.0) {
            return;
        }
        dx = dx / length * 40.0 * limits.getPixelWidth();
        dy = dy / length * 40.0 * limits.getPixelHeight();
        Color saveColor = g.getColor();
        Stroke saveStroke = g.getStroke();
        g.setStroke(new BasicStroke(2.0f * limits.getDefaultStrokeSize()));
        g.setColor(Color.red);
        g.draw(new Line2D.Double(x, y, x + dx, y + dy));
        g.setColor(Color.blue);
        g.draw(new Line2D.Double(x, y, x - dy, y + dx));
        g.setColor(saveColor);
        g.setStroke(saveStroke);
    }
}

