/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Graphics2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.core.Animation;
import vmm.core.BasicAnimator;
import vmm.core.Decorateable;
import vmm.core.Decoration;
import vmm.core.Parameterizable;
import vmm.core.ThreadedAnimation;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.PlaneCurveParametric;

public abstract class ConicSection
extends PlaneCurveParametric {
    protected abstract void drawFociAndDirectrix(Graphics2D var1, View var2, Transform var3, double var4);

    @Override
    public Animation getCreateAnimation(View view) {
        if (!(view instanceof PlaneCurveParametric.PlaneCurveParametricView)) {
            return null;
        }
        PlaneCurveParametric.PlaneCurveParametricView myView = (PlaneCurveParametric.PlaneCurveParametricView)view;
        return new ConicAnimation(myView);
    }

    @Override
    public BasicAnimator getMorphingAnimation(View view, int looping) {
        final BasicAnimator anim = super.getMorphingAnimation(view, looping);
        if (anim == null) {
            return null;
        }
        Parameterizable owner = view == null ? this : view;
        anim.addChangeListener(new ChangeListener((Decorateable)((Object)owner)){
            Decoration dec;
            final /* synthetic */ Decorateable val$owner;
            {
                this.val$owner = decorateable;
                this.dec = new FocusDirectrixDecoration();
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (anim.isRunning()) {
                    this.val$owner.addDecoration(this.dec);
                } else {
                    this.val$owner.removeDecoration(this.dec);
                }
            }
        });
        return anim;
    }

    private class FocusDirectrixDecoration
    extends Decoration {
        double t = Double.NaN;

        private FocusDirectrixDecoration() {
        }

        void setT(double t) {
            this.t = t;
            this.fireDecorationChangeEvent();
        }

        @Override
        public void doDraw(Graphics2D g, View view, Transform limits) {
            ConicSection.this.drawFociAndDirectrix(g, view, limits, this.t);
        }
    }

    private final class ConicAnimation
    extends ThreadedAnimation {
        private final PlaneCurveParametric.PlaneCurveParametricView view;

        private ConicAnimation(PlaneCurveParametric.PlaneCurveParametricView view) {
            this.view = view;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runAnimation() {
            FocusDirectrixDecoration dec = null;
            try {
                for (int i = 0; i < 50; ++i) {
                    this.view.fractionToDraw = (double)i / 50.0;
                    this.view.forceRedraw();
                    this.pause(20);
                }
                this.view.fractionToDraw = 1.0;
                dec = new FocusDirectrixDecoration();
                this.view.addDecoration(dec);
                this.pause(200);
                int points = ConicSection.this.tResolution.getValue();
                double t = ConicSection.this.tmin.getValue();
                double dt = (ConicSection.this.tmax.getValue() - t) / (double)points;
                for (int reps = 0; reps < 10; ++reps) {
                    for (int i = 0; i <= points; ++i) {
                        dec.setT(t + (double)i * dt);
                        this.pause(35);
                    }
                    this.pause(300);
                }
                this.view.fractionToDraw = 1.0;
            }
            catch (Throwable throwable) {
                this.view.fractionToDraw = 1.0;
                this.view.forceRedraw();
                if (dec != null) {
                    this.view.removeDecoration(dec);
                }
                throw throwable;
            }
            this.view.forceRedraw();
            if (dec != null) {
                this.view.removeDecoration(dec);
            }
        }
    }
}

