/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.secondorder2D;

import vmm.core.RealParamAnimateable;
import vmm.ode.secondorder2D.CentralForce;

public class Yukawa
extends CentralForce {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 2.5);
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", 0.25, 0.2, 0.3);

    public Yukawa() {
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.initialDataDefault = new double[]{0.5, 0.5, -1.25, 2.0};
        this.setDefaultWindow(-3.0, 3.0, -3.0, 3.0);
    }

    @Override
    protected double force(double r) {
        double a = this.aa.getValue();
        double b = this.bb.getValue();
        return -a * Math.exp(-b * r) * (b / r + 1.0 / (r * r));
    }
}

