/*
 * Decompiled with CFR 0.152.
 */
package vmm.latticemodel;

import vmm.core.RealParam;
import vmm.core.View;
import vmm.latticemodel.LatticeModel;

public class Toda
extends LatticeModel {
    protected RealParam a = new RealParam("vmm.latticeModel.Toda.a", 1.0);
    protected RealParam b = new RealParam("vmm.latticeModel.Toda.b", 1.0);

    @Override
    protected double potentialEnergy(double x, double theLatticeSpacing) {
        return (this.a.getValue() / this.b.getValue() * (Math.exp(-this.b.getValue() * x) - 1.0) + this.a.getValue() * x) / (16.0 * theLatticeSpacing);
    }

    @Override
    protected double internalForceLaw(double x, double theLatticeSpacing) {
        return this.a.getValue() * (Math.exp(-this.b.getValue() * x) - 1.0) / (16.0 * theLatticeSpacing);
    }

    @Override
    protected double externalForceLaw(double x, double theLatticeSpacing) {
        return 0.0;
    }

    public Toda() {
        this.canShowNormalModeDisplay = true;
        this.defaultStepSize = 0.03;
        this.defaultAmplitude = 0.5;
        this.defaultScaleFactor = 1.5;
        this.defaultNumberOfNodes = 128;
        this.defaultBoundaryCondition = 1;
        this.defaultInitialShape = 0;
        this.defaultInitialMode = 3;
        this.addParameter(this.b);
        this.addParameter(this.a);
    }

    @Override
    public View getDefaultView() {
        return new TodaView();
    }

    public class TodaView
    extends LatticeModel.LMView {
        @Override
        public LatticeModel.LatticeData getLatticeData() {
            if (this.latticeData == null) {
                this.latticeData = new TodaLatticeData(this);
            }
            return this.latticeData;
        }
    }

    protected class TodaLatticeData
    extends LatticeModel.LatticeData {
        TodaLatticeData(TodaView view) {
            super(view);
            this.youngsModulus = Toda.this.a.getValue() * Toda.this.b.getValue();
        }

        @Override
        public void step(LatticeModel.LMView view) {
            Toda.this.numIterations = 1;
            super.step(view);
            TodaView todaView = (TodaView)view;
        }
    }
}

