/*
 * Decompiled with CFR 0.152.
 */
package vmm.fourier;

import vmm.core.Complex;

public class FastFourier {
    static final int MAXFFTSIZE = 512;
    static Complex[] twid;

    static Complex Cadd(Complex a, Complex b) {
        return a.plus(b);
    }

    static Complex Csub(Complex a, Complex b) {
        return a.minus(b);
    }

    static Complex Cmul(Complex a, Complex b) {
        return a.times(b);
    }

    static Complex Cdiv(Complex a, Complex b) {
        return a.dividedBy(b);
    }

    static Complex RCmul(double a, Complex b) {
        return b.times(a);
    }

    static Complex Cexp(Complex a) {
        return a.exponential();
    }

    static Complex Comp(double a, double b) {
        Complex c = Complex.ZERO_C;
        c.assign(a, b);
        return c;
    }

    static Complex cexp(double x, double y) {
        return FastFourier.RCmul(Math.exp(x), FastFourier.Comp(Math.cos(y), Math.sin(y)));
    }

    static Complex Cconjg(Complex c) {
        return c.conj();
    }

    static double Cabs(Complex c) {
        return c.r();
    }

    static Complex Cexpi(double y) {
        return FastFourier.Comp(Math.cos(y), Math.sin(y));
    }

    private static void SetupTwid() {
        if (twid == null) {
            twid = new Complex[512];
            double h = 0.01227184630308513;
            for (int j = 0; j < 512; ++j) {
                FastFourier.twid[j] = new Complex();
                FastFourier.twid[j].re = Math.cos((double)j * h);
                FastFourier.twid[j].im = Math.sin((double)j * h);
            }
        }
    }

    static void fft(Complex[] c, int J) {
        FastFourier.SetupTwid();
        int i = 0;
        for (int j = 1; j < J; ++j) {
            int bit;
            for (bit = J / 2; i >= bit; i -= bit, bit /= 2) {
            }
            if ((i += bit) >= j) continue;
            Complex temp = c[i];
            c[i] = c[j];
            c[j] = temp;
        }
        int numtrans = J;
        int sizetrans = 1;
        while (numtrans > 1) {
            numtrans /= 2;
            int halfsize = sizetrans;
            sizetrans *= 2;
            for (int in = 0; in < halfsize; ++in) {
                Complex twiddle = twid[in * numtrans];
                for (int sub = 0; sub < numtrans; ++sub) {
                    int iplus = sub * sizetrans + in;
                    int iminus = iplus + halfsize;
                    Complex but1 = c[iplus];
                    Complex but2 = FastFourier.Cmul(twiddle, c[iminus]);
                    c[iplus] = FastFourier.Cadd(but1, but2);
                    c[iminus] = FastFourier.Csub(but1, but2);
                }
            }
        }
    }

    static void ifft(Complex[] c, int J) {
        int k;
        FastFourier.SetupTwid();
        double oJ = 1.0 / (double)J;
        for (k = 0; k < J; ++k) {
            c[k] = FastFourier.Cconjg(c[k]);
        }
        FastFourier.fft(c, J);
        for (k = 0; k < J; ++k) {
            c[k] = FastFourier.RCmul(oJ, FastFourier.Cconjg(c[k]));
        }
    }

    public static Complex[] ffTransform(Complex[] c, int J) {
        Complex[] ffTransform_c = new Complex[c.length];
        for (int i = 0; i < c.length; ++i) {
            ffTransform_c[i] = new Complex(c[i]);
        }
        FastFourier.fft(ffTransform_c, J);
        return ffTransform_c;
    }

    public static Complex[] iffTransform(Complex[] c, int J) {
        Complex[] inverseTransform_c = new Complex[c.length];
        for (int i = 0; i < c.length; ++i) {
            inverseTransform_c[i] = new Complex(c[i]);
        }
        FastFourier.ifft(inverseTransform_c, J);
        return inverseTransform_c;
    }
}

