/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ToggleAction;
import vmm.core.I18n;
import vmm.core.SaveAndRestore;
import vmm.core.Util;
import vmm.core.VMMSave;
import vmm.core3D.DirectionalLight;
import vmm.core3D.LightSettings;
import vmm.core3D.LightSettingsDialog;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public class View3DWithLightSettings
extends View3D {
    @VMMSave
    private boolean lightingEnabled = true;
    private LightSettings anaglyphLightSettings;
    private LightSettings nonAnaglyphLightSettings;
    protected AbstractActionVMM lightSettingsCommand = new AbstractActionVMM(I18n.tr("vmm.core3D.commands.LightSettings")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            LightSettingsDialog.showDialog(View3DWithLightSettings.this);
        }
    };
    protected ToggleAction lightingEnabledToggle = new ToggleAction(I18n.tr("vmm.core3D.commands.EnableLighting"), true){

        @Override
        public void actionPerformed(ActionEvent evt) {
            View3DWithLightSettings.this.setLightingEnabled(this.getState());
        }
    };

    public View3DWithLightSettings() {
        this.anaglyphLightSettings = this.nonAnaglyphLightSettings = new LightSettings();
    }

    public LightSettings getLightSettings() {
        return this.getViewStyle() == 1 ? this.anaglyphLightSettings : this.nonAnaglyphLightSettings;
    }

    public void setLightSettings(LightSettings lightSettings) {
        if (lightSettings != null) {
            if (this.anaglyphLightSettings == this.nonAnaglyphLightSettings) {
                this.anaglyphLightSettings = this.nonAnaglyphLightSettings = lightSettings;
            } else if (this.getViewStyle() == 1) {
                this.anaglyphLightSettings = lightSettings;
            } else {
                this.nonAnaglyphLightSettings = lightSettings;
            }
        }
    }

    protected void setAnaglyphLightSettings(LightSettings lightSettings) {
        if (lightSettings != null) {
            this.anaglyphLightSettings = lightSettings;
        }
    }

    protected void setNonAnaglyphLightSettings(LightSettings lightSettings) {
        if (lightSettings != null) {
            this.nonAnaglyphLightSettings = lightSettings;
        }
    }

    public boolean getLightingEnabled() {
        return this.lightingEnabled;
    }

    public void setLightingEnabled(boolean lightingEnabled) {
        if (this.lightingEnabled == lightingEnabled) {
            return;
        }
        this.lightingEnabled = lightingEnabled;
        this.lightingEnabledToggle.setState(lightingEnabled);
        this.forceRedraw();
    }

    @Override
    public void setViewStyle(int viewStyle) {
        super.setViewStyle(viewStyle);
        this.setLightSettings(viewStyle == 1 ? this.anaglyphLightSettings : this.nonAnaglyphLightSettings);
    }

    @Override
    public ActionList getSettingsCommands() {
        ActionList commands = super.getSettingsCommands();
        this.lightSettingsCommand.setEnabled(this.getEnableThreeD());
        commands.add(null);
        commands.add(this.lightingEnabledToggle);
        commands.add(this.lightSettingsCommand);
        return commands;
    }

    @Override
    public void addExtraXML(Document containingDocument, Element viewElement) {
        super.addExtraXML(containingDocument, viewElement);
        Element lightSettingsElement = containingDocument.createElement("light-settings");
        this.addLightToXML(containingDocument, lightSettingsElement, this.nonAnaglyphLightSettings);
        viewElement.appendChild(lightSettingsElement);
        if (this.anaglyphLightSettings != this.nonAnaglyphLightSettings) {
            lightSettingsElement = containingDocument.createElement("light-settings-anaglyph");
            this.addLightToXML(containingDocument, lightSettingsElement, this.anaglyphLightSettings);
            viewElement.appendChild(lightSettingsElement);
        }
    }

    private void addLightToXML(Document containingDocument, Element lightSettingsElement, LightSettings lightSettings) {
        Element light;
        SaveAndRestore.addProperty(lightSettings, "specularRatio", containingDocument, lightSettingsElement);
        SaveAndRestore.addProperty(lightSettings, "specularExponent", containingDocument, lightSettingsElement);
        SaveAndRestore.addProperty(lightSettings, "light0", containingDocument, lightSettingsElement);
        SaveAndRestore.addProperty(lightSettings, "ambientLight", containingDocument, lightSettingsElement);
        if (lightSettings.getDirectionalLight1() != null) {
            light = containingDocument.createElement("light1");
            light.setAttribute("color", Util.toExternalString(lightSettings.getDirectionalLight1().getItsColor()));
            light.setAttribute("direction", Util.toExternalString(lightSettings.getDirectionalLight1().getItsDirection()));
            lightSettingsElement.appendChild(light);
        }
        if (lightSettings.getDirectionalLight2() != null) {
            light = containingDocument.createElement("light2");
            light.setAttribute("color", Util.toExternalString(lightSettings.getDirectionalLight2().getItsColor()));
            light.setAttribute("direction", Util.toExternalString(lightSettings.getDirectionalLight2().getItsDirection()));
            lightSettingsElement.appendChild(light);
        }
        if (lightSettings.getDirectionalLight3() != null) {
            light = containingDocument.createElement("light3");
            light.setAttribute("color", Util.toExternalString(lightSettings.getDirectionalLight3().getItsColor()));
            light.setAttribute("direction", Util.toExternalString(lightSettings.getDirectionalLight3().getItsDirection()));
            lightSettingsElement.appendChild(light);
        }
    }

    @Override
    public void readExtraXML(Element viewInfo) throws IOException {
        LightSettings lightSettings;
        super.readExtraXML(viewInfo);
        Element lightSettingsElement = SaveAndRestore.getChildElement(viewInfo, "light-settings");
        if (lightSettingsElement == null) {
            return;
        }
        this.nonAnaglyphLightSettings = this.anaglyphLightSettings = (lightSettings = this.readLightFromXML(lightSettingsElement));
        lightSettingsElement = SaveAndRestore.getChildElement(viewInfo, "light-settings-anaglyph");
        if (lightSettingsElement != null) {
            this.anaglyphLightSettings = lightSettings = this.readLightFromXML(lightSettingsElement);
        }
    }

    private LightSettings readLightFromXML(Element lightSettingsElement) throws IOException {
        Vector3D direction;
        Color color;
        LightSettings lightSettings = new LightSettings();
        SaveAndRestore.readProperties(lightSettings, lightSettingsElement);
        Element lightElement = SaveAndRestore.getChildElement(lightSettingsElement, "light1");
        if (lightElement != null) {
            try {
                color = (Color)Util.externalStringToValue(lightElement.getAttribute("color"), Color.class);
            }
            catch (Exception e) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", lightElement.getAttribute("color"), "color"));
            }
            try {
                direction = (Vector3D)Util.externalStringToValue(lightElement.getAttribute("direction"), Vector3D.class);
                direction.normalize();
            }
            catch (Exception e) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", lightElement.getAttribute("direction"), "direction"));
            }
            lightSettings.setDirectionalLight1(new DirectionalLight(color, direction));
        }
        if ((lightElement = SaveAndRestore.getChildElement(lightSettingsElement, "light2")) != null) {
            try {
                color = (Color)Util.externalStringToValue(lightElement.getAttribute("color"), Color.class);
            }
            catch (Exception e) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", lightElement.getAttribute("color"), "color"));
            }
            try {
                direction = (Vector3D)Util.externalStringToValue(lightElement.getAttribute("direction"), Vector3D.class);
                direction.normalize();
            }
            catch (Exception e) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", lightElement.getAttribute("direction"), "direction"));
            }
            lightSettings.setDirectionalLight2(new DirectionalLight(color, direction));
        }
        if ((lightElement = SaveAndRestore.getChildElement(lightSettingsElement, "light3")) != null) {
            try {
                color = (Color)Util.externalStringToValue(lightElement.getAttribute("color"), Color.class);
            }
            catch (Exception e) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", lightElement.getAttribute("color"), "color"));
            }
            try {
                direction = (Vector3D)Util.externalStringToValue(lightElement.getAttribute("direction"), Vector3D.class);
                direction.normalize();
            }
            catch (Exception e) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", lightElement.getAttribute("direction"), "direction"));
            }
            lightSettings.setDirectionalLight3(new DirectionalLight(color, direction));
        }
        return lightSettings;
    }
}

