/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import vmm.core.Complex;
import vmm.core3D.Vector3D;

public class ComplexVector3D {
    public Complex x;
    public Complex y;
    public Complex z;
    static final Complex ZERO_C = new Complex(0.0, 0.0);
    static final Complex ONE_C = new Complex(1.0, 0.0);
    public static final ComplexVector3D ORIGIN = new ComplexVector3D();
    public static final ComplexVector3D UNIT_X = new ComplexVector3D(ONE_C, ZERO_C, ZERO_C);
    public static final ComplexVector3D UNIT_Y = new ComplexVector3D(ZERO_C, ONE_C, ZERO_C);
    public static final ComplexVector3D UNIT_Z = new ComplexVector3D(ZERO_C, ZERO_C, ONE_C);

    public ComplexVector3D() {
        this.x = new Complex(0.0, 0.0);
        this.y = new Complex(0.0, 0.0);
        this.z = new Complex(0.0, 0.0);
    }

    public ComplexVector3D(Complex x, Complex y, Complex z) {
        if (x == null || y == null || z == null) {
            this.x = new Complex(0.0, 0.0);
            this.y = new Complex(0.0, 0.0);
            this.z = new Complex(0.0, 0.0);
        } else {
            this.x = new Complex(x);
            this.y = new Complex(y);
            this.z = new Complex(z);
        }
    }

    public void assign(Complex a, Complex b, Complex c) {
        this.x.assign(a);
        this.y.assign(b);
        this.z.assign(c);
    }

    public ComplexVector3D(Vector3D rea, Vector3D ima) {
        if (rea == null && ima == null) {
            this.x = new Complex(0.0, 0.0);
            this.y = new Complex(0.0, 0.0);
            this.z = new Complex(0.0, 0.0);
        } else if (ima == null) {
            this.x = new Complex(rea.x, 0.0);
            this.y = new Complex(rea.y, 0.0);
            this.z = new Complex(rea.z, 0.0);
        } else if (rea == null) {
            this.x = new Complex(0.0, ima.x);
            this.y = new Complex(0.0, ima.y);
            this.z = new Complex(0.0, ima.z);
        } else {
            this.x = new Complex(rea.x, ima.x);
            this.y = new Complex(rea.y, ima.y);
            this.z = new Complex(rea.z, ima.z);
        }
    }

    public ComplexVector3D(ComplexVector3D v) {
        if (v == null) {
            this.x = new Complex(0.0, 0.0);
            this.y = new Complex(0.0, 0.0);
            this.z = new Complex(0.0, 0.0);
        } else if (v.x == null || v.y == null || v.z == null) {
            this.x = new Complex(0.0, 0.0);
            this.y = new Complex(0.0, 0.0);
            this.z = new Complex(0.0, 0.0);
        } else {
            this.x = new Complex(v.x);
            this.y = new Complex(v.y);
            this.z = new Complex(v.z);
        }
    }

    public void assign(ComplexVector3D v) {
        this.x.assign(v.x);
        this.y.assign(v.y);
        this.z.assign(v.z);
    }

    public boolean equals(Object obj) {
        try {
            ComplexVector3D v = (ComplexVector3D)obj;
            if (this.x == null && v.x != null) {
                return false;
            }
            if (this.y == null && v.y != null) {
                return false;
            }
            if (this.z == null && v.z != null) {
                return false;
            }
            return this.x.equals(v.x) && this.y.equals(v.y) && this.z.equals(v.z);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Vector3D re() {
        Vector3D v = new Vector3D();
        v.x = this.x.re;
        v.y = this.y.re;
        v.z = this.z.re;
        return v;
    }

    public Vector3D im() {
        Vector3D v = new Vector3D();
        v.x = this.x.im;
        v.y = this.y.im;
        v.z = this.z.im;
        return v;
    }

    public double norm() {
        return Math.sqrt(this.re().norm2() + this.im().norm2());
    }

    public void normalize() {
        double lengthRecip = 1.0 / Math.sqrt(this.norm());
        if (Double.isNaN(lengthRecip) || Double.isInfinite(lengthRecip)) {
            this.z.re = Double.NaN;
            this.y.re = Double.NaN;
            this.x.re = Double.NaN;
            this.z.im = Double.NaN;
            this.y.im = Double.NaN;
            this.x.im = Double.NaN;
        } else {
            this.x = this.x.times(lengthRecip);
            this.y = this.y.times(lengthRecip);
            this.z = this.z.times(lengthRecip);
        }
    }

    public void negate() {
        this.x = this.x.times(-1.0);
        this.y = this.y.times(-1.0);
        this.z = this.z.times(-1.0);
    }

    public ComplexVector3D plus(ComplexVector3D v) {
        return new ComplexVector3D(this.x.plus(v.x), this.y.plus(v.y), this.z.plus(v.z));
    }

    public void assignPlus(ComplexVector3D v) {
        this.x.assignPlus(v.x);
        this.y.assignPlus(v.y);
        this.z.assignPlus(v.z);
    }

    public ComplexVector3D minus(ComplexVector3D v) {
        return new ComplexVector3D(this.x.minus(v.x), this.y.minus(v.y), this.z.minus(v.z));
    }

    public void assignMinus(ComplexVector3D v) {
        this.x.assignMinus(v.x);
        this.y.assignMinus(v.y);
        this.z.assignMinus(v.z);
    }

    public ComplexVector3D times(Complex d) {
        return new ComplexVector3D(this.x.times(d), this.y.times(d), this.z.times(d));
    }

    public ComplexVector3D times(double r) {
        return new ComplexVector3D(this.x.times(r), this.y.times(r), this.z.times(r));
    }

    public void assignTimes(Complex d) {
        this.x.assignTimes(d);
        this.y.assignTimes(d);
        this.z.assignTimes(d);
    }

    public void assignTimes(double r) {
        this.x.assignTimes(r);
        this.y.assignTimes(r);
        this.z.assignTimes(r);
    }
}

