/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import vmm.core.Display;
import vmm.core.MouseTask;
import vmm.core.TimerAnimation;
import vmm.core.View;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public class BasicMouseTask3D
extends MouseTask {
    private int operation;
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private static final int ROTATE = 3;
    private static final int MOVE_NORMAL_TO_SCREEN = 4;
    private int startx;
    private int starty;
    private int prevx;
    private int prevy;
    private double[] startWindow;
    private double requestedAspectRatio;
    private Transform3D transform;
    private double virtualSphereRadius;
    private Vector3D previousRay;
    private Vector3D currentRay;
    private long lastDragTime;
    private long mouseDownTime;
    private boolean startedDragging;
    private boolean saveFastDrawing;
    private boolean isStereographView;
    private Rectangle stereographLeftEyeRect;
    private Rectangle stereographRightEyeRect;
    private boolean inLeftEyeRect;
    private Transform3D stereographTransform;
    private double zoom_startx_real;
    private double zoom_starty_real;
    private double zoom_startx_pixel;
    private double zoom_starty_pixel;
    private double originalObjectDisplacementNormalToScreen;

    @Override
    public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
        this.operation = 0;
        if (view.getExhibit() == null) {
            return false;
        }
        try {
            this.startWindow = view.getWindow();
            this.transform = (Transform3D)view.getTransform();
            this.requestedAspectRatio = Math.abs((this.transform.getYmaxRequested() - this.transform.getYminRequested()) / (this.transform.getXmaxRequested() - this.transform.getXminRequested()));
        }
        catch (Exception e) {
            return false;
        }
        this.operation = view instanceof View3D && ((View3D)view).getViewStyle() == 1 && evt.isAltDown() && evt.isShiftDown() ? 4 : (evt.isAltDown() || evt.isShiftDown() ? 2 : (evt.isControlDown() || evt.isMetaDown() ? 1 : 3));
        this.startx = this.prevx = evt.getX();
        this.starty = this.prevy = evt.getY();
        boolean bl = this.isStereographView = view instanceof View3D && (((View3D)view).getViewStyle() == 2 || ((View3D)view).getViewStyle() == 3);
        if (this.isStereographView && !(view.getTransform() instanceof Transform3D)) {
            return false;
        }
        if (this.isStereographView && this.operation != 1) {
            this.stereographLeftEyeRect = ((View3D)view).stereographLeftEyeRect();
            this.stereographRightEyeRect = ((View3D)view).stereographRightEyeRect();
            if (this.stereographLeftEyeRect.contains(this.startx, this.starty)) {
                this.startx = this.prevx = this.startx - this.stereographLeftEyeRect.x;
                this.starty = this.prevy = this.starty - this.stereographLeftEyeRect.y;
                this.inLeftEyeRect = true;
            } else if (this.stereographRightEyeRect.contains(this.startx, this.starty)) {
                this.startx = this.prevx = this.startx - this.stereographRightEyeRect.x;
                this.starty = this.prevy = this.starty - this.stereographRightEyeRect.y;
                this.inLeftEyeRect = false;
            } else {
                return false;
            }
            this.stereographTransform = (Transform3D)view.getTransform().clone();
            this.stereographTransform.setUpDrawInfo(null, 0, 0, this.stereographLeftEyeRect.width, this.stereographLeftEyeRect.height, view.getPreserveAspect(), view.getApplyGraphics2DTransform());
        }
        if (this.operation == 2) {
            this.operation = 2;
            if (this.isStereographView) {
                this.zoom_startx_real = this.stereographTransform.getXmin() + (double)this.startx * ((this.stereographTransform.getXmax() - this.stereographTransform.getXmin()) / (double)this.stereographTransform.getWidth());
                this.zoom_starty_real = this.stereographTransform.getYmin() + (double)(this.stereographTransform.getHeight() - this.starty) * ((this.stereographTransform.getYmax() - this.stereographTransform.getYmin()) / (double)this.stereographTransform.getHeight());
                Point2D.Double pt = new Point2D.Double(this.startx, this.starty);
                this.stereographTransform.viewportToWindow(pt);
                this.transform.windowToViewport(pt);
                this.zoom_startx_pixel = ((Point2D)pt).getX();
                this.zoom_starty_pixel = ((Point2D)pt).getY();
            } else {
                this.zoom_startx_real = this.startWindow[0] + (double)this.startx * ((this.startWindow[1] - this.startWindow[0]) / (double)width);
                this.zoom_starty_real = this.startWindow[2] + (double)(height - this.starty) * ((this.startWindow[3] - this.startWindow[2]) / (double)height);
                this.zoom_startx_pixel = this.startx;
                this.zoom_starty_pixel = this.starty;
            }
        } else if (this.operation == 3) {
            this.virtualSphereRadius = this.isStereographView ? 0.48 * Math.min(Math.abs(this.stereographTransform.getXmax() - this.stereographTransform.getXmin()), Math.abs(this.stereographTransform.getYmax() - this.stereographTransform.getYmin())) : 0.48 * Math.min(Math.abs(this.transform.getXmax() - this.transform.getXmin()), Math.abs(this.transform.getYmax() - this.transform.getYmin()));
            this.operation = 3;
        } else if (this.operation == 4) {
            this.originalObjectDisplacementNormalToScreen = ((Transform3D)view.getTransform()).getObjectDisplacementNormalToScreen();
        }
        this.saveFastDrawing = view.getFastDrawing();
        this.mouseDownTime = evt.getWhen();
        this.startedDragging = false;
        return true;
    }

    @Override
    public void doMouseDrag(MouseEvent evt, Display display, View view, int width, int height) {
        if (this.operation == 0) {
            return;
        }
        if (!this.startedDragging && evt.getWhen() - this.mouseDownTime < 300L && Math.abs(evt.getX() - this.startx) < 3 && Math.abs(evt.getY() - this.starty) < 3) {
            return;
        }
        if (!this.startedDragging) {
            this.startedDragging = true;
            view.setFastDrawing(true);
        }
        if (this.operation == 4) {
            double extent = Math.max(this.transform.getXmax() - this.transform.getXmin(), this.transform.getYmax() - this.transform.getYmin());
            double change = (double)(evt.getY() - this.starty) / (double)(height / 2) * extent;
            this.transform.setObjectDisplacementNormalToScreen(this.originalObjectDisplacementNormalToScreen + change);
            return;
        }
        int newoperation = evt.isAltDown() || evt.isShiftDown() ? 2 : (evt.isControlDown() || evt.isMetaDown() ? 1 : 3);
        if (newoperation != this.operation) {
            this.operation = newoperation;
            this.startx = this.prevx = evt.getX();
            this.starty = this.prevy = evt.getY();
            if (this.isStereographView && this.operation != 1) {
                if (this.inLeftEyeRect) {
                    this.startx = this.prevx = this.startx - this.stereographLeftEyeRect.x;
                    this.starty = this.prevy = this.starty - this.stereographLeftEyeRect.y;
                } else {
                    this.startx = this.prevx = this.startx - this.stereographRightEyeRect.x;
                    this.starty = this.prevy = this.starty - this.stereographRightEyeRect.y;
                }
                this.stereographTransform = (Transform3D)view.getTransform().clone();
                this.stereographTransform.setUpDrawInfo(null, 0, 0, this.stereographLeftEyeRect.width, this.stereographLeftEyeRect.height, view.getPreserveAspect(), view.getApplyGraphics2DTransform());
            }
            this.startWindow = view.getWindow();
            if (newoperation == 2) {
                if (this.isStereographView) {
                    this.zoom_startx_real = this.stereographTransform.getXmin() + (double)this.startx * ((this.stereographTransform.getXmax() - this.stereographTransform.getXmin()) / (double)this.stereographTransform.getWidth());
                    this.zoom_starty_real = this.stereographTransform.getYmin() + (double)(this.stereographTransform.getHeight() - this.starty) * ((this.stereographTransform.getYmax() - this.stereographTransform.getYmin()) / (double)this.stereographTransform.getHeight());
                    Point2D.Double pt = new Point2D.Double(this.startx, this.starty);
                    this.stereographTransform.viewportToWindow(pt);
                    this.transform.windowToViewport(pt);
                    this.zoom_startx_pixel = ((Point2D)pt).getX();
                    this.zoom_starty_pixel = ((Point2D)pt).getY();
                } else {
                    this.zoom_startx_real = this.startWindow[0] + (double)this.startx * ((this.startWindow[1] - this.startWindow[0]) / (double)width);
                    this.zoom_starty_real = this.startWindow[2] + (double)(height - this.starty) * ((this.startWindow[3] - this.startWindow[2]) / (double)height);
                    this.zoom_startx_pixel = this.startx;
                    this.zoom_starty_pixel = this.starty;
                }
            } else if (newoperation == 3) {
                this.virtualSphereRadius = this.isStereographView ? 0.48 * Math.min(Math.abs(this.stereographTransform.getXmax() - this.stereographTransform.getXmin()), Math.abs(this.stereographTransform.getYmax() - this.stereographTransform.getYmin())) : 0.48 * Math.min(Math.abs(this.transform.getXmax() - this.transform.getXmin()), Math.abs(this.transform.getYmax() - this.transform.getYmin()));
            }
            return;
        }
        int currentX = evt.getX();
        int currentY = evt.getY();
        if (this.isStereographView && this.operation != 1) {
            if (this.inLeftEyeRect) {
                currentX -= this.stereographLeftEyeRect.x;
                currentY -= this.stereographLeftEyeRect.y;
            } else {
                currentX -= this.stereographRightEyeRect.x;
                currentY -= this.stereographRightEyeRect.y;
            }
        }
        switch (this.operation) {
            case 1: {
                double offsetY;
                double offsetX;
                if (this.isStereographView) {
                    int offset = evt.getX() - this.prevx;
                    if (offset != 0) {
                        ((View3D)view).moveStereographImages(offset);
                    }
                    this.prevx = evt.getX();
                    break;
                }
                double pixelWidth = Math.abs(this.startWindow[1] - this.startWindow[0]) / (double)width;
                double pixelHeight = Math.abs(this.startWindow[3] - this.startWindow[2]) / (double)height;
                if (this.isStereographView) {
                    double pixelWidthS = Math.abs(this.stereographTransform.getXmax() - this.stereographTransform.getXmin()) / (double)this.stereographLeftEyeRect.width;
                    double pixelHeightS = Math.abs(this.stereographTransform.getYmax() - this.stereographTransform.getYmin()) / (double)this.stereographLeftEyeRect.height;
                    offsetX = (double)(this.startx - currentX) * pixelWidthS;
                    offsetY = (double)(-(this.starty - currentY)) * pixelHeightS;
                } else {
                    offsetX = (double)(this.startx - currentX) * pixelWidth;
                    offsetY = (double)(-(this.starty - currentY)) * pixelHeight;
                }
                this.newWindow(view, this.startWindow[0] + offsetX, this.startWindow[1] + offsetX, this.startWindow[2] + offsetY, this.startWindow[3] + offsetY);
                view.forceRedraw();
                break;
            }
            case 2: {
                if (this.isStereographView) {
                    width = this.stereographTransform.getWidth();
                    height = this.stereographTransform.getHeight();
                }
                double diff = (double)(-(this.starty - currentY)) / 200.0;
                double mag = Math.exp(diff);
                double newwidth = (this.startWindow[1] - this.startWindow[0]) * mag;
                double newheight = (this.startWindow[3] - this.startWindow[2]) * mag;
                double newpixelwidth = newwidth / (double)width;
                double newpixelheight = newheight / (double)height;
                double newxmin = this.zoom_startx_real - newpixelwidth * this.zoom_startx_pixel;
                double newxmax = newxmin + newwidth;
                double newymin = this.zoom_starty_real - newpixelheight * ((double)height - this.zoom_starty_pixel);
                double newymax = newymin + newheight;
                this.newWindow(view, newxmin, newxmax, newymin, newymax);
                view.forceRedraw();
                break;
            }
            case 3: {
                if (this.prevx == currentX && this.prevy == currentY) break;
                this.previousRay = this.mousePointToRay(this.prevx, this.prevy);
                this.currentRay = this.mousePointToRay(currentX, currentY);
                this.transform.applyTransvection(this.previousRay, this.currentRay);
                this.prevx = currentX;
                this.prevy = currentY;
                view.forceRedraw();
                this.lastDragTime = evt.getWhen();
            }
        }
    }

    @Override
    public void doMouseUp(MouseEvent evt, Display display, final View view, int width, int height) {
        if (!this.startedDragging || this.operation == 0) {
            return;
        }
        boolean keepGoing = false;
        if (this.operation == 3) {
            display.repaint();
            final boolean fast = this.saveFastDrawing;
            final Transform3D tr = this.transform;
            final Vector3D ray1 = this.previousRay;
            final Vector3D ray2 = this.currentRay;
            if (evt.getWhen() - this.lastDragTime < 200L && this.currentRay != null && this.currentRay.minus(this.previousRay).norm() >= 0.002) {
                keepGoing = true;
                display.installAnimation(new TimerAnimation(0, 50){

                    @Override
                    protected void drawFrame() {
                        tr.applyTransvection(ray1, ray2);
                        view.forceRedraw();
                    }

                    @Override
                    protected void animationEnding() {
                        view.setFastDrawing(fast);
                    }
                });
            }
        }
        if (!keepGoing) {
            view.setFastDrawing(this.saveFastDrawing);
        }
        this.transform = null;
        this.currentRay = null;
        this.previousRay = null;
        this.stereographLeftEyeRect = null;
        this.stereographRightEyeRect = null;
        this.stereographTransform = null;
        this.operation = 0;
    }

    @Override
    public Cursor getCursorForDragging(MouseEvent mouseDownEvent, Display display, View view) {
        if (this.operation == 1) {
            return Cursor.getPredefinedCursor(13);
        }
        if (this.operation == 2) {
            return Cursor.getPredefinedCursor(9);
        }
        return null;
    }

    private Vector3D mousePointToRay(int x, int y) {
        Vector3D answer;
        Transform3D theTransform = this.isStereographView ? this.stereographTransform : this.transform;
        Point2D.Double pt = new Point2D.Double(x, y);
        theTransform.viewportToWindow(pt);
        Vector3D xdir = theTransform.getImagePlaneXDirection();
        Vector3D ydir = theTransform.getImagePlaneYDirection();
        double vx = ((Point2D)pt).getX() * xdir.x + ((Point2D)pt).getY() * ydir.x;
        double vy = ((Point2D)pt).getX() * xdir.y + ((Point2D)pt).getY() * ydir.y;
        double vz = ((Point2D)pt).getX() * xdir.z + ((Point2D)pt).getY() * ydir.z;
        double normSquared = vx * vx + vy * vy + vz * vz;
        if (normSquared > this.virtualSphereRadius * this.virtualSphereRadius) {
            double len = Math.sqrt(normSquared);
            answer = new Vector3D(vx * this.virtualSphereRadius / len, vy * this.virtualSphereRadius / len, vz * this.virtualSphereRadius / len);
        } else {
            double z = Math.sqrt(this.virtualSphereRadius * this.virtualSphereRadius - normSquared);
            Vector3D zdir = theTransform.getViewDirection();
            answer = new Vector3D(vx - z * zdir.x, vy - z * zdir.y, vz - z * zdir.z);
        }
        answer.normalize();
        return answer;
    }

    private void newWindow(View view, double xmin, double xmax, double ymin, double ymax) {
        double aspect = Math.abs((ymax - ymin) / (xmax - xmin));
        if (aspect > this.requestedAspectRatio) {
            double shrinkFactor = this.requestedAspectRatio / aspect;
            double newHeight = (ymax - ymin) * shrinkFactor;
            double middle = (ymax + ymin) / 2.0;
            ymin = middle - newHeight / 2.0;
            ymax = middle + newHeight / 2.0;
        } else {
            double shrinkFactor = aspect / this.requestedAspectRatio;
            double newWidth = (xmax - xmin) * shrinkFactor;
            double middle = (xmax + xmin) / 2.0;
            xmin = middle - newWidth / 2.0;
            xmax = middle + newWidth / 2.0;
        }
        view.setWindow(xmin, xmax, ymin, ymax);
    }
}

