/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import vmm.actions.AbstractActionVMM;
import vmm.core.Animateable;
import vmm.core.Complex;
import vmm.core.ComplexVariableParam;
import vmm.core.ComplexVariableParamAnimateable;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.ParameterInput;
import vmm.core.Parameterizable;
import vmm.core.SaveAndRestore;
import vmm.core.VariableParam;
import vmm.core.VariableParamAnimateable;
import vmm.core.View;
import vmm.functions.ComplexFunction;
import vmm.functions.Function;
import vmm.functions.ParseError;
import vmm.functions.Parser;

public interface UserExhibit
extends Parameterizable {
    public Support getUserExhibitSupport();

    public Parameter[] getParameters();

    public double[] getDefaultWindow();

    public void setDefaultWindow(double[] var1);

    public View getDefaultView();

    public static class Support {
        private final UserExhibit exhibit;
        private ArrayList<FunctionInfo> functions = new ArrayList();
        private ArrayList<Parameter> functionParameters = new ArrayList();
        private boolean showWindow = true;
        private boolean allowNewParameters = true;
        private boolean allowChangeUserDataCommand = true;

        public Support(UserExhibit exhibit) {
            this.exhibit = exhibit;
        }

        public void addFunctionParameter(VariableParam p) {
            this.functionParameters.add(p);
            p.setOwner(this.exhibit);
        }

        public void addFunctionParameter(ComplexVariableParam p) {
            this.functionParameters.add(p);
            p.setOwner(this.exhibit);
        }

        public FunctionInfo addRealFunction(String name, String definition, String ... argumentName) {
            FunctionInfo f = new FunctionInfo(name, definition, argumentName, false);
            this.functions.add(f);
            return f;
        }

        public FunctionInfo addComplexFunction(String name, String definition, String ... argumentName) {
            FunctionInfo f = new FunctionInfo(name, definition, argumentName, true);
            this.functions.add(f);
            return f;
        }

        public int getFunctionCount() {
            return this.functions.size();
        }

        public FunctionInfo getFunctionInfo(int index) {
            return this.functions.get(index);
        }

        public Parameter[] getFunctionParameters() {
            Parameter[] array = new Parameter[this.functionParameters.size()];
            this.functionParameters.toArray(array);
            return array;
        }

        public boolean getAllowChangeUserDataCommand() {
            return this.allowChangeUserDataCommand;
        }

        public void setAllowChangeUserDataCommand(boolean allowChangeUserDataCommand) {
            this.allowChangeUserDataCommand = allowChangeUserDataCommand;
        }

        public boolean getAllowNewParameters() {
            return this.allowNewParameters;
        }

        public void setAllowNewParameters(boolean allowNewParameters) {
            this.allowNewParameters = allowNewParameters;
        }

        public boolean getShowWindow() {
            return this.showWindow;
        }

        public void setShowWindow(boolean showWindow) {
            this.showWindow = showWindow;
        }

        public View defaults() {
            View view = this.exhibit.getDefaultView();
            Dialog dialog = this.createDialog(null, view, true);
            boolean ok = dialog.getData();
            if (!ok) {
                return null;
            }
            this.finish(dialog, view, true);
            return view;
        }

        public View showCreateDialog(Display display) {
            View view = this.exhibit.getDefaultView();
            Dialog dialog = this.createDialog(display, view, true);
            boolean ok = dialog.showDialog();
            if (!ok) {
                return null;
            }
            this.finish(dialog, view, true);
            return view;
        }

        public boolean showChangeDialog(Display display, View view) {
            Dialog dialog = this.createDialog(display, view, false);
            boolean ok = dialog.showDialog();
            if (!ok) {
                return false;
            }
            this.finish(dialog, view, false);
            return true;
        }

        public AbstractActionVMM makeChangeUserDataAction(final View view) {
            return new AbstractActionVMM(I18n.tr("vmm.core.UserExhibitDialog.SetUserData")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (Support.this.showChangeDialog(view.getDisplay(), view) && view.getExhibit() != null) {
                        view.getExhibit().forceRedraw();
                    }
                }
            };
        }

        public void addToXML(Document containingDocument, Element userDataElement) {
            for (Parameter param : this.functionParameters) {
                Element paramElement = containingDocument.createElement("functionParam");
                SaveAndRestore.buildParameterElement(containingDocument, paramElement, param);
                paramElement.setAttribute("isComplex", param instanceof ComplexVariableParam ? "yes" : "no");
                paramElement.setAttribute("isAnimateable", param instanceof Animateable ? "yes" : "no");
                userDataElement.appendChild(paramElement);
            }
            for (FunctionInfo func : this.functions) {
                Element functionElement = containingDocument.createElement("function");
                functionElement.setAttribute("name", func.name);
                functionElement.setAttribute("definition", func.definition);
                userDataElement.appendChild(functionElement);
            }
            SaveAndRestore.addProperties(this, new String[]{"allowChangeUserDataCommand", "showWindow", "allowNewParameters"}, containingDocument, userDataElement);
        }

        public void readFromXML(Element userDataElement) throws IOException {
            int i;
            ArrayList<VariableParamAnimateable> functionParameters = new ArrayList<VariableParamAnimateable>();
            Parser parser = new Parser();
            NodeList paramCandidates = userDataElement.getChildNodes();
            for (i = 0; i < paramCandidates.getLength(); ++i) {
                Node node = paramCandidates.item(i);
                if (!(node instanceof Element) || !((Element)node).getTagName().equals("functionParam")) continue;
                Element paramInfo = (Element)node;
                String name = paramInfo.getAttribute("name").trim();
                boolean isComplex = "yes".equalsIgnoreCase(paramInfo.getAttribute("isComplex"));
                boolean isAnimateable = "yes".equalsIgnoreCase(paramInfo.getAttribute("isAnimateable"));
                Parameter param = isComplex ? (isAnimateable ? new ComplexVariableParamAnimateable(name, new Complex()) : new ComplexVariableParam(name, new Complex())) : (isAnimateable ? new VariableParamAnimateable(name, 0.0) : new VariableParam(name, 0.0));
                SaveAndRestore.setParamInfoFromElement(param, paramInfo);
                functionParameters.add((VariableParamAnimateable)param);
                if (param instanceof ComplexVariableParam) {
                    parser.add(((ComplexVariableParam)param).getVariable());
                    continue;
                }
                parser.add(((VariableParam)param).getVariable());
            }
            for (i = 0; i < paramCandidates.getLength(); ++i) {
                Node node = paramCandidates.item(i);
                if (!(node instanceof Element) || !((Element)node).getTagName().equals("function")) continue;
                Element functionElement = (Element)node;
                String name = functionElement.getAttribute("name").trim();
                String definition = functionElement.getAttribute("definition").trim();
                FunctionInfo info = null;
                for (FunctionInfo f : this.functions) {
                    if (!f.getName().equalsIgnoreCase(name)) continue;
                    info = f;
                    break;
                }
                if (info == null) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.UnknownFunctionInUserExhibitData", name));
                }
                info.definition = definition;
                try {
                    if (info.isComplex) {
                        info.function = parser.parseComplexFunction(info.name, definition, info.argumentNames);
                        continue;
                    }
                    info.function = parser.parseFunction(info.name, definition, info.argumentNames);
                    continue;
                }
                catch (ParseError e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadExpressionDefinition"));
                }
            }
            for (Parameter parameter : functionParameters) {
                parameter.setOwner(null);
            }
            this.functionParameters = functionParameters;
            for (Parameter parameter : functionParameters) {
                parameter.setOwner(this.exhibit);
            }
            SaveAndRestore.readProperties(this, userDataElement);
        }

        protected Dialog createDialog(Display display, View view, boolean creating) {
            Container c;
            for (c = display; c != null && !(c instanceof JFrame); c = c.getParent()) {
            }
            Dialog dialog = new Dialog((JFrame)c, "");
            if (this.showWindow) {
                double[] window = creating ? this.exhibit.getDefaultWindow() : view.getRequestedWindow();
                dialog.showViewWindowLimits(window[0], window[1], window[2], window[3]);
            }
            if (this.allowNewParameters) {
                dialog.allowNewParameters();
            }
            return dialog;
        }

        protected void finish(Dialog dialog, View view, boolean creating) {
            view.setWindow(dialog.getWindow());
            this.exhibit.setDefaultWindow(dialog.getWindow());
        }

        protected class Dialog
        extends JDialog {
            private JFrame parent;
            private ArrayList<ParameterInput> parameterInputs;
            private ArrayList<JTextField> functionInputs;
            private ArrayList<ExtraPanel> extraPanels;
            private JPanel expressionPromptPanel;
            private JPanel expressionInputPanel;
            private JPanel parameterPanel;
            private boolean parameterPanelAdded;
            private JPanel windowPanel;
            private Box inputPane;
            private JPanel buttons;
            private JButton okButton;
            private JButton cancelButton;
            private JButton addParameterButton;
            private JButton removeParameterButton;
            private double[] window;
            private JTextField[] windowInputs;
            private boolean showParameters;
            private boolean canceled;

            protected Dialog(JFrame parent, String title) {
                super(parent, title, true);
                this.parameterInputs = new ArrayList();
                this.functionInputs = new ArrayList();
                this.parent = parent;
                Parameter[] exhibitParameters = Support.this.exhibit.getParameters();
                JPanel contentPane = new JPanel();
                contentPane.setLayout(new BorderLayout(8, 8));
                this.setContentPane(contentPane);
                this.inputPane = Box.createVerticalBox();
                JScrollPane scroller = new JScrollPane(this.inputPane, 20, 30);
                contentPane.add((Component)scroller, "Center");
                this.okButton = new JButton(I18n.tr("buttonNames.OK"));
                this.cancelButton = new JButton(I18n.tr("buttonNames.Cancel"));
                this.addParameterButton = new JButton(I18n.tr("buttonNames.AddParameter"));
                this.removeParameterButton = new JButton(I18n.tr("buttonNames.RemoveParameter"));
                ButtonHandler buttonHandler = new ButtonHandler();
                this.okButton.addActionListener(buttonHandler);
                this.cancelButton.addActionListener(buttonHandler);
                this.addParameterButton.addActionListener(buttonHandler);
                this.removeParameterButton.addActionListener(buttonHandler);
                this.removeParameterButton.setEnabled(Support.this.functionParameters.size() > 0);
                this.buttons = new JPanel();
                this.buttons.setLayout(new FlowLayout(2, 8, 8));
                this.buttons.add(this.cancelButton);
                this.buttons.add(this.okButton);
                contentPane.add((Component)this.buttons, "South");
                JPanel expressionPanel = new JPanel();
                expressionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), I18n.tr("vmm.core.UserExhibitDialog.EnterExpressions")), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
                expressionPanel.setLayout(new BorderLayout(5, 5));
                this.expressionPromptPanel = new JPanel();
                this.expressionPromptPanel.setLayout(new GridLayout(0, 1, 5, 5));
                expressionPanel.add((Component)this.expressionPromptPanel, "West");
                this.expressionInputPanel = new JPanel();
                this.expressionInputPanel.setLayout(new GridLayout(0, 1, 5, 5));
                expressionPanel.add((Component)this.expressionInputPanel, "Center");
                for (FunctionInfo funcInfo : Support.this.functions) {
                    this.expressionPromptPanel.add(new JLabel(funcInfo.prompt, 4));
                    JTextField in = new JTextField(funcInfo.definition, 40);
                    this.functionInputs.add(in);
                    this.expressionInputPanel.add((Component)in, "Center");
                }
                this.inputPane.add(expressionPanel);
                this.parameterPanel = new JPanel();
                this.parameterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), I18n.tr("vmm.core.UserExhibitDialog.Parameters")), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
                this.parameterPanel.setLayout(new GridLayout(0, 4, 5, 5));
                Color red = new Color(180, 0, 0);
                JLabel label = new JLabel(I18n.tr("vmm.core.ParameterDialog.ParameterName"), 0);
                label.setForeground(red);
                this.parameterPanel.add(label);
                label = new JLabel(I18n.tr("vmm.core.ParameterDialog.ParameterValue"), 0);
                label.setForeground(red);
                this.parameterPanel.add(label);
                label = new JLabel(I18n.tr("vmm.core.ParameterDialog.AnimationStartValue"), 0);
                label.setForeground(red);
                this.parameterPanel.add(label);
                label = new JLabel(I18n.tr("vmm.core.ParameterDialog.AnimationEndValue"), 0);
                label.setForeground(red);
                this.parameterPanel.add(label);
                if (Support.this.functionParameters.size() > 0) {
                    for (Parameter p : Support.this.functionParameters) {
                        this.addParamInputs(p);
                    }
                }
                if (exhibitParameters != null && exhibitParameters.length > 0) {
                    JPanel exhibitParamPanel = new JPanel();
                    exhibitParamPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), I18n.tr("vmm.core.UserExhibitDialog.ExhibitParameters")), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
                    exhibitParamPanel.setLayout(new GridLayout(0, 4, 5, 5));
                    for (int i = 0; i < exhibitParameters.length; ++i) {
                        Parameter p = exhibitParameters[i];
                        exhibitParamPanel.add(new JLabel(p.getTitle() + " = ", 4));
                        ParameterInput in0 = p.createParameterInput(0);
                        this.parameterInputs.add(in0);
                        exhibitParamPanel.add(in0);
                        if (p instanceof Animateable) {
                            ParameterInput in1 = p.createParameterInput(1);
                            this.parameterInputs.add(in1);
                            exhibitParamPanel.add(in1);
                            ParameterInput in2 = p.createParameterInput(2);
                            this.parameterInputs.add(in2);
                            exhibitParamPanel.add(in2);
                            continue;
                        }
                        exhibitParamPanel.add(new JLabel());
                        exhibitParamPanel.add(new JLabel());
                    }
                    this.inputPane.add(exhibitParamPanel);
                }
                if (this.extraPanels != null) {
                    for (ExtraPanel extraInput : this.extraPanels) {
                        this.inputPane.add(extraInput);
                    }
                }
                this.buttons.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "cancel");
                this.buttons.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "ok");
                this.buttons.getActionMap().put("cancel", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Dialog.this.cancelButton.doClick();
                    }
                });
                this.buttons.getActionMap().put("ok", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Dialog.this.okButton.doClick();
                    }
                });
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        Dialog.this.canceled = true;
                        Dialog.this.dispose();
                    }
                });
            }

            public void addExtraPanel(ExtraPanel inputPanel) {
                if (this.extraPanels == null) {
                    this.extraPanels = new ArrayList();
                }
                this.extraPanels.add(inputPanel);
                this.inputPane.add(inputPanel);
            }

            private boolean showDialog() {
                if (this.parent != null) {
                    this.setLocation(this.parent.getX() + 20, this.parent.getY() + 40);
                }
                this.checkBounds();
                this.canceled = false;
                this.setVisible(true);
                return !this.canceled;
            }

            private void checkBounds() {
                this.pack();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                if (this.getHeight() > screenSize.height - 30) {
                    this.setSize(this.getWidth() + 30, screenSize.height - 30);
                }
                if (this.getLocation().y + this.getHeight() > screenSize.height - 3) {
                    this.setLocation(this.getLocation().x, screenSize.height - this.getHeight() - 3);
                }
                if (this.getLocation().x + this.getWidth() > screenSize.width - 3) {
                    this.setLocation(screenSize.width - 3 - this.getWidth(), this.getLocation().y);
                }
            }

            private void makeWindowInputPanel(double[] initialWindow) {
                this.windowPanel = new JPanel();
                this.windowPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), I18n.tr("vmm.core.UserExhibitDialog.ViewLimits")), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
                this.windowPanel.setLayout(new GridLayout(0, 4, 5, 5));
                this.windowInputs = new JTextField[initialWindow.length];
                for (int i = 0; i < initialWindow.length; ++i) {
                    this.windowInputs[i] = new JTextField("" + initialWindow[i]);
                }
                this.windowPanel.add(new JLabel(I18n.tr("common.xmin") + " = ", 4));
                this.windowPanel.add(this.windowInputs[0]);
                this.windowPanel.add(new JLabel(I18n.tr("common.xmax") + " = ", 4));
                this.windowPanel.add(this.windowInputs[1]);
                this.windowPanel.add(new JLabel(I18n.tr("common.ymin") + " = ", 4));
                this.windowPanel.add(this.windowInputs[2]);
                this.windowPanel.add(new JLabel(I18n.tr("common.ymax") + " = ", 4));
                this.windowPanel.add(this.windowInputs[3]);
            }

            private void errorMessage(String message) {
                JOptionPane.showMessageDialog(this, message, I18n.tr("vmm.core.UserExhibitDialog.errorTitle"), 0);
            }

            private void allowNewParameters() {
                if (!this.showParameters) {
                    this.showParameters = true;
                    this.buttons.add((Component)this.addParameterButton, 0);
                    this.buttons.add((Component)this.removeParameterButton, 0);
                    this.buttons.validate();
                }
            }

            private void doAddParameter() {
                JCheckBox isComplex = new JCheckBox(I18n.tr("vmm.core.UserExhibitDialog.ParameterIsComplex"));
                JCheckBox isAnimateable = new JCheckBox(I18n.tr("vmm.core.UserExhibitDialog.ParameterIsAnimateable"), true);
                JPanel top = new JPanel();
                top.add(new JLabel(I18n.tr("vmm.core.UserExhibitDialog.ParameterName")));
                JTextField nameInput = new JTextField(4);
                top.add(nameInput);
                JPanel panel = new JPanel();
                panel.setLayout(new GridLayout(3, 1, 10, 10));
                panel.add(top);
                panel.add(isComplex);
                panel.add(isAnimateable);
                int response = JOptionPane.showConfirmDialog(this, panel, I18n.tr("vmm.core.UserExhibitDialog.AddParameterTitle"), 2, -1);
                if (response == 2) {
                    return;
                }
                String paramName = nameInput.getText();
                if (paramName == null || paramName.trim().length() == 0) {
                    return;
                }
                if (!Character.isLetter((paramName = paramName.trim()).charAt(0))) {
                    this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.BadParamName"));
                    return;
                }
                for (int i = 0; i < paramName.length(); ++i) {
                    if (Character.isLetterOrDigit(paramName.charAt(i))) continue;
                    this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.BadParamName"));
                    return;
                }
                for (Parameter p : Support.this.functionParameters) {
                    if (!p.getName().equalsIgnoreCase(paramName)) continue;
                    this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.DuplicateParam", paramName));
                    return;
                }
                Parameter p = isComplex.isSelected() ? (isAnimateable.isSelected() ? new ComplexVariableParamAnimateable(paramName, new Complex(1.0), new Complex(-5.0), new Complex(5.0)) : new ComplexVariableParam(paramName, new Complex(1.0))) : (isAnimateable.isSelected() ? new VariableParamAnimateable(paramName, 1.0, -5.0, 5.0) : new VariableParam(paramName, 1.0));
                Support.this.functionParameters.add(p);
                p.setOwner(Support.this.exhibit);
                this.addParamInputs(p);
                this.removeParameterButton.setEnabled(true);
                this.validate();
                this.checkBounds();
            }

            private void doRemoveParameter() {
                final JDialog dlg = new JDialog(this, I18n.tr("vmm.core.UserExhibitDialog.RemoveParameterDialogTitle"), true);
                dlg.setDefaultCloseOperation(2);
                JPanel deleteButtons = new JPanel();
                deleteButtons.setLayout(new GridLayout(0, 1, 7, 7));
                deleteButtons.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
                int i = 0;
                while (i < Support.this.functionParameters.size()) {
                    JButton b = new JButton(((Parameter)Support.this.functionParameters.get(i)).getTitle());
                    deleteButtons.add(b);
                    final int paramNum = i++;
                    b.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            dlg.dispose();
                            Parameter p = (Parameter)Support.this.functionParameters.get(paramNum);
                            Support.this.functionParameters.remove(paramNum);
                            p.setOwner(null);
                            Dialog.this.parameterPanel.remove(4 * (paramNum + 1) + 3);
                            Dialog.this.parameterPanel.remove(4 * (paramNum + 1) + 2);
                            Dialog.this.parameterPanel.remove(4 * (paramNum + 1) + 1);
                            Dialog.this.parameterPanel.remove(4 * (paramNum + 1));
                            for (int i = Dialog.this.parameterInputs.size() - 1; i >= 0; --i) {
                                if (((ParameterInput)Dialog.this.parameterInputs.get(i)).getParameter() != p) continue;
                                Dialog.this.parameterInputs.remove(i);
                            }
                            Dialog.this.validate();
                            if (Support.this.functionParameters.size() == 0) {
                                Dialog.this.removeParameterButton.setEnabled(false);
                            }
                            Dialog.this.checkBounds();
                        }
                    });
                }
                JPanel content = new JPanel();
                dlg.setContentPane(content);
                content.setLayout(new BorderLayout(7, 7));
                content.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
                content.add((Component)new JLabel(I18n.tr("vmm.core.UserExhibitDialog.RemoveParameterDialogPrompt")), "North");
                JPanel middle = new JPanel();
                middle.add(deleteButtons);
                content.add((Component)middle, "Center");
                JPanel bottom = new JPanel();
                JButton cb = new JButton(I18n.tr("buttonNames.Cancel"));
                cb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        dlg.dispose();
                    }
                });
                bottom.add(cb);
                content.add((Component)bottom, "South");
                dlg.pack();
                dlg.setLocation(this.getLocation().x + 15, this.getLocation().y + 25);
                dlg.setVisible(true);
            }

            private boolean getData() {
                int i;
                int i2;
                Object[] newFunctions = new Object[this.functionInputs.size()];
                Parser parser = new Parser();
                for (Parameter parameter : Support.this.functionParameters) {
                    if (parameter instanceof ComplexVariableParam) {
                        parser.add(((ComplexVariableParam)parameter).getVariable());
                        continue;
                    }
                    parser.add(((VariableParam)parameter).getVariable());
                }
                for (int i22 = 0; i22 < this.functionInputs.size(); ++i22) {
                    try {
                        FunctionInfo functionInfo = (FunctionInfo)Support.this.functions.get(i22);
                        if (functionInfo.isComplex) {
                            newFunctions[i22] = parser.parseComplexFunction(functionInfo.name, this.functionInputs.get(i22).getText(), functionInfo.argumentNames);
                            continue;
                        }
                        newFunctions[i22] = parser.parseFunction(functionInfo.name, this.functionInputs.get(i22).getText(), functionInfo.argumentNames);
                        continue;
                    }
                    catch (ParseError parseError) {
                        this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.parseError", this.functionInputs.get(i22).getText(), parseError.getMessage()));
                        this.functionInputs.get(i22).requestFocus();
                        this.functionInputs.get(i22).selectAll();
                        return false;
                    }
                }
                if (this.windowInputs != null) {
                    this.window = new double[4];
                    for (i2 = 0; i2 < 4; ++i2) {
                        try {
                            this.window[i2] = Double.parseDouble(this.windowInputs[i2].getText());
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            String which = "common.";
                            if (i2 == 0) {
                                which = which + "xmin";
                            } else if (i2 == 1) {
                                which = which + "xmax";
                            } else if (i2 == 2) {
                                which = which + "ymin";
                            } else if (i2 == 3) {
                                which = which + "ymax";
                            }
                            this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.badReal", I18n.tr(which)));
                            this.windowInputs[i2].requestFocus();
                            this.windowInputs[i2].selectAll();
                            return false;
                        }
                    }
                    if (this.window[1] <= this.window[0]) {
                        this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.badRange", I18n.tr("common.xmax"), I18n.tr("common.xmin")));
                        this.windowInputs[1].requestFocus();
                        this.windowInputs[1].selectAll();
                        return false;
                    }
                    if (this.window[3] <= this.window[2]) {
                        this.errorMessage(I18n.tr("vmm.core.UserExhibitDialog.error.badRange", I18n.tr("common.ymax"), I18n.tr("common.ymin")));
                        this.windowInputs[1].requestFocus();
                        this.windowInputs[1].selectAll();
                        return false;
                    }
                }
                for (i2 = 0; i2 < this.parameterInputs.size(); ++i2) {
                    String string = this.parameterInputs.get(i2).checkContents();
                    if (string == null) continue;
                    this.errorMessage(string);
                    return false;
                }
                if (this.extraPanels != null) {
                    for (ExtraPanel extraPanel : this.extraPanels) {
                        try {
                            extraPanel.checkData();
                        }
                        catch (IllegalArgumentException e) {
                            this.errorMessage(e.getMessage());
                        }
                    }
                }
                for (i = 0; i < this.functionInputs.size(); ++i) {
                    ((FunctionInfo)Support.this.functions.get(i)).function = newFunctions[i];
                    ((FunctionInfo)Support.this.functions.get(i)).definition = this.functionInputs.get(i).getText();
                }
                for (i = 0; i < this.parameterInputs.size(); ++i) {
                    this.parameterInputs.get(i).setValueAndDefaultFromContents();
                }
                if (this.extraPanels != null) {
                    for (ExtraPanel extraPanel : this.extraPanels) {
                        extraPanel.commitData();
                    }
                }
                return true;
            }

            private void addParamInputs(Parameter p) {
                ParameterInput input0 = p.createParameterInput(0);
                this.parameterInputs.add(input0);
                this.parameterPanel.add(new JLabel(p.getTitle() + " = ", 4));
                this.parameterPanel.add(input0);
                if (p instanceof Animateable) {
                    ParameterInput input1 = p.createParameterInput(1);
                    ParameterInput input2 = p.createParameterInput(2);
                    this.parameterInputs.add(input1);
                    this.parameterInputs.add(input2);
                    this.parameterPanel.add(input1);
                    this.parameterPanel.add(input2);
                } else {
                    this.parameterPanel.add(new JLabel());
                    this.parameterPanel.add(new JLabel());
                }
                if (!this.parameterPanelAdded) {
                    this.inputPane.add((Component)this.parameterPanel, 1);
                    this.parameterPanelAdded = true;
                }
            }

            private void showViewWindowLimits(double xmin, double xmax, double ymin, double ymax) {
                this.makeWindowInputPanel(new double[]{xmin, xmax, ymin, ymax});
                this.inputPane.add(this.windowPanel);
            }

            public double[] getWindow() {
                if (this.window == null) {
                    return null;
                }
                return (double[])this.window.clone();
            }

            private class ButtonHandler
            implements ActionListener {
                private ButtonHandler() {
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Object src = evt.getSource();
                    if (src == Dialog.this.cancelButton) {
                        Dialog.this.canceled = true;
                        Dialog.this.dispose();
                    } else if (src == Dialog.this.addParameterButton) {
                        Dialog.this.doAddParameter();
                    } else if (src == Dialog.this.removeParameterButton) {
                        Dialog.this.doRemoveParameter();
                    } else if (src == Dialog.this.okButton && Dialog.this.getData()) {
                        Dialog.this.canceled = false;
                        Dialog.this.dispose();
                    }
                }
            }
        }

        protected static abstract class ExtraPanel
        extends JPanel {
            public ExtraPanel(String title) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), title), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
            }

            public void commitData() {
            }

            public abstract void checkData() throws IllegalArgumentException;
        }
    }

    public static class FunctionInfo {
        private Object function;
        private final boolean isComplex;
        private final String name;
        private final String[] argumentNames;
        private String prompt;
        private String definition;

        private FunctionInfo(String name, String definition, String[] argumentNames, boolean isComplex) {
            this.name = name;
            this.definition = definition;
            this.argumentNames = argumentNames;
            this.isComplex = isComplex;
            this.setPrompt(null);
        }

        public double realFunctionValue(double ... arg) {
            return ((Function)this.function).value(arg);
        }

        public Complex complexFunctionValue(Complex ... arg) {
            return ((ComplexFunction)this.function).value(arg);
        }

        public Complex complexFunctionValue(double ... arg) {
            return ((ComplexFunction)this.function).value(arg);
        }

        public Function getRealFunction() {
            return (Function)this.function;
        }

        public ComplexFunction getComplexFunction() {
            return (ComplexFunction)this.function;
        }

        public String[] getArgumentNames() {
            return this.argumentNames;
        }

        public String getDefinition() {
            return this.definition;
        }

        public boolean getIsComplex() {
            return this.isComplex;
        }

        public String getName() {
            return this.name;
        }

        public void setPrompt(String prompt) {
            if (prompt != null) {
                this.prompt = prompt;
            } else {
                this.prompt = this.name;
                this.prompt = this.prompt + "(";
                if (this.argumentNames != null && this.argumentNames.length > 0) {
                    for (int i = 0; i < this.argumentNames.length; ++i) {
                        this.prompt = this.prompt + this.argumentNames[i];
                        this.prompt = this.prompt + (i == this.argumentNames.length - 1 ? ") = " : ",");
                    }
                }
            }
        }
    }
}

