/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import vmm.core.Animateable;
import vmm.core.Complex;
import vmm.core.ComplexParam;
import vmm.core.Decoration;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.Parameter;
import vmm.core.RealParam;
import vmm.core.Transform;
import vmm.core.UserExhibit;
import vmm.core.Util;
import vmm.core.VMMSave;
import vmm.core.View;

public class SaveAndRestore {
    public static Exhibit readExhibitFromXML(File in) throws IOException {
        return SaveAndRestore.readExhibitFromXML(new FileInputStream(in), in.getName());
    }

    public static Exhibit convertXMLToExhibit(Document exhibitDocument) {
        try {
            Exhibit exhibit;
            Element exhibitInfo = exhibitDocument.getDocumentElement();
            if (!exhibitInfo.getTagName().equals("exhibit-info")) {
                throw new IllegalArgumentException();
            }
            Element exhibitElement = SaveAndRestore.getChildElement(exhibitInfo, "exhibit");
            if (exhibitElement == null) {
                throw new IllegalArgumentException();
            }
            if (exhibitInfo.getElementsByTagName("exhibit").getLength() > 1) {
                throw new IllegalArgumentException();
            }
            try {
                exhibit = SaveAndRestore.buildExhibitFromElement(exhibitElement);
            }
            catch (Exception e) {
                throw new IllegalArgumentException();
            }
            NodeList viewCandidates = exhibitInfo.getChildNodes();
            for (int i = 0; i < viewCandidates.getLength(); ++i) {
                Node child = viewCandidates.item(i);
                if (!(child instanceof Element) || !((Element)child).getTagName().equals("view")) continue;
                Element viewInfo = (Element)child;
                SaveAndRestore.buildViewFromElement(viewInfo, exhibit);
            }
            return exhibit;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(I18n.tr("vmm.core.SaveAndRestore.error.NotValidExhibitDocument"));
        }
    }

    public static Exhibit readExhibitFromXML(InputStream in, String inputName) throws IOException {
        Exhibit exhibit;
        Document doc = SaveAndRestore.readXMLDocument(in, inputName);
        Element exhibitInfo = doc.getDocumentElement();
        if (!exhibitInfo.getTagName().equals("exhibit-info")) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.NotAnExhibitInfoFile", inputName, exhibitInfo.getTagName()));
        }
        Element exhibitElement = SaveAndRestore.getChildElement(exhibitInfo, "exhibit");
        if (exhibitElement == null) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingExhibitElement", inputName));
        }
        if (exhibitInfo.getElementsByTagName("exhibit").getLength() > 1) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.TooManyExhibitElements", inputName));
        }
        try {
            exhibit = SaveAndRestore.buildExhibitFromElement(exhibitElement);
        }
        catch (Exception e) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.IllegalDataInFile", inputName, e.getMessage()));
        }
        NodeList viewCandidates = exhibitInfo.getChildNodes();
        for (int i = 0; i < viewCandidates.getLength(); ++i) {
            Node child = viewCandidates.item(i);
            if (!(child instanceof Element) || !((Element)child).getTagName().equals("view")) continue;
            Element viewInfo = (Element)child;
            SaveAndRestore.buildViewFromElement(viewInfo, exhibit);
        }
        return exhibit;
    }

    public static Document readXMLDocument(File file) throws IOException {
        return SaveAndRestore.readXMLDocument(new FileInputStream(file), file.getName());
    }

    public static Document readXMLDocument(InputStream in, String inputName) throws IOException {
        Document doc;
        DocumentBuilder reader;
        try {
            reader = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantGetDocumentBuilder"));
        }
        try {
            doc = reader.parse(in);
        }
        catch (SAXException e) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.IllegalXMLFile", inputName, e.getMessage()));
        }
        catch (IOException e) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.InputError", inputName, e.getMessage()));
        }
        return doc;
    }

    public static Document exhibitToXML(Exhibit exhibit, View view) {
        View[] viewArray;
        if (view == null) {
            viewArray = null;
        } else {
            View[] viewArray2 = new View[1];
            viewArray = viewArray2;
            viewArray2[0] = view;
        }
        return SaveAndRestore.exhibitToXML(exhibit, viewArray);
    }

    public static Document exhibitToXML(Exhibit exhibit) {
        ArrayList<View> views = exhibit.getViews();
        if (views == null || views.size() == 0) {
            return SaveAndRestore.exhibitToXML(exhibit, (View[])null);
        }
        View[] viewArray = new View[views.size()];
        views.toArray(viewArray);
        return SaveAndRestore.exhibitToXML(exhibit, viewArray);
    }

    public static Document exhibitToXML(Exhibit exhibit, View[] views) {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new RuntimeException(I18n.tr("vmm.core.SaveAndRestore.error.CantGetDocumentBuilder"));
        }
        Document exhibitDocument = builder.getDOMImplementation().createDocument(null, "exhibit-info", null);
        Element exhibitInfoElement = exhibitDocument.getDocumentElement();
        Element exhibitElement = exhibitDocument.createElement("exhibit");
        exhibitInfoElement.appendChild(exhibitElement);
        SaveAndRestore.buildExhibitElement(exhibitDocument, exhibitElement, exhibit);
        if (views != null) {
            for (int i = 0; i < views.length; ++i) {
                Element viewElement = exhibitDocument.createElement("view");
                SaveAndRestore.buildViewElement(exhibitDocument, viewElement, views[i]);
                exhibitInfoElement.appendChild(viewElement);
            }
        }
        return exhibitDocument;
    }

    public static void writeXMLDocument(PrintWriter out, Document doc) {
        out.println("<?xml version=\"1.0\"?>");
        SaveAndRestore.writeElement(out, doc.getDocumentElement(), "");
    }

    public static void addProperties(Object propertyOwner, String[] propertyNames, Document document, Element element) {
        for (int i = 0; i < propertyNames.length; ++i) {
            SaveAndRestore.addProperty(propertyOwner, propertyNames[i], document, element);
        }
    }

    public static void addProperty(Object propertyOwner, String propertyName, Document document, Element element) {
        Element propertyElement = document.createElement("property");
        try {
            Method readMethod = new PropertyDescriptor(propertyName, propertyOwner.getClass()).getReadMethod();
            Object value = readMethod.invoke(propertyOwner, (Object[])null);
            String valueString = Util.toExternalString(value);
            propertyElement.setAttribute("name", propertyName);
            propertyElement.setAttribute("value", valueString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't access property \"" + propertyName + "\".");
        }
        element.appendChild(propertyElement);
    }

    public static void readProperties(Object owner, Element containingElement) throws IOException {
        NodeList children = containingElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element) || !((Element)child).getTagName().equals("property")) continue;
            Element propertyElement = (Element)child;
            String propertyName = propertyElement.getAttribute("name").trim();
            if (propertyName.length() == 0) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingPropertyName"));
            }
            if (!propertyElement.hasAttribute("value")) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingValueAttribute", "property/" + propertyName));
            }
            try {
                Method writeMethod;
                String valueString = propertyElement.getAttribute("value");
                try {
                    writeMethod = new PropertyDescriptor(propertyName, owner.getClass()).getWriteMethod();
                }
                catch (IntrospectionException e) {
                    continue;
                }
                Class<?>[] parameterTypes = writeMethod.getParameterTypes();
                Object value = Util.externalStringToValue(valueString, parameterTypes[0]);
                writeMethod.invoke(owner, value);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.ErrorReadingProperty", propertyName, e.getMessage()));
            }
        }
    }

    public static void addDecorationElement(Document doc, Element parentElement, Decoration dec) {
        Element decorationElement = doc.createElement("decoration");
        String classname = dec.getClass().getName();
        decorationElement.setAttribute("class", classname);
        SaveAndRestore.addSavedProperties(dec, doc, decorationElement);
        dec.addExtraXML(doc, decorationElement);
        parentElement.appendChild(decorationElement);
    }

    public static void addElement(Document containingDocument, Element parentElement, String name, Object value) {
        Element child = containingDocument.createElement(name);
        child.setAttribute("value", Util.toExternalString(value));
        parentElement.appendChild(child);
    }

    public static Object getChildElementValue(Element parentElement, String name, Class valueType) {
        Element child = SaveAndRestore.getChildElement(parentElement, name);
        if (child == null) {
            return null;
        }
        String valueString = child.getAttribute("value");
        if (valueString == null || valueString.length() == 0) {
            return null;
        }
        try {
            return Util.externalStringToValue(valueString, valueType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Element makeTransformElement(String nodeName, Document doc, Transform transform) {
        Element transformElement = doc.createElement(nodeName);
        transformElement.setAttribute("class", transform.getClass().getName());
        Element windowElement = doc.createElement("window");
        windowElement.setAttribute("limits", transform.getXminRequested() + " " + transform.getXmaxRequested() + " " + transform.getYminRequested() + " " + transform.getYmaxRequested());
        transformElement.appendChild(windowElement);
        SaveAndRestore.addSavedProperties(transform, doc, transformElement);
        return transformElement;
    }

    public static Transform buildTransformFromElement(Element transformElement) throws IOException {
        Transform transform;
        String transformClassName = transformElement.getAttribute("class");
        try {
            transform = (Transform)SaveAndRestore.createObjectFromClassName(transformClassName, null);
        }
        catch (Exception e) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", transformClassName));
        }
        Element windowElement = SaveAndRestore.getChildElement(transformElement, "window");
        if (windowElement != null) {
            double[] window;
            String str = windowElement.getAttribute("limits");
            try {
                window = (double[])Util.externalStringToValue(str, double[].class);
            }
            catch (Exception e) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", str, "window"));
            }
            if (window.length != 4) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", str, "window"));
            }
            transform.setLimits(window[0], window[1], window[2], window[3]);
        }
        if (transform != null) {
            SaveAndRestore.readProperties(transform, transformElement);
        }
        return transform;
    }

    public static Element getChildElement(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element) || !((Element)child).getTagName().equals(tagName)) continue;
            return (Element)child;
        }
        return null;
    }

    private static Object createObjectFromClassName(String classname, Object possiblyContainingObject) throws Exception {
        Class<?> theClass = Class.forName(classname);
        try {
            return theClass.newInstance();
        }
        catch (Exception exception) {
            Class<?>[] parameterTypes;
            int i;
            if (possiblyContainingObject == null) {
                throw new Exception();
            }
            Object theObject = null;
            Constructor<?>[] clist = theClass.getConstructors();
            for (i = 0; i < clist.length; ++i) {
                parameterTypes = clist[i].getParameterTypes();
                if (parameterTypes == null || parameterTypes.length != 1 || !parameterTypes[0].isInstance(possiblyContainingObject)) continue;
                theObject = clist[i].newInstance(possiblyContainingObject);
                break;
            }
            if (theObject == null && possiblyContainingObject instanceof View && ((View)possiblyContainingObject).getExhibit() != null) {
                possiblyContainingObject = ((View)possiblyContainingObject).getExhibit();
                for (i = 0; i < clist.length; ++i) {
                    parameterTypes = clist[i].getParameterTypes();
                    if (parameterTypes == null || parameterTypes.length != 1 || !parameterTypes[0].isInstance(possiblyContainingObject)) continue;
                    theObject = clist[i].newInstance(possiblyContainingObject);
                    break;
                }
            }
            if (theObject == null) {
                throw new Exception();
            }
            return theObject;
        }
    }

    private static void writeElement(PrintWriter out, Element element, String indent) {
        NodeList children;
        String name = element.getTagName();
        out.print(indent + "<" + name);
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                out.print(" " + attribute.getName() + "=\"" + attribute.getValue() + "\"");
            }
        }
        if ((children = element.getChildNodes()).getLength() == 0) {
            out.println("/>");
        } else {
            out.println(">");
            for (int i = 0; i < children.getLength(); ++i) {
                SaveAndRestore.writeElement(out, (Element)children.item(i), indent + "   ");
            }
            out.println(indent + "</" + name + ">");
        }
    }

    private static void buildExhibitElement(Document doc, Element exhibitElement, Exhibit exhibit) {
        String classname = exhibit.getClass().getName();
        exhibitElement.setAttribute("class", classname);
        if (!classname.equals(exhibit.getName())) {
            exhibitElement.setAttribute("name", exhibit.getName());
        }
        Parameter[] params = exhibit.getParameters();
        for (int i = params.length - 1; i >= 0; --i) {
            Element paramElement = doc.createElement("parameter");
            SaveAndRestore.buildParameterElement(doc, paramElement, params[i]);
            exhibitElement.appendChild(paramElement);
        }
        Decoration[] decorations = exhibit.getDecorations();
        for (int i = 0; i < decorations.length; ++i) {
            Class<?> cl = decorations[i].getClass();
            if (cl.getAnnotation(VMMSave.class) == null) continue;
            SaveAndRestore.addDecorationElement(doc, exhibitElement, decorations[i]);
        }
        SaveAndRestore.addSavedProperties(exhibit, doc, exhibitElement);
        exhibit.addExtraXML(doc, exhibitElement);
        if (exhibit instanceof UserExhibit) {
            UserExhibit.Support userData = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport();
            Element userDataElement = doc.createElement("userdata");
            userData.addToXML(doc, userDataElement);
            exhibitElement.appendChild(userDataElement);
        }
    }

    static void buildParameterElement(Document doc, Element parameterElement, Parameter param) {
        String classname = param.getClass().getName();
        parameterElement.setAttribute("class", classname);
        String name = param.getName();
        if (name != null) {
            parameterElement.setAttribute("name", name);
        }
        Element valueElement = doc.createElement("value");
        valueElement.setAttribute("value", param.getValueAsString());
        valueElement.setAttribute("default", param.getDefaultValueAsString());
        if (param instanceof IntegerParam) {
            int min = ((IntegerParam)param).getMinimumValueForInput();
            int max = ((IntegerParam)param).getMaximumValueForInput();
            if (min > Integer.MIN_VALUE) {
                valueElement.setAttribute("min", "" + min);
            }
            if (max < Integer.MAX_VALUE) {
                valueElement.setAttribute("max", "" + max);
            }
        } else if (param instanceof RealParam) {
            double min = ((RealParam)param).getMinimumValueForInput();
            double max = ((RealParam)param).getMaximumValueForInput();
            if (min > Double.NEGATIVE_INFINITY) {
                valueElement.setAttribute("min", Util.toExternalString(new Double(min)));
            }
            if (max < Double.POSITIVE_INFINITY) {
                valueElement.setAttribute("max", Util.toExternalString(new Double(max)));
            }
        } else if (param instanceof ComplexParam) {
            Complex min = ((ComplexParam)param).getMinimumValueForInput();
            Complex max = ((ComplexParam)param).getMaximumValueForInput();
            if (min.re > Double.NEGATIVE_INFINITY) {
                valueElement.setAttribute("min_re", Util.toExternalString(new Double(min.re)));
            }
            if (max.re < Double.POSITIVE_INFINITY) {
                valueElement.setAttribute("max_re", Util.toExternalString(new Double(max.re)));
            }
            if (min.im > Double.NEGATIVE_INFINITY) {
                valueElement.setAttribute("min_im", Util.toExternalString(new Double(min.im)));
            }
            if (max.im < Double.POSITIVE_INFINITY) {
                valueElement.setAttribute("max_im", Util.toExternalString(new Double(max.im)));
            }
        }
        parameterElement.appendChild(valueElement);
        if (param instanceof Animateable) {
            Animateable anim = (Animateable)((Object)param);
            Element startElement = doc.createElement("start");
            startElement.setAttribute("value", anim.getAnimationStartAsString());
            startElement.setAttribute("default", anim.getDefaultAnimationStartAsString());
            parameterElement.appendChild(startElement);
            Element endElement = doc.createElement("end");
            endElement.setAttribute("value", anim.getAnimationEndAsString());
            endElement.setAttribute("default", anim.getDefaultAnimationEndAsString());
            parameterElement.appendChild(endElement);
        }
    }

    private static void buildViewElement(Document doc, Element viewElement, View view) {
        String classname = view.getClass().getName();
        viewElement.setAttribute("class", classname);
        if (!classname.equals(view.getName())) {
            viewElement.setAttribute("name", view.getName());
        }
        Parameter[] params = view.getParameters();
        for (int i = params.length - 1; i >= 0; --i) {
            Element paramElement = doc.createElement("parameter");
            SaveAndRestore.buildParameterElement(doc, paramElement, params[i]);
            viewElement.appendChild(paramElement);
        }
        Decoration[] decorations = view.getDecorations();
        for (int i = 0; i < decorations.length; ++i) {
            Class<?> cl = decorations[i].getClass();
            if (cl.getAnnotation(VMMSave.class) == null) continue;
            SaveAndRestore.addDecorationElement(doc, viewElement, decorations[i]);
        }
        Transform transform = view.getTransform();
        if (transform != null) {
            Element transformElement = SaveAndRestore.makeTransformElement("transform", doc, transform);
            viewElement.appendChild(transformElement);
        }
        SaveAndRestore.addSavedProperties(view, doc, viewElement);
        view.addExtraXML(doc, viewElement);
    }

    private static void addSavedProperties(Object obj, Document document, Element element) {
        Class<?> cl = obj.getClass();
        while (!cl.equals(Object.class)) {
            Field[] fields;
            for (Field field : fields = cl.getDeclaredFields()) {
                if (field.getAnnotation(VMMSave.class) == null) continue;
                String propName = field.getName();
                SaveAndRestore.addProperty(obj, propName, document, element);
            }
            cl = cl.getSuperclass();
        }
    }

    private static Exhibit buildExhibitFromElement(Element exhibitElement) throws IOException {
        Exhibit exhibit;
        String classname = exhibitElement.getAttribute("class").trim();
        if (classname.trim().length() == 0) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingClassNameForExhibit"));
        }
        try {
            exhibit = (Exhibit)Class.forName(classname).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", classname));
        }
        String name = exhibitElement.getAttribute("name").trim();
        if (name.length() > 0) {
            exhibit.setName(name);
        }
        NodeList paramCandidates = exhibitElement.getChildNodes();
        Element userDataElement = null;
        for (int i = 0; i < paramCandidates.getLength(); ++i) {
            Node child = paramCandidates.item(i);
            if (child instanceof Element && ((Element)child).getTagName().equals("parameter")) {
                Element paramInfo = (Element)child;
                classname = paramInfo.getAttribute("class").trim();
                if (classname.length() == 0) {
                    throw new IOException("vmm.core.SaveAndRestore.error.MissingClassNameForParameter");
                }
                name = paramInfo.getAttribute("name").trim();
                Parameter param = null;
                if (name.length() > 0) {
                    param = exhibit.getParameterByName(name);
                }
                if (param == null) {
                    try {
                        param = (Parameter)SaveAndRestore.createObjectFromClassName(classname, exhibit);
                    }
                    catch (Exception e) {
                        throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", classname));
                    }
                    if (name.length() > 0) {
                        param.setName(name);
                    }
                    exhibit.addParameter(param);
                }
                SaveAndRestore.setParamInfoFromElement(param, paramInfo);
                continue;
            }
            if (child instanceof Element && ((Element)child).getTagName().equals("decoration")) {
                Decoration dec;
                Element decorationInfo = (Element)child;
                classname = decorationInfo.getAttribute("class");
                if (classname.length() == 0) {
                    throw new IOException("vmm.core.SaveAndRestore.error.MissingClassNameForDecoration");
                }
                try {
                    dec = (Decoration)SaveAndRestore.createObjectFromClassName(classname, exhibit);
                }
                catch (Exception e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", classname));
                }
                SaveAndRestore.readProperties(dec, decorationInfo);
                dec.readExtraXML(decorationInfo);
                exhibit.addDecoration(dec);
                continue;
            }
            if (!(child instanceof Element) || !((Element)child).getTagName().equals("userdata")) continue;
            userDataElement = (Element)child;
        }
        SaveAndRestore.readProperties(exhibit, exhibitElement);
        exhibit.readExtraXML(exhibitElement);
        if (exhibit instanceof UserExhibit) {
            if (userDataElement == null) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingUserData"));
            }
            UserExhibit.Support userInfo = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport();
            userInfo.readFromXML(userDataElement);
        }
        return exhibit;
    }

    static void setParamInfoFromElement(Parameter param, Element paramInfo) throws IOException {
        String dstr;
        String str;
        String max;
        String min;
        Element item = SaveAndRestore.getChildElement(paramInfo, "value");
        if (item != null) {
            String str2 = item.getAttribute("value").trim();
            String dstr2 = item.getAttribute("default").trim();
            if (str2.length() == 0) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingValueAttribute", "value"));
            }
            try {
                param.setValueFromString(str2);
            }
            catch (Exception e) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", str2, "value"));
            }
            if (dstr2.length() > 0) {
                try {
                    param.setDefaultValueFromString(dstr2);
                }
                catch (Exception e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", str2, "default"));
                }
            }
        }
        if (param instanceof IntegerParam) {
            min = item.getAttribute("min").trim();
            max = item.getAttribute("max").trim();
            if (min.length() > 0) {
                try {
                    ((IntegerParam)param).setMinimumValueForInput(Integer.parseInt(min));
                }
                catch (NumberFormatException e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", min, "min"));
                }
            }
            if (max.length() > 0) {
                try {
                    ((IntegerParam)param).setMaximumValueForInput(Integer.parseInt(max));
                }
                catch (NumberFormatException e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", max, "max"));
                }
            }
        } else if (param instanceof RealParam) {
            Double d;
            min = item.getAttribute("min").trim();
            max = item.getAttribute("max").trim();
            if (min.length() > 0) {
                try {
                    d = (Double)Util.externalStringToValue(min, Double.TYPE);
                    ((RealParam)param).setMinimumValueForInput(d);
                }
                catch (Exception e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", min, "min"));
                }
            }
            if (max.length() > 0) {
                try {
                    d = (Double)Util.externalStringToValue(max, Double.TYPE);
                    ((RealParam)param).setMaximumValueForInput(d);
                }
                catch (Exception e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", max, "max"));
                }
            }
        } else if (param instanceof ComplexParam) {
            Double d;
            String min_re = item.getAttribute("min_re").trim();
            String max_re = item.getAttribute("max_re").trim();
            String min_im = item.getAttribute("min_im").trim();
            String max_im = item.getAttribute("max_im").trim();
            Complex min2 = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            Complex max2 = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            if (min_re.length() > 0) {
                try {
                    d = (Double)Util.externalStringToValue(min_re, Double.TYPE);
                    min2.re = d;
                }
                catch (Exception e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", min_re, "min_re"));
                }
            }
            if (min_im.length() > 0) {
                try {
                    d = (Double)Util.externalStringToValue(min_im, Double.TYPE);
                    min2.im = d;
                }
                catch (Exception e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", min_im, "min_in"));
                }
            }
            if (max_re.length() > 0) {
                try {
                    d = (Double)Util.externalStringToValue(max_re, Double.TYPE);
                    max2.re = d;
                }
                catch (Exception e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", max_re, "max_re"));
                }
            }
            if (max_im.length() > 0) {
                try {
                    d = (Double)Util.externalStringToValue(max_im, Double.TYPE);
                    max2.im = d;
                }
                catch (Exception e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", max_im, "max_in"));
                }
            }
            ((ComplexParam)param).setMinimumValueForInput(min2);
            ((ComplexParam)param).setMaximumValueForInput(max2);
        }
        if (!(param instanceof Animateable)) {
            return;
        }
        Animateable anim = (Animateable)((Object)param);
        item = SaveAndRestore.getChildElement(paramInfo, "start");
        if (item != null) {
            str = item.getAttribute("value").trim();
            dstr = item.getAttribute("default").trim();
            if (str.length() == 0) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingValueAttribute", "value"));
            }
            try {
                anim.setAnimationStartFromString(str);
            }
            catch (Exception e) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", str, "value"));
            }
            if (dstr.length() > 0) {
                try {
                    anim.setDefaultAnimationStartFromString(dstr);
                }
                catch (Exception e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", str, "default"));
                }
            }
        }
        if ((item = SaveAndRestore.getChildElement(paramInfo, "end")) != null) {
            str = item.getAttribute("value").trim();
            dstr = item.getAttribute("default").trim();
            if (str.length() == 0) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingValueAttribute", "value"));
            }
            try {
                anim.setAnimationEndFromString(str);
            }
            catch (Exception e) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", str, "value"));
            }
            if (dstr.length() > 0) {
                try {
                    anim.setDefaultAnimationEndFromString(dstr);
                }
                catch (Exception e) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", str, "default"));
                }
            }
        }
    }

    private static void buildViewFromElement(Element viewElement, Exhibit exhibit) throws IOException {
        View view;
        String classname = viewElement.getAttribute("class").trim();
        if (classname.trim().length() == 0) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingClassNameForView"));
        }
        try {
            view = (View)SaveAndRestore.createObjectFromClassName(classname, exhibit);
        }
        catch (Exception e) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", classname));
        }
        String name = viewElement.getAttribute("name").trim();
        if (name.length() > 0) {
            view.setName(name);
        }
        view.setExhibit(exhibit);
        NodeList paramCandidates = viewElement.getChildNodes();
        for (int i = 0; i < paramCandidates.getLength(); ++i) {
            Decoration dec;
            Node child = paramCandidates.item(i);
            if (child instanceof Element && ((Element)child).getTagName().equals("parameter")) {
                Element paramInfo = (Element)child;
                classname = paramInfo.getAttribute("class").trim();
                if (classname.length() == 0) {
                    throw new IOException("vmm.core.SaveAndRestore.error.MissingClassNameForParameter");
                }
                name = paramInfo.getAttribute("name").trim();
                Parameter param = null;
                if (name.length() > 0) {
                    param = view.getParameterByName(name);
                }
                if (param == null) {
                    try {
                        param = (Parameter)SaveAndRestore.createObjectFromClassName(classname, view);
                    }
                    catch (Exception e) {
                        throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", classname));
                    }
                    if (name.length() > 0) {
                        param.setName(name);
                    }
                    view.addParameter(param);
                }
                SaveAndRestore.setParamInfoFromElement(param, paramInfo);
                continue;
            }
            if (!(child instanceof Element) || !((Element)child).getTagName().equals("decoration")) continue;
            Element decorationInfo = (Element)child;
            classname = decorationInfo.getAttribute("class");
            if (classname.length() == 0) {
                throw new IOException("vmm.core.SaveAndRestore.error.MissingClassNameForDecoration");
            }
            try {
                dec = (Decoration)SaveAndRestore.createObjectFromClassName(classname, view);
            }
            catch (Exception e) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", classname));
            }
            SaveAndRestore.readProperties(dec, decorationInfo);
            dec.readExtraXML(decorationInfo);
            view.addDecoration(dec);
        }
        SaveAndRestore.readProperties(view, viewElement);
        Element transformElement = SaveAndRestore.getChildElement(viewElement, "transform");
        if (transformElement != null) {
            Transform transform = SaveAndRestore.buildTransformFromElement(transformElement);
            view.setTransform(transform);
        }
        view.readExtraXML(viewElement);
    }
}

