/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import vmm.core.I18n;
import vmm.core.ParameterInput;
import vmm.core.Parameterizable;

public abstract class Parameter {
    private Object value;
    private String valueString;
    private Object defaultValue;
    private String defaultValueString;
    private Parameterizable owner;
    private String name;

    protected Parameter(String name, Object value) {
        if (value != null) {
            this.setValueObject(value);
        }
        this.name = name;
    }

    public Parameter(String name, String valueAsString) {
        if (valueAsString != null) {
            this.setValueFromString(valueAsString);
        }
        this.name = name;
    }

    protected void reset(Object value) {
        this.setDefaultValueObject(value);
        this.setValueObject(value);
    }

    public void reset(String valueAsString) {
        this.setValueAndDefaultFromString(valueAsString);
    }

    protected String valueObjectToString(Object obj) {
        return obj == null ? "0" : obj.toString();
    }

    protected abstract Object stringToValueObject(String var1);

    public Parameterizable getOwner() {
        return this.owner;
    }

    public void setOwner(Parameterizable owner) {
        this.owner = owner;
    }

    public Object getValueObject() {
        return this.value;
    }

    public void setValueObject(Object value) {
        Object oldValue = this.value;
        this.value = value;
        this.valueString = null;
        if (value != null && this.defaultValue == null) {
            this.setDefaultValueObject(value);
        }
        if (this.owner != null) {
            if (oldValue == null ? value == null : oldValue.equals(value)) {
                return;
            }
            this.owner.parameterChanged(this, oldValue, value);
        }
    }

    public void setDefaultValueObject(Object object) {
        this.defaultValue = object;
        this.defaultValueString = null;
    }

    public Object getDefaultValueObject() {
        return this.defaultValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        String name = this.getName();
        if (name == null) {
            return I18n.tr("unnamed.parameter");
        }
        return I18n.tr(name);
    }

    public String getHint() {
        String name = this.getName();
        String hint = null;
        if (name != null) {
            hint = I18n.trIfFound(name + ".hint");
        }
        return hint;
    }

    public final String getValueAsString() {
        if (this.valueString != null) {
            return this.valueString;
        }
        if (this.value == null) {
            return "0";
        }
        return this.valueObjectToString(this.value);
    }

    public String getDefaultValueAsString() {
        if (this.defaultValueString != null) {
            return this.defaultValueString;
        }
        if (this.defaultValue == null) {
            return "0";
        }
        return this.valueObjectToString(this.defaultValue);
    }

    public final void setValueFromString(String valueAsString) {
        boolean newDefaultVal = this.defaultValue == null;
        this.setValueObject(this.stringToValueObject(valueAsString));
        this.valueString = valueAsString;
        if (newDefaultVal) {
            this.defaultValueString = valueAsString;
        }
    }

    public final void setDefaultValueFromString(String valueAsString) {
        this.setDefaultValueObject(this.stringToValueObject(valueAsString));
        this.defaultValueString = valueAsString;
    }

    public final void setValueAndDefaultFromString(String valueAsString) {
        Object obj = this.stringToValueObject(valueAsString);
        this.setValueObject(obj);
        this.valueString = valueAsString;
        this.setDefaultValueObject(obj);
        this.defaultValueString = valueAsString;
    }

    public ParameterInput createParameterInput(int inputType) {
        return new ParameterInput(this, inputType);
    }

    public String toString() {
        return this.getTitle() + "(" + this.getValueAsString() + ")";
    }
}

