/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    private static ArrayList<ResourceBundle> bundles = new ArrayList();
    private static ArrayList<String> bundleNames = new ArrayList();
    private static Locale locale;
    private static String defaultPropertiesFileName;

    public static void setLocale(Locale locale) {
        I18n.setLocale(locale, true);
    }

    public static synchronized void setLocale(Locale locale, boolean reload) {
        I18n.locale = locale;
        if (reload) {
            bundles.clear();
            ArrayList<String> names = bundleNames;
            bundleNames = new ArrayList();
            for (int i = 0; i < names.size(); ++i) {
                I18n.load(names.get(i));
            }
        }
    }

    public static Locale getLocale() {
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }

    public static synchronized boolean addFile(String fileName) {
        ResourceBundle b;
        if (fileName == null) {
            return false;
        }
        for (int i = 0; i < bundleNames.size(); ++i) {
            if (!bundleNames.get(i).equals(fileName)) continue;
            return bundles.get(i) != null;
        }
        if (bundles.size() == 0 && !fileName.equals(defaultPropertiesFileName)) {
            I18n.load(defaultPropertiesFileName);
        }
        return (b = I18n.load(fileName)) != null;
    }

    private static synchronized ResourceBundle load(String name) {
        ResourceBundle bundle;
        if (name == null) {
            return null;
        }
        try {
            bundle = locale == null ? ResourceBundle.getBundle(name) : ResourceBundle.getBundle(name, locale);
        }
        catch (MissingResourceException e) {
            bundle = null;
        }
        bundles.add(bundle);
        bundleNames.add(name);
        return bundle;
    }

    public static String tr(String key) {
        String s = I18n.trIfFound(key);
        return s == null ? key : s;
    }

    public static String tr(String key, Object ... arg) {
        return MessageFormat.format(I18n.tr(key), arg);
    }

    public static String trIfFound(String key) {
        if (key == null) {
            return null;
        }
        if (bundles.size() == 0) {
            I18n.load(defaultPropertiesFileName);
        }
        for (int i = bundles.size() - 1; i >= 0; --i) {
            ResourceBundle b = bundles.get(i);
            if (b == null) continue;
            try {
                return b.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String trIfFound(String key, Object ... arg) {
        String s = I18n.trIfFound(key);
        if (s == null) {
            return null;
        }
        return MessageFormat.format(s, arg);
    }

    static {
        defaultPropertiesFileName = "vmm.resources.strings";
    }
}

