/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import vmm.core.Complex;
import vmm.core.ComplexParam;
import vmm.functions.ComplexVariable;

public class ComplexVariableParam
extends ComplexParam {
    private ComplexVariable variable;

    public ComplexVariableParam() {
        this(null, (Complex)null);
    }

    public ComplexVariableParam(String name, Complex initialValue) {
        super(name, initialValue);
        this.variable = initialValue == null ? new ComplexVariable(name) : new ComplexVariable(name, initialValue.re, initialValue.im);
    }

    public ComplexVariableParam(String name, String value) throws NumberFormatException {
        super(name, value);
        Complex val = this.getValue();
        this.variable = new ComplexVariable(name, val.re, val.im);
    }

    public ComplexVariableParam(ComplexVariable v) {
        super(v.getName(), v.getVal());
        this.variable = v;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.variable.setName(name);
    }

    @Override
    public void setValueObject(Object object) {
        super.setValueObject(object);
        if (this.variable != null) {
            this.variable.setVal((Complex)object);
        }
    }

    @Override
    public Object getValueObject() {
        Complex val = (Complex)super.getValueObject();
        if (!this.variable.getVal().equals(val)) {
            val = this.variable.getVal();
            super.setValueObject(val);
        }
        return val;
    }

    public ComplexVariable getVariable() {
        return this.variable;
    }
}

