/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.timeseries.models.parametric;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.SolverException;
import net.finmath.timeseries.HistoricalSimulationModel;
import net.finmath.timeseries.TimeSeriesInterface;
import net.finmath.timeseries.TimeSeriesModelParametric;
import net.finmath.timeseries.TimeSeriesView;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimplePointChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.CMAESOptimizer;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;

public class DisplacedLognormalGJRGARCH
implements TimeSeriesModelParametric,
HistoricalSimulationModel {
    private TimeSeriesInterface timeSeries;
    private double lowerBoundDisplacement;
    private double upperBoundDisplacement = 1.0E7;
    private int maxIterations = 10000000;
    private final String[] parameterNames = new String[]{"omega", "alpha", "beta", "mu", "gamma", "displacement"};
    private final double[] parameterGuess = new double[]{0.1, 0.2, 0.2, 0.0, 0.0, 10.0};
    private final double[] parameterStep = new double[]{0.01, 0.1, 0.1, 0.1, 0.1, 1.0};
    private final double[] lowerBound;
    private final double[] upperBound;

    public DisplacedLognormalGJRGARCH(TimeSeriesInterface timeSeriesInterface) {
        this(timeSeriesInterface, -1.7976931348623157E308);
    }

    public DisplacedLognormalGJRGARCH(TimeSeriesInterface timeSeriesInterface, double d) {
        this.timeSeries = timeSeriesInterface;
        double d2 = Double.MAX_VALUE;
        for (double d3 : timeSeriesInterface.getValues()) {
            d2 = Math.min(d3, d2);
        }
        this.lowerBoundDisplacement = Math.max(-d2 + 1.0, d);
        this.lowerBound = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, this.lowerBoundDisplacement};
        this.upperBound = new double[]{Double.POSITIVE_INFINITY, 1.0, 1.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, this.upperBoundDisplacement};
    }

    public DisplacedLognormalGJRGARCH(TimeSeriesInterface timeSeriesInterface, double d, double d2) {
        this.timeSeries = timeSeriesInterface;
        double d3 = Double.MAX_VALUE;
        for (double d4 : timeSeriesInterface.getValues()) {
            d3 = Math.min(d4, d3);
        }
        this.lowerBoundDisplacement = Math.max(-d3 + 1.0, d);
        this.upperBoundDisplacement = Math.max(this.lowerBoundDisplacement, d2);
        this.lowerBound = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, this.lowerBoundDisplacement};
        this.upperBound = new double[]{Double.POSITIVE_INFINITY, 1.0, 1.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, this.upperBoundDisplacement};
    }

    public double getLogLikelihoodForParameters(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        double d6 = dArray[5];
        double d7 = 0.0;
        double d8 = 1.0 + Math.abs(d6);
        double d9 = 0.0;
        double d10 = d8 * Math.log((this.timeSeries.getValue(1) + d6) / (this.timeSeries.getValue(0) + d6));
        double d11 = d / (1.0 - d2 - d3);
        double d12 = 0.0;
        int n = this.timeSeries.getNumberOfTimePoints();
        for (int i = 1; i < n - 1; ++i) {
            double d13;
            d12 = d10;
            d11 = d + (d2 + d5 * (d12 < d4 ? 1.0 : 0.0)) * d12 * d12 + d3 * d11;
            double d14 = this.timeSeries.getValue(i);
            double d15 = this.timeSeries.getValue(i + 1);
            double d16 = d13 = d8 * Math.log((d15 + d6) / (d14 + d6));
            d7 += -Math.log(d11) - 2.0 * Math.log((d15 + d6) / d8) - d16 * d16 / d11;
            d9 = d10;
            d10 = d13;
        }
        d7 += -Math.log(Math.PI * 2) * (double)n;
        return d7 *= 0.5;
    }

    public double getLastResidualForParameters(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        double d6 = dArray[5];
        double d7 = 0.0;
        double d8 = 1.0 + Math.abs(d6);
        double d9 = d / (1.0 - d2 - d3);
        double d10 = 0.0;
        int n = this.timeSeries.getNumberOfTimePoints();
        for (int i = 1; i < n - 1; ++i) {
            double d11 = d8 * Math.log((this.timeSeries.getValue(i) + d6) / (this.timeSeries.getValue(i - 1) + d6));
            d10 = d11;
            d9 = d + (d2 + d5 * (d10 < d4 ? 1.0 : 0.0)) * d10 * d10 + d3 * d9;
            d7 = d11;
        }
        return d9;
    }

    public double[] getSzenarios(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        double d6 = dArray[5];
        double[] dArray2 = new double[this.timeSeries.getNumberOfTimePoints() - 1];
        double d7 = 1.0 + Math.abs(d6);
        double d8 = 0.0;
        double d9 = d / (1.0 - d2 - d3);
        double d10 = 0.0;
        double d11 = Math.sqrt(d9) / d7;
        for (int i = 1; i <= this.timeSeries.getNumberOfTimePoints() - 1; ++i) {
            double d12;
            double d13 = Math.log((this.timeSeries.getValue(i) + d6) / (this.timeSeries.getValue(i - 1) + d6));
            d10 = d12 = d7 * d13;
            dArray2[i - 1] = d10 / d11 / d7;
            d9 = d + (d2 + d5 * (d10 < d4 ? 1.0 : 0.0)) * d10 * d10 + d3 * d9;
            d11 = Math.sqrt(d9) / d7;
            d8 = d12;
        }
        Arrays.sort(dArray2);
        return dArray2;
    }

    @Override
    public Map<String, Object> getBestParameters() {
        return this.getBestParameters(null);
    }

    @Override
    public Map<String, Object> getBestParameters(Map<String, Object> map) {
        class GARCHMaxLikelihoodFunction
        implements MultivariateFunction,
        Serializable {
            private static final long serialVersionUID = 7072187082052755854L;

            GARCHMaxLikelihoodFunction() {
            }

            public double value(double[] dArray) {
                double d = dArray[0];
                double d2 = dArray[1];
                double d3 = dArray[2];
                double d4 = dArray[3];
                double d5 = dArray[4];
                double d6 = dArray[5];
                double d7 = DisplacedLognormalGJRGARCH.this.getLogLikelihoodForParameters(dArray);
                d7 -= Math.max(1.0E-30 - d, 0.0) / 1.0E-30;
                d7 -= Math.max(1.0E-30 - d2, 0.0) / 1.0E-30;
                d7 -= Math.max(d2 - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
                d7 -= Math.max(1.0E-30 - d3, 0.0) / 1.0E-30;
                return d7 -= Math.max(d3 - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
            }
        }
        final GARCHMaxLikelihoodFunction gARCHMaxLikelihoodFunction = new GARCHMaxLikelihoodFunction();
        final double[] dArray = new double[6];
        System.arraycopy(this.parameterGuess, 0, dArray, 0, this.parameterGuess.length);
        if (map != null) {
            dArray[0] = (Double)map.get("Omega");
            dArray[1] = (Double)map.get("Alpha");
            dArray[2] = (Double)map.get("Beta");
            dArray[3] = (Double)map.get("Mu");
            dArray[4] = (Double)map.get("Gamme");
            dArray[5] = (Double)map.get("Displacement");
        }
        LevenbergMarquardt levenbergMarquardt = new LevenbergMarquardt(dArray, new double[]{1000.0}, this.maxIterations * 100, 2){
            {
                super(dArray, dArray2, n, n2);
            }

            @Override
            public void setValues(double[] dArray, double[] dArray2) throws SolverException {
                dArray2[0] = gARCHMaxLikelihoodFunction.value(dArray);
            }
        };
        double[] dArray2 = null;
        boolean bl = false;
        if (bl) {
            try {
                levenbergMarquardt.run();
            }
            catch (SolverException solverException) {
                solverException.printStackTrace();
            }
            dArray2 = levenbergMarquardt.getBestFitParameters();
        } else {
            CMAESOptimizer cMAESOptimizer = new CMAESOptimizer(this.maxIterations, Double.POSITIVE_INFINITY, true, 0, 0, (RandomGenerator)new MersenneTwister(), false, (ConvergenceChecker)new SimplePointChecker(0.0, 0.0)){
                {
                    super(n, d, bl, n2, n3, randomGenerator, bl2, convergenceChecker);
                }

                public double computeObjectiveValue(double[] dArray2) {
                    return gARCHMaxLikelihoodFunction.value(dArray2);
                }

                public GoalType getGoalType() {
                    return GoalType.MAXIMIZE;
                }

                public double[] getStartPoint() {
                    return dArray;
                }

                public double[] getLowerBound() {
                    return DisplacedLognormalGJRGARCH.this.lowerBound;
                }

                public double[] getUpperBound() {
                    return DisplacedLognormalGJRGARCH.this.upperBound;
                }
            };
            try {
                PointValuePair pointValuePair = cMAESOptimizer.optimize(new OptimizationData[]{new CMAESOptimizer.PopulationSize((int)(4.0 + 3.0 * Math.log(dArray.length))), new CMAESOptimizer.Sigma(this.parameterStep)});
                dArray2 = pointValuePair.getPoint();
            }
            catch (MathIllegalStateException mathIllegalStateException) {
                System.out.println("Solver failed");
                dArray2 = dArray;
            }
        }
        double d = dArray2[0];
        double d2 = dArray2[1];
        double d3 = dArray2[2];
        double d4 = dArray2[3];
        double d5 = dArray2[4];
        double d6 = dArray2[5];
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("parameters", dArray2);
        hashMap.put("Omega", d);
        hashMap.put("Alpha", d2);
        hashMap.put("Beta", d3);
        hashMap.put("Mu", d4);
        hashMap.put("gamma", d5);
        hashMap.put("Displacement", d6);
        hashMap.put("Szenarios", this.getSzenarios(dArray2));
        hashMap.put("Likelihood", this.getLogLikelihoodForParameters(dArray2));
        hashMap.put("Vol", Math.sqrt(this.getLastResidualForParameters(dArray2)));
        System.out.println(hashMap.get("Likelihood") + "\t" + Arrays.toString(dArray2));
        return hashMap;
    }

    private static double restrictToOpenSet(double d, double d2, double d3) {
        d = Math.max(d, d2 * (1.0 + Math.signum(d2) * 1.0E-15) + 1.0E-15);
        d = Math.min(d, d3 * (1.0 - Math.signum(d3) * 1.0E-15) - 1.0E-15);
        return d;
    }

    @Override
    public TimeSeriesModelParametric getCloneCalibrated(TimeSeriesInterface timeSeriesInterface) {
        return new DisplacedLognormalGJRGARCH(timeSeriesInterface);
    }

    @Override
    public HistoricalSimulationModel getCloneWithWindow(int n, int n2) {
        return new DisplacedLognormalGJRGARCH(new TimeSeriesView(this.timeSeries, n, n2));
    }

    @Override
    public double[] getParameters() {
        return (double[])this.getBestParameters().get("parameters");
    }

    @Override
    public String[] getParameterNames() {
        return this.parameterNames;
    }
}

