/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.util.Calendar;
import net.finmath.time.TenorInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.daycount.DayCountConventionInterface;
import net.finmath.time.daycount.DayCountConvention_ACT_365;

public class Tenor
extends TimeDiscretization
implements TenorInterface {
    private static final long serialVersionUID = 4027884423439197483L;
    private static DayCountConventionInterface internalDayCounting = new DayCountConvention_ACT_365();
    private Calendar referenceDate;
    private Calendar[] dates;

    public Tenor(Calendar[] calendarArray, Calendar calendar) {
        super(Tenor.createTimeDiscretizationFromDates(calendarArray, calendar));
        this.dates = calendarArray;
        this.referenceDate = calendar;
    }

    private static double[] createTimeDiscretizationFromDates(Calendar[] calendarArray, Calendar calendar) {
        double[] dArray = new double[calendarArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = internalDayCounting.getDaycountFraction(calendar, calendarArray[i]);
        }
        return dArray;
    }

    public Tenor(double[] dArray) {
        super(dArray);
    }

    public Tenor(Double[] doubleArray) {
        super(doubleArray);
    }

    public Tenor(double d, int n, double d2) {
        super(d, n, d2);
    }

    public Tenor(double d, double d2, double d3, TimeDiscretization.ShortPeriodLocation shortPeriodLocation) {
        super(d, d2, d3, shortPeriodLocation);
    }

    @Override
    public Calendar getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public Calendar getDate(int n) {
        return this.dates[n];
    }

    @Override
    public double getDaycountFraction(int n) {
        return this.getTimeStep(n);
    }
}

