/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.tests.montecarlo;

import java.text.DecimalFormat;
import net.finmath.montecarlo.GammaProcess;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import org.junit.Assert;
import org.junit.Test;

public class GammaProcessTests {
    static final DecimalFormat formatterReal2 = new DecimalFormat(" 0.00");
    static final DecimalFormat formatterSci4 = new DecimalFormat(" 0.0000E00;-0.0000E00");
    static final DecimalFormat formatterSci1 = new DecimalFormat(" 0E00;-0.E00");

    @Test
    public void testScaling() {
        int n = 53252;
        int n2 = 10000;
        double d = 10.0;
        double d2 = 0.1;
        System.out.println("Test of scaling of Gamma increments.");
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, (int)(d / d2), d2);
        double d3 = 3.0;
        double d4 = 1.0;
        double d5 = 2.0;
        GammaProcess gammaProcess = new GammaProcess(timeDiscretization, 1, n2, n, d3, d4);
        GammaProcess gammaProcess2 = new GammaProcess(timeDiscretization, 1, n2, n, d3, d5);
        RandomVariableInterface randomVariableInterface = gammaProcess.getIncrement(3, 0);
        RandomVariableInterface randomVariableInterface2 = gammaProcess2.getIncrement(3, 0);
        for (int i = 0; i < randomVariableInterface.size(); ++i) {
            double d6 = randomVariableInterface2.get(i) - d5 / d4 * randomVariableInterface.get(i);
            System.out.println(formatterReal2.format(randomVariableInterface.get(i)) + "\t" + formatterReal2.format(randomVariableInterface2.get(i)) + "\t" + formatterSci4.format(d6));
            Assert.assertTrue((Math.abs(d6) < 1.0E-8 ? 1 : 0) != 0);
        }
    }
}

