/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.products;

import java.util.Arrays;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.AbstractMonteCarloProduct;
import net.finmath.montecarlo.MonteCarloSimulationInterface;
import net.finmath.stochastic.RandomVariableInterface;

public class PortfolioMonteCarloProduct
extends AbstractMonteCarloProduct {
    private AbstractMonteCarloProduct[] products;
    private double[] weights;

    public PortfolioMonteCarloProduct(AbstractMonteCarloProduct[] abstractMonteCarloProductArray) {
        this(abstractMonteCarloProductArray, PortfolioMonteCarloProduct.weightsOfOne(abstractMonteCarloProductArray.length));
    }

    public PortfolioMonteCarloProduct(AbstractMonteCarloProduct[] abstractMonteCarloProductArray, double[] dArray) {
        this.products = abstractMonteCarloProductArray;
        this.weights = dArray;
    }

    private static double[] weightsOfOne(int n) {
        double[] dArray = new double[n];
        Arrays.fill(dArray, 1.0);
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getValue(final double d, final MonteCarloSimulationInterface monteCarloSimulationInterface) throws CalculationException {
        if (this.products == null || this.products.length == 0) {
            return null;
        }
        int n = Math.min(Math.max(2 * Runtime.getRuntime().availableProcessors(), 1), this.products.length);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        RandomVariableInterface randomVariableInterface = null;
        try {
            int n2;
            Vector vector = new Vector(this.products.length);
            for (n2 = 0; n2 < this.products.length; ++n2) {
                final AbstractMonteCarloProduct abstractMonteCarloProduct = this.products[n2];
                final double d2 = this.weights[n2];
                Callable<RandomVariableInterface> callable = new Callable<RandomVariableInterface>(){

                    @Override
                    public RandomVariableInterface call() throws CalculationException {
                        return abstractMonteCarloProduct.getValue(d, monteCarloSimulationInterface).mult(d2);
                    }
                };
                executorService.submit(callable);
            }
            randomVariableInterface = (RandomVariableInterface)((Future)vector.get(0)).get();
            for (n2 = 1; n2 < this.products.length; ++n2) {
                randomVariableInterface = randomVariableInterface.add((RandomVariableInterface)((Future)vector.get(n2)).get());
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        finally {
            executorService.shutdown();
        }
        return randomVariableInterface;
    }
}

