/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public class Option
extends AbstractProductComponent {
    private static final long serialVersionUID = 2987369289230532162L;
    private final double exerciseDate;
    private final double strikePrice;
    private final AbstractLIBORMonteCarloProduct underlying;
    private final AbstractLIBORMonteCarloProduct strikeProduct;
    private final boolean isCall;

    public Option(double d, AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct) {
        this(d, 0.0, abstractLIBORMonteCarloProduct);
    }

    public Option(double d, double d2, AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct) {
        this(d, d2, true, abstractLIBORMonteCarloProduct);
    }

    public Option(double d, double d2, boolean bl, AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct) {
        this.exerciseDate = d;
        this.strikePrice = d2;
        this.underlying = abstractLIBORMonteCarloProduct;
        this.isCall = bl;
        this.strikeProduct = null;
    }

    public Option(double d, boolean bl, AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct, AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct2) {
        this.exerciseDate = d;
        this.strikePrice = Double.NaN;
        this.strikeProduct = abstractLIBORMonteCarloProduct;
        this.underlying = abstractLIBORMonteCarloProduct2;
        this.isCall = bl;
    }

    @Override
    public String getCurrency() {
        return this.underlying.getCurrency();
    }

    @Override
    public Set<String> queryUnderlyings() {
        if (this.underlying instanceof AbstractProductComponent) {
            return ((AbstractProductComponent)this.underlying).queryUnderlyings();
        }
        throw new IllegalArgumentException("Underlying cannot be queried for underlyings.");
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface;
        RandomVariableInterface randomVariableInterface2;
        RandomVariableInterface randomVariableInterface3;
        RandomVariableInterface randomVariableInterface4 = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        RandomVariableInterface randomVariableInterface5 = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(0.0);
        if (d > this.exerciseDate) {
            return randomVariableInterface5;
        }
        RandomVariableInterface randomVariableInterface6 = this.underlying.getValue(this.exerciseDate, lIBORModelMonteCarloSimulationInterface);
        RandomVariableInterface randomVariableInterface7 = randomVariableInterface6.sub(randomVariableInterface3 = this.strikeProduct != null ? this.strikeProduct.getValue(this.exerciseDate, lIBORModelMonteCarloSimulationInterface) : lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(this.strikePrice)).mult(this.isCall ? 1.0 : -1.0);
        if (randomVariableInterface7.getFiltrationTime() > this.exerciseDate) {
            randomVariableInterface2 = randomVariableInterface7.isNaN().sub(1.0).mult(-1.0);
            randomVariableInterface = randomVariableInterface7.mult(randomVariableInterface2);
            double d2 = randomVariableInterface.getAverage();
            double d3 = randomVariableInterface.getStandardDeviation();
            double d4 = d2 * (1.0 - Math.signum(d2) * 1.0E-5) - 3.0 * d3;
            double d5 = d2 * (1.0 + Math.signum(d2) * 1.0E-5) + 3.0 * d3;
            RandomVariableInterface randomVariableInterface8 = randomVariableInterface7.barrier(randomVariableInterface7.sub(d4), randomVariableInterface4, randomVariableInterface5).mult(randomVariableInterface7.barrier(randomVariableInterface7.sub(d5).mult(-1.0), randomVariableInterface4, randomVariableInterface5));
            randomVariableInterface8 = randomVariableInterface8.mult(randomVariableInterface2);
            randomVariableInterface7 = randomVariableInterface7.mult(randomVariableInterface8);
            RandomVariableInterface[] randomVariableInterfaceArray = this.getRegressionBasisFunctions(this.exerciseDate, lIBORModelMonteCarloSimulationInterface);
            RandomVariableInterface[] randomVariableInterfaceArray2 = new RandomVariableInterface[randomVariableInterfaceArray.length];
            for (int i = 0; i < randomVariableInterfaceArray.length; ++i) {
                randomVariableInterfaceArray2[i] = randomVariableInterfaceArray[i].mult(randomVariableInterface8);
            }
            MonteCarloConditionalExpectationRegression monteCarloConditionalExpectationRegression = new MonteCarloConditionalExpectationRegression(randomVariableInterfaceArray2, randomVariableInterfaceArray);
            randomVariableInterface7 = monteCarloConditionalExpectationRegression.getConditionalExpectation(randomVariableInterface7);
        }
        randomVariableInterface6 = this.strikeProduct != null ? randomVariableInterface6.barrier(randomVariableInterface7, randomVariableInterface6, this.strikeProduct.getValue(this.exerciseDate, lIBORModelMonteCarloSimulationInterface)) : randomVariableInterface6.barrier(randomVariableInterface7, randomVariableInterface6, this.strikePrice);
        if (d != this.exerciseDate) {
            randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getNumeraire(d);
            randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getNumeraire(this.exerciseDate);
            randomVariableInterface6 = randomVariableInterface6.div(randomVariableInterface).mult(randomVariableInterface2);
        }
        return randomVariableInterface6;
    }

    private RandomVariableInterface[] getRegressionBasisFunctions(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        double d2;
        double d3;
        ArrayList<RandomVariableInterface> arrayList = new ArrayList<RandomVariableInterface>();
        RandomVariableInterface randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        int n = lIBORModelMonteCarloSimulationInterface.getLiborPeriodIndex(d);
        if (n < 0) {
            n = -n - 1;
        }
        int n2 = n + 1;
        double d4 = lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2) - lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n);
        RandomVariableInterface randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d, lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n), lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2));
        randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d4);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d4);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        n = lIBORModelMonteCarloSimulationInterface.getLiborPeriodIndex(d);
        if (n < 0) {
            n = -n - 1;
        }
        if ((d3 = lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2 = (n + lIBORModelMonteCarloSimulationInterface.getNumberOfLibors()) / 2) - lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n)) != d4) {
            randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d, lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n), lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2));
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d3);
            arrayList.add(randomVariableInterface);
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d3);
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d3);
        }
        randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        n = lIBORModelMonteCarloSimulationInterface.getLiborPeriodIndex(d);
        if (n < 0) {
            n = -n - 1;
        }
        if ((d2 = lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2 = lIBORModelMonteCarloSimulationInterface.getNumberOfLibors()) - lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n)) != d4 && d2 != d3) {
            randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d, lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n), lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2));
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d2);
            arrayList.add(randomVariableInterface);
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d2);
        }
        return arrayList.toArray(new RandomVariableInterface[0]);
    }

    @Override
    public String toString() {
        return "Option [exerciseDate=" + this.exerciseDate + ", strikePrice=" + this.strikePrice + ", underlying=" + this.underlying + ", isCall=" + this.isCall + ", toString()=" + super.toString() + "]";
    }
}

