/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.ArrayList;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public class Exposure
extends AbstractProductComponent {
    private static final long serialVersionUID = 2987369289230532162L;
    private final AbstractLIBORMonteCarloProduct underlying;

    public Exposure(double d, double d2, boolean bl, AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct) {
        this.underlying = abstractLIBORMonteCarloProduct;
    }

    public Exposure(AbstractLIBORMonteCarloProduct abstractLIBORMonteCarloProduct) {
        this.underlying = abstractLIBORMonteCarloProduct;
    }

    @Override
    public String getCurrency() {
        return this.underlying.getCurrency();
    }

    @Override
    public Set<String> queryUnderlyings() {
        if (this.underlying instanceof AbstractProductComponent) {
            return ((AbstractProductComponent)this.underlying).queryUnderlyings();
        }
        throw new IllegalArgumentException("Underlying cannot be queried for underlyings.");
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        RandomVariableInterface randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        RandomVariableInterface randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(0.0);
        RandomVariableInterface randomVariableInterface3 = this.underlying.getValue(d, lIBORModelMonteCarloSimulationInterface);
        if (randomVariableInterface3.getFiltrationTime() > d) {
            RandomVariableInterface randomVariableInterface4 = randomVariableInterface3.isNaN().sub(1.0).mult(-1.0);
            RandomVariableInterface randomVariableInterface5 = randomVariableInterface3.mult(randomVariableInterface4);
            double d2 = randomVariableInterface5.getAverage();
            double d3 = randomVariableInterface5.getStandardDeviation();
            double d4 = d2 * (1.0 - Math.signum(d2) * 1.0E-5) - 3.0 * d3;
            double d5 = d2 * (1.0 + Math.signum(d2) * 1.0E-5) + 3.0 * d3;
            RandomVariableInterface randomVariableInterface6 = randomVariableInterface3.barrier(randomVariableInterface3.sub(d4), randomVariableInterface, randomVariableInterface2).mult(randomVariableInterface3.barrier(randomVariableInterface3.sub(d5).mult(-1.0), randomVariableInterface, randomVariableInterface2));
            randomVariableInterface6 = randomVariableInterface6.mult(randomVariableInterface4);
            randomVariableInterface3 = randomVariableInterface3.mult(randomVariableInterface6);
            RandomVariableInterface[] randomVariableInterfaceArray = this.getRegressionBasisFunctions(d, lIBORModelMonteCarloSimulationInterface);
            RandomVariableInterface[] randomVariableInterfaceArray2 = new RandomVariableInterface[randomVariableInterfaceArray.length];
            for (int i = 0; i < randomVariableInterfaceArray.length; ++i) {
                randomVariableInterfaceArray2[i] = randomVariableInterfaceArray[i].mult(randomVariableInterface6);
            }
            MonteCarloConditionalExpectationRegression monteCarloConditionalExpectationRegression = new MonteCarloConditionalExpectationRegression(randomVariableInterfaceArray2, randomVariableInterfaceArray);
            randomVariableInterface3 = monteCarloConditionalExpectationRegression.getConditionalExpectation(randomVariableInterface3);
        }
        return randomVariableInterface3;
    }

    private RandomVariableInterface[] getRegressionBasisFunctions(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        double d2;
        double d3;
        ArrayList<RandomVariableInterface> arrayList = new ArrayList<RandomVariableInterface>();
        RandomVariableInterface randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        int n = lIBORModelMonteCarloSimulationInterface.getLiborPeriodIndex(d);
        if (n < 0) {
            n = -n - 1;
        }
        int n2 = n + 1;
        double d4 = lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2) - lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n);
        RandomVariableInterface randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d, lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n), lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2));
        randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d4);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d4);
        arrayList.add(randomVariableInterface);
        randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        n = lIBORModelMonteCarloSimulationInterface.getLiborPeriodIndex(d);
        if (n < 0) {
            n = -n - 1;
        }
        if ((d3 = lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2 = (n + lIBORModelMonteCarloSimulationInterface.getNumberOfLibors()) / 2) - lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n)) != d4) {
            randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d, lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n), lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2));
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d3);
            arrayList.add(randomVariableInterface);
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d3);
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d3);
        }
        randomVariableInterface = lIBORModelMonteCarloSimulationInterface.getRandomVariableForConstant(1.0);
        n = lIBORModelMonteCarloSimulationInterface.getLiborPeriodIndex(d);
        if (n < 0) {
            n = -n - 1;
        }
        if ((d2 = lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2 = lIBORModelMonteCarloSimulationInterface.getNumberOfLibors()) - lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n)) != d4 && d2 != d3) {
            randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d, lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n), lIBORModelMonteCarloSimulationInterface.getLiborPeriod(n2));
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d2);
            arrayList.add(randomVariableInterface);
            randomVariableInterface = randomVariableInterface.discount(randomVariableInterface2, d2);
        }
        return arrayList.toArray(new RandomVariableInterface[0]);
    }
}

