/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.AbstractMonteCarloProduct;
import net.finmath.montecarlo.MonteCarloSimulationInterface;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.SwaptionSingleCurveAnalyticApproximation;
import net.finmath.stochastic.RandomVariableInterface;

public class SwaprateCovarianceAnalyticApproximation
extends AbstractMonteCarloProduct {
    final double[] swapTenor1;
    final double[] swapTenor2;

    public SwaprateCovarianceAnalyticApproximation(double[] dArray, double[] dArray2) {
        this.swapTenor1 = dArray;
        this.swapTenor2 = dArray2;
    }

    @Override
    public RandomVariableInterface getValue(double d, MonteCarloSimulationInterface monteCarloSimulationInterface) throws CalculationException {
        return this.getValue(d, (LIBORMarketModel)((LIBORModelMonteCarloSimulationInterface)monteCarloSimulationInterface).getModel());
    }

    public RandomVariableInterface getValue(double d, LIBORMarketModel lIBORMarketModel) throws CalculationException {
        int n = lIBORMarketModel.getLiborPeriodIndex(this.swapTenor1[0]);
        int n2 = lIBORMarketModel.getLiborPeriodIndex(this.swapTenor1[this.swapTenor1.length - 1]);
        int n3 = lIBORMarketModel.getLiborPeriodIndex(this.swapTenor2[0]);
        int n4 = lIBORMarketModel.getLiborPeriodIndex(this.swapTenor2[this.swapTenor2.length - 1]);
        int n5 = lIBORMarketModel.getTimeIndex(Math.min(this.swapTenor1[0], this.swapTenor2[0]));
        double[] dArray = SwaptionSingleCurveAnalyticApproximation.getLogSwaprateDerivative(lIBORMarketModel.getLiborPeriodDiscretization(), lIBORMarketModel.getForwardRateCurve(), this.swapTenor1).get("values");
        double[] dArray2 = SwaptionSingleCurveAnalyticApproximation.getLogSwaprateDerivative(lIBORMarketModel.getLiborPeriodDiscretization(), lIBORMarketModel.getForwardRateCurve(), this.swapTenor2).get("values");
        double[][] dArray3 = lIBORMarketModel.getIntegratedLIBORCovariance()[n5];
        double d2 = 0.0;
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                d2 += dArray[i - n] * dArray2[j - n3] * dArray3[i][j];
            }
        }
        return new RandomVariable(d, d2);
    }
}

