/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class ForwardRateVolatilitySurfaceCurvature
extends AbstractLIBORMonteCarloProduct {
    private double tolerance = 0.0;

    public ForwardRateVolatilitySurfaceCurvature() {
    }

    public ForwardRateVolatilitySurfaceCurvature(double d) {
        this.tolerance = d;
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) {
        return this.getValues(d, lIBORModelMonteCarloSimulationInterface.getModel());
    }

    public RandomVariableInterface getValues(double d, LIBORMarketModelInterface lIBORMarketModelInterface) {
        if (d > 0.0) {
            throw new RuntimeException("Forward start evaluation currently not supported.");
        }
        AbstractLIBORCovarianceModel abstractLIBORCovarianceModel = lIBORMarketModelInterface.getCovarianceModel();
        int n = abstractLIBORCovarianceModel.getLiborPeriodDiscretization().getNumberOfTimeSteps();
        RandomVariableInterface randomVariableInterface = new RandomVariable(0.0);
        for (int i = 0; i < n; ++i) {
            double d2 = abstractLIBORCovarianceModel.getLiborPeriodDiscretization().getTime(i);
            int n2 = abstractLIBORCovarianceModel.getTimeDiscretization().getTimeIndex(d2);
            if (n2 < 0) {
                n2 = -n2 - 2;
            }
            RandomVariableInterface randomVariableInterface2 = new RandomVariable(0.0);
            for (int j = 0; j < n2 - 2; ++j) {
                double d3 = abstractLIBORCovarianceModel.getTimeDiscretization().getTimeStep(j);
                double d4 = abstractLIBORCovarianceModel.getTimeDiscretization().getTimeStep(j + 1);
                RandomVariableInterface randomVariableInterface3 = abstractLIBORCovarianceModel.getCovariance(j + 0, i, i, (RandomVariableInterface[])null);
                RandomVariableInterface randomVariableInterface4 = abstractLIBORCovarianceModel.getCovariance(j + 1, i, i, (RandomVariableInterface[])null);
                RandomVariableInterface randomVariableInterface5 = abstractLIBORCovarianceModel.getCovariance(j + 2, i, i, (RandomVariableInterface[])null);
                RandomVariableInterface randomVariableInterface6 = randomVariableInterface5.sub(randomVariableInterface4.mult(2.0)).add(randomVariableInterface3);
                randomVariableInterface6 = randomVariableInterface6.div(d3 * d4);
                randomVariableInterface6 = randomVariableInterface6.squared();
                randomVariableInterface2 = randomVariableInterface2.add(randomVariableInterface6.mult(d3));
            }
            if (d2 == 0.0) continue;
            randomVariableInterface2 = randomVariableInterface2.div(d2);
            randomVariableInterface2 = randomVariableInterface2.sqrt();
            randomVariableInterface = randomVariableInterface.add(randomVariableInterface2);
        }
        randomVariableInterface = randomVariableInterface.div(n);
        return randomVariableInterface.sub(this.tolerance).floor(0.0);
    }
}

