/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORVolatilityModelFourParameterExponentialForm
extends LIBORVolatilityModel {
    private double a;
    private double b;
    private double c;
    private double d;
    private boolean isCalibrateable = false;

    public LIBORVolatilityModelFourParameterExponentialForm(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, double d, double d2, double d3, double d4, boolean bl) {
        super(timeDiscretizationInterface, timeDiscretizationInterface2);
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.isCalibrateable = bl;
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        double[] dArray = new double[]{this.a, this.b, this.c, this.d};
        return dArray;
    }

    @Override
    public void setParameter(double[] dArray) {
        if (!this.isCalibrateable) {
            return;
        }
        this.a = dArray[0];
        this.b = dArray[1];
        this.c = dArray[2];
        this.d = dArray[3];
    }

    @Override
    public RandomVariableInterface getVolatility(int n, int n2) {
        double d = this.getTimeDiscretization().getTime(n);
        double d2 = this.getLiborPeriodDiscretization().getTime(n2);
        double d3 = d2 - d;
        double d4 = d3 <= 0.0 ? 0.0 : (this.a + this.b * d3) * Math.exp(-this.c * d3) + this.d;
        if (d4 < 0.0) {
            d4 = Math.max(d4, 0.0);
        }
        return new RandomVariable(this.getTimeDiscretization().getTime(n), d4);
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelFourParameterExponentialForm(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.a, this.b, this.c, this.d, this.isCalibrateable);
    }
}

