/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.stochastic.RandomVariableInterface;

public class BlendedLocalVolatilityModel
extends AbstractLIBORCovarianceModelParametric {
    private AbstractLIBORCovarianceModelParametric covarianceModel;
    private double displacement;
    private ForwardCurveInterface forwardCurve;
    private boolean isCalibrateable = false;

    public BlendedLocalVolatilityModel(AbstractLIBORCovarianceModelParametric abstractLIBORCovarianceModelParametric, ForwardCurveInterface forwardCurveInterface, double d, boolean bl) {
        super(abstractLIBORCovarianceModelParametric.getTimeDiscretization(), abstractLIBORCovarianceModelParametric.getLiborPeriodDiscretization(), abstractLIBORCovarianceModelParametric.getNumberOfFactors());
        this.covarianceModel = abstractLIBORCovarianceModelParametric;
        this.forwardCurve = forwardCurveInterface;
        this.displacement = d;
        this.isCalibrateable = bl;
    }

    public BlendedLocalVolatilityModel(AbstractLIBORCovarianceModelParametric abstractLIBORCovarianceModelParametric, double d, boolean bl) {
        this(abstractLIBORCovarianceModelParametric, null, d, bl);
    }

    @Override
    public Object clone() {
        return new BlendedLocalVolatilityModel((AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone(), this.forwardCurve, this.displacement, this.isCalibrateable);
    }

    public AbstractLIBORCovarianceModelParametric getBaseCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return this.covarianceModel.getParameter();
        }
        double[] dArray = this.covarianceModel.getParameter();
        if (dArray == null) {
            return new double[]{this.displacement};
        }
        double[] dArray2 = new double[dArray.length + 1];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        dArray2[dArray.length] = this.displacement;
        return dArray2;
    }

    @Override
    public void setParameter(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return;
        }
        if (!this.isCalibrateable) {
            this.covarianceModel.setParameter(dArray);
            return;
        }
        double[] dArray2 = new double[dArray.length - 1];
        System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
        this.covarianceModel.setParameter(dArray2);
        this.displacement = dArray[dArray2.length];
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray) {
        RandomVariableInterface[] randomVariableInterfaceArray2 = this.covarianceModel.getFactorLoading(n, n2, randomVariableInterfaceArray);
        double d = 1.0;
        if (this.forwardCurve != null) {
            double d2 = this.getLiborPeriodDiscretization().getTime(n2) - this.getTimeDiscretization().getTime(n);
            d = this.forwardCurve.getForward(null, Math.max(d2, 0.0));
        }
        if (randomVariableInterfaceArray != null && randomVariableInterfaceArray[n2] != null) {
            RandomVariableInterface randomVariableInterface = randomVariableInterfaceArray[n2].mult(1.0 - this.displacement).add(this.displacement * d);
            for (int i = 0; i < randomVariableInterfaceArray2.length; ++i) {
                randomVariableInterfaceArray2[i] = randomVariableInterfaceArray2[i].mult(randomVariableInterface);
            }
        }
        return randomVariableInterfaceArray2;
    }

    @Override
    public RandomVariable getFactorLoadingPseudoInverse(int n, int n2, int n3, RandomVariableInterface[] randomVariableInterfaceArray) {
        throw new UnsupportedOperationException();
    }
}

