/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulation;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.SolverException;
import net.finmath.time.TimeDiscretizationInterface;

public abstract class AbstractLIBORCovarianceModelParametric
extends AbstractLIBORCovarianceModel {
    private static final Logger logger = Logger.getLogger("net.finmath");

    public AbstractLIBORCovarianceModelParametric(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, int n) {
        super(timeDiscretizationInterface, timeDiscretizationInterface2, n);
    }

    public abstract double[] getParameter();

    public abstract void setParameter(double[] var1);

    public abstract Object clone();

    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] dArray) {
        AbstractLIBORCovarianceModelParametric abstractLIBORCovarianceModelParametric = (AbstractLIBORCovarianceModelParametric)this.clone();
        abstractLIBORCovarianceModelParametric.setParameter(dArray);
        return abstractLIBORCovarianceModelParametric;
    }

    public AbstractLIBORCovarianceModelParametric getCloneCalibrated(LIBORMarketModelInterface lIBORMarketModelInterface, AbstractLIBORMonteCarloProduct[] abstractLIBORMonteCarloProductArray, double[] dArray, double[] dArray2) throws CalculationException {
        return this.getCloneCalibrated(lIBORMarketModelInterface, abstractLIBORMonteCarloProductArray, dArray, dArray2, null);
    }

    public AbstractLIBORCovarianceModelParametric getCloneCalibrated(final LIBORMarketModelInterface lIBORMarketModelInterface, final AbstractLIBORMonteCarloProduct[] abstractLIBORMonteCarloProductArray, final double[] dArray, double[] dArray2, Map<String, Object> map) throws CalculationException {
        double[] dArray3 = this.getParameter();
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        Integer n = (Integer)map.get("numberOfPaths");
        Integer n2 = (Integer)map.get("seed");
        Integer n3 = (Integer)map.get("maxIterations");
        Double d = (Double)map.get("accuracy");
        BrownianMotionInterface brownianMotionInterface = (BrownianMotionInterface)map.get("brownianMotion");
        int n4 = n != null ? n : 2000;
        int n5 = n2 != null ? n2 : 31415;
        int n6 = n3 != null ? n3 : 400;
        double d2 = d != null ? d : 1.0E-7;
        int n7 = 2 * Math.min(2, Runtime.getRuntime().availableProcessors());
        final ExecutorService executorService = Executors.newFixedThreadPool(n7);
        final BrownianMotionInterface brownianMotionInterface2 = brownianMotionInterface != null ? brownianMotionInterface : new BrownianMotion(this.getTimeDiscretization(), this.getNumberOfFactors(), n4, n5);
        int n8 = 5;
        LevenbergMarquardt levenbergMarquardt = new LevenbergMarquardt(dArray3, dArray, n6, n8){

            @Override
            public void setValues(double[] dArray3, double[] dArray2) throws SolverException {
                int n;
                AbstractLIBORCovarianceModelParametric abstractLIBORCovarianceModelParametric = AbstractLIBORCovarianceModelParametric.this.getCloneWithModifiedParameters(dArray3);
                LIBORMarketModelInterface lIBORMarketModelInterface2 = lIBORMarketModelInterface.getCloneWithModifiedCovarianceModel(abstractLIBORCovarianceModelParametric);
                ProcessEulerScheme processEulerScheme = new ProcessEulerScheme(brownianMotionInterface2);
                final LIBORModelMonteCarloSimulation lIBORModelMonteCarloSimulation = new LIBORModelMonteCarloSimulation(lIBORMarketModelInterface2, processEulerScheme);
                ArrayList<Future<Double>> arrayList = new ArrayList<Future<Double>>(abstractLIBORMonteCarloProductArray.length);
                for (n = 0; n < abstractLIBORMonteCarloProductArray.length; ++n) {
                    Future<Double> future;
                    final int n2 = n;
                    Callable<Double> callable = new Callable<Double>(){

                        @Override
                        public Double call() throws SolverException {
                            try {
                                return abstractLIBORMonteCarloProductArray[n2].getValue(lIBORModelMonteCarloSimulation);
                            }
                            catch (CalculationException calculationException) {
                                return dArray[n2];
                            }
                            catch (Exception exception) {
                                return dArray[n2];
                            }
                        }
                    };
                    if (executorService != null) {
                        future = executorService.submit(callable);
                        arrayList.add(n, future);
                        continue;
                    }
                    future = new FutureTask<Double>(callable);
                    ((FutureTask)future).run();
                    arrayList.add(n, future);
                }
                for (n = 0; n < abstractLIBORMonteCarloProductArray.length; ++n) {
                    try {
                        double d;
                        dArray2[n] = d = ((Double)((Future)arrayList.get(n)).get()).doubleValue();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new SolverException(interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        throw new SolverException(executionException);
                    }
                }
            }
        };
        levenbergMarquardt.setWeights(dArray2);
        levenbergMarquardt.setErrorTolerance(d2);
        try {
            levenbergMarquardt.run();
        }
        catch (SolverException solverException) {
            throw new CalculationException(solverException);
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
            }
        }
        double[] dArray4 = levenbergMarquardt.getBestFitParameters();
        AbstractLIBORCovarianceModelParametric abstractLIBORCovarianceModelParametric = this.getCloneWithModifiedParameters(dArray4);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("The solver required " + levenbergMarquardt.getIterations() + " iterations. The best fit parameters are:");
            String string = "Best parameters:";
            for (int i = 0; i < dArray4.length; ++i) {
                string = string + "\tparameter[" + i + "]: " + dArray4[i];
            }
            logger.fine(string);
        }
        return abstractLIBORCovarianceModelParametric;
    }

    public String toString() {
        return "AbstractLIBORCovarianceModelParametric [getParameter()=" + Arrays.toString(this.getParameter()) + "]";
    }
}

