/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import cern.jet.random.engine.MersenneTwister64;
import java.io.Serializable;
import net.finmath.functions.NormalDistribution;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class BrownianMotion
implements BrownianMotionInterface,
Serializable {
    private static final long serialVersionUID = -5430067621669213475L;
    private final TimeDiscretizationInterface timeDiscretization;
    private final int numberOfFactors;
    private final int numberOfPaths;
    private final int seed;
    private AbstractRandomVariableFactory randomVariableFactory = new RandomVariableFactory();
    private transient RandomVariableInterface[][] brownianIncrements;
    private final Object brownianIncrementsLazyInitLock = new Object();

    public BrownianMotion(TimeDiscretizationInterface timeDiscretizationInterface, int n, int n2, int n3) {
        this.timeDiscretization = timeDiscretizationInterface;
        this.numberOfFactors = n;
        this.numberOfPaths = n2;
        this.seed = n3;
        this.brownianIncrements = null;
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedSeed(int n) {
        return new BrownianMotion(this.getTimeDiscretization(), this.getNumberOfFactors(), this.getNumberOfPaths(), n);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedTimeDiscretization(TimeDiscretizationInterface timeDiscretizationInterface) {
        return new BrownianMotion(timeDiscretizationInterface, this.getNumberOfFactors(), this.getNumberOfPaths(), this.getSeed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getBrownianIncrement(int n, int n2) {
        Object object = this.brownianIncrementsLazyInitLock;
        synchronized (object) {
            if (this.brownianIncrements == null) {
                this.doGenerateBrownianMotion();
            }
        }
        return this.brownianIncrements[n][n2];
    }

    private void doGenerateBrownianMotion() {
        int n;
        if (this.brownianIncrements != null) {
            return;
        }
        MersenneTwister64 mersenneTwister64 = new MersenneTwister64(this.seed);
        double[][][] dArray = new double[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors][this.numberOfPaths];
        double[] dArray2 = new double[this.timeDiscretization.getNumberOfTimeSteps()];
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = Math.sqrt(this.timeDiscretization.getTimeStep(n));
        }
        for (n = 0; n < this.numberOfPaths; ++n) {
            for (int i = 0; i < this.timeDiscretization.getNumberOfTimeSteps(); ++i) {
                double d = dArray2[i];
                for (int j = 0; j < this.numberOfFactors; ++j) {
                    double d2 = mersenneTwister64.nextDouble();
                    dArray[i][j][n] = NormalDistribution.inverseCumulativeDistribution(d2) * d;
                }
            }
        }
        this.brownianIncrements = new RandomVariableInterface[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors];
        for (n = 0; n < this.timeDiscretization.getNumberOfTimeSteps(); ++n) {
            double d = this.timeDiscretization.getTime(n + 1);
            for (int i = 0; i < this.numberOfFactors; ++i) {
                this.brownianIncrements[n][i] = this.randomVariableFactory.createRandomVariable(d, dArray[n][i]);
            }
        }
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    @Override
    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double d) {
        return this.randomVariableFactory.createRandomVariable(d);
    }

    public int getSeed() {
        return this.seed;
    }

    public String toString() {
        return super.toString() + "\n" + "timeDiscretization: " + this.timeDiscretization.toString() + "\n" + "numberOfPaths: " + this.numberOfPaths + "\n" + "numberOfFactors: " + this.numberOfFactors + "\n" + "seed: " + this.seed;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BrownianMotion brownianMotion = (BrownianMotion)object;
        if (this.numberOfFactors != brownianMotion.numberOfFactors) {
            return false;
        }
        if (this.numberOfPaths != brownianMotion.numberOfPaths) {
            return false;
        }
        if (this.seed != brownianMotion.seed) {
            return false;
        }
        return this.timeDiscretization.equals(brownianMotion.timeDiscretization);
    }

    public int hashCode() {
        int n = this.timeDiscretization.hashCode();
        n = 31 * n + this.numberOfFactors;
        n = 31 * n + this.numberOfPaths;
        n = 31 * n + this.seed;
        return n;
    }
}

