/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.time.RegularSchedule;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class SwapAnnuity
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private final ScheduleInterface schedule;
    private final String discountCurveName;

    public SwapAnnuity(ScheduleInterface scheduleInterface, String string) {
        this.schedule = scheduleInterface;
        this.discountCurveName = string;
    }

    @Override
    public double getValue(double d, AnalyticModelInterface analyticModelInterface) {
        DiscountCurveInterface discountCurveInterface = (DiscountCurveInterface)analyticModelInterface.getCurve(this.discountCurveName);
        return SwapAnnuity.getSwapAnnuity(d, this.schedule, discountCurveInterface, analyticModelInterface);
    }

    public static double getSwapAnnuity(TimeDiscretizationInterface timeDiscretizationInterface, DiscountCurveInterface discountCurveInterface) {
        return SwapAnnuity.getSwapAnnuity((ScheduleInterface)new RegularSchedule(timeDiscretizationInterface), discountCurveInterface);
    }

    public static double getSwapAnnuity(TimeDiscretizationInterface timeDiscretizationInterface, ForwardCurveInterface forwardCurveInterface) {
        return SwapAnnuity.getSwapAnnuity((ScheduleInterface)new RegularSchedule(timeDiscretizationInterface), forwardCurveInterface);
    }

    public static double getSwapAnnuity(ScheduleInterface scheduleInterface, DiscountCurveInterface discountCurveInterface) {
        double d = 0.0;
        return SwapAnnuity.getSwapAnnuity(d, scheduleInterface, discountCurveInterface, null);
    }

    public static double getSwapAnnuity(ScheduleInterface scheduleInterface, ForwardCurveInterface forwardCurveInterface) {
        DiscountCurveFromForwardCurve discountCurveFromForwardCurve = new DiscountCurveFromForwardCurve(forwardCurveInterface.getName());
        double d = 0.0;
        return SwapAnnuity.getSwapAnnuity(d, scheduleInterface, discountCurveFromForwardCurve, new AnalyticModel(new CurveInterface[]{forwardCurveInterface, discountCurveFromForwardCurve}));
    }

    public static double getSwapAnnuity(double d, ScheduleInterface scheduleInterface, DiscountCurveInterface discountCurveInterface, AnalyticModelInterface analyticModelInterface) {
        double d2 = 0.0;
        for (int i = 0; i < scheduleInterface.getNumberOfPeriods(); ++i) {
            double d3 = scheduleInterface.getPayment(i);
            if (d3 <= d) continue;
            double d4 = scheduleInterface.getPeriodLength(i);
            double d5 = discountCurveInterface.getDiscountFactor(analyticModelInterface, d3);
            d2 += d4 * d5;
        }
        return d2 / discountCurveInterface.getDiscountFactor(analyticModelInterface, d);
    }

    public String toString() {
        return "SwapAnnuity [schedule=" + this.schedule + ", discountCurveName=" + this.discountCurveName + "]";
    }
}

