/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;

public class Cashflow
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private final double flowAmount;
    private final double flowDate;
    private final boolean isPayer;
    private final String discountCurveName;

    public Cashflow(String string, double d, double d2, boolean bl, String string2) {
        this.flowAmount = d;
        this.flowDate = d2;
        this.isPayer = bl;
        this.discountCurveName = string2;
    }

    @Override
    public double getValue(double d, AnalyticModelInterface analyticModelInterface) {
        DiscountCurveInterface discountCurveInterface = analyticModelInterface.getDiscountCurve(this.discountCurveName);
        if (discountCurveInterface == null && this.flowDate > d) {
            throw new IllegalArgumentException("Model does not provide a discount curve under the name \"" + this.discountCurveName + "\"");
        }
        double d2 = this.flowDate > d ? discountCurveInterface.getDiscountFactor(analyticModelInterface, this.flowDate) : 0.0;
        double d3 = (this.isPayer ? -1.0 : 1.0) * this.flowAmount * d2;
        return d3 / discountCurveInterface.getDiscountFactor(analyticModelInterface, d);
    }
}

