/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.util.Calendar;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;

public abstract class AbstractVolatilitySurface
implements VolatilitySurfaceInterface,
Cloneable {
    private final Calendar referenceDate;
    private final String name;
    protected ForwardCurveInterface forwardCurve;
    protected DiscountCurveInterface discountCurve;
    protected VolatilitySurfaceInterface.QuotingConvention quotingConvention;

    public AbstractVolatilitySurface(String string, Calendar calendar) {
        this.name = string;
        this.referenceDate = calendar;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Calendar getReferenceDate() {
        return this.referenceDate;
    }

    public String toString() {
        return super.toString() + "\n\"" + this.getName() + "\"";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public VolatilitySurfaceInterface.QuotingConvention getQuotingConvention() {
        return this.quotingConvention;
    }

    public double convertFromTo(AnalyticModelInterface analyticModelInterface, double d, double d2, double d3, VolatilitySurfaceInterface.QuotingConvention quotingConvention, VolatilitySurfaceInterface.QuotingConvention quotingConvention2) {
        if (quotingConvention.equals((Object)quotingConvention2)) {
            return d3;
        }
        double d4 = this.forwardCurve.getForward(null, d);
        double d5 = this.discountCurve.getDiscountFactor(d + this.forwardCurve.getPaymentOffset(d)) * this.forwardCurve.getPaymentOffset(d);
        if (quotingConvention2.equals((Object)VolatilitySurfaceInterface.QuotingConvention.PRICE) && quotingConvention.equals((Object)VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL)) {
            return AnalyticFormulas.blackScholesGeneralizedOptionValue(d4, d3, d, d2, d5);
        }
        if (quotingConvention2.equals((Object)VolatilitySurfaceInterface.QuotingConvention.PRICE) && quotingConvention.equals((Object)VolatilitySurfaceInterface.QuotingConvention.VOLATILITYNORMAL)) {
            return AnalyticFormulas.bachelierOptionValue(d4, d3, d, d2, d5);
        }
        if (quotingConvention2.equals((Object)VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL) && quotingConvention.equals((Object)VolatilitySurfaceInterface.QuotingConvention.PRICE)) {
            return AnalyticFormulas.blackScholesOptionImpliedVolatility(d4, d, d2, d5, d3);
        }
        if (quotingConvention2.equals((Object)VolatilitySurfaceInterface.QuotingConvention.VOLATILITYNORMAL) && quotingConvention.equals((Object)VolatilitySurfaceInterface.QuotingConvention.PRICE)) {
            return AnalyticFormulas.bachelierOptionImpliedVolatility(d4, d, d2, d5, d3);
        }
        return this.convertFromTo(analyticModelInterface, d, d2, this.convertFromTo(analyticModelInterface, d, d2, d3, quotingConvention, VolatilitySurfaceInterface.QuotingConvention.PRICE), VolatilitySurfaceInterface.QuotingConvention.PRICE, quotingConvention2);
    }

    public double convertFromTo(double d, double d2, double d3, VolatilitySurfaceInterface.QuotingConvention quotingConvention, VolatilitySurfaceInterface.QuotingConvention quotingConvention2) {
        return this.convertFromTo(null, d, d2, d3, quotingConvention, quotingConvention2);
    }
}

