/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import net.finmath.marketdata.calibration.ParameterObjectInterface;
import net.finmath.marketdata.calibration.Solver;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveNelsonSiegelSvensson;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.optimizer.SolverException;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;
import org.junit.Assert;
import org.junit.Test;

public class NelsonSiegelSvenssonCalibrationTest {
    public double[] calibrateNSSCurve(Map<String, Object> map) throws SolverException {
        Object object;
        Object object2;
        Calendar calendar = (Calendar)map.get("referenceDate");
        String string = (String)map.get("currency");
        String string2 = (String)map.get("forwardCurveTenor");
        String[] stringArray = (String[])map.get("maturities");
        String[] stringArray2 = (String[])map.get("fixLegFrequencies");
        String[] stringArray3 = (String[])map.get("floatLegFrequencies");
        String[] stringArray4 = (String[])map.get("fixLegDaycountConventions");
        String[] stringArray5 = (String[])map.get("floatLegDaycountConventions");
        double[] dArray = (double[])map.get("rates");
        Assert.assertEquals((long)stringArray.length, (long)stringArray2.length);
        Assert.assertEquals((long)stringArray.length, (long)stringArray4.length);
        Assert.assertEquals((long)stringArray.length, (long)dArray.length);
        Assert.assertEquals((long)stringArray2.length, (long)stringArray3.length);
        Assert.assertEquals((long)stringArray4.length, (long)stringArray5.length);
        int n = 2;
        String string3 = "0D";
        double[] dArray2 = new double[]{0.025, -0.015, -0.025, 0.03, 1.5, 10.0};
        DiscountCurveNelsonSiegelSvensson discountCurveNelsonSiegelSvensson = new DiscountCurveNelsonSiegelSvensson("discountCurve-" + string, calendar, dArray2, 1.0);
        ForwardCurveFromDiscountCurve forwardCurveFromDiscountCurve = new ForwardCurveFromDiscountCurve(discountCurveNelsonSiegelSvensson.getName(), calendar, string2);
        AnalyticModel analyticModel = new AnalyticModel(new CurveInterface[]{discountCurveNelsonSiegelSvensson, forwardCurveFromDiscountCurve});
        Vector<AnalyticProductInterface> vector = new Vector<AnalyticProductInterface>();
        for (int i = 0; i < dArray.length; ++i) {
            object2 = ScheduleGenerator.createScheduleFromConventions(calendar.getTime(), n, string3, stringArray[i], stringArray2[i], stringArray4[i], "first", "following", new BusinessdayCalendarExcludingTARGETHolidays(), -2, 0);
            object = ScheduleGenerator.createScheduleFromConventions(calendar.getTime(), n, string3, stringArray[i], stringArray3[i], stringArray5[i], "first", "following", new BusinessdayCalendarExcludingTARGETHolidays(), -2, 0);
            vector.add(new Swap((ScheduleInterface)object2, null, dArray[i], discountCurveNelsonSiegelSvensson.getName(), (ScheduleInterface)object, forwardCurveFromDiscountCurve.getName(), 0.0, discountCurveNelsonSiegelSvensson.getName()));
        }
        HashSet<ParameterObjectInterface> hashSet = new HashSet<ParameterObjectInterface>();
        hashSet.add(discountCurveNelsonSiegelSvensson);
        object2 = new Solver(analyticModel, vector);
        object = ((Solver)object2).getCalibratedModel(hashSet);
        System.out.println("Solver reported acccurary....: " + ((Solver)object2).getAccuracy());
        Assert.assertEquals((String)"Calibration accurarcy", (double)0.0, (double)((Solver)object2).getAccuracy(), (double)0.001);
        double[] dArray3 = object.getDiscountCurve(discountCurveNelsonSiegelSvensson.getName()).getParameter();
        discountCurveNelsonSiegelSvensson = new DiscountCurveNelsonSiegelSvensson(discountCurveNelsonSiegelSvensson.getName(), calendar, dArray3, 1.0);
        forwardCurveFromDiscountCurve = new ForwardCurveFromDiscountCurve(forwardCurveFromDiscountCurve.getName(), discountCurveNelsonSiegelSvensson.getName(), calendar, "3M", new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendarInterface.DateRollConvention.MODIFIED_FOLLOWING, 1.0, 0.0);
        analyticModel = new AnalyticModel(new CurveInterface[]{discountCurveNelsonSiegelSvensson, forwardCurveFromDiscountCurve});
        double d = 0.0;
        for (AnalyticProductInterface analyticProductInterface : vector) {
            double d2 = analyticProductInterface.getValue(0.0, analyticModel);
            double d3 = 0.0;
            double d4 = d2 - d3;
            d += d4 * d4;
        }
        double d5 = Math.sqrt(d / (double)vector.size());
        System.out.println("Independent checked acccurary: " + d5);
        return dArray3;
    }

    @Test
    public void testCalibration() throws SolverException {
        String[] stringArray = new String[]{"3M", "6M", "1Y", "2Y", "3Y", "4Y", "5Y", "6Y", "7Y", "8Y", "9Y", "10Y", "11Y", "12Y", "15Y", "20Y", "25Y", "30Y", "35Y", "40Y", "50Y"};
        String[] stringArray2 = new String[]{"annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual", "annual"};
        String[] stringArray3 = new String[]{"quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly", "quarterly"};
        String[] stringArray4 = new String[]{"ACT/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360", "E30/360"};
        String[] stringArray5 = new String[]{"ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360", "ACT/360"};
        double[] dArray = new double[]{0.0042, 0.0032, 0.0038, 0.0052, 0.0069, 0.00855, 0.0102, 0.0119, 0.0134, 0.015, 0.0165, 0.0178, 0.0189, 0.02, 0.0224, 0.025, 0.0264, 0.0271, 0.0275, 0.0276, 0.0276};
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("referenceDate", new GregorianCalendar(2014, 7, 12));
        hashMap.put("currency", "EUR");
        hashMap.put("forwardCurveTenor", "3M");
        hashMap.put("maturities", stringArray);
        hashMap.put("fixLegFrequencies", stringArray2);
        hashMap.put("floatLegFrequencies", stringArray3);
        hashMap.put("fixLegDaycountConventions", stringArray4);
        hashMap.put("floatLegDaycountConventions", stringArray5);
        hashMap.put("rates", dArray);
        double[] dArray2 = this.calibrateNSSCurve(hashMap);
        System.out.println(Arrays.toString(dArray2));
        System.out.println();
    }
}

