/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.interpolation;

import java.util.Arrays;
import net.finmath.functions.LinearAlgebra;

public class RationalFunctionInterpolation {
    private final double[] points;
    private final double[] values;
    private InterpolationMethod interpolationMethod = InterpolationMethod.LINEAR;
    private ExtrapolationMethod extrapolationMethod = ExtrapolationMethod.DEFAULT;
    private RationalFunction[] interpolatingRationalFunctions;
    private final Object interpolatingRationalFunctionsLazyInitLock = new Object();

    public RationalFunctionInterpolation(double[] dArray, double[] dArray2) {
        this.points = dArray;
        this.values = dArray2;
    }

    public RationalFunctionInterpolation(double[] dArray, double[] dArray2, InterpolationMethod interpolationMethod, ExtrapolationMethod extrapolationMethod) {
        this.points = dArray;
        this.values = dArray2;
        this.interpolationMethod = interpolationMethod;
        this.extrapolationMethod = extrapolationMethod;
    }

    public InterpolationMethod getInterpolationMethod() {
        return this.interpolationMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getValue(double d) {
        Object object = this.interpolatingRationalFunctionsLazyInitLock;
        synchronized (object) {
            if (this.interpolatingRationalFunctions == null) {
                this.doCreateRationalFunctions();
            }
        }
        int n = Arrays.binarySearch(this.points, d);
        if (n >= 0) {
            return this.values[n];
        }
        int n2 = -n - 2;
        if (n2 < 0) {
            if (this.extrapolationMethod == ExtrapolationMethod.CONSTANT) {
                return this.values[0];
            }
            if (this.extrapolationMethod == ExtrapolationMethod.LINEAR) {
                return this.values[0] + (this.values[1] - this.values[0]) / (this.points[1] - this.points[0]) * (d - this.points[0]);
            }
            n2 = 0;
        } else if (n2 > this.points.length - 2) {
            if (this.extrapolationMethod == ExtrapolationMethod.CONSTANT) {
                return this.values[this.points.length - 1];
            }
            if (this.extrapolationMethod == ExtrapolationMethod.LINEAR) {
                return this.values[this.points.length - 1] + (this.values[this.points.length - 2] - this.values[this.points.length - 1]) / (this.points[this.points.length - 2] - this.points[this.points.length - 1]) * (d - this.points[this.points.length - 1]);
            }
            n2 = this.points.length - 2;
        }
        RationalFunction rationalFunction = this.interpolatingRationalFunctions[n2];
        return rationalFunction.getValue(d - this.points[n2]);
    }

    private void doCreateRationalFunctions() {
        switch (this.interpolationMethod) {
            case PIECEWISE_CONSTANT: 
            case PIECEWISE_CONSTANT_LEFTPOINT: 
            case PIECEWISE_CONSTANT_RIGHTPOINT: {
                this.doCreateRationalFunctionsForPiecewiseConstantInterpolation();
                break;
            }
            default: {
                this.doCreateRationalFunctionsForLinearInterpolation();
                break;
            }
            case CUBIC_SPLINE: {
                this.doCreateRationalFunctionsForCubicSplineInterpolation();
                break;
            }
            case AKIMA: {
                this.doCreateRationalFunctionsForAkimaInterpolation();
                break;
            }
            case AKIMA_CONTINUOUS: {
                this.doCreateRationalFunctionsForAkimaInterpolation(0.01);
                break;
            }
            case HARMONIC_SPLINE: {
                this.doCreateRationalFunctionsForHarmonicSplineInterpolation();
                break;
            }
            case HARMONIC_SPLINE_WITH_MONOTONIC_FILTERING: {
                this.doCreateRationalFunctionsForHarmonicSplineInterpolation();
            }
        }
    }

    private void doCreateRationalFunctionsForPiecewiseConstantInterpolation() {
        this.interpolatingRationalFunctions = new RationalFunction[this.points.length - 1];
        for (int i = 0; i < this.points.length - 1; ++i) {
            double[] dArray = this.interpolationMethod == InterpolationMethod.PIECEWISE_CONSTANT_RIGHTPOINT ? new double[]{this.values[i + 1]} : new double[]{this.values[i]};
            this.interpolatingRationalFunctions[i] = new RationalFunction(dArray);
        }
    }

    private void doCreateRationalFunctionsForLinearInterpolation() {
        this.interpolatingRationalFunctions = new RationalFunction[this.points.length - 1];
        for (int i = 0; i < this.points.length - 1; ++i) {
            double[] dArray = new double[2];
            double d = this.points[i];
            double d2 = this.points[i + 1];
            double d3 = this.values[i];
            double d4 = this.values[i + 1];
            dArray[1] = (d4 - d3) / (d2 - d);
            dArray[0] = d3;
            this.interpolatingRationalFunctions[i] = new RationalFunction(dArray);
        }
    }

    private void doCreateRationalFunctionsForCubicSplineInterpolation() {
        int n;
        int n2 = this.points.length;
        double[] dArray = new double[n2 - 1];
        for (int i = 0; i < n2 - 1; ++i) {
            dArray[i] = this.points[i + 1] - this.points[i];
        }
        double[] dArray2 = new double[n2];
        double[][] dArray3 = new double[n2][n2];
        double[] dArray4 = new double[n2];
        dArray3[0][0] = 1.0;
        dArray3[n2 - 1][n2 - 1] = 1.0;
        dArray4[0] = 0.0;
        dArray4[n2 - 1] = 0.0;
        for (n = 1; n < n2 - 1; ++n) {
            dArray4[n] = 6.0 * ((this.values[n + 1] - this.values[n]) / dArray[n] - (this.values[n] - this.values[n - 1]) / dArray[n - 1]);
            dArray3[n][n - 1] = dArray[n - 1];
            dArray3[n][n] = 2.0 * (dArray[n - 1] + dArray[n]);
            dArray3[n][n + 1] = dArray[n];
        }
        if (n2 > 1) {
            dArray3[0][1] = dArray3[1][0];
            dArray3[n2 - 2][n2 - 1] = dArray3[n2 - 1][n2 - 2];
        }
        dArray2 = LinearAlgebra.solveLinearEquationSymmetric(dArray3, dArray4);
        this.interpolatingRationalFunctions = new RationalFunction[n2 - 1];
        for (n = 0; n < n2 - 1; ++n) {
            double[] dArray5 = new double[]{this.values[n], (this.values[n + 1] - this.values[n]) / dArray[n] - (dArray2[n + 1] + 2.0 * dArray2[n]) * dArray[n] / 6.0, dArray2[n] / 2.0, (dArray2[n + 1] - dArray2[n]) / (6.0 * dArray[n])};
            this.interpolatingRationalFunctions[n] = new RationalFunction(dArray5);
        }
    }

    private void doCreateRationalFunctionsForAkimaInterpolation() {
        this.doCreateRationalFunctionsForAkimaInterpolation(0.0);
    }

    private void doCreateRationalFunctionsForAkimaInterpolation(double d) {
        int n = this.points.length;
        if (n < 4) {
            this.doCreateRationalFunctionsForCubicSplineInterpolation();
        } else {
            int n2;
            double[] dArray = new double[n - 1];
            double[] dArray2 = new double[n - 1];
            double[] dArray3 = new double[n - 2];
            for (int i = 0; i < n - 1; ++i) {
                dArray[i] = this.points[i + 1] - this.points[i];
                dArray2[i] = (this.values[i + 1] - this.values[i]) / dArray[i];
                if (i <= 0) continue;
                dArray3[i - 1] = Math.abs(dArray2[i] - dArray2[i - 1]) + d;
            }
            double[] dArray4 = new double[n];
            dArray4[0] = 0.5 * (3.0 * dArray2[0] - dArray2[1]);
            dArray4[1] = dArray3[1] == 0.0 && dArray3[0] == 0.0 ? (dArray[1] * dArray2[0] + dArray[0] * dArray2[1]) / (dArray[0] + dArray[1]) : (dArray3[1] * dArray2[0] + dArray3[0] * dArray2[1]) / (dArray3[1] + dArray3[0]);
            dArray4[n - 2] = dArray3[n - 3] == 0.0 && dArray3[n - 4] == 0.0 ? (dArray[n - 2] * dArray2[n - 3] + dArray[n - 3] * dArray2[n - 2]) / (dArray[n - 3] + dArray[n - 2]) : (dArray3[n - 3] * dArray2[n - 3] + dArray3[n - 4] * dArray2[n - 2]) / (dArray3[n - 3] + dArray3[n - 4]);
            dArray4[n - 1] = 0.5 * (3.0 * dArray2[n - 2] - dArray2[n - 3]);
            for (n2 = 2; n2 < n - 2; ++n2) {
                dArray4[n2] = dArray3[n2] == 0.0 && dArray3[n2 - 2] == 0.0 ? (dArray[n2] * dArray2[n2 - 1] + dArray[n2 - 1] * dArray2[n2]) / (dArray[n2 - 1] + dArray[n2]) : (dArray3[n2] * dArray2[n2 - 1] + dArray3[n2 - 2] * dArray2[n2]) / (dArray3[n2] + dArray3[n2 - 2]);
            }
            this.interpolatingRationalFunctions = new RationalFunction[n - 1];
            for (n2 = 0; n2 < n - 1; ++n2) {
                double[] dArray5 = new double[]{this.values[n2], dArray4[n2], (3.0 * dArray2[n2] - 2.0 * dArray4[n2] - dArray4[n2 + 1]) / dArray[n2], (dArray4[n2] + dArray4[n2 + 1] - 2.0 * dArray2[n2]) / (dArray[n2] * dArray[n2])};
                this.interpolatingRationalFunctions[n2] = new RationalFunction(dArray5);
            }
        }
    }

    private void doCreateRationalFunctionsForHarmonicSplineInterpolation() {
        int n;
        int n2 = this.points.length;
        double[] dArray = new double[n2 - 1];
        double[] dArray2 = new double[n2 - 1];
        double[] dArray3 = new double[n2 - 2];
        for (int i = 0; i < n2 - 1; ++i) {
            dArray[i] = this.points[i + 1] - this.points[i];
            dArray2[i] = (this.values[i + 1] - this.values[i]) / dArray[i];
            if (i <= 0) continue;
            dArray3[i - 1] = this.points[i + 1] - this.points[i - 1];
        }
        double[] dArray4 = new double[n2];
        dArray4[0] = (2.0 * dArray[0] + dArray[1]) / dArray3[0] * dArray2[0] - dArray[0] / dArray3[0] * dArray2[1];
        dArray4[n2 - 1] = (2.0 * dArray[n2 - 2] + dArray[n2 - 3]) / dArray3[n2 - 3] * dArray2[n2 - 2] - dArray[n2 - 2] / dArray3[n2 - 3] * dArray2[n2 - 3];
        if (this.interpolationMethod == InterpolationMethod.HARMONIC_SPLINE_WITH_MONOTONIC_FILTERING) {
            if (dArray4[0] * dArray2[0] > 0.0 && dArray2[0] * dArray2[1] <= 0.0 && Math.abs(dArray4[0]) < 3.0 * Math.abs(dArray2[0])) {
                dArray4[0] = 3.0 * dArray2[0];
            }
            if (dArray4[0] * dArray2[0] <= 0.0) {
                dArray4[0] = 0.0;
            }
            if (dArray4[n2 - 1] * dArray2[n2 - 2] > 0.0 && dArray2[n2 - 2] * dArray2[n2 - 3] <= 0.0 && Math.abs(dArray4[n2 - 1]) < 3.0 * Math.abs(dArray2[n2 - 2])) {
                dArray4[n2 - 1] = 3.0 * dArray2[n2 - 2];
            }
            if (dArray4[n2 - 1] * dArray2[n2 - 2] <= 0.0) {
                dArray4[n2 - 1] = 0.0;
            }
        }
        for (n = 1; n < n2 - 1; ++n) {
            if (dArray2[n - 1] * dArray2[n] <= 0.0) {
                dArray4[n] = 0.0;
                continue;
            }
            double d = (dArray[n - 1] + 2.0 * dArray[n]) / (3.0 * dArray3[n - 1] * dArray2[n - 1]) + (2.0 * dArray[n - 1] + dArray[n]) / (3.0 * dArray3[n - 1] * dArray2[n]);
            dArray4[n] = 1.0 / d;
        }
        this.interpolatingRationalFunctions = new RationalFunction[n2 - 1];
        for (n = 0; n < n2 - 1; ++n) {
            double[] dArray5 = new double[]{this.values[n], dArray4[n], (3.0 * dArray2[n] - 2.0 * dArray4[n] - dArray4[n + 1]) / dArray[n], (dArray4[n] + dArray4[n + 1] - 2.0 * dArray2[n]) / (dArray[n] * dArray[n])};
            this.interpolatingRationalFunctions[n] = new RationalFunction(dArray5);
        }
    }

    public static void main(String[] stringArray) {
        double d;
        double d2;
        int n;
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        double[] dArray2 = new double[]{5.0, 6.0, 4.0, 7.0, 5.0, 6.0};
        System.out.println("Interplation of given input points (x,y):");
        System.out.println("  x: " + Arrays.toString(dArray));
        System.out.println("  y: " + Arrays.toString(dArray2));
        System.out.println("");
        System.out.println("Default:");
        RationalFunctionInterpolation rationalFunctionInterpolation = new RationalFunctionInterpolation(dArray, dArray2);
        for (n = 0; n < 200; ++n) {
            d2 = dArray[0] + (double)n / 199.0 * dArray[dArray.length - 1] - dArray[0];
            d = rationalFunctionInterpolation.getValue(d2);
            System.out.println("" + d2 + "\t" + d);
        }
        System.out.println("");
        rationalFunctionInterpolation = new RationalFunctionInterpolation(dArray, dArray2, InterpolationMethod.AKIMA, ExtrapolationMethod.CONSTANT);
        System.out.println("AKIMA:");
        for (n = 0; n < 200; ++n) {
            d2 = dArray[0] + (double)n / 199.0 * dArray[dArray.length - 1] - dArray[0];
            d = rationalFunctionInterpolation.getValue(d2);
            System.out.println("" + d2 + "\t" + d);
        }
        System.out.println("");
        rationalFunctionInterpolation = new RationalFunctionInterpolation(dArray, dArray2, InterpolationMethod.CUBIC_SPLINE, ExtrapolationMethod.CONSTANT);
        System.out.println("CUBIC_SPLINE:");
        for (n = 0; n < 200; ++n) {
            d2 = dArray[0] + (double)n / 199.0 * dArray[dArray.length - 1] - dArray[0];
            d = rationalFunctionInterpolation.getValue(d2);
            System.out.println("" + d2 + "\t" + d);
        }
        System.out.println("");
        rationalFunctionInterpolation = new RationalFunctionInterpolation(dArray, dArray2, InterpolationMethod.PIECEWISE_CONSTANT, ExtrapolationMethod.CONSTANT);
        System.out.println("PIECEWISE_CONSTANT:");
        for (n = 0; n < 200; ++n) {
            d2 = dArray[0] + (double)n / 199.0 * dArray[dArray.length - 1] - dArray[0];
            d = rationalFunctionInterpolation.getValue(d2);
            System.out.println("" + d2 + "\t" + d);
        }
        System.out.println("");
        rationalFunctionInterpolation = new RationalFunctionInterpolation(dArray, dArray2, InterpolationMethod.HARMONIC_SPLINE, ExtrapolationMethod.CONSTANT);
        System.out.println("HARMONIC_SPLINE:");
        for (n = 0; n < 200; ++n) {
            d2 = dArray[0] + (double)n / 199.0 * dArray[dArray.length - 1] - dArray[0];
            d = rationalFunctionInterpolation.getValue(d2);
            System.out.println("" + d2 + "\t" + d);
        }
        System.out.println("");
    }

    private class RationalFunction {
        public final double[] coefficientsNumerator;
        public final double[] coefficientsDenominator;

        public RationalFunction(double[] dArray, double[] dArray2) {
            this.coefficientsNumerator = dArray;
            this.coefficientsDenominator = dArray2;
        }

        public RationalFunction(double[] dArray) {
            this.coefficientsNumerator = dArray;
            this.coefficientsDenominator = null;
        }

        public double getValue(double d) {
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 1.0;
            for (double d5 : this.coefficientsNumerator) {
                d2 += d5 * d4;
                d4 *= d;
            }
            if (this.coefficientsDenominator == null) {
                return d2;
            }
            d4 = 1.0;
            for (double d5 : this.coefficientsDenominator) {
                d3 += d5 * d4;
                d4 *= d;
            }
            return d2 / d3;
        }
    }

    public static enum ExtrapolationMethod {
        DEFAULT,
        CONSTANT,
        LINEAR;

    }

    public static enum InterpolationMethod {
        PIECEWISE_CONSTANT,
        PIECEWISE_CONSTANT_LEFTPOINT,
        PIECEWISE_CONSTANT_RIGHTPOINT,
        LINEAR,
        CUBIC_SPLINE,
        AKIMA,
        AKIMA_CONTINUOUS,
        HARMONIC_SPLINE,
        HARMONIC_SPLINE_WITH_MONOTONIC_FILTERING;

    }
}

