/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.util.Calendar;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.plaf.basic.BasicCalendarRenderingHandler;
import org.jdesktop.swingx.plaf.basic.CalendarAdapter;
import org.jdesktop.swingx.plaf.basic.CalendarState;

public class DemoCalendarRenderingHandler
extends BasicCalendarRenderingHandler {
    private DemoCalendarAdapter adapter;
    private CompoundHighlighter demoHighlighter;

    public void setHighlighters(Highlighter ... highlighters) {
        this.getHighlighter().setHighlighters(highlighters);
    }

    public void addHighlighters(Highlighter ... highlighters) {
        for (Highlighter highlighter : highlighters) {
            this.getHighlighter().addHighlighter(highlighter);
        }
    }

    @Override
    public JComponent prepareRenderingComponent(JXMonthView monthView, Calendar calendar, CalendarState dayState) {
        JComponent component = super.prepareRenderingComponent(monthView, calendar, dayState);
        return (JComponent)this.getHighlighter().highlight(component, this.getCalendarAdapter(monthView, calendar, dayState));
    }

    protected CompoundHighlighter getHighlighter() {
        if (this.demoHighlighter == null) {
            this.demoHighlighter = new CompoundHighlighter(new Highlighter[0]);
        }
        return this.demoHighlighter;
    }

    protected DemoCalendarAdapter getCalendarAdapter(JXMonthView monthView, Calendar calendar, CalendarState dayState) {
        if (this.adapter == null) {
            this.adapter = new DemoCalendarAdapter(monthView);
        }
        return this.adapter.install(calendar, dayState);
    }

    public static class DemoCalendarAdapter
    extends CalendarAdapter {
        public DemoCalendarAdapter(JXMonthView component) {
            super(component);
        }

        @Override
        public DemoCalendarAdapter install(Calendar calendar, CalendarState dayState) {
            return (DemoCalendarAdapter)super.install(calendar, dayState);
        }

        @Override
        public boolean isSelected() {
            if (!this.isDayInMonth()) {
                return false;
            }
            return super.isSelected();
        }

        public Calendar getCalendar() {
            return (Calendar)this.calendar.clone();
        }

        public boolean isDayInMonth() {
            return CalendarState.IN_MONTH == this.getCalendarState() || CalendarState.TODAY == this.getCalendarState();
        }
    }
}

