/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.AutoComplete;
import org.jdesktop.swingx.autocomplete.AutoCompleteComboBoxEditor;
import org.jdesktop.swingx.autocomplete.AutoCompleteDocument;
import org.jdesktop.swingx.autocomplete.AutoCompleteStyledDocument;
import org.jdesktop.swingx.autocomplete.ComboBoxAdaptor;
import org.jdesktop.swingx.autocomplete.ListAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.autocomplete.TextComponentAdaptor;
import org.jdesktop.swingx.autocomplete.workarounds.MacOSXPopupLocationFix;

public class AutoCompleteDecorator {
    private static final List<String> COMBO_BOX_ACTIONS = Collections.unmodifiableList(Arrays.asList("selectNext", "selectNext2", "selectPrevious", "selectPrevious2", "pageDownPassThrough", "pageUpPassThrough", "homePassThrough", "endPassThrough"));
    private static final Object errorFeedbackAction = new TextAction("provide-error-feedback"){

        @Override
        public void actionPerformed(ActionEvent e) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.getTextComponent(e));
        }
    };

    private AutoCompleteDecorator() {
    }

    private static void installMap(InputMap componentMap, boolean strict) {
        AutoComplete.InputMap map = new AutoComplete.InputMap();
        if (strict) {
            map.put(KeyStroke.getKeyStroke(8, 0), "selection-backward");
            map.put(KeyStroke.getKeyStroke(127, 0), errorFeedbackAction);
            map.put(KeyStroke.getKeyStroke(88, 128), errorFeedbackAction);
        } else {
            map.put(KeyStroke.getKeyStroke(8, 0), "nonstrict-backspace");
        }
        map.setParent(componentMap.getParent());
        componentMap.setParent(map);
    }

    static AutoCompleteDocument createAutoCompleteDocument(AbstractAutoCompleteAdaptor adaptor, boolean strictMatching, ObjectToStringConverter stringConverter, Document delegate) {
        if (delegate instanceof StyledDocument) {
            return new AutoCompleteStyledDocument(adaptor, strictMatching, stringConverter, (StyledDocument)delegate);
        }
        return new AutoCompleteDocument(adaptor, strictMatching, stringConverter, delegate);
    }

    public static void decorate(JComboBox comboBox) {
        AutoCompleteDecorator.decorate(comboBox, null);
    }

    public static void decorate(JComboBox comboBox, ObjectToStringConverter stringConverter) {
        AutoCompleteDecorator.undecorate(comboBox);
        boolean strictMatching = !comboBox.isEditable();
        comboBox.setEditable(true);
        MacOSXPopupLocationFix.install(comboBox);
        JTextComponent editorComponent = (JTextComponent)comboBox.getEditor().getEditorComponent();
        ComboBoxAdaptor adaptor = new ComboBoxAdaptor(comboBox);
        AutoCompleteDocument document = AutoCompleteDecorator.createAutoCompleteDocument(adaptor, strictMatching, stringConverter, editorComponent.getDocument());
        AutoCompleteDecorator.decorate(editorComponent, document, adaptor);
        editorComponent.addKeyListener(new AutoComplete.KeyAdapter(comboBox));
        comboBox.setEditor(new AutoCompleteComboBoxEditor(comboBox.getEditor(), document.stringConverter));
        AutoComplete.PropertyChangeListener pcl = new AutoComplete.PropertyChangeListener(comboBox);
        comboBox.addPropertyChangeListener("editor", pcl);
        comboBox.addPropertyChangeListener("enabled", pcl);
        if (!strictMatching) {
            ActionMap map = comboBox.getActionMap();
            for (String key : COMBO_BOX_ACTIONS) {
                Action a = map.get(key);
                map.put(key, new AutoComplete.SelectionAction(a));
            }
        }
    }

    static void undecorate(JComboBox comboBox) {
        JTextComponent editorComponent = (JTextComponent)comboBox.getEditor().getEditorComponent();
        if (editorComponent.getDocument() instanceof AutoCompleteDocument) {
            AutoCompleteDocument doc = (AutoCompleteDocument)editorComponent.getDocument();
            if (doc.strictMatching) {
                PropertyChangeListener[] map = comboBox.getActionMap();
                for (String key : COMBO_BOX_ACTIONS) {
                    map.put(key, null);
                }
            }
            for (PropertyChangeListener l : comboBox.getPropertyChangeListeners("editor")) {
                if (!(l instanceof AutoComplete.PropertyChangeListener)) continue;
                comboBox.removePropertyChangeListener("editor", l);
            }
            for (PropertyChangeListener l : comboBox.getPropertyChangeListeners("enabled")) {
                if (!(l instanceof AutoComplete.PropertyChangeListener)) continue;
                comboBox.removePropertyChangeListener("enabled", l);
            }
            AutoCompleteComboBoxEditor editor = (AutoCompleteComboBoxEditor)comboBox.getEditor();
            comboBox.setEditor(editor.wrapped);
            for (KeyListener keyListener : editorComponent.getKeyListeners()) {
                if (!(keyListener instanceof AutoComplete.KeyAdapter)) continue;
                editorComponent.removeKeyListener(keyListener);
                break;
            }
            AutoCompleteDecorator.undecorate(editorComponent);
            for (EventListener eventListener : comboBox.getActionListeners()) {
                if (!(eventListener instanceof ComboBoxAdaptor)) continue;
                comboBox.removeActionListener((ActionListener)eventListener);
                break;
            }
        }
    }

    public static void decorate(JList list, JTextComponent textComponent) {
        AutoCompleteDecorator.decorate(list, textComponent, null);
    }

    public static void decorate(JList list, JTextComponent textComponent, ObjectToStringConverter stringConverter) {
        AutoCompleteDecorator.undecorate(list);
        ListAdaptor adaptor = new ListAdaptor(list, textComponent, stringConverter);
        AutoCompleteDocument document = AutoCompleteDecorator.createAutoCompleteDocument(adaptor, true, stringConverter, textComponent.getDocument());
        AutoCompleteDecorator.decorate(textComponent, document, adaptor);
    }

    static void undecorate(JList list) {
        for (ListSelectionListener l : list.getListSelectionListeners()) {
            if (!(l instanceof ListAdaptor)) continue;
            list.removeListSelectionListener(l);
            break;
        }
    }

    public static void decorate(JTextComponent textComponent, List<?> items, boolean strictMatching) {
        AutoCompleteDecorator.decorate(textComponent, items, strictMatching, null);
    }

    public static void decorate(JTextComponent textComponent, List<?> items, boolean strictMatching, ObjectToStringConverter stringConverter) {
        TextComponentAdaptor adaptor = new TextComponentAdaptor(textComponent, items);
        AutoCompleteDocument document = AutoCompleteDecorator.createAutoCompleteDocument(adaptor, strictMatching, stringConverter, textComponent.getDocument());
        AutoCompleteDecorator.decorate(textComponent, document, adaptor);
    }

    public static void decorate(JTextComponent textComponent, AutoCompleteDocument document, AbstractAutoCompleteAdaptor adaptor) {
        AutoCompleteDecorator.undecorate(textComponent);
        textComponent.setDocument(document);
        textComponent.addFocusListener(new AutoComplete.FocusAdapter(adaptor));
        InputMap editorInputMap = textComponent.getInputMap();
        while (editorInputMap != null) {
            InputMap parent = editorInputMap.getParent();
            if (parent instanceof UIResource) {
                AutoCompleteDecorator.installMap(editorInputMap, document.isStrictMatching());
                break;
            }
            editorInputMap = parent;
        }
        ActionMap editorActionMap = textComponent.getActionMap();
        editorActionMap.put("nonstrict-backspace", new NonStrictBackspaceAction(editorActionMap.get("delete-previous"), editorActionMap.get("selection-backward"), adaptor));
    }

    static void undecorate(JTextComponent textComponent) {
        Document doc = textComponent.getDocument();
        if (doc instanceof AutoCompleteDocument) {
            InputMap map = textComponent.getInputMap();
            while (map.getParent() != null) {
                InputMap parent = map.getParent();
                if (parent instanceof AutoComplete.InputMap) {
                    map.setParent(parent.getParent());
                }
                map = parent;
            }
            textComponent.getActionMap().put("nonstrict-backspace", null);
            for (FocusListener l : textComponent.getFocusListeners()) {
                if (!(l instanceof AutoComplete.FocusAdapter)) continue;
                textComponent.removeFocusListener(l);
                break;
            }
            textComponent.setDocument(((AutoCompleteDocument)doc).delegate);
        }
    }

    static class NonStrictBackspaceAction
    extends TextAction {
        Action backspace;
        Action selectionBackward;
        AbstractAutoCompleteAdaptor adaptor;

        public NonStrictBackspaceAction(Action backspace, Action selectionBackward, AbstractAutoCompleteAdaptor adaptor) {
            super("nonstrict-backspace");
            this.backspace = backspace;
            this.selectionBackward = selectionBackward;
            this.adaptor = adaptor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.adaptor.listContainsSelectedItem()) {
                this.selectionBackward.actionPerformed(e);
            } else {
                this.backspace.actionPerformed(e);
            }
        }
    }
}

