/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.AMatrixViewVector;

public class SubMatrixViewVector
extends AMatrixViewVector {
    private static final long serialVersionUID = -839770692590916488L;
    private final int rowStart;
    private final int colStart;
    private final int rows;
    private final int cols;

    public SubMatrixViewVector(AMatrix source, int rowStart, int colStart, int rows, int cols) {
        super(source, rows * cols);
        source.checkRow(rowStart);
        source.checkRow(rowStart + rows - 1);
        source.checkColumn(colStart);
        source.checkColumn(colStart + cols - 1);
        this.rowStart = rowStart;
        this.colStart = colStart;
        this.rows = rows;
        this.cols = cols;
    }

    @Override
    public double get(int i) {
        this.checkIndex(i);
        return this.unsafeGet(i);
    }

    @Override
    public void set(int i, double value) {
        this.checkIndex(i);
        this.unsafeSet(i, value);
    }

    @Override
    public double unsafeGet(int i) {
        return this.source.unsafeGet(this.calcRow(i), this.calcCol(i));
    }

    @Override
    public void unsafeSet(int i, double value) {
        this.source.unsafeSet(this.calcRow(i), this.calcCol(i), value);
    }

    @Override
    public AVector exactClone() {
        return new SubMatrixViewVector(this.source.exactClone(), this.rowStart, this.colStart, this.rows, this.cols);
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        double result = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            result += this.source.getRow(this.rowStart + i).subVector(this.colStart, this.cols).dotProduct(data, offset);
            offset += this.cols;
        }
        return result;
    }

    @Override
    protected int calcRow(int i) {
        return this.rowStart + i / this.cols;
    }

    @Override
    protected int calcCol(int i) {
        return this.colStart + i % this.cols;
    }
}

