/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.util.Arrays;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.impl.ArrayIndexScalar;
import mikera.vectorz.impl.BaseIndexedVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.IntArrays;
import mikera.vectorz.util.VectorzException;

public final class IndexedArrayVector
extends BaseIndexedVector {
    private static final long serialVersionUID = 3220750778637547658L;
    private final double[] data;

    private IndexedArrayVector(double[] source, int[] indexes) {
        super(indexes);
        this.data = source;
    }

    public static IndexedArrayVector wrap(double[] data, int[] indexes) {
        return new IndexedArrayVector(data, indexes);
    }

    @Override
    public final double get(int i) {
        return this.data[this.indexes[i]];
    }

    @Override
    public final double unsafeGet(int i) {
        return this.data[this.indexes[i]];
    }

    @Override
    public IndexedArrayVector selectView(int ... inds) {
        int[] ci = IntArrays.select(this.indexes, inds);
        return this.replaceIndex(ci);
    }

    @Override
    public final void set(int i, double value) {
        this.data[this.indexes[i]] = value;
    }

    @Override
    public final void unsafeSet(int i, double value) {
        this.data[this.indexes[i]] = value;
    }

    @Override
    public void addAt(int i, double value) {
        int n = this.indexes[i];
        this.data[n] = this.data[n] + value;
    }

    @Override
    public void applyOp(Op op) {
        for (int i = 0; i < this.length; ++i) {
            this.data[this.indexes[i]] = op.apply(this.data[this.indexes[i]]);
        }
    }

    @Override
    public AVector subVector(int offset, int length) {
        int len = this.checkRange(offset, length);
        if (length == 0) {
            return Vector0.INSTANCE;
        }
        if (length == len) {
            return this;
        }
        int end = offset + length;
        int[] newIndexes = Arrays.copyOfRange(this.indexes, offset, end);
        return this.replaceIndex(newIndexes);
    }

    @Override
    public ArrayIndexScalar slice(int i) {
        return ArrayIndexScalar.wrap(this.data, this.indexes[i]);
    }

    @Override
    public void getElements(double[] dest, int offset) {
        for (int i = 0; i < this.length; ++i) {
            dest[offset + i] = this.data[this.indexes[i]];
        }
    }

    @Override
    public void copyTo(int offset, double[] dest, int destOffset, int length) {
        for (int i = 0; i < length; ++i) {
            dest[destOffset + i] = this.unsafeGet(i + offset);
        }
    }

    @Override
    public void copyTo(int offset, double[] dest, int destOffset, int length, int stride) {
        for (int i = 0; i < length; ++i) {
            dest[destOffset + i * stride] = this.unsafeGet(i + offset);
        }
    }

    @Override
    public void addToArray(double[] dest, int offset) {
        for (int i = 0; i < this.length; ++i) {
            int n = offset + i;
            dest[n] = dest[n] + this.data[this.indexes[i]];
        }
    }

    @Override
    public void addMultipleToArray(double factor, int offset, double[] dest, int destOffset, int length) {
        for (int i = 0; i < length; ++i) {
            int n = destOffset + i;
            dest[n] = dest[n] + this.data[this.indexes[offset + i]] * factor;
        }
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        double result = 0.0;
        for (int i = 0; i < this.length; ++i) {
            result += this.unsafeGet(i) * data[offset + i];
        }
        return result;
    }

    @Override
    public double dotProduct(double[] data, int offset, int stride) {
        double result = 0.0;
        for (int i = 0; i < this.length; ++i) {
            result += this.unsafeGet(i) * data[offset];
            offset += stride;
        }
        return result;
    }

    @Override
    public IndexedArrayVector exactClone() {
        return IndexedArrayVector.wrap((double[])this.data.clone(), (int[])this.indexes.clone());
    }

    @Override
    public AVector join(AVector v) {
        if (v instanceof IndexedArrayVector) {
            IndexedArrayVector iv = (IndexedArrayVector)v;
            if (iv.data == this.data) {
                return this.replaceIndex(IntArrays.concat(this.indexes, iv.indexes));
            }
        }
        return super.join(v);
    }

    @Override
    protected IndexedArrayVector replaceIndex(int[] newIndices) {
        return new IndexedArrayVector(this.data, newIndices);
    }

    @Override
    public boolean equalsArray(double[] data, int offset) {
        for (int i = 0; i < this.length; ++i) {
            if (data[offset + i] == this.data[this.indexes[i]]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validate() {
        if (this.length != this.indexes.length) {
            throw new VectorzException("Invalid index length");
        }
        super.validate();
    }
}

